/*
 *	personne record skeleton
 */

#define	PERRSIZ	128		/* number of bytes per record */
#define	PERNAM	"/acct/personne"	/* where PERSONNE lives */
#define DELFLAG	0174777	/* rad50 for special deleted  logname */
#define	PRV_ACCT 01	/* acct privelege */
#define	PRV_LDR 02	/* group leader prv */
#define PRV_SU 04	/* super user priv */
#define PRV_XLPT 010	/* can use print command */
#define PRV_XPSWD 020	/* can change his password */
#define PRV_XAUTS 040	/* can change his autostart */
#define PRV_32	0100	/* member of "32" club */
#define	PRV_TW	0200	/* terminal watcher */
#define PRV_NET 0400	/* net 11->10 priv */


struct	user	{
	struct	user	*next_user;		/*chain-pointer*/
	int	log_name[5];			/*login-name*/
	int	usr_num;			/*user-number*/
	int	last_name[6];			/*real last-name*/
	int	first_name[4];			/*real first-name*/
	int	burs_num[3];			/*bursars number*/
	int	log_path[10];			/*initial directory*/
	int	mnemonic[5];			/*course mnemonic*/
	char	password[8];			/*password*/
	int	priv;				/*priveleges*/
	char	auto_st[8];			/*autostart name*/
	char	simul_use;			/*simultaneous users*/
	char	cpu_prio;			/*cpu priority*/
	char	school;				/*school affilliation*/
	char	type;				/*acct type*/
	char	core_lim;			/*core restriction*/
	char	procs_lim;			/*process limit*/
	int	charge;				/*largent pointer*/
	int	dsk_lim;			/*logout disk limit*/
	int	dsk_used;			/*actual disk useage*/
	int	dol_bud;			/*$ budget*/
	int	dol_used[2];			/*$ used*/
	int	dol_charged[2];			/*$ charged*/
	int	cpu_used[2];			/*cpu used*/
	int	cnct_used[2];			/*connect used*/
	int	accs_date[2];			/*last access date*/
	int	lpages;				/*lp pages*/
	char	lpbud;				/*#pages allowed(*50)*/
	char	abuse;				/*# of abuses*/
	char	filler[2];			/*dummy filler to 64*/
};

struct user u_buf;	/* global buffer used by get*.c */
int pich;	/* global file handle used by get*.c */

/* return codes from getubuf */
#define AOK 1
#define OUT_OF_RANGE 0
#define DELETED -1
#define EOB -2
#define NULSTR -1  /* null string returned when bad uid */
