/*
 * A clist structure is the head
 * of a linked list queue of characters.
 * The characters are stored in 4-word
 * blocks containing a link and 6 characters.
 * The routines getc and putc (m45.s or m40.s)
 * manipulate these structures.
 */
struct clist
{
	int	c_cc;		/* character count */
	int	c_cf;		/* pointer to first block */
	int	c_cl;		/* pointer to last block */
};

/*
 * A tty structure is needed for
 * each UNIX character device that
 * is used for normal terminal IO.
 * The routines in tty.c handle the
 * common code associated with
 * these structures.
 * The definition and device dependent
 * code is in each driver. (kl.c dc.c dh.c)
 */
struct tty
{
	struct	clist t_rawq;	/* input chars right off device */
	struct	clist t_canq;	/* input chars after erase and kill */
	struct	clist t_outq;	/* output list to device */
	int	t_flag1;	/* 1st stty work - read only */
	int	t_flag2;	/* 2nd stty word */
	int	t_flag3;	/* mode, settable by stty call */
	int	(*t_addr)();	/* device address (register or startup fcn) */
	char	t_delay;	/* delay generated by special chars */
	char	t_delct;	/* number of delimiters in raw q */
	char	t_col;		/* printing column of device */
	char	t_state;	/* internal state, not visible externally */
	char	t_stat2;	/* 2nd word of internal states --
				   driver dependent 
				   (may be overlayed) */
	char	t_rdlen;	/* length given to mux on read */
	char	*t_chari;
	char	*t_charo;	/* addr of output buffer for mux */
	int	t_pgrp;		/* process group name */
	int	*t_mxregs;	/* ptr to device registers */
};

char partab[];			/* ASCII table: parity, character class */

#define	TTIPRI	10
#define	TTOPRI	20

#define	CERASE	010		/* default special characters */
#define	CEOT	004
#define CKILL	025	/* cntl u */
#define	CQUIT	034		/* FS, cntl shift L */
#define	CINTR	0177		/* DEL */

/* limits */
#define	TTHIWAT	50
#define	TTLOWAT	30
#define	TTYHOG	100

/* modes -- flag3 */
#define IINTR	01		/* inhibit special significance
				   of rubout or ctrl shft l */
#define	XTABS	02
#define CWAKEUP	04		/* wakeup on all ctrl chars */
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040		/* wakeup on all chars */
/* output parity designation */
#define	ODDP	0100
#define	EVENP	0200
#define INLCASE	02000
#define OUTLCASE 04000
#define DELAYS	071400
#define	NLDELAY	001400
#define	CRDELAY	030000
#define	VTDELAY	040000
#define UPRESC	0100000

/* additional modes in flag2 */
#define ISIG	01		/* ignore special significance
				   of chars not covered by other
				   inhibitory bits -- i.e.
				   ctrl h and ctrl u */
#define IHECHO	02		/* inhibit hardware echo */
#define INPARITY 04		/* leave alone the parity
				   bit on imcoming chars */
#define CTEKSPC	010		/* space before hat and underline
				   for Computek terminal */

/* protected bits in flag1 -- readonly, set by driver */
#define DIALUP	01		/* terminal opened as a dialup */
#define SIHECHO 02		/* slaved hardware echo inhibit --
				   set if inlcase != outlcase or
				   if ECHO is off or
				   if IHECHO is set */
#define FLUSH	04		/* if set causes a wait on output,
				    and a flush of input before stty
				    is performed */
#define PRESENCE 010		/* =1 on gtty means the user has had tty
				   input or output since the bit was last
				   zero */
#define PRESET 020		/* =1 on stty resets PRESENCE. */

/* Internal state bits */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	CARR_ON	020		/* Software copy of carrier-present */
#define TSBLKMUX 0100		/* set if device is open to blk mux */
#define MPX	0200		/* set if device open to software
				   multiplexor -- cpu to cpu
				   communications */

/* Driver dependent internal states */
#define	TIMEOUT	01		/* Delay timeout in progress */
#define WCLOSE	02		/* waiting to close */
#define TIMELOCK 010		/* Delay timeout inviolable */
#define	BUSY	020		/* Output in progress */
#define	ASLEEP	0100		/* Wakeup when output done */
#define TSBMXRDN 0100		/* block mux read done */

/* Hardware bits */
#define	DONE	0200
#define	IENABLE	0100
