#
/*
 * xc - impliment 2c, 3c ...
 *	Filter standard input to multi-column output
 * 	Usage:  x | <n>c [-<linelength>]
 * 		x is any command which writes to standard output.
 *		<n> is a number from 1 to 10.
 * 		<linelength> = width in characters of output device.
 *	Creation: cc -O nc.c
 * 		  mv a.out 2c
 *		  ln 2c 3c   (etc)
 */

#define LINESZ 80

int ncolumns;
int linelength LINESZ;
int tabstop[10] { 0,  16, 32, 48, 64, 
		LINESZ };

main(argc,argv)
char **argv;
{
	register int colnum,charnum;

	register char c;

	ncolumns = atoi(*argv);
	if (argc > 1) {
		argv++;
		(*argv)++;		/* skip minus */
		linelength = atoi(*argv);
	}
	if (ncolumns != 5) {
		charnum = linelength/ncolumns;
		for (colnum = 0;colnum < ncolumns; colnum++)
			tabstop[colnum] = colnum*charnum;
		tabstop[colnum] = linelength;
	}

	colnum = 0;
	charnum = 0;
	while ((c=getchar()) > 0) {
		if (c == '\n') {
			while (++colnum<ncolumns && charnum>=tabstop[colnum]);
			if (colnum >= ncolumns) {
				putchar('\n');
				colnum = charnum = 0;
			} else 
				while(charnum < tabstop[colnum]) {
					charnum++;
					putchar(' ');
				}
		} else {
			charnum++;
			putchar(c);
		}
	}
	putchar('\n');
}
