.sp 2
.ce 1
Ploting Routines for the Zeta 1240/3640 Plotter
.sp 2
This directory contains routines that drive the Zeta Plotter.
They represent the minimal conversion effort to take 
Zeta Research's NOVA routines and make them fly under Unix and
F4P.
.sp
The files contained here are:
.sp 2
.in 10
z.f4p
.br
 	The zeta routines themselves.
.sp
ex1.f4p
.br
	A test routine
.sp
zeta.s
.br
	A routine that can be linked with either C or F4P (and 
macro) that forks and execs a plotter driver.
The motivation is to 1) allow C to call the Plotter routines
and 2) take up less space (the plotter routines are almost 16k Wds).
.sp
c.s
.br
	Prefix file for zeta.s to cause C-style output
.sp
macro.s
.br
	Prefix file for zeta.s to cause F4P/MACRO style output.
.sp
driver.m11
.br
	The other end of the ploter driver, that reads pipes and
calls the zeta routines.
.sp 2
.in 0
There are three ways to use these routines:
.br
1) simply link in the z.obj file with a fortran/macro task, i.e.
.br
.in 20
linker -c -l jnk.obj z.obj
.in 0
.sp
2) Make the plotter driver and link in the C-routines with your 
C-compilation:
.br
.in 20
cc jnk.c zeta.o
.in 0
.sp
3) Make the plotter driver and link in the F4P/MACRO routines with
your F4P/Macro compilation
.br
.in 20
linker [switches] jnk.obj zeta.obj
.br
.in 0
.sp
Other ways are bound to follow.
.sp 2
.ce 1
Notes, Documentation, Disclaimer, Etc.
.sp 2
The document of Zeta Research
.ul
Zeta 230 Compatible Plotting Subroutines Reference Manual for Time Share Systems (release 3.5)
and
.ul
Addendum for PDP-10 Time Share System
(which describes the 1240 and 3640 additional subroutines)
are the principle reference sources.
There is only one additional routine that is intended to be called from
the "exec'ed driver" case -- Plotfs(itrans, xhFile_name, ix) and
Plotfs(itrans, "filename") do the output to the named file, instead of
the plotf way of doing output to a fortran unit device.
.sp
To use the routines from C, use the same conventions as in fortran.
The plot exec routine knows about C passing Doubles instead of Floats
on the stack, although it demands that the arrays passed be Float arrays.
The "funny" routine in C is Where(x,y,fctr) where x,y, and fctr MUST
be ptrs to floats rather than the floats themselves (think about the
by reference/by value calling conventions).
.sp
And now the disclaimer.
The Zeta routines on this machine have been implemented as a
"minimal time effort" as part of a larger overall effort that
we wished to achieve.
There are no bugs that we know of; however, we have by no means
extensively tested every call with the millions of different arguements
that are available.
The two most serious shortcommings of the routines are 1) In case of
the "exec'ed" plotdriver, read/write errors on the pipe often take the
approach to simply exit rathere than figure out what's wrong, and 2)
The (standard) Zeta character set is very poor.
We hope to (over the next few months) improve the character set (to be
identical to the character set of the VT-11) and work out any
remaining bugs.
However, in the meantime we feel that the routines (especially in the file
z.f4p) should be usefull to certian individuals the way they are (functionally
identical to the Zeta specs) and therefore submit them to the library.
.sp
Please feel free to contact me if you have any questions/criticisms/suggestions/contributions
to the software.
.sp
.in 10
Forrest W. Howard Jr.
.br
Commercial Union Leasing Co.
.br
645 Madison Ave.
.br
New York, NY 10022


