/ 
/ 	This program is intended to be the second loader of 
/ 	the gt40 loading stuff.
/ 	It  starts at 0, and relocates itself as high as possible
/ 	in core, clearing stuff as it goes.
/ 	
/ 	It then takes sets of 2-6 and 1-4 bit characters from the 
/ 	host into words. The first word is the total number of
/ 	words to load (therefore the high limit).
/ 	it then reads words until everything is happy.
/ 
/ 	when the program is loaded, a clear pc is done, and
/ 	the user's program is off.
/ 
/ 	Forrest W. Howard, Jr.
/ 	Commercial Union Leasing Co
/ 	645 Madison Avenue
/ 	New York, NY. 10022
/ 
	reset=5
	dl11s= 175610
	dl11c= 175612
/ 	dl11s = 177560 / for debug
/ 	dl11c = 177562
	dl11os= 0175614
	dl11oc= 0175616
	tstack = 1000			/ above limit
start:
	reset;240;240;240;240;240	/ halt, then past traps
1:	mov	$cont,*$4		/ find top of memory
	clr	*$6			/ clear ps when found
	reset				/ clear out stuff
	mov	$tstack,sp		/ and set up stack

1:
	mov	sp,r5			/ get copy
	clr	(r5)+			/ clear it
	mov	r5,sp			/ still good (i hope)
	br	1b			/ so try again.

cont:	tst	(sp)+			/ (sp) is now top memory word
	mov	sp,r5			/ copy it
	tst	(r5)+			/ and point above the first loc
	mov	$loade+2,r4		/ and get ready to shuffle
	mov	r4,r0			/ and to clear out low core

1:
	mov	-(r4),-(r5)		/ copy it
	cmp	r4,$loadlp
	bhi	1b			/ and loop till done

	clr	r2			/ diagnostic count of bytes
	mov	$tstack+2,r0		/ clear out all the low stuff
	jsr	r5,xout; 033		/ out an alt
	jsr	r5,xout; 'G		/ and a cap g
	jsr	r5,xout; 4		/ and a ^d to transmit it
	jmp	(r5)			/ and go
xout:
1:	tstb	*$dl11os
	bpl	1b
	mov	(r5)+,*$dl11oc
	rts	r5



loadlp:
1:
	clr	-(r0)		/ and clear low core
	tst	r0
	bne	1b

	jsr	pc,getw
	mov	r0,r5

	clr	r4

1:
	jsr	pc,getw
	mov	r0,(r4)+
	cmp	r4,r5
	blo	1b
	clr	pc



getw:	clr	r0
	mov	$3,r3		/  r3 is the count
1:	tstb	*$dl11s
	bpl	1b
	movb	*$dl11c,r1
	inc	r2		/ kick byte count
	asr	r1
	ror	r0
	asr	r1
	ror	r0
	asr	r1
	ror	r0
	asr	r1
	ror	r0
	dec	r3
	beq	2f		/ if last time, only 4 shifts
	asr	r1
	ror	r0
	asr	r1
	ror	r0
	br	1b
2:	rts	pc


	.=.+10			/ small stack
loade= .
