#
#define	MEM	8192	/*processable memory locations (bytes)*/

struct	mem	{
	char	m_used;	/*set if memory location is to be loaded*/
	char	m_data;	/*value to be loaded*/
	};

struct mem	mem[MEM];
char		checksum;	/*built-up checksum*/

main()
	{
	exit((getmem() == 0 && putmem() == 0) ? 0 : -1);
	}

getmem()
	{
	register int		bytesleft;	/*data bytes in record*/
	register struct mem *	dollarsign;	/*points to current cell*/
	register int		regint;
	int			lowpart;

	while	(1)
		{
		while	((regint = getchar()) != ':')
			if	(regint == 0)
				return(-1);
		if	((bytesleft = getbyte()) <= 0)
			return(bytesleft == 0 &&
				getbyte() == 0 && getbyte() == 0 &&
				getbyte() == 0 && getbyte() == 0 &&
				getchar() == '\n' && getchar() == '\0' ?
				0 : -1);
		if	((regint = getbyte()) < 0 ||
			(lowpart = getbyte()) < 0)
			return(-1);
		dollarsign = &mem[(regint << 8) | lowpart];
		if	(getbyte() != 0)
			return(-1);
		do	{
			if	((regint = getbyte()) < 0 ||
				dollarsign >= &mem[MEM])
				return(-1);
			dollarsign->m_used = 1;
			dollarsign->m_data = regint;
			dollarsign++;
			}
			while	(--bytesleft);
		if	(getbyte()<0 || checksum!=0 || getchar()!='\n')
			return(-1);
		}
	}

getbyte()
	{
	register int	high;
	register int	low;

	if	((high = char2val(getchar())) < 0 ||
		(low = char2val(getchar())) < 0)
		return(-1);
	checksum =+ (low =| (high << 4));
	return(low);
	}

char2val(ac)
char	ac;
	{
	return((ac >= '0' && ac <= '9') ? ac - '0' :
		((ac >= 'A' && ac <= 'F') ? ac + 10 - 'A' :
		-1));
	}

putmem()
	{
	register struct mem *	dollarsign;
	register struct mem *	lookahead;

	dollarsign = &mem[0];
	while	(dollarsign < &mem[MEM])
		if	(dollarsign->m_used == 0)
			dollarsign++;
		else	{
			lookahead = dollarsign + 1;
			while	(lookahead <= &mem[MEM] &&
				lookahead - dollarsign < 16 &&
				lookahead->m_used)
				lookahead++;
			putchar(':');
			putbyte(lookahead - dollarsign);
			putbyte((dollarsign - mem) >> 8);
			putbyte(dollarsign - mem);
			putbyte(0);
			while	(dollarsign < lookahead)
				putbyte((dollarsign++)->m_data);
			putbyte(-checksum);
			putchar('\n');
			}
	putchar(':');
	putbyte(0);
	putbyte(0);
	putbyte(0);
	putbyte(0);
	putbyte(0);
	putchar('\n');
	return(0);
	}

putbyte(abyte)
int	abyte;
	{
	putchar(val2char(abyte >> 4));
	putchar(val2char(abyte));
	checksum =+ (abyte & 0377);
	return(abyte);
	}

val2char(aval)
int	aval;
	{
	return((aval&017) <= 9 ? (aval&017) + '0' : (aval&017) + 'A'-10);
	}
