#
/*
 *	Copyright 1973 Bell Telephone Laboratories Inc
 *	Modified by Ferenz to conform to Children's Museum code
 *	Also replaces address algorithm by a table lookup
 *	Modified by Lou Katz to fix timeout crash of system
 *	on bad disconnect, and to put in parts of Irwin Sobel's
 *	code to recognize a 'break' keystroke by
 *	sending BREAKCH into ttyinput.
 */

/*
 *   KL/DL-11 driver
 */
#include "../param.h"
#include "../conf.h"
#include "../user.h"
#include "../tty.h"
#include "../proc.h"

#define BREAKCH	021	/* control q */
#define	NKL11	1
#define NDL11	7
#define DSRDY	0000002
#define RDRENB	0000001
#define REQSEND	0000004
#define	DSIENB	0000040
#define CARRIER 0010000
#define FRAMERR	0020000
#define CLEARSD 0020000
#define	RING	0040000
#define ERROR   0100000
#define RINGING 0100000
#define MBUSY	0000040	/* MODEM hangup timeout sequence in progress */

/* new tables */
char	*addrlst[]		{ 0177560,0175610,0175620,0175630,0175640,0175650,0175660,0175670};
char	dialup[]		{	0,	0,	1,	1,	1,	1,	0,	1};

struct	tty dl11[NKL11+NDL11];

struct dlregs {
	int dlrcsr;
	int dlrbuf;
	int dltcsr;
	int dltbuf;
};

dlopen(dev, flag)
{
	register minor;
	register char *addr;
	register struct tty *tp;

	if ((minor = dev.d_minor) >= NKL11+NDL11) {
		u.u_error = ENXIO;
		return;
	}
	tp = &dl11[minor];

	/**** new table look up ****/
	addr = addrlst[minor];
	tp->t_addr = addr;
	if ((tp->t_state&ISOPEN) == 0) {
		tp->t_state =! WOPEN;	/* retain MBUSY if necessary */
		tp->t_flags = XTABS|LCASE|ECHO|CRMOD;
		tp->t_erase = CERASE;
		tp->t_kill = CKILL;
	}

	addr->dltcsr =| IENABLE;
	if ((dialup[minor]==0) || (addr ->dlrcsr & CARRIER))
		tp->t_state =| CARR_ON;
	addr->dlrcsr =| IENABLE|DSRDY|RDRENB|DSIENB;
	if (dialup[minor]) {
		spl5();
		while ((tp->t_state & CARR_ON)==0)
			sleep(&tp->t_rawq,TTIPRI);
		spl0();
	}
out:
	tp->t_state =& ~WOPEN;
	tp->t_state =| ISOPEN;
	if (u.u_procp->p_ttyp ==0) {
		u.u_procp->p_ttyp = tp;
		tp->t_dev = dev;
	}
}

dlclose(dev)
{
	register struct tty *tp;

	tp = &dl11[dev.d_minor];
	if (tp->t_flags & HUPCL)
		tp->t_addr->dlrcsr = 0;
	tp->t_state =& MBUSY;	/* turn off everything but MBUSY */
	wflushtty(tp);
}

dlread(dev)
{
	register struct tty *tp;

	tp = &dl11[dev.d_minor];
	if (tp->t_state & CARR_ON)
		ttread(tp);
}

dlwrite(dev)
{
	register struct tty *tp;

	tp = &dl11[dev.d_minor];
	if (tp->t_state & CARR_ON)
		ttwrite(tp);
}

dlxint(dev)
{
	register struct tty *tp;
	tp = &dl11[dev.d_minor];
	ttstart(tp);
	if (tp->t_outq.c_cc == 0 || tp->t_outq.c_cc == TTLOWAT)
		wakeup(&tp->t_outq);
}

/* code to handle hangup of phone. This is necessary in installations
 * without 'second-party disconnect' (common in centrex systems)
 * to cope with wrong numbers, when carrier is never established.
 * L. Katz.  10 May 76
 */

dlrstrt(atp)
{
	register struct tty *tp;
	register int *addr;

	tp = atp;
	addr = tp->t_addr;

	addr->dlrcsr =| RDRENB|IENABLE|DSRDY|DSIENB;
	tp->t_state =& ~MBUSY;
}

dlrcheck(atp)
{
	register struct tty *tp;
	register int csr;

	tp = atp;
	csr = tp->t_addr->dlrcsr;
	if (csr & CARRIER) {
		if ((tp->t_state & CARR_ON) ==0)
			tp->t_addr->dlrcsr =| RDRENB|IENABLE|DSRDY|DSIENB;
		tp->t_state =& ~MBUSY;
		return;
	}

	tp->t_addr->dlrcsr =& ~DSRDY;
	signal(tp,SIGHUP);
	flushtty(tp);
	/* DSRDY must be down a finite amount of time to hang up
	 * lbolt doesnt work at this level
	 */
	timeout(dlrstrt,tp,15);
	tp->t_state =& ~CARR_ON;
	return;
}

dlrint(dev)
{
	register struct tty *tp;
	register int c,csr;

	tp = &dl11[dev.d_minor];
	c = tp->t_addr->dlrbuf;
	if (dialup[dev.d_minor]) {
		csr=tp->t_addr->dlrcsr;


/* we dont use this junk
		if(((tp->t_state&RINGING)==0) && (csr&RING)){
			tp->t_state =| RINGING;
			tp->t_addr->dlrcsr =| REQSEND|RDRENB|IENABLE|DSRDY|DSIENB;
			return;
		}
*/

		if(csr&ERROR) {
			if((csr&CARRIER)==0) {
				if ((tp->t_state&MBUSY) == 0) {
					tp->t_state =| MBUSY;
					timeout(dlrcheck,tp,8 * HZ);
				}
				tp->t_state =& ~CARR_ON;
				goto endrint;
			}
			else tp->t_state =|CARR_ON;
			wakeup(tp);
			goto endrint;
		}
	}
	if ((c&0177)==0)
		if (c&FRAMERR)
			c = BREAKCH;

	ttyinput(c, tp);
endrint:
	tp->t_addr->dlrcsr =| RDRENB|IENABLE|DSRDY|DSIENB;
}

dlsgtty(dev, v)
int *v;
{
	register struct tty *tp;

	tp = &dl11[dev.d_minor];
	ttystty(tp, v);
}

