.hn n
.m1 0
.m2 1
.m3 1
.m4 2
.fn y
.pl 60
.in 0
.br
gfc
56
.br
3 June 1977
.in 5
.in +5
.sp2
.he """QMC UNIX Software"
.ce 2
The QMC Unix Software


.sp2
.in-5
.ce 2
Computer Systems Laboratory
Queen Mary College  Mile End Road  London E1 4NS (01-980 4811 x751)


.ti-5
Summary
This document has two parts. Part I describes the software available
in general terms. Part II says how to implement it.

.ti-5
Part I
.in +5

We are making available to Licensed UNIX users a set of new
UNIX command programs, C procedure libraries and
other software that
has been developed in this Lab. over the past two years. The
software is available free of charge to educational, academic
and UK government establishments. Other potential users should
apply to the Lab. for the terms under which the software is
available to them.

.ti-5
What There Is

In general, the software reflects our research interests:
(a) display techniques,
(b) interactive software design,
(c) the application of microcomputers and
(d) the development of utilities and programming aids for all
of these activities.

The software we have selected for distribution
is just that part of our work that is independent of any untried
ideas or special hardware. Most of it has been in daily use at
QMC for many months.
All of it is fully documented to the UNIX manual standards, and
in some cases there are additional tutorial or reference documents.
The documentation files are included in the distribution.
The QMC Unix manual (the Bell edition 6 with additions
and ammendments covering the QMC software) can be purchased by
Licensed Unix users for #2.00 from Mrs. M. Higgins, Department
of Computer Science and Statistics, Queen Mary College, Mile
End Road, London E1 4NS, England.

There are about 40 new sections in the  QMC manual, representing
an equivalent number of new system commands and other extensions.
It is difficult to summarise the entire contents, so
a few examples are listed below.

Interest (a) is reflected by the POP library - a collection of
C procedures that enables an alphanumeric display with cursor
addressing to be programmed as a set of display windows, each
window acting as an independently programmable 'virtual display'.
(A paper describing the philosophy of POPs has been prepared
for publication by their originator - Jon Rowson).
Some application programs that use this package are also included
- 'intray' to interactively process a mail file, 
'ic' an interactive calculator for integer arithmetic to any
base, and several games.

Interest (b) is represented by an extended version of 'ed', called
'em' - editor for mortals. It is more forgiving than
'ed', and includes comprehensive in-line editing with word-oriented
operations and automatic line breaking if desired. Em is fully
teletype compatible,
but the new facilities are designed to make the editor more effective
when used with a display terminal, and cannot be fully exploited
on a terminal slower than about 1200 baud. For those who have
already received a version of 'em' this one is a considerable
development of 'em' as originally distributed, it is faster,
has some nice extra features and is supported
by an introductory text on editing with em as well as a manual
section. There are versions for use with the Bell teletype driver
(using raw mode) and our version of the UCLA driver (using userbreak
mode, see below). Another recent addition to 'em' is a recovery
facility to assist in recovering the workfile when the system
(or the user) crashes.

(c) is represented by an assembler for the M6800 (called 'mas'),
and a compiler ('mc') for a subset of C for the M6800.
There are also utilities for
down-line loading and for interaction with a processor at the
end of a terminal line. ( 'link',  'setup' etc.).

In category (d), here is a range of new utilities. Many of them
designed to enable
UNIX to be more effectively used from faster terminals (e.g.
'fi' and 'fs' - improved versions of 'ls', a 'send' to send mail
interactively, a 'news' system, improved
'login', etc.).

Also included in category  (d) is a comprehensive 
library that implements a 'heap' for C programs. The library
includes some checks on the validity of heap operations and has
functions to generate arbitrary sized vectors that are either
local or global. There are also some additional control primitives
of the same ilk as setexit and reset, but much more powerful.
('leave' and 'recall').

We run an improved version of the UCLA terminal driver (originally
developed by Mark Kampe at UCLA, extended further and some bugs
fixed at QMC).
The version
we use has paging of terminal output, better keyboard correction
functions (modeled on Tenex), the userbreak terminal mode developed
at UCLA, but with breaks possible on all of the 128 possible
input characters.
The driver is used in several of the interactive programs we
are distributing, but you can usually dispense with it by a few
systematic modifications. The driver is well worth installing
if the majority of your terminals are displays.

.ti-5
Availability

An RK05 containing the entire distribution will be deposited
at Glasgow University as soon as they are able to provide facilities
to distribute Unix software. Meanwhile, Dr. Steve Wylbur in the
Statistics and Computer Science Department at University College
London, Gower Street, WC1 has an RK05 containing almost all of
the files and has indicated his willingness to make a limited
number of copies.



.in-5
.ti-5
Part II
.in+5

.ti-5
Files

The software and documentation is issued as filestore with the
following root directory:

.nf
 8080asm	- Intel 8080 assembler source (not QMC software)
 docs		- contains documentation for all of the software
 games		- some new game programs (most use 'pops')
 heap		- the heap library source
 imlac		- a library of graphical primitives
 mas		- M6800 assembler source
 mc		- M6800 C compiler source 
 ml1		- ML1 macroprocessor source (courtesy of Peter Brown)
 odb		- qmc's interactive debugger source
 pop		- the pop library source (and implementation instructions)
 readme.r	- this document
 s1		- source for qmc's new command programs
 s2		- more command programs
 s4		- system calls
 s5		- library calls
 ttydriver	- source for the QMC tty driver
.fi

.ti-5
Implementation

The programs are distributed as C source files with a corresponding
documentation file (usually in Unix manual format) in one of
the subdirectories of 'docs'.

There are three libraries, the 'pop' library, the 'heap' library
and the Imlac graphics library. They are implemented as lib/libw.a, lib/libh.a
and lib/libg.a respectively, using 'ar'.

Implementation of most of the command programs is completely
straightforward. The exceptions are mentioned below.

em:
.br
This is our enhanced editor. It is a complete superset of 'ed',
and is an extension of the Bell program.
The documentation is in docs/man1/em.1, and there is an introductory
document in docs/em/emintro.r.
The source is in s1/em1.c and s1/em2.c. If you do not have the
modified ttydriver, you must make the alterations given for the
Bell driver.
Put the object in /bin/em. (It must have the name 'em'). There
is no need to keep a separate object file for 'ed'. You can make
a link from /bin/em to /bin/ed. You will then be able to use
'ed' exactly as before, without prompts, and 'em' if you want
prompts. Both ed and em will have the extra facilities described
in the documentation.
There is a help facility in 'em' that uses some information files
in a directory called /usr/lib/emhelp. The information files
we use are in docs/em/emhelp.
There is a spelling aid in the 'o' command of 'em'. To implement
this you must have the program in s2/spell.c implemented as /bin/spell.

link, setup, lock, unlock, avail:
.br
These commands are implemented by a single program with links
in /usr/bin for each command name. The source
is in s1/link1.c and s1/link2.c. Read the documentation in
docs/man1/link.1, setup.1, lock.1, diablo.1 and docs/man5/spdevices.5
and protocols.5.
You will have to modify the source if you run the standard Bell
tty driver. The mods are to replace calls to sterm() and gterm()
by calls to stty() and gtty().
You can add links to the link program for each special device
defined in your /etc/spdevices file.

fi, dir, del, fs, protect:
.br
These are all implemented by the program in s1/dir.c. Once again,
the different commands are just links in /bin.

ttydriver:
.br
Read the documentation in docs/man1/ter.1, docs/man2/terms.2,
docs/man3/sterm.3 and gterm.3, and docs/man4/tty.4.
