#include	"odbh0.c"

putins(v,x)
{
	register struct optab *p;
	register insval, *svp;
	if ( dot&1 )
		dot--;
	svp = &symbuf[10];
	insval = v;
	seekoff();
	while(getsym(symbuf))
		if (*svp == dot) {
			if (rmvch(symbuf, *(svp-1)))
				continue;
			symbuf[8] = NUL;
			putlp(symbuf);
			putlp(":");
			break;
		}
	putlp(TAB);
	bytwrd = 2;
	for (p=optab;  ;p++)
		if ((insval & ~p->mask) == p->opcode)
				break;
	putlp(p->name);
	switch(p->optype) {
		case ASHINS :
		case MULDIV :
			insval = ((insval>>6) & 07) |		/* swap */
				 ((insval<<6) & 07700);		/* fields */
			goto dblab;
		case JSRXOR :
			insval =& 0777;
		case DOUBLE :
		dblab:
			putlp(TAB);
			putad(insval>>6);
			putlp(",");
			putad(insval);
		case NOADDR :
			return;
		case RTSINS :
			insval =& 07;
		case SINGLE :
			putlp(TAB);
			putad(insval);
			return;
		case SOBINS :
			putlp(TAB);
			putad((insval>>6) & 07);
			putlp(",");
			insval = -(insval&077);
			goto branch;
		case BRANCH :
			putlp(TAB);
		branch:
			insval =& 0377;
			if (insval&0200)
				insval =| 0177400;
			insval = dot+2+(insval<<1);
			putoff(insval);
			return;
		case TRAPIN :
			syscal(insval, x);
			return;
		case EMTINS :
			insval =& 0377;
			putlp(TAB);
			putdec(insval);
			return;
		default     :
			putlp(TAB);
			putoct(insval);
	}
}



putad(a)
{
	register mode,reg,ccont;
	mode = a;
	reg = mode&07;
	mode = (mode>>3)&07;
	if (reg == 7 && mode&2) {		/* pc addressing */
		ccont = get(dot+bytwrd);
		if (mode&1)
			putlp("@");
		if (mode&4)
		 	putoff(ccont+dot+2+bytwrd);
		else {
			putlp("#");
			putoff(ccont);
		}
		bytwrd =+ 2;
		return;
	}
	reg = regtab[reg].r_name;
	switch (mode) {		/* general register addressing */
		case 0 :
			putlp(reg);
			return;
		case 1 :
			pbreg(reg);
			return;
		case 3 :
			putlp("@");
		case 2 :
			pbreg(reg);
			putlp("+");
			return;
		case 5 :
			putlp("@");
		case 4 :
			putlp("-");
			pbreg(reg);
			return;
		case 7 :
			putlp("@");
		case 6 :
			putoff(get(dot+bytwrd));
			bytwrd =+ 2;
			pbreg(reg);
	}
}

pbreg(rr)
{
	putlp("(");
	putlp(rr);
	putlp(")");
}

putoff(v)
char *v;
{
	register char  *ofset;
	if ((ofset = vallook(v)) > 010000) {
		putoct(v);
		return(0);
	}
	symbuf[8] = NUL;
	putlp(symbuf);
	if (ofset) {
		putlp("+");
		putoct(ofset);
	}
	return(1);
}


syscal(v,x)
{
	register inst,cnt;
	inst = v;
	putlp(TAB);
	if ((cnt = inst&077) > 48) {
		putoct(inst);
		return;
	}
	putlp(systab[inst=cnt].sysnam);
	if (!inst && !x) {
		newline();
		linput();
		putins(get(dot+2),1);
		bytwrd = 4;
		return;
	}
	cnt = systab[inst].argcnt;
	while (cnt--) {
		newline();
		putlp(DTABS);
		putoff(get(dot+bytwrd));
		bytwrd =+ 2;
	}
}

colon()
{
	int adrbuf[3];
	register struct optab *p;
	register int *ap, i;
	i = 0;
	rch();
	skip();
	loop:
		symbuf[i++] = ch;
		switch(ch) {
			case ' '  :
			case '\t' :
			case LF :
				symbuf[--i] = NUL;
				break;
			default	:
				if (i<7) {
					rch();
					goto loop;
				}
				error();
		}
	for (p=optab; p->mask != 0177777; p++)
		if (cmpst(symbuf,p->name)) {
			aap = ap = adrbuf;
			pcntr = dot+2;
			aap++;
			*ap = p->opcode;
			valfnd = svalfnd = 0;
			if (p->optype == NOADDR)
				goto nomore;
			rch();
			skip();
			i = 06;
		switch(p->optype) {
			case SINGLE :
			case DOUBLE : case MULDIV :
			case ASHINS :
				aexp();
				break;
			case RTSINS :
			case JSRXOR : case SOBINS :
				getreg();
				break;
			case BRANCH :
				i = 010;
				aexp1(1);
				adrval = (adrval-pcntr) >> 1;
				if (adrval>0377 || adrval<0177401)
						error();
				svalfnd = adrval;
				break;
			case EMTINS : case TRAPIN :
				aexp1(1);
				svalfnd = adrval;
		}
		skip();
		switch(p->optype) {
			case DOUBLE : case ASHINS : case JSRXOR :
			case MULDIV : case SOBINS :
				if (ch != ',')
					error();
				rch();
				skip();
		}
		patch(i);
		svalfnd = 0;
		switch(p->optype) {
			case DOUBLE : case JSRXOR :
				aexp();
				break;
			case SOBINS :
				aexp1(1);
				if (adrval > pcntr)
					error();
				svalfnd = adrval >> 1;
				break;
			case MULDIV : case ASHINS :
				getreg();
				patch(i);
				valfnd = ((valfnd>>6) & 077) |
					 ((valfnd<<6) & 0700);
			default :
				goto nomore;
		}
		patch(i);
	nomore:
		if (ch != LF)
			error();
		*ap =| valfnd;
		pcntr = dot;
		valfnd = 1;
		for (ap = adrbuf; ap < aap; ap++) {
			adrval = *ap;
			closloc();
			dot =+ 2;
		}
		dot = pcntr - 2;
		valfnd = 0;
		return;
	}
	error();
}


aexp2()
{
	if (digit(ch) || alpha(ch))
			term(0);
	else
		adrval = 0;
}


aexp()
{
	if (ch == '@') {
		svalfnd =| 010;
		if (rch() == '(') {
			aexplb();
			if (ch == '+') {
				svalfnd =| 020;
				rch();
			} else {
				adrval = 0;
				svalfnd =| 060;
				incpc();
			}
		} else
			nbraket();
	} else
		direct();
}


nbraket()
{
	if (spclreg())
		getreg();
	else
	switch(ch) {
		case '%' : case 'r' :
		case 'R' :
			rch();
			getreg();
			return;
		case '#' :
			svalfnd =| 027;
			rch();
			aexp1(1);
			incpc();
			return;
		case '-' :
			rch();
			if (ch == '(') {
				svalfnd =| 040;
				aexplb();
				return;
			}
			aexp1(0);
			goto def;
		default :
			aexp1(1);
		   def:
			if (ch != '(') {
				svalfnd =| 067;
				adrval =- (pcntr+2);
				incpc();
			} else {
				svalfnd =| 060;
				incpc();
				aexplb();
			}
	}
}


direct()
{
	if (ch == '(') {
		if (svalfnd != 0)
			error();
		svalfnd =| 010;
		aexplb();
		if (ch=='+') {
			rch();
			svalfnd =+ 010;
		}
	} else
		nbraket();
}


aexp1(k)
{
	aexp2();
	if (!k)
		adrval = -adrval;
	aexp3();
}


aexp3()
{
	register t1;
	t1 = 0;
	for (;;) {
		t1 =+ adrval;
		switch(ch) {
			case '+' :
				rch();
				aexp2();
				continue;
			case '-' :
				rch();
				aexp2();
				adrval = -adrval;
				continue;
			default :
				adrval = t1;
				return;
		}
	}
}


aexplb()
{
	rch();
	getreg();
	if (ch != ')')
		error();
	rch();
}


getreg()
{
	if (match(ch, "rR%"))
		rch();
	else
		spclreg();
	if ((ch =- '0') > 7)
		error();
	svalfnd =| ch;
	rch();
	skip();
}

spclreg()
{
	if (((ch == 'p' && *lp == 'c') || (ch == 's' && *lp == 'p')) &&
		 !alpha(*(lp+1))) {
			lp++;
			return((ch = ch == 'p' ? '7' : '6'));
		}
	return(0);
}

incpc()
{
	*aap++ = adrval;
	pcntr =+ 2;
}


patch(c)
{
	valfnd = (valfnd << c) | (svalfnd & 077);
}
