.ll+12
.nh
.TI
An Introduction to the QMC Unix Editor - 'em'
.TE
.HT "Introduction to `em`"
.AU "George Coulouris"
.ST


This document is intended to introduce you to enough of the
editor to enable you to enter and edit programs and documentation
files.
When you are familiar with the features described here, you
will probably want to learn more to enable you to make full use
of the editor's facilities. To do this, you can read the
documentation supplied in the Unix manual. You can also refer to
the brief summaries provided by the editor's help command - '>h'
and experiment with the commands described there to test your understanding.

The editor is designed to enable you to conveniently make new
Unix files and alter existing ones.
It can operate on any file that consists of a sequence
of characters, provided that it is made up of lines
(normally, lines should be shorter than 80
characters so that they can be displayed correctly. When you
are making a text file, you can arrange for 'em' to put line breaks
at appropriate points for you as explained under the '>b' command below).

To edit a file called 'myfile', type the following command to Unix:

	em myfile

If 'myfile' is the name of one of the files in your current working
directory, then 'em' makes a copy of it (called the 'working
file') in its own file space.
The changes that you make while editing the file, and the portions
that you display on the screen refer to the working file, and not to
the original. In fact, the original will remain unchanged unless
you instruct the editor to write the modified text onto it (this is discussed
further below).

When the editor is ready,
it will announce itself and prompt you to type a command:

	Editor
	>

The '>' is a prefix displayed by the editor whenever it is ready
for you to type a command. Commands usually consist of a single letter
and 'RETURN'.
When discussing them here we shall write them with the '>'
prefix (although this is actually typed by the editor) to distinguish them
from ordinary letters.
There are about 40 possible commands to the editor
but fortunately you can do most things with only seven, they are:
.ne9
.nf

	d	(delete lines)
	o	(open the current line)
	p	(print lines)
	q	(quit the editor)
	r	(read a file)
	w	(write a file)
	x	(exchange a new string for an existing string)
.fi

In addition, h (help) will give you a screen full of information
about all of the editor commands.

The 'current line' is normally the last one displayed on the
terminal screen, (denoted by the character '.' if you need to
refer to it explicitly in any command).
Whenever you are in doubt about which is the
current line, use a >p command to display it.
You can make any line the current line. If you type a
number instead of a command (e.g. >693) then that line
(i.e. the 693rd in our example) becomes the current line and
its contents is displayed on the terminal.
If you type a 'RETURN' without any command letter, the line 
following the current line is displayed and becomes the current line.
There are several other ways to move the position of the current
line pointer: >- moves it back one line, >+ moves it forward
a line. >+3 or >+++ will move it forward by three lines and >-3
or >--- will do the reverse.

Lastly, but most usefully of all,
you can move without knowing the position of the line to which
you wish to move. If you type >/character string/ the first
line that containing the string of characters 'character string'
after the current line
becomes the new current line. (If there is no such line before
the end of the working file, then the search continues from the
first line. If no line
contains the specified string, then the editor
displays the 'not found' symbol: '??' and leaves the current
line unchanged.

We shall now describe briefly each of the seven commands listed
above.

.SH" d	delete lines"

You will need to be able to delete part of a file once you have
created it, to correct errors, or for example to
make a new file containing part of an old file. The command '>d'
removes the current line from the working file.  If you
want to remove several adjacent lines you can specify a range
for the delete command, e.g. '>20,32d' removes lines 20 to 32
inclusive. (Ranges for commands are discussed more fully under 'p' below.)

.SH" o	open the current line"

This command has several versions. The one activated by '>o'
enables you to alter the text of an existing line. (If you
want to add some completely new lines, you would use '>o+' to append
after the current line or '>o-' to insert before
the current line.)

When you open an existing line with the '>o' command, the editor
will respond with a '\\' prompt and position the cursor at the
beginning of a blank line.
If the line you have opened (i.e. the current line) contains
any text, then you can position the cursor anywhere you wish
in the text by typing certain 'control characters'. Control characters
are typed by holding down the 'CTRL' button while typing an alphabetic
key. (i.e. 'CTRL' is an additional 'shift' on the keyboard for
typing control characters. Control characters do not actually
appear on the screen when they are typed, instead they cause
some action by the program. When we refer to the control characters
in this document and other program documentation, we represent
them by an upper-case alphabetic letter prefixed by
the '^' symbol: '^A', '^B', '^C', etc.)

Returning to the '>o' command, the control codes that can be
used to position the cursor in the current line and perform some
other useful functions are listed below. You can display
this list of functions at any time while you are in an '>o' command just
by typing '^H' (for 'help').
.ne12
.nf

char:	advance ^Q  [->]      line:   display to end  ^E  [ ]
	backup  ^U  [<-]	      reset to start  ^S  [^]
	delete  RUBOUT		      delete backward ^X
word:	advance ^A  [>>]	      delete forward  ^F
	backup  ^B  [<<]	      release margin  ^G
	delete  ^W		      re-type	      ^R
	spell	^V  [SEND]    exit:   with new text   ESCAPE
				      unchanged text  ^C

.fi
Other characters (including RETURN) are inserted as typed;
the symbols in [] are the equivalent BLUE keys on QMC ITT terminals.

You will learn gradually to use all of these functions to help you type
new text or alter existing lines.
To start with, you can probably manage with ^A to advance the
cursor by one word, ^S to reset the cursor to the start of the
current line, and the RUBOUT key to delete the preceding character,
but ^W to delete the preceding word, ^E to position the
cursor at the end of the line, and ^B to move the cursor back
a word without deleting it are also very useful.
Remember if you get stuck that ^H gives you help, and that ^d or the ESCAPE key
closes the current line and returns you to the editor's '>' level.

You needn't return to '>' level to type a sequence of lines
of text, since if you use the 'RETURN' key, the current line
is stored, and a new current line (normally empty initially) is created.
You should now practice using the facilities of '>o' to create
some text lines. Enter the editor without any source file (just
type 'em' to Unix) and then use the '>o+' variant of the '>o'
command (since the
curent line is initially a 'phantom' line called line 0, and
you wish to create a new line which will follow line 0, namely line
1).

You can type any text you like. Now use ^S and ^A to make some
insertion in the text you have already typed, and proceed from
where you left off by using a sequence of ^A's or just one ^E.
Now use the ^H facility to see what other functions there are
and try some of them. If you try to do something impossible (e.g. ^A when
the cursor is already at the end of the current line), then you
will see an error symbol (a reversed '?') on the screen (only
on 'ITT' terminals).

You will have noticed that whenever the cursor has to move backwards,
the characters up to the new position of the cursor are displayed
again on a new line on the screen. This is because the majority of the terminals
we use do not enable the cursor to actually move backwards within
a line. You can tell from the characters appended to the previous
displayed line whether the new cursor position is the result
of a deletion (i.e. ^W, ^X or RUBOUT) or just a re-positioning
of the cursor (^S or ^B). The deletion functions append characters
to the preceding line as follows:

	^W:	[]
	RUBOUT:	[d] (where 'd' is the deleted character)
	^X:	@

You should now be able to create new text using '>o+' (for typing
convenience, '>o;' is interpreted as '>o+',) and to
alter existing lines with '>o'. The remaining five commands
will enable you to examine the text on the screen, to make systematic
alterations, and to read and write files
other than the working file.

.SH" p	print lines"

The command '>p' displays the current line. 
The same effect is obtained by typing '>.'. This is because
a command consisting of a line number or a reference to a line
causes that line to be printed (and the line become
the current line). Since '.' refers to the current line, the
effect of '>.' is just to print the current line.

The more useful applications of print are to display a number
of lines from the working file. For example, you could display
the first 10 lines of the working file with '>1,10p'. 
The pair of integers separated by a comma are called the 'range'
of the command. Most of the editor commands can be used with
a range. The effect is to apply the command to each line in the
range in turn. Also, the last line in the range becomes the current line. 

You will frequently wish to display some number of lines preceding
(or following) the current line. You could display enough
lines to fill the screen of the ITT terminal with '>.-16,.p'.
This command is used so frequently that the editor has a single-character
abbreviation for it: '>&'. There are also two similar abbreviations for
print commands: '>"' for '>.+1,.+17p', and '>%' for '.-6,.+6p'.
The last abbreviation '>%' is designed to enable you to see the
context of the line your are working on. To do so, it marks the
current line by surrounding it with two lines of '-' characters,
and after displaying the context, it leaves the current line
as it was before (i.e. it does not change to the last line in
the range). You will have noticed by now that line numbers can
be specified by expressions (using '+' and '-' only) to indicate
relative line positions rather than the actual line number starting
from the beginning of the file. There is a special way of referring
to the last line of the working file. It is denoted by the symbol '$'.
So '>1,$p' will display the entire file on the terminal screen.

.SH" q	quit the editor"

You should make sure that the working file has been written 
(see '>w' below) before you use '>q' to leave the editor. If
the working file has changed since the last '>w' command, then
the editor will respond to '>q' with 'sure?'. If you want the
working file you should write it before repeating the '>q',
but even if you don't, the second '>q' will leave the editor.

.SH" r	read a file"

You may wish to insert the contents of an existing file into
the working file. You can do this by using '>.r filename' where 'filename'
is the name of any text file in the file system. A copy of the
named file is inserted in the work file immediately after the
current line. The current line after the '>r' has been completed
is the last line read. '>r' is one of the few commands that cannot
sensibly have a range, although it can be prefixed with a single line
number to specify the point at which the new text should appear.
(If there is no line number specified, then the new text is placed
at the end of the current text).
For example, if you wanted to insert a file called 'globals' at
the beginning of the current work file, you could use '>0r globals'.

.SH" w	write a file"

You must use '>w' to save the results of your editing. If you
specified a filename when you called the editor (by typing 'em filename'
initially), then '>w' will replace the contents of the file named
in the original call
with a copy of the working file. Be sure that you don't need
the earlier version before you do this.
If for any reason you want to write the results of your editing
onto a different file, you can use '>w otherfile' to write a copy
of the working file into the file called 'otherfile' (replacing
the previous contents of 'otherfile' if it already existed, or
creating a new file with that name if it didn't).
It is possible to write just a range of lines from the working
file onto a named file. For example '>1,40w page1' would write
a copy of the first 40 lines onto a file called 'page1'.

When you use '>w' without giving the filename, the editor actually
uses a name called the 'remembered file name' as the destination
of the write. If you forget what that name is,
you can check it with the '>f' command. You can also alter the 'remembered
file name'. Just type '>f newfile' and subsequent writes will
use 'newfile' as the remembered name.
.SH" "
x	exchange a new string for an existing string

Most editors have a command to substitute a new string for an
old one. In this case, it can be applied to any range of lines,
and it will find all of the occurrences of the old string in
the range, displaying each in turn with a request for confirmation.
For example:

	>1,100x/October/November/

would display in turn each line in the given range that
contains the string 'October',
marking clearly the string 'October' itself.
You can perform each substitution by typing a '.' and 'RETURN', causing
the new string to be inserted in
place of the old, or bypass any instance by just the 'RETURN' key.

In all commands that require strings to be specified, there is a
fairly comprehensive set of rules to enable you to specify not
only exact matching of character strings, but a whole set of
useful additional forms. For example, you may wish to find only
those instances of some string that appear at the beginning of
a line. The '^' symbol is used to denote the beginning of a line,
so /^string/ will match all of the instances of 'string' that
are at the beginnings of lines. A more useful example of this
might be:

	>1,$x/^int/real/

to display each line having 'int' as its first three characters
and enable you to change each to 'real' interactively.
Note that '^' is superfluous in the new string, since the position
of the new string is always that of the old one. There is a special
symbol for the  end of a line: '$'. Thus

	>1,$x/$/;/

appends a ';' to each line in the working file. Of course, each
line is first displayed for confirmation. If you want to dispense
with the confirmation, you can use another command that is very
similar to the '>x' command: 

.SH" s	substitute new string for old"

Thus:

	1,$s/$/;/

will append the ';' to every line without further ado. Although
the only change we had to make here was in the command letter,
there is one significant difference between the operation of
the '>x' and the '>s' command. The normal mode of operation of
the substitute command is to replace only the first instance
of the old string in each line, whereas the exchange command
displays each instance for confirmation. So for example:

	1,$s/12/13/

would not actually alter every instance of the digits '12' to '13'.
To do so, you must indicate that the substitution is 'global'
within each line by appending a 'g' to the command:

	>1,$s/12/13/g

You may wish to operate on strings containing '/', '^' or '$'
characters with '>x' or '>s' commands ('&', '.', '*' and '[' also
have special meanings not dealt with here in string specifications).
If you wish to include one of them in the new or old string,
you must prefix it with a '\` character. Thus for example '\\\^' stands
for the '^' character.
Finally to include '\\' in a string specification, you should use '\\\\'.
.SH"Diagnostics"

The editor is very terse when you try to do
something that is impossible. Apart from the reversed '?' used
in the '>o' command, there are really only two error
messages: '?' and '??'. The first indicates that the command
you have just typed is not properly formed (missing characters,
extra characters, command not known, etc.) or that the command
is not possible for some other reason (reference to a line that
does not exist, attempt to read a file that is not present, attempt
to write a file that is protected, etc.). The '??' is displayed
only when a string that has been specified cannot be found in
the working file. (When the latter occurs, the current line remains
unchanged.)

.SH" Some more facilities"

Using the knowledge you have gained of the editor by reading
this document, you should be able to use the editor effectively
to create and alter your files, but you will find that some editing
activities seem rather awkward. This is probably an indication
that there is a more appropriate facility that you are not aware of.
We will mention here a few of the facilities that will prove useful
as you increase your knowledge of the editor.

When you are editing programs, you will frequently need to move
a few lines from one part of the file to another. Although this
can be achieved by a 'write' on a temporary file followed by
a 'delete' and a 'read' in the new position, it can also be done
in one operation and without the use of an additional file by
using the 'move' command. 

.SH" m	move lines"

For example the command '>10,15m24' moves lines 10 to 15 inclusive to appear
following line 24. Note that numbers of the lines between 10
and 24 will have changed as a result.
Of course, you can use '.' and '$' as line references in a 'move'
command. For example '>.,.+3m$' would move the current line and
the three lines following it to the end of the file.

.SH"l	list lines"

It is possible accidentally or intentionally to insert characters
that have no printed representation (e.g. control characters)
into a text file. If the
file is a source program, this can cause mysterious errors during
compilation. The '>l' command enables you
to output part or all of a file to the screen with special codes
inserted for the non-printing characters.
It works exactly as the '>p' command, except that the non-printing
characters are displayed as octal character codes (e.g. '\\32' for ^Z).

.SH"=	display line number"

This is generally used to find out the number of the current
line: '>=' does just that.

.SH"b	line breaks on"
When you are typing or editing a text file such as a document,
it is very convenient to be able to ignore the position of right-hand margin.
The '>b' command switches on a mode of operation in the '>o' command
that automatically starts a new line
whenever a space is typed after character position 60. The lines in the file
you create will therefore be roughly equal in size, and they
will fit on the screen. To format the text more acurately, you
must process the file with a text formatter such as 'roff' or 'nroff'
(see the relevant sections of the Unix manual).

The '>b' command is also automatically invoked whenever the current
file name ends in '.r' or '.n' (the conventional names for 'roff'
and 'nroff' text files).
You can de-activate it at any time by typing '>b-'.

.SH"Further Documentation"

The '>h' command has already been mentioned as a means of getting
a summary of all of the editor commands.
You can get further useful information by using '>h reg' for
help with regular expressions (i.e. search strings), '>h s' or '>h x'
for help on the substitute and exchange commands, and
'>h o' for information on the '>o' command. One day there will
be on-line help available for all the other commands too.

Since 'em' is an extension of 'ed', the standard Unix editor,
the sections in the Unix manual on 'ed' and 'em'
together form a complete reference to all of the the facilities in the editor.
