#
/*	This is the second and final segment of the QMC Unix Editor - em */
/*	Altered by Peter C Nov 76 to cope with alterations to tty protocol */
/*	Altered to remove margin control - June 1977  - Peter C */
/*	Altered to cope with terms call - Sept 1977 - Peter C */
#define EOF -1
#define LBSIZE	512
#define	SIGHUP	1
#define	SIGINTR	2
#define	SIGQUIT	3
#define UNIXBUFL 100
#define error	goto errlab

#define RAW	040
#define ECHO	010
#define INDICATE 01000
#define OPEN	'/'
#define BELL	07
#define ESCAPE	033
#define SPACE	040
#define BACKSL	0134
#define RUBOUT	0177
#define BREAK	07
#define CTRLA	01
#define CTRLB	02
#define CTRLC	03
#define CTRLD	04
#define CTRLE	05
#define CTRLF	06
#define CTRLG	07
#define CTRLH	010
#define CTRLI	011
#define TAB	011
#define CTRLQ	021
#define CTRLN	016
#define CTRLR	022
#define CTRLS	023
#define CTRLU	025
#define	CTRLV	026
#define CTRLW	027
#define CTRLX	030
#define CTRLZ	032

#define ITT	0100000

extern int	peekc, lastc, peekkey, lastkey;
extern char	*linebp, *loc2, linebuf[LBSIZE], genbuf[LBSIZE],
			unixbuffer[UNIXBUFL];
extern int	onquit,onhup;
extern int	*zero, *addr1, *addr2;
extern int	*errlab;
int	oflag;
char	*lnp,*gnp,*brp;
int	savetty, tty[14];


op(inglob)
{	register *a1;
	register char *lp, *sp;
	char seof, ch;
	int t, nl, getopen(), getnil();

	if ((ch = peekc = getchar())  == BACKSL)
	{
		t = 1;
		delete();
		addr2 = addr1;
	}
	else
	if(ch == ';' || ch == '+')
		t = 0;
	else
	if(ch == '-')
		t =1;
	else goto normal;


	peekc = 0;
	if(addr1 != addr2) error;
	oflag = 0;
	append(getnil, addr2 - t);
	addr1 = addr2 =- (t-1);
	setdot();
	nonzero();


normal:
	if(addr1 == zero) error;
	if ((seof = getchar()) == '\n') { loc2 = linebuf-1;
						seof = '\0';}
		else compile(seof);
	setraw(); /* terminal into raw mode*/

	for ( a1 = addr1; a1 <= addr2; a1++) {
		if (seof) {if (execute(0,a1) == 0) continue;}
			else getline(*a1);
		puts("\\\r");
		lp = linebuf;
		sp = genbuf;
		inglob =| 01;
		while (lp < loc2){ putch(*lp); *sp++ = *lp++; }
		lnp = lp;
		gnp = sp;


		oflag = gopen(); /* open the current line */
		*a1 = putline(); /* write revised line */
			nl = append( getopen,a1);
			a1 =+ nl;
			addr2 =+ nl;
	}
	setcook(); /* terminal in cook mode */
	putchar('\n');
	if (inglob == 0) { putchar('?'); lastc = '\n'; error;}
}

getnil()
{
	if(oflag == EOF) return EOF;
	linebuf[0] = '\0';
	oflag = EOF;
	return 0;
}

setraw()
{
	if(terms(0, 2, tty) == -1) error;
	savetty = tty[2];
	tty[2] =| RAW;
	tty[2] =& ~INDICATE;
	terms(0, 3, tty);
}

setcook()
{
	tty[2] = savetty;
	terms(0, 3, tty);
}

inword(c) char c;
{	if(c -'0' < 0 ) return 0;
	if(c - '9' <= 0) return 1;
	c =& 0137;
	if(c -'A' < 0) return 0;
	if(c - 'Z' <= 0) return 1;
	return 0;
}

rescan()
{	register char *lp, *sp;

	lp = linebuf;
	sp = genbuf;
	while(*lp++ = *sp++) if(lp>linebuf+LBSIZE) {
				*(--lp) = '\0';
				return 0;
				}
}


gopen()
	/*leaves revised line in linebuf,
	returns 0 if more to follow, EOF if last line */
{	register char *lp, *sp, *rp;
	char ch, *br, *pr;
	int retcode, savint, pid, rpid;

	lp = lnp;
	sp = gnp;
	for(;;){
		switch (ch = getkey()) {
			case CTRLD:
			case ESCAPE:	/* close the line (see case '\n' also) */
			close:
				putb(lp);
				while(*sp++ = *lp++);
				rescan();
				return(EOF);

			case CTRLR:	/* verify line */
			verify: puts("\\\r");
				*sp = '\0';
				putb(genbuf);
				continue;

			case CTRLB:	/* back a word */
				if(sp == genbuf) goto backquery;

				if(sp-genbuf>lp-linebuf) {
					rp = sp;
					while(*sp++ = *lp++);
					rescan();
					sp = rp;
					lp = linebuf - genbuf + sp;
				}

				while(wdsep(*(--lp) = *(--sp)) );
				if(sp < genbuf) goto out;
				if(inword(*sp)) {
					while(inword((*(--lp) = *(--sp))));
					if(sp < genbuf) goto out;
					if(wdsep(*sp))
						while(wdsep(*(--lp) = *(--sp)));
					if(sp < genbuf) goto out; 
				}	
				else while(sp >= genbuf && !inword(*sp))
					*lp-- = *sp--;
			out:
				if(lp++ < linebuf) lp = linebuf;
				if(sp++ < genbuf) sp = genbuf;
				goto verify;

			case CTRLQ: /* forward one char */
				if(*lp == '\0') goto backquery;
				putch(*lp);
			forward:
				*sp++ = *lp++;	/* one character */
				continue;


			case CTRLF:
			/* delete forward */
				while(*lp++);
				lp--;
				goto verify;

			case CTRLE:
				if(*lp == '\0') goto backquery;
				putb(lp);
				while(*sp++ = *lp++);
				sp--; lp--;
				continue;

			case CTRLH:  filelist("/usr/lib/emohlp"); goto verify;

			case CTRLS:	/* re-set to start of line */
				while(*sp++ = *lp++);
				rescan();
				lp = linebuf; sp = genbuf;
				goto verify;

		/*
			when putting this section back replace - in line below by *'s
			case CTRLV:	/- verify spelling -/
				rp = sp;
				pr = unixbuffer+UNIXBUFL-2;
				*pr = 0;
				while(wdsep(*(--rp)));
				while(inword(*rp) && rp >= genbuf)
					*(--pr) = *rp--;
				if(*pr == 0) goto backquery;
				puts("!!");
				setcook();
				if((pid = fork()) == 0)
					{signal(SIGHUP, onhup);
					  signal(SIGQUIT, onquit);
					  execl("/bin/spell", "spell", pr, 0);
					  puts("sorry, can't spell today");
					  exit();
				}
				savint = signal(SIGINTR,1);
				while((rpid = wait(&retcode)) != pid
					 && rpid != -1);
				signal(SIGINTR, savint);
				setraw();
				puts("!!");
				goto verify;
			*/


			case CTRLZ:	/* forward one word */
				if(*lp == '\0') goto backquery;
				rp = sp;
				while(wdsep(*lp))
					*sp++ = *lp++;
				if(inword(*lp)) {
					while(inword(*lp)) 
						*sp++ = *lp++;
					if(wdsep(*lp)) {
						while(wdsep(*(lp+1)))
							   *sp++ = *lp++;
					}
				}
				else while(*lp && !inword(*lp)) 
					*sp++ = *lp++;
				*sp = '\0';
				putb(rp);
				break;


			case CTRLC:
			case CTRLW:	/* delete a word */
				if((rp = sp) == genbuf) goto backquery;
				while(wdsep(*(--sp)));
				if(sp < genbuf) { sp = genbuf; goto verify; }
				if(inword(*sp)) {
					while(inword(*(--sp)));
					if(sp < genbuf) { sp = genbuf; goto verify; }
					if(wdsep(*sp))
						while(wdsep(*(--sp)));
					if(sp < genbuf) { sp = genbuf; goto verify; }
				}	
				if(++sp == rp) goto backquery;
				goto verify;

			case CTRLU:
			case '@':	/*delete displayed line */
			/* delete backward */
				sp = genbuf;
				goto verify;

			case BREAK:
				puts("\\\r");
				setcook();
				lastc = '\n';
				error;

			case CTRLX:
			case RUBOUT:
				putch('#');
				if( sp == genbuf) goto backquery;
				--sp;
				if( ch == CTRLX) goto verify;
				continue;

			case '\n':
			case '\r': /* split line, actually handled at
					end of switch block */
				ch = '\n';
				*sp++ = ch;
				br = sp;
				break;

			case CTRLA: /* special symbols */
				putch('\\');
				switch (ch = peekkey = getkey()) {
				case '(':  ch = '{'; peekkey = 0; break;
				case ')':  ch = '}'; peekkey = 0; break;
				case '!':  ch = '|'; peekkey = 0; break;
				case '^':  ch = '~'; peekkey = 0; break;
				case '\'':  ch = '`'; peekkey = 0; break;
				case CTRLA:
				case '@':  peekkey = 0; break;

				default:  if(ch >= 'a' && ch <= 'z') {
						peekkey = 0; ch =- 040;}
					else if(ch <= 040 && ch != '\n') 
							peekkey = 0;
						else {
							*(--lp) = BACKSL;
							goto forward;
						}
				}

			default:
					if((ch >= CTRLA && ch  < CTRLI) || (ch >= CTRLN && ch <= CTRLZ)) goto backquery;
					*(--lp) = ch;
					goto forward;
			}

		if (ch == '\n') { /* split line */
			lnp = sp;
			while(*sp++ = *lp++); /*move the rest over */
			brp  = linebuf +(br - genbuf);
			lnp = linebuf + (lnp - br);
			rescan();
			*(brp-1) ='\0';
			return(0);
			}
		else continue;
	backquery: putch('?');
		} /* end of forloop block */
} /* end of gopen */



getopen()  /* calls gopen, deals with multiple lines etc. */
{	register char *lp, *sp;
	if (oflag == EOF) return EOF;

/* otherwise, multiple lines */

	lp = linebuf;
	sp = brp;
	while(*lp++ = *sp++); /*move it down */
	sp = genbuf;
	lp = linebuf;
	while (lp < lnp) *sp++ = *lp++;
	gnp = sp;
	/* should check whether empty line returned */
	oflag = gopen();
	return 0;
}

putch(ch) char ch;
{	register char c;
	c = ch;
	if((c >= CTRLA && c <= CTRLG) || (c >= CTRLN && c <= CTRLZ) )
	{	putch('^'); ch =|  0100;	}
	write(1, &ch, 1);
}

putb(ptr)	char *ptr;	/*display string */

{	register char *p;

	p = ptr;
	if(*p == '\0') return;
	while(*p) putch(*p++);
}

int wdsep(c)		/* Returns true if character is a separator */
char c;
{	return(c == SPACE || c == TAB);	}
