#
/*
 *	lpr.c - New version for UKC use
 *	Peter Collinson March 77
 * 	Modified Sept 1977 - to use pipes for obtaining the pathname
 *	For every file on input it creates a command file on /usr/lpd starting with lp
 *	This file contains:
 *	Line 1	- user name
 *	Line 2	- current pathname
 *	Line 3 - NFMDLP - a single byte with these bits set
 *			+ 0100 to make it a visible character
 *		N	- suppress header page output
 *		F	- print a FORM feed after header
 *		M	- send mail after printing
 *		D	- delete file after printing (if file has .lst extension will be deleted anyway).
 *		L	- use 'list' to print file.
 *		P	- use 'pr' to print file.
 *
 *	Switches are:
 *	-n	Suppress header page output
 *	-f	Print form feed after header
 *	-m	Send mail
 *	-r	remove file after printing
 *	-d	remove file after printing
 *	-c	create a copy of file called filename.lst
 *	-l	use 'list'
 *	-p	use 'pr'
 *
 */

char lpname[]	"/usr/lpd/lpDDaXXXXX";
char lpd[]	"/usr/lpd";
int	nextname;		/* Points to little 'a' byte in above line */
char	pathname[256];		/* Storage for pathname */
char 	cantopen[]	"Cannot open: %s";
char	toomany[]	"There are %d files queued for printing - please try later\n";
char	person[24];
extern fout;
/* Flags */
int	copyflg	0;
char	swit	0100;		/* Used to collect switches for placing on the file */
#define MAXQ	25

#define NOHDR	040
#define FWANTED	020
#define MAIL	010
#define	DELETE	04
#define LIST	02
#define PR	01
int	filefound	0;

struct
{	int	majmin;
	int	inumber;
	int	flags;
	int	fill[2];
	int	size;
	int	fill2[12];
} statb;

struct
{	int	inode;
	char	spoolname[14];
} dir;

char	listfile[128];

main(argc, argv)
int argc; char **argv;
{	register int procno;

	signal(2, 1);
	signal(3, 1);

	if(qlength() >= MAXQ) 
	{	printf(toomany, MAXQ);
		leave();
	}

	while(--argc)
	{	argv++;
		if(**argv == '-')
		{	copyflg = 0;
			swit = 0100;

			while(*++*argv)
			switch(**argv)
			{	case 'n':	swit =| NOHDR; break;
				case 'f':	swit =| FWANTED; break;
				case 'm':	swit =| MAIL; break;
				case 'c':	copyflg++;
				case 'd':
				case 'r':	swit =| DELETE; break;
				case 'l':	if(swit&PR) error("Either pr or list");
						swit =| LIST; break;
				case 'p':	if(swit&LIST) error("Either pr or list");
						swit =| PR; break;

				default:	error("Unrecognised switch"); 
			}
		}
		else
		{	if(qlength() >= MAXQ)
			{	printf(toomany, MAXQ);
				if(argc)
				{	printf("Did not queue:");
					while(--argc) printf(" %s", *argv++);
					printf("\n");
				}
				leave();
			}
			else processfile(*argv);
		}
	}
	if(filefound == 0) error("No file found");
	else
	{	if((procno = fork()) < 0) printf("Cannot create daemon\n");
		else
		if(procno == 0)
		{	execl("/etc/lpd", "lpd", 0);
			printf("Cannot start daemon\n");
		}
	}
	leave();
}


setup()
{	register int i;
	setday();
	pidfn();
	if(getpw(getuid(), person) < 0)
		error("Cannot find user name");
	for(i = 0; person[i] != ':'; i++);
	person[i] = '\0';
	getpathname();
}

setday()
{	int tvec[2];
	register char *pt; register int i;

	time(tvec);
	pt = ctime(tvec);
	i = 0;
	while(lpname[i] != 'D') i++;
	lpname[i++] = (pt[8] == 040)? '0': pt[8];
	lpname[i] = pt[9];
}

pidfn()
{	register i,j,c;
	int p;

	p = getpid();
	i = 0;
	while(lpname[i] != 'X') i++;
	i =+ 4;
	for(j = 0; j < 5; j++)
	{	c = (p%10) + '0';
		p=/ 10;
		lpname[i--] = c;
	}
	nextname = i;
}

getpathname()
{	int procno, stat, pv[2];
	register char *p;

	/* This is a nasty routine calling pwd and getting its result piped back */

	p = pathname;
	pipe(pv);
	if((procno = fork()) < 0)
		error("Cannot create new processes\n");

	if(procno == 0)
	{	close(pv[0]);
		close(1);
		dup(pv[1]);
		close(pv[1]);
		execl("/usr/bin/pwd", "pwd", 0);
	}
	else
	{	close(pv[1]);
		do read(pv[0], p, 1); while(*p++ != '\n');
		*p = '\0';
		close(pv[0]);
		wait(&stat);
	}

}

char *copystr(s, d)
char *s, *d;
{	register char *i, *j;
	i = s; j = d;
	while(*j++ = *i++);
	return(--j);
}

processfile(file)
char *file;
{	int fd;

	if(filefound++ == 0) setup();
	if(copyflg) file = copyfile(file);

	if((fd = creat(lpname, 0666)) < 0)
		error(cantopen, lpname);

	if((stat(file, &statb) < 0) || statb.size == 0)
		error("Cannot open : %s or file size = 0", file);

	statb.flags =& 0777;
	statb.flags =| 0444;
	if(swit&DELETE) statb.flags =| 0222;
	chmod(file, statb.flags);
	flush();
	fout = fd;
	printf("%s\n%s%c\n%s\n", person, pathname, swit, file);
	flush();
	fout = 1;
	close(fd);
	lpname[nextname]++;
}

char *copyfile(file)
char *file;
{	char buf[512];
	register int ch;
	register char *p;
	int fdin, fdout;

	p = copystr(file, listfile);
	p = copystr(".lst", p);
	*p = '\0';

	if((fdin = open(file, 0)) < 0)
		error(cantopen, file);

	if((fdout = creat(listfile, 0666)) < 0)
		error(cantopen, listfile);

	while((ch = read(fdin, buf, 512)) > 0)
	{	ch = write(fdout, buf, ch);
		if(ch < 0) break;
	}
	if(ch < 0)
	{
		unlink(listfile);
		error("Error in copying file");
	}
	close(fdin);	close(fdout);
	return(listfile);
}

error(format, s)
char *format, *s;
{	printf(format, s);
	printf("\n");
	unlink(lpname);
	leave();
}

int qlength()
{	register int fd, sum;

	sum = 0;
	if((fd = open(lpd, 0)) < 0)
	{	printf("Cannot open /usr/lpd\n");
		leave();
	}

	seek(fd, 32, 0);	/* Avoid . and .. entries */
	while(read(fd, &dir, 16) > 0)
		if(dir.inode != 0 && dir.spoolname[0] == 'l' && dir.spoolname[1] == 'p')
			sum++;
	close(fd);
	return(sum);
}

leave()
{	flush(); exit();	}
