#

/*
 * lp - submit lineprinter spooler requests
 */

#include		"lpdaemon.h"

#define	true		0177777
#define	false		000000

#define	EXECUTE		0
#define	WRITE		1
#define	READ		2
#define	HUP		1
#define	INTR		2
#define	QUIT		3
#define	XHTAB		02
#define XVTAB		0100	/* 0100 = 040000 >> 8 */

#define	LPDFILELNG	11
char	lpdfiles[]	"/tmp/lpd/lp";
#define	DAEMONFAIL	"lp: Can't start daemon\n"

#define	LPQLNG		sizeof lpq
#define	DIRENTLNG	sizeof dirent
#define	MOUNTLNG	sizeof mountent

char	title_supplied;
char	userbuf[512];
int	*setup		userbuf;
int	user, qletter, qfd, semfd, pid, start_only;

struct	{
	char	fname[32];
	char	dname[32];
	}  mountent;

struct	{
	int	d_num;
	char	d_name[14];
	}  dirent;

struct	{
	int	i_dev;
	int	i_num;
	int	i_flags;
	char	i_nlinks;
	char	i_uid;
	char	i_gid;
	char	i_size0;
	int	i_size1;
	int	i_addr[8];
	int	i_actime[2];
	int	i_modtime[2];
	}  statbuf;

struct	{
	char	u_uid;
	char	u_gid;
	};

struct	{
	char	lobyte;
	char	hibyte;
	};





main( argc, argv)
int	argc;
char	**argv;
	{
	register int	i;
	register char	*s, *p;
	extern		delete();

	signal( HUP, delete );
	signal( INTR, delete );
	signal( QUIT, delete );

	/* Find the real user id, and name */
	lpq.uid = user.u_uid = getuid();
	lpq.gid = user.u_gid = getgid();
	user.u_gid = getgid();
	if ( getpw( user.u_uid, userbuf ) )  {
		printf("lp: Unrecognized UID\n");
		exit(-1);
		}
	s = lpq.from;
	p = userbuf;
	while ( *p != ':' )
		*s++ = *p++;
	*s++ = '\0';

	/* Set up the default options */
	qname[ QNAMELNG] = DEFAULTQ;
	title_supplied = false;
	lpq.num_copies = 1 ;
	lpq.top_margin = 2 ;
	lpq.margin = 8 ;
	/* Fish out his current tab sizes */
	userbuf[5] = 0;
	terms( 2, 2, userbuf );
	lpq.htabsize =  userbuf[4] &XHTAB ? userbuf[8]: 8;
	lpq.vtabsize =  userbuf[5] &XVTAB ? userbuf[9]: 0;
	lpq.bottom_margin = 1;
	lpq.numbers = true;
	lpq.header = true;
	lpq.lpdfile = false;
	time( lpq.date );
	strcopy( lpq.from, lpq.to, UIDLNG);

	/* Start processing flags, especially '-q?' which must
	 * preceed all filenames */
	argc--;    argv++;
	while ( argc >0 )  {
		p = *argv;
		if ( p[0] == '-'  &&  p[1] == 'q'  &&  p[2] == '=' )
			qname[ QNAMELNG] = *++p;
		else	if ( *p == '-'  ||  *p == '!' )
				process_flag( p );
			else	break;
		argv++;    argc--;
		}

	/* Open the queue */
	if ( (qfd= open( qname, 2)) < 0 )  {
		printf("lp: Can't open queue %s\n", qname );
		exit(-1);
		}
	setup[0] = setup[1] = 0;
	if ( (semfd= semopen( QLOCK)) < 0 )  {
		printf("lp: Can't open queue lock\n");
		exit(-1);
		}
	lock( semfd );
	read( qfd, setup, 4 );
	seek( qfd, 0, 0 );
	write( qfd, setup, 4 );
	unlock( semfd );

	if ( !start_only )  {
		/* If no arguments left then read from std input */
		if ( argc == 0 )  {
			lpq.lpdfile = true;
			print_file( 0 );
			}
	
		/* Process filenames and interspersed flags */
		while ( argc-- )  {
			p = *argv++;
			if ( *p == '-'  ||  *p == '!' )
				process_flag( p );
			else	print_file( p );
			}

		/* Is the Daemon already running ? */
		lock( semfd );
		seek( qfd, 2, 0 );
		pid = 0;
		read( qfd, &pid, 2 );
		if ( pid != 0 )  {    /* Yes */
			unlock( semfd );
			exit( 0 );
			}
		}

	/* Fork the Daemon */
	if ( (pid= fork()) < 0 )
		printf( DAEMONFAIL );
	if ( pid == 0 )  {
		signal( HUP, 1 );
		signal( INTR, 1 );
		signal( QUIT, 1 );
		pid = getpid();
		seek( qfd, 2, 0 );
		write( qfd, &pid, 2 );
		unlock( semfd );
		setuid(0);
		setgid(1);
		chdir("/");
		close(0);
		close(1);
		userbuf[0] = qfd;
		userbuf[1] = semfd;
		userbuf[2] = 0;
		execl( DAEMON, "spooler", userbuf, qname, 0 );
		printf( DAEMONFAIL );
		}
	exit();
	while ( wait() != pid );
	}




print_file( fname )
char	*fname;
	{
	register char	*s;

	/* Get a unique serial no from bytes 0-1 */
	lock( semfd );
	seek( qfd, 0, 0 );
	read( qfd, &pid, 2 );
	lpq.serial = ++pid;
	seek( qfd, 0, 0 );
	write( qfd, &pid, 2 );
	unlock( semfd );

	if ( fname  &&  access( fname, READ ) )
		return;
	lpq.mdate[0] = statbuf.i_modtime[0];
	lpq.mdate[1] = statbuf.i_modtime[1];

	/* Make a copy of the file, or determine its complete
	 * pathname */
	if ( lpq.lpdfile )  {
		if ( make_file( fname) < 0 )
			return;
		}
	else	{
		if ( (s= qualify( fname)) == 0 )
			return;
		strcopy( s, lpq.filename, FILENMLNG);
		}

	if ( !title_supplied )  {
		if ( fname != 0 )  {
			for ( s=fname; *s++; );
			while ( *--s != '/'  &&  s >= fname );
			strcopy( ++s, lpq.title, TITLELNG);
			}
		else	{
			*lpq.title = '\0';
			time( lpq.mdate );
			}
		}

	stat( lpq.lpdfile? lpq.filename: fname,  &statbuf );
	lpq.fblocks = ((statbuf.i_size0<<7) & 077600) |
				((statbuf.i_size1>>9) & 0177);
	if ( statbuf.i_size1 &0777 )
		lpq.fblocks++;
	if ( lpq.fblocks == 0 )  {
		printf("lp: ");
		if ( fname )
			printf(" %s  ", fname );
		printf("null request, not queued\n");
		if ( lpq.lpdfile )
			unlink( lpq.filename );
		return;
		}

	lpq.mdate[0] = statbuf.i_modtime[0];
	lpq.mdate[1] = statbuf.i_modtime[1];

	/* Write the queue element */
	lock( semfd );
	seek( qfd, 0, 2 );
	write( qfd, &lpq, LPQLNG );
	unlock( semfd );
	title_supplied = false;
	}




qualify( fname )
char	*fname;
	{
	register int	dirfd, cur_i_num;
	register char	*p;
	int		dev;
	static char	workingdir[FILENMLNG];

	if ( *fname == '/' )
		return( fname );

      tryagain:
	if ( *workingdir )  {
		p =  strcopy( workingdir, userbuf, FILENMLNG);
		p =  strcopy( fname, p, FILENMLNG-(p-userbuf) );
		return( userbuf );
		}

	/* Find the the pathname of the current directory */
	p = &userbuf[255];
	*p = '\0';
	*--p = '/';
	stat( "." , &statbuf );
	cur_i_num = statbuf.i_num;

	while ( cur_i_num != 1 )  {
		dirfd = open( ".." , 0 );
		while ( read( dirfd, &dirent, DIRENTLNG) == DIRENTLNG )
			if ( dirent.d_num == cur_i_num )  {
				dirent.d_num = 0;
				p =  prepend( dirent.d_name, p );
				p =  prepend( "/", p );
				chdir("..");
				stat( ".", &statbuf );
				cur_i_num = statbuf.i_num;
				goto foundname;
				}
		printf("lp: Unable to find path for :  %s\n", p );
		return(0);
	      foundname:
		close( dirfd );
		}

	dev = statbuf.i_dev;
	dirfd =  open( "/etc/mtab", 0 );
	while ( read( dirfd, &mountent, MOUNTLNG) == MOUNTLNG )  {
		if ( mountent.fname[0] == '\0' )
			continue;
		stat( mountent.fname, &statbuf );
		/* Check both for device and inumber = 1, because /etc/mtab
		   is not always accurate, eg when system first comes up */
		if ( (dev == statbuf.i_dev)  &&  (statbuf.i_num == 1) )  {
			p =  prepend( mountent.fname, p );
			if ( *p != '/' )
				p =  prepend("/", p );
			break;
			}
		}
	close( dirfd );

	strcopy( p, workingdir, FILENMLNG );
	chdir( workingdir );
	goto tryagain;
	}




make_file( fname )
char	*fname;
	{
	register char	*s, *f;
	register int	i;
	int		j, filein, fileout;

	/* If no filename, use standard input */
	if ( fname )  {
		if ( access( fname, READ) )
			return(-1);
		filein = open( fname, 0 );
		}
	else	filein = 0;

	/* Invent a filename */
	s =  strcopy( lpdfiles, lpq.filename, LPDFILELNG +1 );
	f = lpq.serial;
	for ( i=10000; i >0; i=/ 10 )  {
		*s++ = f/i + '0';
		f =% i;
		}
	*s = '\0';
	fileout =  creat( lpq.filename, 0600);
	if ( fileout < 0 )  {
		printf("lp: Can't open output file\n");
		return(-1);
		}

	/* Make a copy of the input */
	while ( (i= read( filein, userbuf, 512)) >0
		&&  (j= write( fileout, userbuf, i)) >0 );
	close( filein );
	close( fileout );
	if ( i < 0  ||  j < 0 )  {
		printf("lp: I/O error, request abandoned\n");
		unlink( lpq.filename );
		return(-1);
		}
	return(0);
	}




process_flag( aptr )
char	*aptr;
	{
	register char	*p, *s;
	int		i, off;
	char		*flag;

	flag = p = aptr;
	if ( *p == '-' )
		p++;
	off = false;
	/* Check for a 'not' */
	if ( *p == '!' )  {
		p++;
		off = true;
		}
	/* Put first two chars into i */
	i.lobyte = *p++;    i.hibyte = *p++;
	if ( *p != '\0'  &&  *p != '=' )
		i = 0;

	switch( i )  {

	case 'so':
		if ( getuid() != 0 )  {
			printf("lp: Must be superuser for -so flag\n");
			exit(-1);
			}
		start_only = true;
		break;

	case 'to':
		strcopy( ++p, lpq.to, UIDLNG);
		break;

	case 'tm':
		i =  atoi( ++p );
		if ( (i < 0)  ||  (i > 20) )
			i = 2;
		lpq.top_margin = i;
		break;

	case 'mg':
		i =  atoi( ++p );
		if ( (i < 0)  ||  (i > 30) )
			i = 8;
		lpq.margin = i ;
		break;

	case 'bm':
		i = atoi( ++p );
		if ( i < 0  ||  i > 20 )
			i = 2;
		lpq.bottom_margin = i;
		break;

	case 'pl':
		i =  atoi( ++p );
		if ( (i < 20)  ||  (i > 66) )
			i = PAGELNG;
		lpq.page_lng = i;
		break;

	case 'pw':
		i =  atoi( ++p );
		if ( (i < 20)  ||  (i > 132) )
			i = PAGEWIDTH;
		lpq.page_wdt = i;
		break;

	case 'tb':
		i = atoi( ++p );
		lpq.htabsize =  i ?  i: 8;
		break;

	case 'vt':
		i = atoi( ++p );
		lpq.vtabsize = i;
		break;

	case 'nu':
		lpq.numbers =  !off;
		return;

	case 'ti':
		if ( off )  {
			lpq.header = false;
			return;
			}
		++p;
		lpq.header = true;
		if ( *p != '\0' )  {
			title_supplied = true;
			strcopy( p, lpq.title, TITLELNG);
			}
		lpq.top_margin = lpq.bottom_margin = 2;
		lpq.margin = 8;
		return;

	case 'co':
		i =  atoi( ++p) ;
		if ( (i < 1)  ||  (i > 30) )  {
			printf("lp: %d copies, invalid\n", lpq.num_copies );
			exit( -1 );
			}
		lpq.num_copies = i ;
		break;

	case 'cp':
		lpq.lpdfile = !off;
		return;

	case 'uf':
		/* set all options to "no cosmetics" */
		lpq.num_copies = 1;
		lpq.header = false;
		title_supplied = false;
		lpq.numbers = false;
		lpq.page_lng = PAGELNG;
		lpq.page_wdt = PAGEWIDTH;
		lpq.lpdfile = false;
		lpq.top_margin = 0 ;
		lpq.margin = 0;
		lpq.bottom_margin = 0;
		break;

	default:
		printf("lp: Unknown flag  %s, ignored\n", flag );
		return;
		}
	if ( off )
		printf("lp: Flag  %s, '!' ignored\n", flag );
	}



strcopy( from, to, length )
char	*from, *to;
int	length;
	{
	register char	*f, *t;

	f = from;
	t = to;
	length++;
	while ( (*t++ = *f++)  &&  t-to <length );
	if ( t-to == length )  {
		printf("lp: Fatal error, string overflow:  %s\n", from );
		exit(-1);
		}
	return( t-1 );
	}




prepend( str1, str2 )
char	*str1, *str2;
	{
	register char	*former, *latter, *firstchar;

	firstchar = str1;
	latter = str2;
	for ( former=firstchar; *former; former++ );

	while ( former > firstchar )
		*--latter = *--former;
	return( latter );
	}




#define	OWNER		0100
#define	GROUP		010
#define	WORLD		01
#define	SUPERUSER	0

access( pathname, rwe )
char	*pathname;
int	rwe;
	{

	if ( stat( pathname, &statbuf) < 0 )  {
		printf("lp: %s  does not exist\n", pathname);
		return(-1);
		}
	if ( (statbuf.i_uid==user.u_uid  &&  statbuf.i_flags&(OWNER<<rwe) )
	   ||  ( statbuf.i_gid==user.u_gid  &&  statbuf.i_flags&(GROUP<<rwe) )
	   ||  ( statbuf.i_flags&(WORLD<<rwe))  ||  user.u_uid==SUPERUSER )
		return(0);
	printf("lp: %s  no permission\n", pathname );
	return(-1);
	}




delete()
	{

	if ( lpq.lpdfile )
		unlink( lpq.filename );
	exit();
	}
