#

/*
 *  A rudimentary (but small) semaphore system.
 */

#include	"../param.h";
#include	"../file.h"
#include	"../user.h"
#include	"../reg.h"
#include	"../conf.h";

#define	SEMPRI	60

char	semaphores[ NSEM ];

semphr( dev )
int	dev;
	{
	register struct file	*fp;
	char			*byte, sem;

	/* Clobber the (irrelevant) file offset pointer */
	fp =  u.u_ofile[ u.u_ar0[R0] ];
	fp->f_offset[0] =  fp->f_offset[1] =  0;

	sem = dev.d_minor;
printf("SEMLOG: sema %o op %o\n", sem, u.u_arg[0]);
	if ( (byte= sem>>3 ) >= NSEM )  {
		u.u_error = ENXIO;
		return;
		}
	byte =  &semaphores[ byte];
	sem =  1<< ( sem &07 );
	u.u_arg[1] = 0;
	spl7();
	if ( *byte &sem )
		u.u_arg[1] = 1;

printf("SEMLOG: was %o\n", u.u_arg[0]);
	switch ( u.u_arg[0] )  {

	/* unlock */
	case 0: *byte =& ~sem;
		wakeup( byte );
		break;

	/* lock */
	case 1:	while ( *byte &sem )
			sleep( byte, SEMPRI );
	/* lockif */
	case 2: *byte =| sem;

	/* locked */
	}

printf("SEMLOG: now %o\n", *byte &sem);
	out:	spl0();
	}



semclose( dev, flag )
int	dev, flag;
	{
	register char	*byte, sem;

	sem = dev.d_minor;
	if ( (byte= sem>>3 ) >= NSEM )  {
		u.u_error = ENXIO;
		return;
		}
	sem =  1<< ( sem &07 );
	semaphore[ byte] =&  ~sem;
	}
