#

/*
 *          write
 *
 *          written in C by Duncan MacLean  7th Dec 76
 */


#define  INTERRUPT  2
#define  BELL  '\007'


    char buf[512];     /*  message buffer  */


unix()      /*  escape temporarily to system  */
{
    register pid,rpid,savint;
    int  *retcode;

    if( (pid = fork()) == -1 ) {
        printf("?\n");
        return;
    }
    if(pid == 0) {
        execl("/bin/sh","sh","-c",&buf[1]);
        exit();
    }
    savint = signal(INTERRUPT,1);
    while( (rpid = wait(retcode)) != pid )
        if(rpid == -1) {
            printf("?\n");
            break;
        }
    signal(INTERRUPT,savint);
    return;
}


compar(s1,s2)     /*  note: names in utmp are padded with blanks  */
    char *s1,*s2;
{
    while(*s1 == *s2) { 
        if(*s2 == '\0') 
            return(1);
        s1++;
        s2++;
    }
    if(*s1 == '\0' && *s2 == ' ')
        return(1);
    return(0);
}




stop()      /*  on EOT or interrupt  */
{
    printf("End of message ...\n\n%c",BELL);
    exit();
}




main(argc,argv)

    int    argc;
    char **argv;
{
    struct {
        char name[14];
        char tty;
        char pad1;
        int  time[2];
        char pad2[2];
    }   utmp;

    char my_name[15],my_tty;
    char *your_name,your_tty;
    char *s,t;

    int i,j,file;


    if(argc <= 1) {
        printf("Usage: write user [ttyno]\n");
        /*  other suggestions are welcome  */
        exit();
    }

    file = open("/etc/utmp",0);
    if(file < 0) {
        printf("Cannot open utmp.\n");
        exit();
    }

    s = argv[1];

    if(argc >= 3)
        t = (argv[2][1] == '\0' ?       /*  to allow arguments of the  */
            *argv[2] : argv[2][3]);     /*  form "ttyx" or simply "x"  */

    *my_name = '\0';
    my_tty = ttyn(0);

    *your_name = '\0';
    your_tty = 'x';



    while( read(file,&utmp,sizeof utmp) ) {

        if(utmp.name[0] == '\0')
            continue;

        else {
            if(utmp.tty == my_tty) {
                for(i = 0; (my_name[i] = utmp.name[i])
                            != ' ' && i < 14; i++);
                my_name[i] = '\0';
            }
            if(compar(s,utmp.name)) {
                your_name = s;
                if(argc >= 3 && utmp.tty != t)
                    continue;
                your_tty = utmp.tty;
            }
        }
    }

    close(file);

    if(*my_name == '\0' || my_tty == 'x') {
        printf("Standard input?\n");
        exit();
    }

    if(*your_name == '\0') {
        printf("%s not logged in.\n",s);
        exit();
    }

    if(your_tty == 'x') {
        printf("%s tty%c not logged in.\n",s,t);
        exit();
    }

    s = "/dev/ttyx";
    s[8] = your_tty;
    file = open(s,1);

    if(file < 0) {
        printf("Permission refused.\n");
        exit();
    }

    j = dup(1);
    close(1);
    dup(file);

    printf("\nMessage from %s tty%c ...\n%c",my_name,my_tty,BELL);

    signal(INTERRUPT,stop);



    while( i = read(0,buf,512) )

        if(buf[0] != '!')
            write(file,buf,i);

        else {
            close(1);
            dup(j);
            buf[i] = '\0';
            unix();
            printf("!\n");
            close(1);
            dup(file);
        }

    stop();

}
