#
/*
 * mountdisk - mounts a disk after checking for permission in the label
 */


#define	MAIN -
#include	"label.h"

#define	NO_PERMIT	"Disk has no mount permission on drive %s\n", *argv

int	flag, write_access, newpid, pid, permit, status;
char	*labelp, *namep, *arg;
char	device[20];


main( argc,argv )
int	argc;
char	**argv;
	{

	argc--;    argv++;

	flag = false;
	arg = *argv;
	if ( *arg == '-' )  {
		if ( *++arg != 'r' )  {
			printf("Unknown flag:  %s\n", *argv );
			exit(-1);
			}
		flag = true;
		argc--;    argv++;
		}

	/* Check that it was called with 1 device argument */
	if ( argc != 1 )  {
		printf("Usage is:  mount (-r) {device}\n");
		exit(-1);
		}

	switch ( check_label( *argv) )  {

	case BOOTPROGRAM:
		printf( NO_PERMIT );
		exit(-1);
	case UNRECOGNIZED:
		printf("Disk %s not mounted, pack has no label\n", *argv );
		exit(-1);
	case VALIDLABEL:
		break;
		}

	/* Examine the devices field of the label for mount permission */
	labelp = label->devices;
	permit = false;
	write_access = false;
	while ( !permit  )  {
		while ( *labelp == ' ')
			labelp++;
		namep = *argv;
		while ( *namep != '\0' &&  *labelp != '\0'
				&&  *namep == *labelp )  {
			namep++;
			labelp++;
			}
		if ( *namep != '\0'  ||  *labelp != ':' )  {
			/* We have found it yet, skip to next entry */
			while ( *labelp != ' '   &&   *labelp != '\0' )
				labelp++;
			if ( *labelp =='\0' )
				break;
			continue;
			}

		/* The label gives mount permission;  r/w ? */
		permit = true;
		if ( *++labelp == 'w' )
			write_access = true;
		}

	if ( !permit )  {
		printf( NO_PERMIT );
		exit(-1);
		}

	if ( flag )
		write_access = false;

	/* Mount the disk */
	pid = getpid();
	newpid =fork();
	if ( pid != getpid())  {
		if ( write_access )
			execl( "/etc/mount", " ", device, label->mount_name, 0);
		execl( "/etc/mount", " ", device, label->mount_name, "-r", 0);
		}
	while ( wait(&status) !=newpid );
	if ( status < 0 )
		exit(-1);
	printf("Disk :        %s\n", label->disk_name );
	printf("Mounted as :  %s\n", label->mount_name );
	if ( write_access )
		printf("Access :      Read/Write\n");
	else
		printf("Access :      Read only\n");
	}
