
/*
 *  Data initialization for the RK handler
 */


#define	NRKDEV	4


/*  * * * *   Port 0   * * * *  */

struct ldisk	rk0[]  {

/* Ldisk 0 */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	0,		/* lo cyl */
	4872,		/* no of blocks */
	&rk0[0],	/* av_forw */
	&rk0[0]		/* av_back */
	};

struct prilev	rk0prio[]  {

/* Level 0 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	rk_ord0,	/* service order */
	0,		/* current ldisk */
	0,		/* next bp for service */

	-1		/* Terminator */
	};


/*  * * * *   Port 1   * * * *  */

struct ldisk	rk1[]  {

/* Ldisk 0 */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	0,		/* lo cyl */
	4872,		/* no of blocks */
	&rk1[0],	/* av_forw */
	&rk1[0]		/* av_back */
	};

struct prilev	rk1prio[]  {

/* Level 0 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	rk_ord0,	/* service order */
	0,		/* current ldisk */
	0,		/* next bp for service */

	-1		/* Terminator */
	};


/*  * * * *   Port 2   * * * *  */

struct ldisk	rk2[]  {

/* Ldisk 0 */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	0,		/* lo cyl */
	4872,		/* no of blocks */
	&rk2[0],	/* av_forw */
	&rk2[0],	/* av_back */

/* Ldisk 1 */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	24,		/* lo cyl */
	4056,		/* no of blocks */
	&rk2[1],	/* av_forw */
	&rk2[1],	/* av_back */

/* Ldisk 2 */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	0400,		/* lo cyl, cyl 0 of drive 3 (nasty frig) */
	4872,		/* no of blocks */
	&rk2[2],	/* av_forw */
	&rk2[2]		/* av_back */
	};

struct prilev	rk2prio[]  {

/* Level 0 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	rk_ord0,	/* service order */
	0,		/* current ldisk */
	0,		/* next bp for service */

/* Level 1 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	rk_ord1,	/* service order */
	0,		/* current ldisk */
	0,		/* next bp for service */

	-1		/* Terminator */
	};


char	rk_ord0[]	"\0,\0;"  ;
char	rk_ord1[]	"\1\2,\2,\2,\2\1;"  ;


/*  * * * *   Pdisks   * * * *  */

struct pdisk	rkdisks[]  {

/* Pdisk 0 */
	0,		/* current request */
	0,		/*    "    ldisk */
	0 |		/* error count */
	(  0  <<8),	/* errors printed */
	0,		/* r/w queue linkage */
	0,		/* physical address 1 */
	0,		/* physical address 2 */
	0,		/* error register */
	0,		/* words after error */
	0 |		/* flags */
	(  1  <<8),	/* no. of ldisks */
	rk0,		/* the ldisks */
	&rkstart,	/* seek start routine */
	rk0prio,	/* priority level structures */

/* Pdisk 1 */
	0,		/* current request */
	0,		/*    "    ldisk */
	0 |		/* error count */
	(  0  <<8),	/* errors printed */
	0,		/* r/w queue linkage */
	0,		/* physical address 1 */
	0,		/* physical address 2 */
	0,		/* error register */
	0,		/* words after error */
	0 |		/* flags */
	(  1  <<8),	/* no. of ldisks */
	rk1,		/* the ldisks */
	&rkstart,	/* seek start routine */
	rk1prio,	/* priority level structures */

/* Pdisk 2 */
	0,		/* current request */
	0,		/*    "    ldisk */
	0 |		/* error count */
	(  0  <<8),	/* errors printed */
	0,		/* r/w queue linkage */
	0,		/* physical address 1 */
	0,		/* physical address 2 */
	0,		/* error register */
	0,		/* words after error */
	0 |		/* flags */
	(  3  <<8),	/* no. of ldisks */
	rk2,		/* the ldisks */
	&rkstart,	/* seek start routine */
	rk2prio		/* priority level structures */
	};
