#-h- ckdos2.asm                  7_0 ascii 05/18/84 14:10:00
page 66,96
include mcall.asm
include libdefs.asm

extrn initzz:far
extrn exit:far

ckdos segment byte public 'code'
    assume cs:ckdos, ds:nothing, es:nothing, ss:nothing

;*******************************************
;
;## ckdos2 -- abort if DOS version not at least 2.00
;
;  synopsis:
;	call ckdos2

ckdos2_msg db 'requires DOS version 2 or greater',cr,lf,'$'
ckdos2_err_code dw TOOLERR

fentry ckdos2
    assume cs:ckdos, ds:nothing, es:nothing, ss:nothing
    save ds

    mov ah,ms_version
    int 21h
    cmp al,2
    jae ckdos2_end

    mov dx,cs		; Print warning using older,
    mov ds,dx		;   universal method
    assume ds:ckdos
    lea dx,ckdos2_msg
    mov ah,ms_print_str
    int 21h

    call initzz			; Initialize for exit.
    lea dx,ckdos2_err_code	; Quit.
    bcall exit,<cs,dx>

    fend ckdos2

ckdos ends

end
#-t- ckdos2.asm                  7_0 ascii 05/18/84 14:10:00
#-h- genv0z.asm                27_14 ascii 05/18/84 15:17:20
page 66,96
include mcall.asm
include libdefs.asm

extrn psp_seg:word

genv segment byte public 'code'
    assume cs:genv, ds:nothing, es:nothing, ss:nothing

;*****************************
;
;## genv0z -- extract named environment entry as a string
;	(whole string after EQUALS)
;
;	stat = genv0z(nam,space,siz)	# Returns ERR if space too small,
;					#   NO if not found,
;					#   YES if found.
;		integer*2 stat, genv0z, siz
;		integer*2 space(siz)	# Counting room for EOS.
;		integer*2 nam		# String to search for:
;					#   no leading or trailing white space
;					#   or EQUALS signs.
;				# Won't match character unless upper byte
;				#   is 0.
;
;	Version for MS-DOS 2+ 5/9/84 PLD


genv0z_fold proc near
    assume cs:genv, ds:nothing, es:nothing, ss:nothing

    cmp al,'A'
    jb genv0z_fold_end
    cmp al,'Z'
    ja genv0z_fold_end

    add al,'a'-'A'

genv0z_fold_end:
    ret

genv0z_fold endp

fentry genv0z,<nam,space,siz>
    assume cs:genv, ds:nothing, ss:nothing, es:nothing
    save ds

    mov bx,seg psp_seg	; Get pointer to PSP
    mov ds,bx
    assume ds:nothing
    mov bx,offset psp_seg
    mov ds,[bx]
    assume ds:nothing	; Now DS:0 --> PSP

    mov bx,psp_env	; Extract pointer to env from PSP
    mov ds,[bx]
    assume ds:nothing
    xor si,si

    cld

genv0z_next_entry:	; DS:SI --> beginning of entry
	assume ds:nothing, es:nothing
	cmp byte ptr [si],0 ; See whether end of environment
	je genv0z_none

genv0z_skip_white:
	lodsb
	cmp al,0	; See whether end of entry
	je genv0z_next_entry

	cmp al,BLANK	; Step over white space
	je genv0z_skip_white
	cmp al,TAB
	je genv0z_skip_white

	dec si
	mov bx,si	; Save start of string

genv0z_find_end:	; Find end of string
	lodsb
	cmp al,0
	je genv0z_next_entry
	cmp al,BLANK
	je genv0z_found_end
	cmp al,TAB
	je genv0z_found_end
	cmp al,EQUALS
	jne genv0z_find_end

genv0z_found_end:	; Found end of string

	dec si		; DS:SI --> delimiter after string
	mov dx,si	; Save end of string

			; Compare string with nam
	mov cx,dx
	sub cx,bx	; CX = length of string
	jcxz genv0z_differ
	les di,nam
	assume es:nothing
	mov si,bx
	mov ah,0
genv0z_compare:
	    lodsb
	    call genv0z_fold
	    cmp ax,es:[di]	; Matches only if upper byte of
				;   character in nam is 0.
	    jne genv0z_differ
	    inc di
	    inc di
	    loop genv0z_compare

			; Fall through implies match

	mov si,dx
genv0z_find_equals:	; Step forward to EQUALS sign
	    lodsb
	    cmp al,0
	    je genv0z_next_entry
	    cmp al,EQUALS
	    jne genv0z_find_equals

			; DS:SI --> string after EQUALS

	les di,siz	; Unpack this entry
	assume es:nothing
	mov cx,es:[di]
;	dec cx		; Removed for 2.00 5/9/84 PLD
	cmp cx,0
	jle genv0z_err	; siz <= 0, so automatic overflow.
	les di,space
	assume es:nothing
	cld
	mov ah,0
genv0z_copy:
	    lodsb
	    cmp al,0
	    je genv0z_done
	    stosw
	    loop genv0z_copy
	jmp short genv0z_err ; Probable overflow.
genv0z_done:
    mov ax,EOS
    stosw

    mov ax,YES
    jmp short genv0z_end

genv0z_differ:		; Step past next null
    assume ds:nothing, es:nothing
    lodsb
    cmp al,0
    jne genv0z_differ
    jmp genv0z_next_entry

genv0z_none:
    assume ds:nothing, es:nothing
    mov ax,NO
    jmp short genv0z_end

genv0z_err:
    assume ds:nothing, es:nothing
    mov ax,ERR

    fend genv0z

genv ends

end
#-t- genv0z.asm                27_14 ascii 05/18/84 15:17:20
#-h- gprfxz.asm                35_51 ascii 05/18/84 14:10:00
page 66,102
include mcall.asm
include libdefs.asm
include prfx.asm

extrn initzz:far
extrn psp_seg:word

box1 segment byte 'code'

;**************************************
;
;## gprfxz -- extract info from tool.com into common block /prfx/
;
;	stat = gprfxz(dum)	# Returns OK or ERR.
;	integer stat, gprfxz
;	anything dum		# unused but must be present.
;
;	Version for MS-DOS 2+ 5/4/84 PLD
; Copyright (c) 1984 by Carousel MicroTools Inc., El Cerrito, CA, USA

signature db '>CMT'

fentry gprfxz,<dum>
    assume cs:box1, ds:nothing, es:nothing, ss:nothing
    save ds

    call initzz		; Initialize psp_seg.

    mov dx,ds		; Save temporarily

    mov bx,seg psp_seg
    mov ds,bx
    assume ds:nothing
    mov bx,offset psp_seg
    mov ds,[bx]
    assume ds:nothing	; Now DS:0 --> PSP

    mov ax,cs		; Check start of cmd line for signature
    mov es,ax
    assume es:box1
    mov di,offset signature
    mov si,cmd_line
    mov cx,4
    cld
    repe cmpsb

    mov es,dx
    assume es:dgroup
    mov es,prfx_seg
    assume es:prfx	; Now ES --> /prfx/

    je gprfxz_indirect	; If match failed, assume direct call
    jmp gprfxz_direct	;   (not from tool.com).

gprfxz_indirect:
    mov isdrct,NO	; Signature found:  we were called by tool.com.

    			; Copy tool name to toolnm
    mov di,offset toolnm
    mov cx,8
    mov ah,0
gprfxz_name:		; It's padded with blanks; caller trims it.
	lodsb
	stosw
	loop gprfxz_name
    mov word ptr es:[di],EOS

			; Get flag bits.
    mov di,offset flags
    mov bl,2		; Counter for outer loop:  2 passes,
			;   one flag byte (6 bits) per pass.
gprfxz_6_flags:
	lodsb
	shl al,1	; Discard leading 2 bits.
	shl al,1
	mov cx,6	; Counter for inner loop:  6 passes,
			;   one bit per pass.
gprfxz_1_flag:
	    mov word ptr es:[di],NO
	    shl al,1	; Move relevant bit into CF.
	    jnc gprfxz_no_bit
		mov word ptr es:[di],YES
gprfxz_no_bit:
	    inc di
	    inc di
	    loop gprfxz_1_flag
	dec bl
	jnz gprfxz_6_flags

			; Extract address from next 6 bytes:
			;   build it in BX:DX.
    lodsb
    and ax,11b		; Leading 2 bits.
    ror ax,1
    ror ax,1
    mov bx,ax

    lodsb
    and al,111111b	; Next 6 bits.
    or bh,al		; Now BH has top 8 bits.

    lodsb
    and al,111111b	; Next 6 bits.
    shl al,1
    shl al,1
    mov bl,al		; Top 14 bits of BX are done.

    lodsb
    and ax,111111b	; Next 6 bits.
    mov cl,4
    shl ax,cl
    or bl,ah		; Now BX is done.
    mov dh,al		; Top 4 bits of DX are done.
    xor dl,dl

    lodsb
    and ax,111111b	; Next 6 bits.
    mov cl,6
    shl ax,cl
    or dx,ax		; Top 10 bits of DX are done.

    lodsb
    and al,111111b	; Lowest 6 bits.
    or dl,al		; BX & DX are both done.

    mov di,offset addr	; Save the completed 32-bit number.
    mov ax,bx
    stosw
    mov ax,dx
    stosw

			; Now blank out all the stuff we just decoded.
    mov ax,ds
    mov es,ax
    assume es:nothing	; ES --> PSP
    mov di,cmd_line
    mov al,BLANK
    mov cx,20
    rep stosb

    mov ax,OK
    jmp short gprfxz_end

gprfxz_direct:
    assume ds:nothing, es:prfx	; DS --> PSP, ES --> /prfx/

    mov isdrct,YES

    mov di,offset flags	; Clear flags.
    mov cx,length flags
    mov ax,NO
    rep stosw

    mov di,offset addr	; Clear addr.
    mov ax,0
    stosw
    stosw

			; Extract first arg as toolnm
			;   and blank it out.

    mov di,offset toolnm

    mov si,cmd_lth	; Note end of command line in DX.
    lodsb
    xor ah,ah
    mov dx,si
    add dx,ax		; DS:DX --> trailing CR.
    
    			; First skip leading white space.
gprfxz_skip_white:
        cmp byte ptr [si],BLANK
	je skip
	cmp byte ptr [si],TAB
	jne found_toolnm
skip:
	inc si
	cmp si,dx
	jb gprfxz_skip_white	; Keep skipping white space

			; Fall through:  ran out of command line
			;   hence toolnm is empty
    mov word ptr es:[di],EOS
    mov ax,OK
    jmp short gprfxz_end

found_toolnm:
    mov bx,(offset toolnm) + 16	; Limit for copying.

copy_toolnm:		; Copy till blank, tab, full, or none left.
	lodsb
	mov byte ptr [si-1],BLANK
	cmp al,BLANK
	je toolnm_done
	cmp al,TAB
	je toolnm_done
	cmp di,bx
	jae toolnm_full
	stosw
	cmp si,dx
	jb copy_toolnm

toolnm_done:
    mov word ptr es:[di],EOS
    mov ax,OK
    jmp short gprfxz_end

toolnm_full:		; Tool name too big.
    mov word ptr es:[di],EOS
    mov ax,ERR

    fend gprfxz

box1 ends

end
#-t- gprfxz.asm                35_51 ascii 05/18/84 14:10:00
#-h- lowio1.asm               187_61 ascii 04/25/84 16:12:21
page 66,96	; For 8 inches, 12 columns/inch.
;************************************************
;
;			LOWIO1.ASM
;
;	Assembler versions of certain ratfor routines in
;	    the Tools' I/O library.
;
;	MS-DOS version 2.00 version in progress 4/4/84

include mcall.asm
include libdefs.asm
include dprimio.asm
include cdsmem.asm

extrn fdokzz:far, exit:far, putlin:far, putint:far, error:far
extrn getrzz:far, getbzz:far, cantzz:far, flush:far

dwletter macro letter,label	;; label is optional.
    @@let = '&letter'
    label dw @@let
    endm

wordstring macro msg,label	;; label is optional.
    @@count = 0
    irpc letter,<msg>
	ife @@count
		dwletter <letter>,<label>
	    else
		dwletter <letter>
	    endif
	@@count = @@count + 1
	endm
    dw EOS
    endm

sframe	struc
savebp	dw	?
retu	dd	?
toparg	dd	?
penarg	dd	?
fstarg	dd	?
sframe	ends

lowio_data segment word public	; Don't use class 'data'!

    first_comads dd ?	; Address of first COMADS entry, normalized.
    first_const dd ?	; Address of first CONST entry, normalized.
			; "Normalized" means having unsigned offset
			;   of minimal value (0 to 0Fh).

			; Table of assembly-level data spaces
			;   to which to relocate fortran common blocks.
    segtable equ this word
    Mem_addr dw offset Mem, seg Mem ; First table entry:
			;	dword addr of first item in /cdsmem/,
			;	to be normalized by savfst.

; (commented out because unused)
;    heap_offset dw offset ds_moat1
;    heap_seg dw seg ds_moat1

    ds_moat2_offset dw ?
    ds_moat2_seg dw ?

    lowio_data ends

lowio1 segment byte 'code'

;**************************************
;
;## savfst -- Record addr of first entries in COMADS and CONST;
;	also save normalized address of Mem as first item in segtable.
;
;	stat = savfst(cnstnt,var)	# Returns OK or ERR.
;	integer*2 stat, savfst
;	# var must be the first variable stored in COMMON in the
;	#   whole program.
;	# cnstnt must be the first constant declared in the whole program:
;	#   its value must be FIRST_CONSTANT

fentry savfst,<cnstnt,var>
    assume cs:lowio1, ds:nothing, ss:nothing, es:nothing
    save ds

    mov dx,ds		; Save initial DS.

    mov bx,seg Mem_addr	; Normalize Mem_addr in place.
    mov ds,bx
    assume ds:lowio_data
    lea bx,Mem_addr
    les di,dword ptr [bx]
    call norm_es_di
    mov [bx],di
    mov [bx]+2,es

    mov ds,dx		; Restore initial DS.
    assume ds:nothing

    les bx,[bp].retu
    assume es:nothing
    mov bx,es:[bx]-9	; Extract pointer to COMADS entry
			;   from calling code.
			; Now DS:BX --> COMADS entry (4 bytes).

			; Compare against addr of passed var.
    les di,var
    assume es:nothing
    cmp di,[bx]
    jne savfst_err
    mov ax,es
    cmp ax,[bx]+2
    jne savfst_err
			; Fall through means COMADS entry points
			;   where we expected it to.

    les di,cnstnt
    assume es:nothing
    cmp word ptr es:[di],FIRST_CONSTANT	; Check for correct value.
    jne savfst_err

    call norm_es_di
    assume es:nothing
    mov dx,es
    mov cx,di		; DX:CX --> First CONST entry.

    mov ax,ds		; Temporarily move DS:BX into ES:DI
    mov es,ax		;   for normalization.
    assume es:nothing
    mov di,bx
    call norm_es_di
    assume es:nothing
    mov bx,di
    mov ax,es
    mov ds,ax
    assume ds:nothing

    mov ax,seg first_comads
    mov es,ax
    assume es:lowio_data
    mov first_comads,bx
    mov first_comads+2,ds
    mov first_const,cx
    mov first_const+2,dx

    mov ax,OK
    jmp short savfst_end

savfst_err:
    mov ax,ERR
    fend savfst

;***************************************
;
;## relcom -- relocate a Fortran common block to coincide with
;	a particular segment, chosen by number.
;
;	stat = relcom(segnum,var)	# Returns OK or ERR.
;	integer*2 stat, relcom
;	integer*2 segnum	# See list of choices in code below.
;				# var must be the very first item
;				#   in the common block.

fentry relcom,<segnum,var>
    assume cs:lowio1, ds:nothing, es:nothing, ss:nothing
    auto <orig_seg,orig_offset>
    save ds

    les bx,[bp].retu
    assume es:nothing
    mov si,es:[bx]-9	; Extract pointer to COMADS entry
			;   from calling code.
			; Now DS:SI --> COMADS entry (4 bytes).

			; Compare against addr of passed var.
    les di,var
    assume es:nothing
    cmp di,[si]
    jne relcom_err
    mov ax,es
    cmp ax,[si]+2
    jne relcom_err
			; Fall through means COMADS entry points
			;   where we expected it to.

    cld
    lodsw		; Save value of original COMADS entry
    mov orig_offset,ax	;   so we can search for its recurrence.
    lodsw
    mov orig_seg,ax

    les bx,segnum
    mov bx,es:[bx]

    cmp bx,CDSMEM_BLK	; Check whether segnum is a known value.
    jne relcom_err

    mov bx,0
			; Now BX is an index into table of segment addresses.

    mov ax,seg first_comads
    mov ds,ax
    assume ds:lowio_data
    les di,first_comads	; ES:DI --> First COMADS entry (normalized).
    assume es:nothing
    lds si,first_const
    assume ds:nothing
    mov dx,ds
    sub si,4
    sbb dx,0	; DX:SI --> Four bytes before
			;   first CONST entry (normalized).

    mov ax,seg segtable
    mov ds,ax
    assume ds:lowio_data

relcom_top:
    assume es:nothing, ds:lowio_data
    add di,4				; Advance ES:DI,		
relcom_check:
	assume es:nothing, ds:lowio_data
	call norm_es_di			;   and normalize them.
	assume es:nothing
			; Check ES:DI.
	mov ax,es	; Exit loop if ES:DI meets or exceeds DX:SI.
	cmp ax,dx
	jb relcom_ok_to_look
	cmp di,si
	jae relcom_done

relcom_ok_to_look:
	mov ax,orig_offset
	cmp es:[di],ax
	jne relcom_top	; Not a match:  check next COMADS entry.
	mov ax,orig_seg
	cmp es:[di]+2,ax
	jne relcom_top	; Not a match:  check next COMADS entry.

	mov ax,segtable[bx]	; Matches, so replace this entry
	stosw			;   with pointer to our data space.
	mov ax,segtable[bx]+2
	stosw			; (Segment wraparound is not a danger
				;   with these STOSWs because ES:DI are
				;   normalized.)
	jmp relcom_check
    
relcom_done:
    mov ax,OK
    jmp short relcom_end

relcom_err:
    assume ds:nothing, es:nothing
    mov ax,ERR

    fend relcom

;************************************
;
;## dsintz -- set up /cdsmem/ at MS-DOS Fortran heap
;
; Version for MS-DOS Fortran 1.00 in progress 2/29/84 PLD.
;
;   synopsis:
;	stat = dsintz(Mem_entry) # Returns OK or ERR.
;	integer*2 stat, dsintz
;	integer Mem_entry	# First element of array Mem

fentry dsintz,<Mem_entry>
    assume cs:lowio1, ds:nothing, ss:nothing, es:nothing
    save ds

    mov di,seg Mem	; Check that Mem_entry points properly at
    mov es,di		;   assembler version of Mem in heap.
    assume es:heap	;  (Address passed should have been normalized by
    mov di,offset Mem	;  savfst above.)
    call norm_es_di
    assume es:nothing
    lds ax,Mem_entry
    cmp ax,di
    je dsintz_ok_1
    jmp dsintz_err
dsintz_ok_1:
    mov ax,ds
    mov cx,es
    cmp ax,cx
    je dsintz_ok_2
    jmp dsintz_err
dsintz_ok_2:

    mov ax,ss		; Put doubleword stack pointer into ES:BX
    mov es,ax
    assume es:nothing
    mov bx,sp

    call addr_to_32	; Convert address ES:BX to
			;   32-bit integer in DX:DI

			; DX:DI now has 32-bit stack pointer.
			; DX:DI represents top of space above heap:
			;   we will deduct several items for which we
			;   must allow space above /cdsmem/.
			; Any negative result means no space for /cdsmem/.

			; First allow space for stack:
    mov si,ds_stacksize*2 ; CX:SI = 32-bit stack size
    mov cx,0

    sub di,si		; DX:DI = DX:DI - CX:SI
    sbb dx,cx
    jc dsintz_err

    mov si,ds_moat2_size*2; Next subtract space for moat2.
    mov cx,0

    sub di,si
    sbb dx,cx
    jc dsintz_err

    call conv_32_to_addr ; Convert DX:DI to doubleword address in ES:BX;
    assume es:nothing
    mov ax,seg ds_moat2_offset
    mov ds,ax
    assume ds:lowio_data
    mov ds_moat2_offset,bx	;   save it as start of 2nd moat.
    mov ds_moat2_seg,es

    les bx,Mem_entry	; Finally compare with beginning of /cdsmem/
    assume es:nothing
    xchg dx,cx
    xchg di,si
    call addr_to_32
    xchg cx,dx
    xchg si,di
    sub di,si
    sbb dx,cx
    jc dsintz_err
			; Now DX:DI contains number of bytes 
			;   available for /cdsmem/.

    			; Convert DX:DI to word count
    shr dx,1		;   (divide by 2)
    rcr di,1

    cmp di,ds_memsize_max ; Use smaller of DI and DS_MEMSIZE_MAX.
    jbe dsintz_limited
    mov di,ds_memsize_max
dsintz_limited:

    cmp di,ds_memsize	; Give up if DI too small for minimal /cdsmem/.
    jb dsintz_err

    les bx,Mem_entry	; Save the size finally found.
    assume es:nothing
    mov es:[bx].((DS_MEMEND-1)*2),di

			; Fill the moats so we can detect high water
			;   marks of heap and stack.
    cld

			; (moat1 filled at link time)
    mov di,ds_moat2_offset
    mov es,ds_moat2_seg
    assume es:nothing
    mov cx,ds_moat2_size
    mov ax,DS_MOAT2_WORD
    rep stosw

    mov ax,OK
    jmp short dsintz_end

dsintz_err:
    mov ax,ERR

    fend dsintz

;***************************************
;
;## addr_to_32 -- local routine to convert (overlapping) doubleword
;	address in ES:BX to 32-bit (actually 20-bit) number in DX:DI.

addr_to_32 proc near
    assume cs:lowio1, es:nothing, ds:nothing, ss:nothing

    mov dx,es
    rept 4
	rol dx,1
	endm
    and dx,1111b
    mov di,es
    rept 4
	shl di,1
	endm
    add di,bx
    adc dx,0

    ret

    addr_to_32 endp

;********************************
;
;## conv_32_to_addr -- convert 20-bit number to doubleword address
;	(normalized).
;
;	In:  DX:DI	Out:  ES:BX

conv_32_to_addr proc near
    assume cs:lowio1, ds:nothing, es:nothing, ss:nothing

    mov bx,dx
    xor bx,di
    and bx,1111b
    xor bx,di		; Lower 4 bits of BX are those of DX;
			;   upper 12 bits of BX are those of DI.
    rept 4
	ror bx,1
	endm		; Now BX has bits 19-4 of DX:DI in order,
    mov es,bx		;   and they are put into ES.
    assume es:nothing
    mov bx,di
    and bx,1111b

    ret

    conv_32_to_addr endp

;**********************************
;
;## dschkz -- abort if /cdsmem/ not healthy
;
;	synopsis:	call dschkz

dschkz_msg db 'dynamic storage overwritten by stack or heap',cr,lf
dschkz_err_code dw toolerr
dschkz_msg_size equ dschkz_err_code-dschkz_msg

fentry dschkz
    assume cs:lowio1, ds:nothing, es:nothing, ss:nothing
    save ds

    cld

    mov ax,seg ds_moat1
    mov es,ax
    assume es:heap
    mov di,offset ds_moat1
    mov cx,ds_moat1_size
    mov ax,ds_moat1_word
    repe scasw
    jne dschkz_err

    mov ax,seg ds_moat2_offset
    mov ds,ax
    assume ds:lowio_data
    mov di,ds_moat2_offset
    mov es,ds_moat2_seg
    assume es:nothing
    mov cx,ds_moat2_size
    mov ax,ds_moat2_word
    repe scasw
    je dschkz_end

dschkz_err:
    mov dx,cs		; By this point we should have confirmed
    mov ds,dx		;   DOS version 2+.
    assume ds:lowio1
    lea dx,dschkz_msg
    mov cx,dschkz_msg_size
    mov bx,ms_errout_handle
    mov ah,ms_putch
    int 21h

    lea dx,dschkz_err_code
    bcall exit,<cs,dx>

    fend dschkz

;*************************************
;
;## getchz -- get byte from file fd
;
;	stat = getchz(char, fd)	# Returns OK, ERR, or EOF.
;	integer*2 stat, getchz, fd
;	character char

wordstring <** getchz: illegal I/O mode fd = >,getchz_msg
getchz_msg_1 dw 1
getchz_msg_errout dw ERROUT
getchz_msg_eos dw EOS

fentry getchz,<char,fd>
    assume cs:lowio1, ds:dgroup, es:nothing, ss:dgroup
    auto <strt_hiword,strt_loword>
;   Don't say "save ds" because we must save it explicitly
;	in order to retrieve it in the middle of the routine.

			; character char
			; filedes fd
			; integer n,b,l
  			; integer junk, itoc, bf, getrzz
  			; character peek2

			; string msg "** getch: illegal I/O mode fd = "

    mov dx,ds		; # Save DS in DX.
    lds bx,fd
    assume ds:nothing
    mov si,[bx]		;	# SI = fd - 1
    sub si,1		;	# Not DEC because we need to check carry
    jl getchz_bad_fd	; if (fd < 1 | fd > MAXOFILES)
    cmp si,MAXOFILES	;	go to GETCHZ_BAD_FD
    jge getchz_bad_fd

    shl si,1
    mov ds,dio_seg
    assume ds:dio

    mov ax,OK		; getchz = OK

    mov di,bfstrc[si]	; bf = bfstrc(fd)
    dec di
    shl di,1

    mov cx,fpos[di]	; n = fpos(bf) + 1 # Stored in CX.
    inc cx

    cmp cx,lastc[di]	; if (n > lastc(bf))
    jg getchz_fillbuf	;	go to GETCHZ_FILLBUF

getchz_finish:		;GETCHZ_FINISH:
    assume ds:dio, es:nothing
    mov fpos[di],cx	; fpos(bf) = n

    shl di,1		; c = peek2 (bufadr(bf), n)
    lds bx,bufadr[di]
    assume ds:nothing
    mov si,cx
    dec si
    mov cl,byte ptr [bx+si]
    xor ch,ch
    lds bx,char
    assume ds:nothing
    mov word ptr [bx],cx

    mov ds,dx		; return
    assume ds:dgroup
    fexit

getchz_bad_fd:
	assume ds:nothing, es:nothing
	mov ds,dx
	assume ds:dgroup
	les bx,fd
	assume es:nothing
	bcall fdokzz,<es,bx>	;	call fdokzz (fd)
				;	# (Should be no return)
	bcall exit

			;GETCHZ_FILLBUF: {
getchz_fillbuf:
      assume ds:dio, es:nothing
      mov bx,state[si]	;    if (state(fd) != READ
      cmp bx,READ
      je getchz_mode_ok
      cmp bx,READWRITE	;	    & state(fd) != READWRITE)
      je getchz_mode_ok
			;	{
	mov ds,dx
	assume ds:dgroup
	mov bx,offset getchz_msg;	call putlin (msg,ERROUT)
	mov cx,offset getchz_msg_errout
	bcall putlin,<cs,bx,cs,cx>

	les ax,fd	;	call putint (fd, 1, ERROUT)
	mov bx,offset getchz_msg_1
	mov cx,offset getchz_msg_errout
	bcall putint,<es,ax,cs,bx,cs,cx>

	mov bx,offset getchz_msg_eos;	call error (null_string)
	bcall error,<cs,bx>

	bcall exit	;	# No return.
			;	}

getchz_mode_ok:
      assume ds:dio, es:nothing
			;    getchz = getrzz(fd, bfstrt(bf) + n - 1)
      push ds
      push di		;	# Save DI across call to getrzz.
      shl di,1
      mov bx,bfstrt[di]
      dec cx		;	# n = CX >= 1, so no chance of borrow.
      add bx,cx
      mov strt_loword,bx
      mov bx,bfstrt[di+2]
      adc bx,0
      mov strt_hiword,bx
      les bx,fd
      assume es:nothing
      lea cx,ds:strt_loword
      mov ds,dx
      assume ds:dgroup
      bcall getrzz,<es,bx,ss,cx>;	# Returns result in AX.	
      mov dx,ds		;	# Save DS in DX again.
      pop di
      pop ds
      assume ds:dio

      mov cx,fpos[di]	;    n = fpos(bf) + 1
      inc cx

      jmp getchz_finish
			;    }

    fend getchz		; end

;***********************************
;
;## getch -- get character from file fd
;
;	c = getch(char, fd)	# Returns character or EOF.
;	character c, getch, char
;	filedes fd

fentry getch,<char,fd>	;character function getch(char, fd)
			; character char
			; filedes fd
    assume cs:lowio1, ds:dgroup, es:nothing, ss:nothing

			; include dprimio
    auto local_char	; character c
			; integer getchz, r, bf

getch_repeat:		; repeat
    assume ds:dgroup, es:nothing

			;    {
    lea bx,local_char	;    r = getchz(c, fd)
    les cx,fd
    assume es:nothing
    bcall getchz,<ss,bx,es,cx>

    mov cx,local_char	;    if (c == CPMEOF | r != OK)
    cmp cx,CPMEOF	;	go to GETCH_EOF
    je getch_eof
    cmp ax,OK
    jne getch_eof

getch_bottom:		; GETCH_BOTTOM:
    assume ds:dgroup, es:nothing

			;    }
    cmp cx,NUL		;    until (c != NUL & c != CR)
    je getch_repeat
    cmp cx,CR
    je getch_repeat

    les bx,char		; char = c
    mov es:[bx],cx

    mov ax,cx		; getch = c

    fexit		; return

getch_eof:		; GETCH_EOF:
    assume ds:dgroup, es:nothing

    les bx,fd		; bf = bfstrc(fd)
    mov si,es:[bx]
    dec si
    shl si,1
    mov dx,ds		; # save original DS in DX.
    mov ds,dio_seg
    assume ds:dio
    mov di,bfstrc[si]
    dec di
    shl di,1

    cmp dev[di],DISK	; if (dev(bf) == DISK)
    jne getch_not_disk	;	{

	dec fpos[di]	;	fpos(bf) = fpos(bf) - 1

	mov cx,EOF	;	c = EOF

	mov ds,dx	;	go to GETCH_BOTTOM
	assume ds:dgroup
	jmp getch_bottom
			;	}
getch_not_disk:		;   else
			;	{
	assume ds:dio, es:nothing
	mov ds,dx
	assume ds:dgroup

	cmp cx,CPMEOF	;	if (c == CPMEOF)
	jne getch_after_skip
	cmp ax,OK	;	 andif (r == OK)
	jne getch_after_skip
			;		{
getch_skip:		;		repeat
	    assume ds:dgroup, es:nothing
	    lea bx,local_char;		    r = getchz(c, fd)
	    les cx,fd
	    assume es:nothing
	    bcall getchz,<ss,bx,es,cx>

	    cmp word ptr local_char,NEWLINE;until (c == NEWLINE)
	    jne getch_skip

getch_after_skip:	;		}
	assume ds:dgroup,es:nothing

			;	}

	mov cx,EOF	; c = EOF

	jmp getch_bottom; go to GETCH_BOTTOM

    fend getch		; end

;*************************************
;
;## putchz -- put byte onto file fd
;
;	call putchz(char, fd)
;	integer*2 fd
;	integer*1 char

wordstring <** putchz: illegal I/O mode fd = >,putchz_msg
putchz_msg_1 dw 1
putchz_msg_errout dw ERROUT
putchz_msg_eos dw EOS

fentry putchz,<char,fd>
    assume cs:lowio1, ds:dgroup, es:nothing, ss:dgroup
    auto <arg_hiword,arg_loword>
;   Don't say "save ds" because we must save it explicitly
;	in order to retrieve it in the middle of the routine.

			; character char
			; filedes fd
			; integer n, flg
			; bfpointer buf
  			; integer junk, itoc, bf, getrzz, getbzz

			; string msg "** putch: illegal I/O mode fd = "

    mov dx,ds		; # Save DS in DX.
    lds bx,fd
    assume ds:nothing
    mov si,[bx]		;	# SI = fd - 1
    sub si,1		;	# Not DEC because we need to check carry
    jl putchz_bad_fd	; if (fd < 1 | fd > MAXOFILES)
    cmp si,MAXOFILES	;	go to PUTCHZ_BAD_FD
    jge putchz_bad_fd

    shl si,1
    mov ds,dio_seg
    assume ds:dio

    mov di,bfstrc[si]	; bf = bfstrc(fd)
    dec di
    shl di,1

    cmp wrt[di],YES	; if (wrt(bf) != YES)
    jne putchz_bad_mode	;	go to PUTCHZ_BAD_MODE

    cmp wbfsiz[di],1	; if (wbfsiz(bf) <= 1)
    jg putchz_buffered
    cmp state[si],WRITE	;   andif (state(bf) == WRITE)
    jne putchz_buffered
    jmp PUTCHZ_UNBUF	;	go to PUTCHZ_UNBUF
putchz_buffered:	; PUTCHZ_BUFFERED:

    mov cx,fpos[di]	; n = fpos(bf) + 1 # Stored in CX.
    inc cx

    les bx,char		; c = char	# Stored in AL.
    assume es:nothing
    mov al,es:[bx]
    
    shl di,1		; buf = bufadr(bf)
    les bx,bufadr[di]
    assume es:nothing
    shr di,1
    mov si,es		; if (buf == BFNULL)
    or si,bx		;	go to PUTCHZ_NEWBUF
    jnz putchz_havebuf
    jmp putchz_newbuf

putchz_havebuf:		; PUTCHZ_HAVEBUF:
    assume ds:dio, es:nothing

    mov si,cx		; call poke2 (c, buf, n)
    dec si
    mov es:[bx+si],al

    mov dirty[di],YES	; dirty(bf) = YES
    mov fpos[di],cx	; fpos(bf) = n

    cmp lastc[di],cx	; if (lastc(bf) < n)
    jge putchz_within
	mov lastc[di],cx;	lastc(bf) = n
putchz_within:

    cmp cx,bufsiz[di]	; if (n >= bufsiz(bf))
    jl putchz_done
    jmp putchz_flush	;	go to PUTCHZ_FLUSH
putchz_done:

    mov ds,dx		; return
    assume ds:dgroup
    fexit

putchz_bad_fd:		; PUTCHZ_BAD_FD:
	assume ds:nothing, es:nothing

	mov ds,dx
	assume ds:dgroup
	les bx,fd
	assume es:nothing
	bcall fdokzz,<es,bx>	;	call fdokzz (fd)
				;	# (Should be no return)

putchz_bad_mode:		; PUTCHZ_BAD_MODE:
    assume ds:dio, es:nothing

    cmp di,bfstrc[2*(STDERR-1)] ; if (bf == bfstrc(STDERR))
    mov ds,dx
    assume ds:dgroup
    jne putchz_not_stderr

	les bx,fd		;		call cantzz (fd)
	assume es:nothing
	bcall cantzz,<es,bx>	; 		# No return.

putchz_not_stderr:
    assume ds:dgroup, es:nothing
    mov bx,offset putchz_msg	; call putlin (msg, ERROUT)
    mov cx,offset putchz_msg_errout
    bcall putlin,<cs,bx,cs,cx>

    les ax,fd			; call putint (fd, 1, ERROUT)
    mov bx,offset putchz_msg_1
    mov cx,offset putchz_msg_errout
    bcall putint,<es,ax,cs,bx,cs,cx>

    mov bx,offset putchz_msg_eos; call error (null_string)
    bcall error,<cs,bx>		; # No return.

putchz_unbuf:		; PUTCHZ_UNBUF:
    assume ds:dio, es:nothing

    mov si,ds		; if (doswrt(handle(bf), &char, 1, after) != OK)
    push dx
    mov bx,handle[di]
    lds dx,char
    assume ds:nothing
    mov cx,1
    mov ah,ms_putch
    int 21h
    pop dx
    cmp cx,1
    jne putchz_dos_err	;	go to PUTCHZ_DOS_ERR

    mov ds,dx		; return
    assume ds:dgroup
    fexit

putchz_dos_err:		; PUTCHZ_DOS_ERR:
    assume ds:nothing, es:nothing

    mov ds,si
    assume ds:dio
    mov iserr[di],YES	; iserr(bf) = YES

    mov wrt[di],NO	; wrt(bf) = NO

    mov ds,dx		; return
    assume ds:dgroup
    fexit

putchz_newbuf:		; PUTCHZ_NEWBUF:
    assume ds:dio, es:nothing

    les bx,fd
    assume es:nothing
    mov si,es:[bx]
    dec si
    shl si,1
    cmp state[si],READWRITE; if (state(bf) == READWRITE)
    jne putchz_getbzz

			;	{
	push ds		;	flg = getrzz(fd, bfstrt(bf) + n - 1)
	push di		; 	# (Forget CX and SI.)
	dec cx
	shl di,1
	les bx,bfstrt[di]
	assume es:nothing
	mov ax,es
	add bx,cx
	adc ax,0
	mov arg_hiword,ax
	mov arg_loword,bx
	les bx,fd
	assume es:nothing
	mov ds,dx
	assume ds:dgroup
	lea dx,arg_loword
	bcall getrzz,<es,bx,ss,dx>
	pop di
	mov dx,ds
	pop ds
	assume ds:dio

	mov cx,1	;	n = 1
	jmp short putchz_gotbuf
			;	}

			;     else	# not READWRITE
putchz_getbzz:
	assume ds:dio, es:nothing

	push ds		;	flg = getbzz(bf, wbfsiz(bf))
	push di
	push cx
	lea cx,wbfsiz[di]
	mov ds,dx
	assume ds:dgroup
	shr di,1	;	# (Adjust bf for fortran.)
	inc di
	lea bx,arg_loword
	mov [bx],di
	bcall getbzz,<ss,bx,dio_seg,cx>
	pop cx
	pop di
	mov dx,ds
	pop ds
	assume ds:dio

putchz_gotbuf:
    assume ds:dio, es:nothing

    cmp ax,ERR		; if (flg == ERR) # getrzz can return EOF
    jne putchz_ok	;	{
	mov wrt[di],no	;	wrt(bf) = NO
	mov iserr[di],YES;	iserr(bf) = YES
	mov ds,dx	;	return
	assume ds:dgroup
	fexit
			;	}
putchz_ok:
    assume ds:dio, es:nothing
    les bx,char
    assume es:nothing
    mov al,es:[bx]
    shl di,1
    les bx,bufadr[di]	; buf = bufadr(bf)
    assume es:nothing
    shr di,1

    jmp putchz_havebuf	; go to PUTCHZ_HAVEBUF

putchz_flush:		; PUTCHZ_FLUSH:
    assume ds:dio, es:nothing

    push ds		; call flush (fd)
    push di
    push cx
    mov ds,dx
    assume ds:dgroup
    les bx,fd
    bcall flush,<es,bx>
    mov dx,ds
    pop cx
    pop di
    pop ds
    assume ds:dio

    mov fpos[di],0	; fpos(bf) = 0

    mov lastc[di],0	; lastc(bf) = 0

    cmp dev[di],DISK	; if (dev(bf) == DISK)
    jne putchz_bfstrt_ok
	shl di,1	;	bfstrt(bf) = bfstrt(bf) + n
	les ax,bfstrt[di]
	assume es:nothing
	add ax,cx
	mov bfstrt[di],ax
	mov ax,es
	adc ax,0
	mov bfstrt[di+2],ax
putchz_bfstrt_ok:
    assume ds:dio, es:nothing

    mov ds,dx
    assume ds:dgroup
    fend putchz		; return
			; end

;**********************************
;
;## norm_es_di -- internal routine to normalize ES:DI
;
;	No arguments passed or registers altered except ES, DI.

bentry norm_es_di
    assume cs:lowio1, es:nothing, ss:nothing, ds:nothing
    save <ax,cx,flags>

	mov	ax,di	; extract top 12 bits of di
	rept 4
	    shr	ax,1
	    endm
	mov	cx,es
	add	ax,cx
	mov	es,ax		; paragraph number
	assume es:nothing
	and	di,1111b	; "Offset" within the paragraph

	bend norm_es_di

;****************************
;
;## nrmadr -- normalize doubleword address
;
;	new = nrmadr(old)
;	integer*4 new, nrmadr, old

fentry nrmadr,<old>
    assume cs:lowio1, ds:nothing, es:nothing, ss:nothing

    les di,old
    assume es:nothing
    les di,dword ptr es:[di]
    assume es:nothing
    call norm_es_di
    assume es:nothing
    mov bx,di

    fend nrmadr

lowio1 ends

end
#-t- lowio1.asm               187_61 ascii 04/25/84 16:12:21
#-h- xor2.asm                   4_99 ascii 03/19/84 20:15:00
page 66,96
;*********************************
;
;##		XOR2.ASM:  Quickie xor2 routine for sys3.lib
;
;	MS-DOS 2.00 version 3/10/84 PLD

include mcall.asm

xorseg segment byte public 'code'
    assume cs:xorseg, ds:nothing, es:nothing, ss:nothing

;************************
;
;## xor2 -- bitwise exclusive-or of two 16-bit quantities
;
;	ans = xor2(var1, var2)
;	integer*2 ans, xor2, var1, var2

fentry xor2,<var1,var2>
    assume cs:xorseg, ds:nothing, es:nothing, ss:nothing

    les bx,var1
    mov ax,es:[bx]
    les bx,var2
    xor ax,es:[bx]

    fend xor2

xorseg ends

end
#-t- xor2.asm                   4_99 ascii 03/19/84 20:15:00
