# include "mfile2"

# define EA  SNAME|SOREG|SCON|SAREG|SBREG
# define EREG  SAREG|SBREG
# define FEA SNAME|SOREG|SCON

struct optab  table[] = {

ASSIGN, INAREG|FOREFF,		/* can't do movb's from SI or DI */	
	EA,	TCHAR|TUCHAR,
	EREG,	TINT|TPOINT|TUNSIGNED,
		0,	RLEFT,
		"	mov	cx,AR\n	movb	AL,cx\n",

ASSIGN,	INAREG|FOREFF,
	EA,	TPOINT|TINT|TUNSIGNED|TCHAR|TUCHAR,
	EREG|SCON,TPOINT|TINT|TUNSIGNED|TCHAR|TUCHAR,
		0,	RRIGHT,
		"	movZB	AL,AR\n",

ASSIGN,	INAREG|FOREFF,
	EREG,	TPOINT|TINT|TUNSIGNED,
	EA,	TPOINT|TINT|TUNSIGNED,
		0,	RLEFT,
		"	mov	AL,AR\n",

ASSIGN,	INAREG|FOREFF,
	EREG,	TCHAR|TUCHAR,
	EA,	TCHAR|TUCHAR,
		0,	RLEFT,
		"	movb	AL,AR\n",

ASSIGN,	FOREFF,
	EA,	TCHAR|TUCHAR,
	EA,	TCHAR|TUCHAR,
		NAREG|NASR,	RNULL,
		"	movb	A1,AR\n	movb	AL,A1\n",

ASSIGN, INAREG|FOREFF,
	EA,	TLONG|TULONG,
	SCON,	TLONG|TULONG|TINT,
		0,	RRIGHT,
		"	mov	AL,AR\n	mov	UL,UR\n",

ASSIGN,	INAREG|FOREFF,
	EA,	TLONG|TULONG,
	EREG,	TLONG|TULONG,
		0,	RRIGHT,
		"	mov	AL,AR\n	mov	UL,UR\n",

ASSIGN,	INAREG|FOREFF,
	EREG,	TLONG|TULONG,
	EA,	TLONG|TULONG,
		0,	RLEFT,
		"	mov	AL,AR\n	mov	UL,UR\n",
#ifndef	X8087
ASSIGN,	FOREFF,
	FEA,	TFLOAT,
	FEA,	TFLOAT,
		0,	RLEFT,
		"	mov	AL,AR\n	mov	UL,UR\n",

ASSIGN,	FOREFF,
	FEA,	TDOUBLE,
	FEA,	TDOUBLE,
		0,	RLEFT,
		"ZD",

#endif

#ifdef X8087
ASSIGN,	FOREFF,
	FEA,	TDOUBLE|TFLOAT,
	FEA,	TDOUBLE|TFLOAT,
		0,	RLEFT,
		"	fldZr	AR\n	fstpZl	AL\n",

ASSIGN,	INTEMP,
	FEA,	TDOUBLE|TFLOAT,
	FEA,	TDOUBLE|TFLOAT,
		4*NTEMP,	RESC1,
		"	fldZr	AR\n	fstZl	AL\n	fstpd	A1\n",
#endif

ASSIGN, INAREG|FOREFF,
	SFLD,	TANY,
	SZERO,	TANY,
		0,	RRIGHT,
		"	and	AL,#~M\n",

ASSIGN, INTAREG|INAREG|FOREFF,
	SFLD,	TANY,
	STAREG,	TANY,
		0,	RRIGHT,
		"F\tpush\tAR\n\tmov\tcl,*H\n\tshl\tAR,cl\n\tand\tAR,#M\n\tand\tAL,#~M\n\tor\tAL,AR\nF\tpop\tAR\n",

ASSIGN, INAREG|FOREFF,
	SFLD,	TANY,
	EA,	TANY,
		NAREG,	RRIGHT,
		"\tmov\tA1,AR\n\tmov\tcl,*H\n\tshl\tA1,cl\n\tand\tA1,#M\n\tand\tAL,#~M\n\tor\tAL,A1\n",

/* put this here so UNARY MUL nodes match OPLTYPE when appropriate */
OPLTYPE,	FOREFF,
	SANY,	TANY,
	EA,	TANY,
		0,	RRIGHT,
		"",   /* this entry throws away computations which don't do anything */

OPLTYPE,	INAREG,
	SANY,	TANY,
	SAREG,	TANY,
		0,	RRIGHT,
		"",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	EA,	TINT|TUNSIGNED|TPOINT,
		NAREG|NASR,	RESC1,
		"	mov	A1,AR\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	EA,	TLONG|TULONG,
		NAREG|NASR,	RESC1,
		"	mov	A1,AR\n	mov	U1,UR\n",

OPLTYPE,	INTBREG|INBREG,
	SANY,	TANY,
	EA,	TINT|TUNSIGNED|TPOINT,
		NBREG|NBSR,	RESC1,
		"	mov	A1,AR\n",

OPLTYPE,	INTEMP,
	SANY,	TANY,
	EREG,	TINT|TUNSIGNED|TPOINT,
		NTEMP,	RESC1,
		"	mov	A1,AR\n",

OPLTYPE,	INTEMP,
	SANY,	TANY,
	EREG,	TLONG|TULONG,
		2*NTEMP,	RESC1,
		"	mov	A1,AR\n	mov	U1,UR\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	EREG,	TINT|TUNSIGNED|TPOINT,
		0,	RESCC,
		"	or	AR,AR\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	EREG,	TLONG|TULONG,
		0,	RESCC,
		"	or	UR,UR\n	jne	.+4\n	or	AR,AR\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	SNAME|SOREG|SAREG|SBREG,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RESCC,
		"	cmpZB	AR,*0\n",

OPLTYPE,	FORCC,		/* only good for eq/neq comparisons... */
	SANY,	TANY,
	SNAME|SOREG|SAREG|SBREG,	TLONG|TULONG,
		0,	RESCC,
		"	cmp	UR,*0\n	jne Zx\n	cmp	AR,*0\nZz",

OPLTYPE,	FORCC,
	SANY,	TANY,
	SCON,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NAREG|NASR,	RESCC,
		"	mov	A1,AR\n	or	A1,A1\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SNAME|SOREG|SAREG|SBREG,	TINT|TUNSIGNED|TPOINT,
		0,	RNULL,
		"	push	AR\nZ-",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SNAME|SOREG|SAREG|SBREG,	TLONG|TULONG,
		0,	RNULL,
		"	push	UR\nZ-	push	AR\nZ-",

#ifndef X8087
OPLTYPE,	FORARG,
	SANY,	TANY,
	FEA,	TDOUBLE,
		NBREG|NBSR,	RNULL,
		"\tlea\tA1,AL\n\tpush\t*6(A1)\n\tpush\t*4(A1)\n\tpush\t*2(A1)\n\tpush\t(A1)\nZ4",
#endif

#ifdef X8087
OPLTYPE,	FORARG,
	SANY,	TANY,
	FEA,	TDOUBLE|TFLOAT,
		NBREG|NBSR,	RNULL,
		"\tfldZB	AR\n	sub	sp,*8\n	mov	A1,sp\n	fstpd	(A1)\nZ4",

OPLTYPE,	INTEMP,
	SANY,	TANY,
	FEA,	TDOUBLE|TFLOAT,
		4*NTEMP,	RESC1,
		"	fldZB	AR\n	fstpd	A1\n",

OPLTYPE,	INTAREG,
	SANY,	TANY,
	FEA,	TDOUBLE|TFLOAT,
		NAREG,	RESC1,
		"	fldZB	AL\n",
#endif

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	SCCON,	TANY,
		NAREG|NASR,	RESC1,
		"	mov	A1,AR\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	EA,	TCHAR,
		NAREG|NASR,	RESC1,
		"	movb	A1,AR\nZe",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	EA,	TUCHAR,
		NAREG|NASR,	RESC1,
		"	movb	A1,AR\n	and	A1,#255\n",

OPLOG,	FORCC,
	EREG,	TPOINT|TINT|TUNSIGNED,
	EA,	TPOINT|TINT|TUNSIGNED,
		0,	RESCC,
		"	cmp	AL,AR\nZI",

OPLOG,	FORCC,
	EA,	TPOINT|TINT|TUNSIGNED,
	EREG|SCON,	TPOINT|TINT|TUNSIGNED,
		0,	RESCC,
		"	cmp	AL,AR\nZI",

OPLOG,	FORCC,
	EREG,	TCHAR|TUCHAR,
	EA,	TCHAR|TUCHAR,
		0,	RESCC,
		"	cmpb	AL,AR\nZI",

OPLOG,	FORCC,
	EA,	TCHAR|TUCHAR,
	EREG,	TCHAR|TUCHAR,
		0,	RESCC,
		"	cmpb	AL,AR\nZI",

OPLOG,	FORCC,
	EA,	TCHAR|TUCHAR,
	SCCON,	TINT,
		0,	RESCC,
		"	cmpb	AL,AR\nZI",

OPLOG,	FORCC,
	EREG,	TLONG|TULONG,
	EA,	TLONG|TULONG,
		0,	RESCC,
		"ZCZI",

OPLOG,	FORCC,
	EA,	TLONG|TULONG,
	EREG|SCON,	TLONG|TULONG,
		0,	RESCC,
		"ZCZI",

#ifdef X8087
OPLOG,	FORCC,
	FEA,	TDOUBLE|TFLOAT,
	FEA,	TDOUBLE|TFLOAT,
		NTEMP,	RESCC,
		"\tfldZl\tAL\n\tfcompZr\tAR\n\tfstsw\tA1\n\tfwait\n\txchg\tah,Z1\n\tsahf\n\txchg\tah,Z1\nZF",
#endif

CCODES,	INTAREG|INAREG,
	SANY,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NAREG,	RESC1,
		"	mov	A1,*1\nZN",

CCODES,	INTAREG|INAREG,
	SANY,	TANY,
	SANY,	TLONG|TULONG,
		NAREG,	RESC1,
		"	mov	A1,*1\n	mov	U1,*0\nZN",

UNARY MINUS,	INTAREG|INAREG,
	STAREG,	TINT|TUNSIGNED,
	SANY,	TANY,
		0,	RLEFT,
		"	neg	AL\n",

UNARY MINUS,	INTAREG|INAREG,
	STAREG,	TLONG|TULONG,
	SANY,	TANY,
		0,	RLEFT,
		"	neg	UL\n	neg	AL\n	sbb	UL,*0\n",

UNARY MINUS,	INTEMP,
	FEA,	TDOUBLE|TFLOAT,
	SANY,	TANY,
		4*NTEMP,	RESC1,
		"	fldZl	AL\n	fchs\n	fstpd	A1\n",

COMPL,	INTAREG|INAREG,
	STAREG,	TINT|TUNSIGNED,
	SANY,	TANY,
		0,	RLEFT,
		"	not	AL\n",

COMPL,	INTAREG|INAREG,
	STAREG,	TLONG|TULONG,
	SANY,	TANY,
		0,	RLEFT,
		"	not	AL\n	not	UL\n",

INCR,	INTAREG|INAREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TANY,
		NAREG,	RESC1,
		"F	movZB	A1,AL\n	incZB	AL\n",

DECR,	INTAREG|INAREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TANY,
		NAREG,	RESC1,
		"F	movZB	A1,AL\n	decZB	AL\n",

INCR,	INTAREG|INAREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		NAREG,	RESC1,
		"F	mov	A1,AL\n	add	AL,AR\n",

DECR,	INTAREG|INAREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		NAREG,	RESC1,
		"F	mov	A1,AL\n	sub	AL,AR\n",

INCR,	INTBREG|INBREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TANY,
		NBREG,	RESC1,
		"F	movZB	A1,AL\n	incZB	AL\n",

DECR,	INTBREG|INBREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TANY,
		NBREG,	RESC1,
		"F	movZB	A1,AL\n	decZB	AL\n",

INCR,	INTBREG|INBREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		NBREG,	RESC1,
		"F	mov	A1,AL\n	add	AL,AR\n",

DECR,	INTBREG|INBREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		NBREG,	RESC1,
		"F	mov	A1,AL\n	sub	AL,AR\n",

INCR,	INTAREG|INAREG|FOREFF,
	EA,	TLONG|TULONG,
	SCON,	TANY,
		NAREG,	RESC1,
		"F	mov	A1,AL\nF	mov	U1,UL\n	add	AL,AR\n	adc	UL,UR\n",

DECR,	INTAREG|INAREG|FOREFF,
	EA,	TLONG|TULONG,
	SCON,	TANY,
		NAREG,	RESC1,
		"F	mov	A1,AL\nF	mov	U1,UL\n	sub	AL,AR\n	sbb	UL,UR\n",

AND,	FORCC,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCON,	TANY,
		0,	RESCC,
		"	test	AL,AR\n",

AND,	FORCC,
	EREG,	TINT|TUNSIGNED|TPOINT,
	EA,	TANY,
		0,	RESCC,
		"	test	AL,AR\n",

ASG MUL,	INTAREG,
	STAREG,	TINT|TCHAR,
	SOREG|SNAME|SAREG|SBREG,	TINT|TCHAR,
		NAREG|NASR,	RLEFT,
		"	imulZB	AR\n",

ASG DIV,	INTAREG,
	STAREG,	TINT,
	SCON,	TINT,
		NAREG,	RLEFT,
		"ZV	mov	cx,AR\n	idiv	cx\n",  /* since lhs must be in r1 */

ASG DIV,	INTAREG,
	STAREG,	TINT,
	SOREG|SNAME|SAREG|SBREG,	TINT,
		NAREG,	RLEFT,
		"ZV	idiv	AR\n",  /* since lhs must be in r1 */

ASG MOD,	INTAREG,
	STAREG,	TINT,
	SCON,	TINT,
		NAREG,	RESC1,
		"ZV	mov	cx,AR\n	idiv	cx\n",  /* since lhs must be in r1 */

ASG MOD,	INTAREG,
	STAREG,	TINT,
	SOREG|SNAME|SAREG|SBREG,	TINT,
		NAREG,	RESC1,
		"ZV	idiv	AR\n",  /* since lhs must be in r1 */

ASG MUL,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	SOREG|SNAME|SAREG|SBREG,	TINT|TUNSIGNED|TPOINT,
		NAREG|NASL,	RLEFT,
		"	mul	AR\n",

ASG DIV,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	SCON,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RLEFT,
		"ZV	mov	cx,AR\n	div	cx\n",  /* since lhs must be in r1 */

ASG DIV,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	SOREG|SNAME|SAREG|SBREG,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RLEFT,
		"ZV	div	AR\n",  /* since lhs must be in r1 */

ASG MOD,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	SCON,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RESC1,
		"ZV	mov	cx,AR\n	div	cx\n",  /* since lhs must be in r1 */

ASG MOD,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	SOREG|SNAME|SAREG|SBREG,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RESC1,
		"ZV	div	AR\n",  /* since lhs must be in r1 */

MINUS,		INTAREG,
	SBREG,	TINT|TUNSIGNED|TPOINT,
	SXCON,	TINT|TUNSIGNED|TPOINT,
		NAREG|NASL,	RESC1,
		"	lea	A1,ZM(AL)\n",
		
MINUS,		INTBREG,
	SBREG,	TINT|TUNSIGNED|TPOINT,
	SXCON,	TINT|TUNSIGNED|TPOINT,
		NBREG|NBSL,	RESC1,
		"	lea	A1,ZM(AL)\n",

PLUS,		INTAREG,
	SBREG,	TINT|TUNSIGNED|TPOINT,
	SCON,	TINT|TUNSIGNED|TPOINT,
		NAREG|NASL,	RESC1,
		"	lea	A1,Zc(AL)\n",
		
PLUS,		INTBREG,
	SBREG,	TINT|TUNSIGNED|TPOINT,
	SCON,	TINT|TUNSIGNED|TPOINT,
		NBREG|NBSL,	RESC1,
		"	lea	A1,Zc(AL)\n",

ASG PLUS,	INAREG,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TINT,
		0,	RLEFT|RESCC,
		"	incZB	AL\n",

ASG MINUS,	INAREG,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TINT,
		0,	RLEFT|RESCC,
		"	decZB	AL\n",

ASG PLUS,	INAREG,
	EA,	TLONG|TULONG,
	SONE,	TINT,
		0,	RLEFT|RESCC,
		"	add	AL,*1\n	adc	UL,*0\n",

ASG MINUS,	INAREG,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TINT,
		0,	RLEFT|RESCC,
		"	sub	AL,*1\n	sbb	UL,*0\n",

ASG OPSIMP,	INAREG|FORCC,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	EREG|SCON,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RLEFT|RESCC,
		"	OIZB	AL,AR\n",

ASG OPSIMP,	INAREG|FORCC,
	EREG,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RLEFT|RESCC,
		"	OIZB	AL,AR\n",

ASG OPSIMP,	INTAREG|FORCC,
	STAREG,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RLEFT|RESCC,
		"	OIZB	AL,AR\n",

ASG OPSIMP,	INTAREG|FORCC,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	EREG|SCON,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NAREG|NASR,	RESC1|RESCC,
		"	OIZB	AL,AR\n	mov	A1,AL\n",

ASG OPSIMP,	INTAREG|FORCC,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	EREG|SCON,	TLONG|TULONG,
		NAREG|NASR,	RESC1|RESCC,
		"	OIZB	AL,AR\nF	mov	A1,AL\n",

ASG PLUS,	INAREG,
	EA,	TLONG|TULONG,
	EREG|SCON,	TLONG|TULONG,
		0,	RLEFT,
		"	add	AL,AR\n	adc	UL,UR\n",

ASG PLUS,	INAREG,
	EREG,	TLONG|TULONG,
	EA,	TLONG|TULONG,
		0,	RLEFT,
		"	add	AL,AR\n	adc	UL,UR\n",

ASG PLUS,	INTAREG,
	STAREG,	TLONG|TULONG,
	EA,	TLONG|TULONG,
		0,	RLEFT,
		"	add	AL,AR\n	adc	UL,UR\n",

ASG MINUS,	INAREG,
	EA,	TLONG|TULONG,
	EREG|SCON,	TLONG|TULONG,
		0,	RLEFT,
		"	sub	AL,AR\n	sbb	UL,UR\n",

ASG MINUS,	INAREG,
	EREG,	TLONG|TULONG,
	EA,	TLONG|TULONG,
		0,	RLEFT,
		"	sub	AL,AR\n	sbb	UL,UR\n",

ASG MINUS,	INTAREG,
	STAREG,	TLONG|TULONG,
	EA,	TLONG|TULONG,
		0,	RLEFT,
		"	sub	AL,AR\n	sbb	UL,UR\n",

ASG OPSIMP,	INAREG,
	EA,	TLONG|TULONG,
	EREG|SCON,	TLONG|TULONG,
		0,	RLEFT,
		"	OI	AL,AR\n	OI	UL,UR\n",

ASG OPSIMP,	INAREG,
	EREG,	TLONG|TULONG,
	EA,	TLONG|TULONG,
		0,	RLEFT,
		"	OI	AL,AR\n	OI	UL,UR\n",

ASG OPSIMP,	INTAREG,
	STAREG,	TLONG|TULONG,
	EA,	TLONG|TULONG,
		0,	RLEFT,
		"	OI	AL,AR\n	OI	UL,UR\n",

#ifdef X8087
OPFLOAT,	INTEMP,
	FEA,	TDOUBLE|TFLOAT,
	FEA,	TDOUBLE|TFLOAT,
		4*NTEMP,	RESC1,
		"	fldZl	AL\n	ZOZr	AR\n	fstpd	A1\n",

ASG OPFLOAT,	FOREFF|INAREG,
	FEA,	TDOUBLE|TFLOAT,
	FEA,	TDOUBLE|TFLOAT,
		0,	RLEFT,
		"	fldZl	AL\n	ZOZr	AR\n	fstpZl	AL\n",
#endif

LS, 	INTBREG,
	STBREG,	TINT|TUNSIGNED|TPOINT,
	SONE,	TINT,
		0,	RLEFT,
		"	sal	AL,*1\n",

LS, 	INTBREG,
	STBREG,	TINT|TUNSIGNED|TPOINT,
	SCON,	TINT,
		0,	RLEFT,
		"	mov	cx,AR\n	sal	AL,cl\n",

LS, 	INTAREG|INAREG,
	EA,	TINT|TUNSIGNED|TPOINT,
	SONE,	TINT,
		NAREG|NASL,	RESC1,
		"	mov	A1,AL\n	sal	A1,*1\n",

LS, 	INTAREG|INAREG,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCON,	TINT,
		NAREG|NASL,	RESC1,
		"	mov	A1,AL\n	mov	cx,AR\n	sal	A1,cl\n",

LS, 	INTBREG,
	EA,	TINT|TUNSIGNED|TPOINT,
	SONE,	TINT,
		NBREG|NBSL,	RESC1,
		"	mov	A1,AL\n	sal	A1,*1\n",

LS, 	INTBREG,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCON,	TINT,
		NBREG|NBSL,	RESC1,
		"	mov	A1,AL\n	mov	cx,AR\n	sal	A1,cl\n",

ASG LS, 	FOREFF|INAREG,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TINT,
		0,	RLEFT,
		"	salZB	AL,*1\n",

ASG LS, 	INAREG|FOREFF,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	EA,	TINT,
		0,	RLEFT,
		"	mov	cx,AR\n	salZB	AL,cl\n",

ASG LS, 	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SONE,	TINT,
		0,	RLEFT,
		"	salZB	AL,*1\n",

ASG LS, 	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	EA,	TINT,
		0,	RLEFT,
		"	mov	cx,AR\n	salZB	AL,cl\n",

ASG LS,		INAREG|FOREFF,
	EA,	TLONG|TULONG,
	SONE,	TINT,
		0,	RLEFT,
		"	shl	AL,*1\n	rcl	UL,*1\n",

ASG LS,		INAREG|FOREFF,
	EA,	TLONG|TULONG,
	EA,	TINT,
		0,	RLEFT,
		"\tmov\tcx,AR\n\tor\tcx,cx\n\tjz\tZY\nZX\tshl\tAL,*1\n\trcl\tUL,*1\n\tloop\tZy\nZs",

ASG LS,		INTAREG|FOREFF,
	STAREG,	TLONG|TULONG,
	EA,	TINT,
		0,	RLEFT,
		"\tmov\tcx,AR\n\tor\tcx,cx\n\tjz\tZY\nZX\tshl\tAL,*1\n\trcl\tUL,*1\n\tloop\tZy\nZs",

ASG RS, 	INAREG|FOREFF,
	EA,	TINT|TCHAR,
	SONE,	TINT,
		0,	RLEFT,
		"	sarZB	AL,*1\n",

ASG RS, 	INAREG|FOREFF,
	EA,	TINT|TCHAR,
	EA,	TINT,
		0,	RLEFT,
		"	mov	cx,AR\n	sarZB	AL,cl\n",

ASG RS, 	INAREG|FOREFF,
	EA,	TUNSIGNED|TPOINT|TUCHAR,
	SONE,	TINT,
		0,	RLEFT,
		"	shrZB	AL,*1\n",

ASG RS, 	INAREG|FOREFF,
	EA,	TUNSIGNED|TPOINT|TUCHAR,
	EA,	TINT,
		0,	RLEFT,
		"	mov	cx,AR\n	shrZB	AL,cl\n",

ASG RS, 	INTAREG,
	STAREG,	TINT|TCHAR,
	SONE,	TINT,
		0,	RLEFT,
		"	sarZB	AL,*1\n",

ASG RS, 	INTAREG,
	STAREG,	TINT|TCHAR,
	EA,	TINT,
		0,	RLEFT,
		"	mov	cx,AR\n	sarZB	AL,cl\n",

ASG RS, 	INTAREG,
	STAREG,	TUNSIGNED|TPOINT|TUCHAR,
	SONE,	TINT,
		0,	RLEFT,
		"	shrZB	AL,*1\n",

ASG RS, 	INTAREG,
	STAREG,	TUNSIGNED|TPOINT|TUCHAR,
	EA,	TINT,
		0,	RLEFT,
		"	mov	cx,AR\n	shrZB	AL,cl\n",

ASG RS,		INAREG|FOREFF,
	EA,	TULONG,
	SONE,	TINT,
		0,	RLEFT,
		"	sar	UL,*1\n	rcr	AL,*1\n",

ASG RS,		INAREG|FOREFF,
	EA,	TULONG,
	EA,	TINT,
		0,	RLEFT,
		"\tmov\tcx,AR\n\tor\tcx,cx\n\tjz\tZY\nZX\tsar\tUL,*1\n\trcr\tAL,*1\n\tloop\tZy\nZs",

ASG RS,		INTAREG|FOREFF,
	STAREG,	TULONG,
	EA,	TINT,
		0,	RLEFT,
		"\tmov\tcx,AR\nor\tcx,cx\n\tjz\tZY\nZX\tsar\tUL,*1\n\trcr\tAL,*1\n\tloop\tZy\nZs",

ASG RS,		INAREG|FOREFF,
	EA,	TLONG,
	SONE,	TINT,
		0,	RLEFT,
		"	sar	UL,*1\n	rcr	AL,*1\n",

ASG RS,		INAREG|FOREFF,
	EA,	TLONG,
	EA,	TINT,
		0,	RLEFT,
		"\tmov\tcx,AR\n\tor\tcx,cx\n\tjz\tZY\nZX\tsar\tUL,*1\n\trcr\tAL,*1\n\tloop\tZy\nZs",

UNARY CALL,	INTAREG,
	SCON,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR|TLONG|TULONG,
		NAREG|NASL,	RESC1, /* should be register 0 */
		"	call	Zd\n",

UNARY CALL,	INTAREG,
	SAREG|SNAME|SOREG,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR|TLONG|TULONG,
		NAREG|NASL,	RESC1, /* should be register 0 */
		"	call	@AL\n",

#ifdef X8087
UNARY CALL,	INTEMP,
	SCON,	TANY,
	SANY,	TDOUBLE,
		4*NTEMP,	RESC1,
		"	call	Zd\n	fstpd	A1\n",

UNARY CALL,	INTEMP,
	SAREG|SNAME|SOREG,	TANY,
	SANY,	TDOUBLE,
		4*NTEMP,	RESC1,
		"	call	@AL\n	fstpd	A1\n",
#endif

#ifndef X8087
UNARY CALL,	INTEMP,
	SCON,	TANY,
	SANY,	TDOUBLE,
		4*NTEMP,	RESC1,
		"\tcall	Zd\n\tpush\tsi\n\tpush\tdi\n\tlea\tsi,Dreg\n\tlea\tdi,A1\n\tmov\tcx,#4\n\tcld\n\trepz\n\tmovw\n\tpop\tdi\n\tpop\tsi\n",

UNARY CALL,	INTEMP,
	SAREG|SNAME|SOREG,	TANY,
	SANY,	TDOUBLE,
		4*NTEMP,	RESC1,
		"\tcall	@AL\n\tpush\tsi\n\tpush\tdi\n\tlea\tsi,Dreg\n\tlea\tdi,A1\n\tmov\tcx,#4\n\tcld\n\trepz\n\tmovw\n\tpop\tdi\n\tpop\tsi\n",

#endif
SCONV,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SANY,	TUCHAR,
		0,	RLEFT,
		"	and	AL,#255\n",

SCONV,	INTAREG,
	EA,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
	SANY,	TCHAR,
		NAREG|NASL,	RESC1,
		"	mov	A1,AL\nZe",

SCONV,	INAREG,
	EA,	TLONG|TULONG,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RLEFT,
		"ZT",

SCONV,	INTAREG,
	STAREG,	TLONG|TULONG,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,	RLEFT,
		"ZT",

SCONV,	INTBREG,
	EA,	TLONG|TULONG,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NBREG|NBSL,	RESC1,
		"	mov	A1,AL\n",

SCONV,	INTAREG,
	EA,	TUCHAR,
	SANY,	TLONG|TULONG,
		NAREG|NASL,	RESC1,
		"	movb	A1,AL\n	and	A1,#255\n	mov	U1,*0\n",

SCONV,	INTAREG,
	EA,	TCHAR,
	SANY,	TLONG|TULONG,
		NAREG|NASL,	RESC1,
		"	mov	A1,AL\nZe",

SCONV,	INTAREG,
	EA,	TINT,
	SANY,	TLONG|TULONG,
		NAREG|NASL,	RESC1,
		"	mov	A1,AL\nZE",

SCONV,	INTAREG,
	EA,	TUNSIGNED|TPOINT,
	SANY,	TLONG|TULONG,
		NAREG|NASL,	RESC1,
		"	mov	A1,AL\n	mov	U1,*0\n",

SCONV,	INTAREG,
	STAREG, TINT|TUNSIGNED|TPOINT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"",

SCONV,	INTBREG,
	STAREG, TINT|TUNSIGNED|TPOINT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NBREG|NBSL,	RESC1,
		"	mov	A1,AL\n",

SCONV,	INTAREG,
	STAREG, TCHAR|TUCHAR,
	SANY,	TCHAR|TUCHAR,
		0,	RLEFT,
		"",

SCONV,	INTAREG,
	STAREG, TLONG|TULONG,
	SANY,	TLONG|TULONG,
		0,	RLEFT,
		"",

#ifdef X8087
SCONV,	INAREG|INTEMP,
	FEA,	TDOUBLE|TFLOAT,
	SANY,	TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NTEMP,	RESC1,
		"	fldZl	AL\n	fstpi	A1\n	fwait\n",

SCONV,	INTEMP,
	FEA,	TDOUBLE|TFLOAT,
	SANY,	TLONG|TULONG|TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		2*NTEMP,	RESC1,
		"	fldZl	AL\n	fstpl	A1\n	fwait\n",

SCONV,	INTEMP,
	FEA,	TLONG|TULONG,
	SANY,	TDOUBLE|TFLOAT,
		4*NTEMP,	RESC1,
		"	fldl	AL\n	fstpd	A1\n",

SCONV,	INTEMP,
	EREG,	TLONG|TULONG,
	SANY,	TDOUBLE|TFLOAT,
		4*NTEMP,	RESC1,
		"	mov	A1,AL\n	mov	U1,UL\n	fldl	A1\n	fstpd	A1\n",

SCONV,	INTEMP,
	FEA,	TINT|TUNSIGNED,
	SANY,	TDOUBLE|TFLOAT,
		4*NTEMP,	RESC1,
		"	fldi	AL\n	fstpd	A1\n",

SCONV,	INTEMP,
	EREG,	TINT|TUNSIGNED,
	SANY,	TDOUBLE|TFLOAT,
		4*NTEMP,	RESC1,
		"	mov	A1,AL\n	fldi	A1\n	fstpd	A1\n",
#endif

PCONV,	INTAREG,
	EA,	TUCHAR,
	SANY,	TPOINT,
		NAREG|NASL,	RESC1,
		"	movb	A1,AL\n	and	A1,#255\n",

PCONV,	INTAREG,
	EA,	TCHAR,
	SANY,	TPOINT,
		NAREG|NASL,	RESC1,
		"	mov	A1,AL\nZe",

PCONV,	INAREG,
	EA,	TLONG|TULONG,
	SANY,	TPOINT,
		0,	RLEFT,
		"ZT",

STASG,	FOREFF,
	EA,	TANY,
	EA,	TANY,
		0,	RNOP,
		"ZS",

/*STASG,	FOREFF,
	SNAME|SOREG,	TANY,
	SCON|SAREG|SBREG,	TANY,
		0,	RNOP,
		"ZS",

STASG,	INTAREG|INAREG,
	SNAME|SOREG,	TANY,
	STAREG|STBREG,	TANY,
		0,	RRIGHT,
		"ZS",

STASG, INAREG|INTAREG,
	SNAME|SOREG,	TANY,
	SCON|SAREG|SBREG,	TANY,
		NAREG|NASR,	RESC1,
		"ZS	mov	A1,AR\n",*/

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RNOP,
		"	.word	ZL\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TLONG|TULONG,
		0,	RNOP,
		"	.long	ZL\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TCHAR|TUCHAR,
		0,	RNOP,
		"	.byte	ZL\n",

	/* for the use of fortran only */

GOTO,	FOREFF,
	SCON,	TANY,
	SANY,	TANY,
		0,	RNOP,
		"	jbr	CL\n",

GOTO,	FOREFF,
	SNAME,	TLONG|TULONG,
	SANY,	TANY,
		0,	RNOP,
		"	jmp	*UL\n",

GOTO,	FOREFF,
	SNAME,	TINT|TUNSIGNED|TCHAR|TUCHAR|TPOINT,
	SANY,	TANY,
		0,	RNOP,
		"	jmp	*AL\n",

	/* Default actions for hard trees ... */

# define DF(x) FORREW,SANY,TANY,SANY,TANY,REWRITE,x,""

UNARY MUL, DF( UNARY MUL ),

INCR, DF(INCR),

DECR, DF(INCR),

ASSIGN, DF(ASSIGN),

STASG, DF(STASG),

OPLEAF, DF(NAME),

OPLOG,	FORCC,
	SANY,	TANY,
	SANY,	TANY,
		REWRITE,	BITYPE,
		"",

OPLOG,	DF(NOT),

COMOP, DF(COMOP),

INIT, DF(INIT),

OPUNARY, DF(UNARY MINUS),


ASG OPANY, DF(ASG PLUS),

OPANY, DF(BITYPE),

FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	"help; I'm in trouble\n" };
