

            plpc (1) --- interface to Primos PL/P compiler           08/27/84


          | _U_s_a_g_e

                 plpc {-<option>[<level>]} <input file>
                          [-b [<binary file>]]
                          [-l [<listing file>]]
                          [-z <PLP option>]
                    <option> ::= e | f | q | v | x


            _D_e_s_c_r_i_p_t_i_o_n

                 'Plpc'  serves as the Subsystem interface to the Primos PL/P
                 compiler (PLP).  It examines its option  specifications  and
                 checks  them  for consistency, provides Subsystem-compatible
                 default file names for  the  listing  and  binary  files  as
                 needed, and then produces a Primos PLP command and causes it
                 to be executed.

                 OOOppptttiiiooonnnsss

                 The  general  structure of an 'plpc' option is a single let-
                 ter, possibly followed by a "level  number"  indicating  the
                 extent to which an option should be employed.  The following
                 list  outlines the options and the meanings of their various
                 levels.  The first line of  each  description  contains  the
                 option  letter  followed  by  its  default level enclosed in
                 parentheses, the  range  of  available  levels  enclosed  in
                 square  brackets,  and  a  brief description of the option's
                 purpose.  In all cases, when an option is specified  without
                 a level number, the maximum allowable value is assumed.


                 -e(1) [0..1] - Error listing on terminal.

                      Level  0 inhibits the printing of compilation errors on
                      the user's terminal.

                      Level 1 causes compilation errors to be printed on  the
                      terminal.

                 -f(0) [0..1] - Offset map.

                      Level  0  inhibits  the  generation of a storage offset
                      map.

                      Level 1 cause the  generation  of  a  map  listing  the
                      storage offset of each program variable.

                 -q(1) [0..1] - Suppress warning messages.

                      Level  0  inhibits the display of compiler warning mes-
                      sages.

                      Level 1 allows the display  of  compiler  warning  mes-
                      sages.



            plpc (1)                      - 1 -                      plpc (1)




            plpc (1) --- interface to Primos PL/P compiler           08/27/84


                 -v(1) [1..2] - Listing verbosity.

                      Level 1 generates a full source code listing.

                      Level  2  generates  a  full source code listing plus a
                      representation of the machine code generated  for  each
                      statement.

                 -x(1) [0..1] - Cross-reference listing control.

                      Level 0 inhibits the generation of a cross-reference.

                      Level  1  causes  the  compiler  to  generate  a cross-
                      reference listing.

                 In addition to the options above, the "-z" option allows the
                 explicit passing of a string verbatim into the command line.

                 FFFiiillleee CCCooonnntttrrrooolll

                 The "-b" option is used to select the name of  the  file  to
                 receive the binary object code output of the compiler.  If a
                 file  name  follows  the option, then that file receives the
                 object code.  (Note that if "/dev/null" is specified as  the
                 file  name, no object code will be produced.)  If the option
                 is not specified, or no file  name  follows  it,  a  default
                 filename  is constructed from the input filename by changing
                 its suffix to ".b".  For example, if the input  filename  is
                 "prog.plp",  the  binary file will be "prog.b"; if the input
                 filename is "foo", the binary file will be "foo.b".

                 The "-l" option is used to select the name of  the  file  to
                 receive  the  listing  generated by the compiler.  If a file
                 name  follows  the  option,  then  that  file  receives  the
                 listing.   The  file name "/dev/null" may be used to inhibit
                 the listing; "/dev/tty" to cause it to appear on the  user's
                 terminal;  "/dev/lps"  to cause it to be spooled to the line
                 printer.  If the "-l" option is  specified  without  a  file
                 name  following  it,  a default filename is constructed from
                 the input filename by changing  its  suffix  to  ".l".   For
                 example,  if  the input filename is "gonzo.plp", the listing
                 file will be "gonzo.l"; if the input filename is "bar",  the
                 listing  file  will  be  "bar.l".  If the "-l" option is not
                 used, no listing is produced.

                 The input filename may be either  a  disk  file  name  (con-
                 ventionally  ending  in ".plp") or the device "/dev/tty", in
                 which case input to the compiler is  read  from  the  user's
                 terminal.

                 In  summary,  then, the default command line for compiling a
                 file named "file.plp" is

                      plpc -e1f0q1v1x1 _
                           file.plp  -b file.b  -l /dev/null



            plpc (1)                      - 2 -                      plpc (1)




            plpc (1) --- interface to Primos PL/P compiler           08/27/84


                 which corresponds to the PLP command

                      plp -i *>file.plp -b *>file.b -l no



            _E_x_a_m_p_l_e_s

                 plpc file.plp
                 plpc -f dmach.plp
                 plpc -x dmach.plp -b b_dmach -l l_dmach
                 plpc -e0 r_mode_prog.plp -z"-newopt"


            _M_e_s_s_a_g_e_s

                 "Usage:  plpc ..."  for invalid option syntax.
                 "level  numbers   for   -<option>   are   <lower bound>   to
                      <upper bound>"  if  an  out-of-range  level  number  is
                      specified.
                 "missing input file name" if  no  input  filename  could  be
                      found.
                 "<name>:   unreasonable  input  file name" if an attempt was
                      made to read from the null device or the  line  printer
                      spooler.
                 "<name>:   unreasonable  binary file name" if an attempt was
                      made to produce object code on  the  terminal  or  line
                      printer spooler.
                 "inconsistency  in  internal  tables"  if the tables used to
                      process the options are incorrectly constructed.   This
                      message  indicates  a serious error in the operation of
                      'plpc'  that  should  be  reported   to   your   system
                      administrator.

                 Numerous other self-explanatory messages may be generated to
                 diagnose conflicts between selected options.


            _B_u_g_s

                 'Plpc' pays no attention to standard ports.


            _S_e_e _A_l_s_o

          |      ld (1), plpcl (1), bind (3)












            plpc (1)                      - 3 -                      plpc (1)


