/*****************************************************************************
 * sqdial.c : Test of the Square Dial widget class
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h> 
#include <Xol/OpenLook.h>
#include "SquareDial.h"

main(argc, argv)
  int   argc;
  char *argv[];
{
  void select_callback();
  Widget toplevel, dial;

  /*
   * Initialize the Intrinsics.
   */
  toplevel = OlInitialize(argv[0], "DialTest", NULL, 0, &argc, argv);
  /*
   * Create a square dial widget and assign a callback.
   */
  dial = XtCreateManagedWidget("dial", 
                               XssquareDialWidgetClass, 
                               toplevel, NULL, 0);
  XtAddCallback(dial, XtNselectCallback,
               select_callback, NULL);
  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void
select_callback(w, client_data, call_data)
  Widget     w;
  XtPointer  client_data;
  XtPointer  call_data;
{
  Arg wargs[1];
  xsdialCallbackStruct *cb = (xsdialCallbackStruct *)call_data;

  XtSetArg(wargs[0], XtNposition, cb->position);
  XtSetValues(w, wargs, 1);
}
