(lisp:eval-when (lisp:compile lisp:load lisp:eval)
		(excl:compile-file-if-needed "go2_h.l")
		(load "go2_h"))
(excl:compile-file-if-needed "util.l")
(load "util")

(defvar CROSS 0)
(defvar BLACK 1)
(defvar WHITE 2)

(defvar board (make-matrix BOARD_SIZE BOARD_SIZE))

(defun pickastone ()
  (let ((i (random 7)))
    (if (> i 2) CROSS i)))

(if (not (ps_open_PostScript))
    (error "Cannot connect to NeWS server"))

(initialize)

(execute)

(do ()
    ((psio_error PostScriptInput))
    (print 'loop)
    (cond
     ((get_black)
      (let ((id get_black_id) (x get_black_x) (y get_black_y))
	(if (= (matrix-ref board x y) BLACK)
	    (let ()
	     (matrix-set! board x y CROSS)
	     (cross id x y))
	  (let ()
	   (matrix-set! board x y BLACK)
	   (black_stone id x y)))
	))
     ((get_white)
      (let ((id get_white_id) (x get_white_x) (y get_white_y))
	(if (= (matrix-ref board x y) WHITE)
	    (let ()
	      (matrix-set! board x y CROSS)
	      (cross id x y))
	  (let ()
	    (matrix-set! board x y WHITE)
	    (white_stone id x y)))
	))
     ((get_menu)
      (do ((x 0 (+ x 1)))
	  ((not (< x BOARD_SIZE)))
	  (do ((y 0 (+ y 1)))
	      ((not (< y BOARD_SIZE)))
	      (let ()
		(matrix-set! board x y (if (= get_menu_cmd FILL_CMD)
					   (pickastone)
					 CROSS))
		)))
      (repaint))
     ((get_damage)
      (draw_board get_damage_id)
      (do ((x 0 (+ x 1)))
	  ((not (< x BOARD_SIZE)))
	  (do ((y 0 (+ y 1)))
	      ((not (< y BOARD_SIZE)))
	      (let ()
		  (cond
		   ((= (matrix-ref board x y) BLACK)
		    (black_stone get_damage_id x y))
		   ((= (matrix-ref board x y) WHITE)
		    (white_stone get_damage_id x y)))
		)))
      (repaired get_damage_id))
     ((not (or (done) (psio_eof PostScriptInput)))
      ))))
(ps_close_PostScript)

