/*
 *	improved banner program
 */

/*
 *	bit pattern character table
 */

char btab[][7]
{
	010,	010,	010,	010,	010,	00,	010,
	024,	024,	024,	00,	00,	00,	00,
	024,	024,	0177,	024,	0177,	024,	024,
	010,	034,	050,	034,	012,	034,	010,
	0161,	0122,	0164,	010,	027,	045,	0107,
	034,	042,	024,	010,	025,	042,	035,
	04,	010,	020,	00,	00,	00,	00,
	01,	02,	04,	04,	04,	02,	01,
	0100,	040,	020,	020,	020,	040,	0100,
	0111,	052,	034,	0177,	034,	052,	0111,
	00,	010,	010,	076,	010,	010,	00,
	00,	00,	00,	00,	00,	040,	0100,
	00,	00,	00,	074,	00,	00,	00,
	00,	00,	00,	00,	00,	00,	040,
	01,	02,	04,	010,	020,	040,	0100,
	034,	042,	0105,	0111,	0121,	042,	034,
	030,	010,	010,	010,	010,	010,	034,
	034,	042,	02,	04,	010,	020,	076,
	034,	042,	02,	04,	02,	042,	034,
	02,	06,	012,	022,	077,	02,	02,
	076,	040,	040,	074,	02,	042,	034,
	02,	04,	010,	036,	041,	041,	036,
	077,	01,	02,	04,	010,	020,	040,
	034,	042,	042,	034,	042,	042,	034,
	036,	041,	041,	036,	04,	010,	020,
	00,	00,	00,	010,	00,	010,	00,
	00,	00,	00,	010,	00,	010,	020,
	02,	04,	010,	020,	010,	04,	02,
	00,	00,	074,	00,	074,	00,	00,
	040,	020,	010,	04,	010,	020,	040,
	034,	042,	02,	04,	010,	00,	010,
	076,	0101,	0117,	0111,	0117,	0100,	076,
	034,	042,	0101,	0177,	0101,	0101,	0101,
	0176,	0101,	0101,	0176,	0101,	0101,	0176,
	034,	042,	0100,	0100,	0100,	042,	034,
	0174,	0102,	0101,	0101,	0101,	0102,	0174,
	0176,	0100,	0100,	0170,	0100,	0100,	0176,
	0176,	0100,	0100,	0170,	0100,	0100,	0100,
	036,	041,	0100,	0100,	0107,	041,	036,
	0101,	0101,	0101,	0177,	0101,	0101,	0101,
	034,	010,	010,	010,	010,	010,	034,
	02,	02,	02,	02,	02,	042,	034,
	0102,	0104,	0110,	0120,	0150,	0104,	0102,
	0100,	0100,	0100,	0100,	0100,	0100,	0176,
	0101,	0143,	0125,	0111,	0101,	0101,	0101,
	0101,	0141,	0121,	0111,	0105,	0103,	0101,
	076,	0101,	0101,	0101,	0101,	0101,	076,
	0176,	0101,	0101,	0176,	0100,	0100,	0100,
	076,	0101,	0101,	0111,	0105,	0102,	075,
	0176,	0101,	0101,	0176,	0104,	0102,	0101,
	076,	0101,	0100,	076,	01,	0101,	076,
	0177,	010,	010,	010,	010,	010,	010,
	0101,	0101,	0101,	0101,	0101,	0101,	076,
	0101,	0101,	0101,	0101,	042,	024,	010,
	0101,	0101,	0101,	0111,	0125,	0143,	0101,
	0101,	042,	024,	010,	024,	042,	0101,
	0101,	042,	024,	010,	010,	010,	010,
	0177,	02,	04,	010,	020,	040,	0177,
	07,	04,	04,	04,	04,	04,	07,
	0100,	040,	020,	010,	04,	02,	01,
	0160,	020,	020,	020,	020,	020,	0160,
	010,	024,	042,	0101,	00,	00,	00,
	00,	00,	00,	00,	00,	00,	0177,
	020,	010,	04,	00,	00,	00,	00,
	00,	076,	02,	076,	042,	077,	00,
	040,	040,	074,	042,	042,	0174,	00,
	00,	036,	040,	040,	040,	036,	00,
	02,	02,	036,	042,	042,	037,	00,
	00,	036,	041,	077,	040,	036,	00,
	010,	024,	020,	070,	020,	020,	00,
	00,	034,	042,	042,	036,	02,	014,
	040,	040,	076,	041,	041,	041,	00,
	010,	00,	010,	010,	010,	034,	00,
	02,	00,	02,	02,	02,	022,	014,
	040,	044,	050,	060,	050,	044,	00,
	030,	010,	010,	010,	010,	034,	00,
	00,	0166,	0111,	0111,	0111,	0111,	00,
	00,	076,	041,	041,	041,	041,	00,
	00,	036,	041,	041,	041,	036,	00,
	00,	074,	042,	042,	074,	040,	040,
	00,	036,	042,	042,	036,	02,	03,
	00,	054,	042,	040,	040,	040,	00,
	00,	036,	040,	036,	01,	036,	00,
	020,	074,	020,	020,	022,	014,	00,
	00,	041,	041,	041,	041,	035,	00,
	00,	042,	042,	024,	024,	010,	00,
	00,	0101,	0101,	0111,	0111,	066,	00,
	00,	042,	024,	010,	024,	042,	00,
	00,	042,	042,	042,	036,	02,	014,
	00,	076,	04,	010,	020,	076,	00,
	03,	04,	04,	030,	04,	04,	03,
	010,	010,	010,	010,	010,	010,	010,
	0140,	020,	020,	014,	020,	020,	0140,
	060,	0111,	06,	00,	00,	00,	00,
	0177,	0177,	0177,	0177,	0177,	0177,	0177,

};

/*
 * subroutine to make the characters for a banner
 */

mkline(s,prch,line,space)
char *s, prch, *space;
int line;
{
	register char *rs, *rl;
	register int bit;
	extern char btab[][7];
	int i, j, m;
	rl = space;
	for (i = 0; i < 7; i++)
	{
		j = 0;
		for (rs = s; *rs && j < line; j++)
		{
			bit = (bit=(*rs++&0177)-'!') < 0 ? 0 : btab[bit][i];
			for (m = 0100; bit; m =>> 1)
			{
				*rl++ = m&bit ? (prch ? prch : rs[-1]) : ' ';
				bit =& ~m;
			}
			*rl++ = '\t';
		}
		while (*--rl == '\t');
		++rl;
		*rl++ = '\n';
	}
	*rl = '\0';
	return(space);
}

main(argc,argv)
int argc;
char **argv;
{
	register char prch, *space;
	static char buf[256];
	register int line;
	extern int fout;
	extern char *alloc();
	prch = '*';
	line = 10;
	while (**++argv == '-')
	{
		--argc;
		switch(*++*argv)
		{
		case 'c':		/* char to use */
			prch = *++*argv;
			break;
		case 'l':
		case 'w':
			line = atoi(++*argv)>>3;
			break;
		}
	}
	fout = dup(1);
	space = alloc(line*64);
	putchar('\n');
	if (--argc)
		do
		{
			printf("\n%s",mkline(*argv++,prch,line,space));
			flush();
		} while (--argc);

	else
		while (getline(buf))
		{
			printf("\n%s",mkline(buf,prch,line,space));
			flush();
		}
}

/*
 *	read in a line from the standard input
 */

getline(p)
char *p;
{
	register char *q;
	q = p;
	while (*q = getchar()) if (*q++ == '\n') break;
	*q = '\0';
	return (q-p);
}
