/*-------------------------------------------------------------*/
/*  File: ol_util.c
 *
 *  Utility function for building menus with OLIT.
 *
 */
 /*-------------------------------------------------------------*/
#include <stdio.h>
#include <varargs.h>     /* UNIX-style variable argument macros */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/OblongButt.h>
#include <Xol/MenuButton.h>

typedef void   (*P_FUNC)();
typedef char   *P_CHAR;

/*-------------------------------------------------------------*/
/*  M a k e M e n u B u t t o n
 *
 *  Create a menu button and attach a menu pane to the button.
 *  Uses variable number of arguments.
 *  Each menu entry is a pair of the form: label, action_proc
 *  A NULL marks the end.
 */
Widget MakeMenuButton(name, parent, pin_state, va_alist)
char   *name;
Widget parent;
int    pin_state;
va_dcl
{
    va_list  argp;         /* Used to access arguments */
    Widget   w, menu, b;
    char     *item_label;
    Widget   button;
    P_FUNC   item_action;
    caddr_t  action_args;
    int      bcount = 0;

/* Create the MenuButton widget */    
    w = XtVaCreateManagedWidget(name,
                      menuButtonWidgetClass, parent,
                      XtNlabel,         name,
                      XtNtitle,         name,
                      XtNpushpin,       pin_state,
                      NULL);

/* Get the menu pane's ID */
    XtVaGetValues(w, XtNmenuPane, &menu, NULL);


/* Add entries (oblong buttons) to the menupane */
/* Get the first optional parameter using "va_start" */
    va_start(argp);

/* Get items one by one and prepare the menu items */
    while((item_label = va_arg(argp, P_CHAR)) != NULL)
    {
        b = XtVaCreateManagedWidget(item_label,
                    oblongButtonWidgetClass, menu,
                    XtNlabel,   item_label,
                    NULL);

/* Make the first menu item the default */
        if(bcount == 0) 
            XtVaSetValues(b, XtNdefault, True, NULL);
        bcount++;

/* Register callback for this menu button */

        item_action = va_arg(argp, P_FUNC);
        action_args = va_arg(argp, caddr_t);
                      
        XtAddCallback(b, XtNselect,
                      item_action, action_args);
    }
    va_end(argp);

    return w;
}
