/*-------------------------------------------------------------*/
/*  File: chkbox.c 
 *
 *  Demonstrates the use of CheckBoxes inside a Nonexclusives 
 *  widget
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/CheckBox.h>
#include <Xol/Nonexclusi.h>

/* Labels for the CheckBoxes */
static char* choices[] =
{
    "Xlib", "OPEN LOOK Widgets", "Motif Widgets"
};

/* Callbacks */
static void box_set();
static void box_unset();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, b;
    int i;
    Pixel black, white;

/* Create the Nonexclusives widget */    
    w = XtVaCreateManagedWidget("ManyOfMany", 
                      nonexclusivesWidgetClass, parent,
                      XtNlayoutType,    OL_FIXEDCOLS,
                      NULL);

/* Add the CheckBox widgets */
    black = BlackPixelOfScreen(XtScreen(w));
    white = WhitePixelOfScreen(XtScreen(w));
    for(i = 0; i < XtNumber(choices); i++)
    {
        b = XtVaCreateManagedWidget("Checkbox",
                    checkBoxWidgetClass, w,
                    XtNlabel,       choices[i],
                    XtNforeground,  black,
                    XtNbackground,  white,
                    NULL);
        XtAddCallback(b, XtNselect, box_set, 
                      (XtPointer)choices[i]);
        XtAddCallback(b, XtNunselect, box_unset, 
                      (XtPointer)choices[i]);
    }
    return w;
}
/*-------------------------------------------------------------*/
static void box_set(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    printf("%s SET\n", (char*) client_data);
}
/*-------------------------------------------------------------*/
static void box_unset(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    printf("%s UNSET\n", (char*) client_data);
}

