.\" $XConsortium: Standards.man,v 1.14 94/04/18 12:06:11 rws Exp $
.\" Copyright (c) 1993, 1994  X Consortium
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"), 
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense, 
.\" and/or sell copies of the Software, and to permit persons to whom the 
.\" Software furnished to do so, subject to the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
.\" SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall not 
.\" be used in advertising or otherwise to promote the sale, use or other 
.\" dealing in this Software without prior written authorization from the 
.\" X Consortium.
.TH XSTANDARDS 1 "Release 6" "X Version 11"
.SH NAME
X Standards \- X Consortium Standards
.SH SYNOPSIS
The major goal of the X Consortium is to promote cooperation within the
computer industry in the creation of standard software interfaces at all layers
in the X Window System environment.  The status of various standards, and
the software in the X11R6 distribution, is explained below.
.SH STANDARDS
The following documents are X Consortium standards:
.nf

X Window System Protocol
X Version 11, Release 6
Robert W. Scheifler

Xlib \- C Language X Interface
X Version 11, Release 6
James Gettys, Robert W. Scheifler, Ron Newman

X Toolkit Intrinsics \- C Language Interface
X Version 11, Release 6
Joel McCormack, Paul Asente, Ralph R. Swick, Donna Converse

Bitmap Distribution Format
Version 2.1
X Version 11, Release 6

Inter-Client Communication Conventions Manual
Version 2.0
X Version 11, Release 6
David Rosenthal, Stuart W. Marks

Compound Text Encoding
Version 1.1
X Version 11, Release 6
Robert W. Scheifler

X Logical Font Description Conventions
Version 1.5
X Version 11, Release 6
Jim Flowers, Stephen Gildea

X Display Manager Control Protocol
Version 1.0
X Version 11, Release 6
Keith Packard

X11 Nonrectangular Window Shape Extension
Version 1.0
X Version 11, Release 6
Keith Packard

X11 Input Extension Protocol Specification
Version 1.0
X Version 11, Release 6
George Sachs, Mark Patrick

X11 Input Extension Library Specification
X Version 11, Release 6
Mark Patrick, George Sachs

The X Font Service Protocol
Version 2.0
X Version 11, Release 6
Jim Fulton

PEX Protocol Specification
Version 5.1
Cheryl Huntington (architect), Paula Womack (editor)

PEXlib Specification and C Language Binding
Version 5.1
Jeff Stevenson

Inter-Client Exchange (ICE) Protocol
Version 1.0
X Version 11, Release 6
Robert Scheifler, Jordan Brown

Inter-Client Exchange (ICE) Library
Version 1.0
X Version 11, Release 6
Ralph Mor

X Session Management Protocol
Version 1.0
X Version 11, Release 6
Mike Wexler

X Session Management Library
Version 1.0
X Version 11, Release 6
Ralph Mor

The Input Method Protocol
Version 1.0
X Version 11, Release 6
Masahiko Narita, Hideki Hiura

X Synchronization Extension
Version 3.0
X Version 11, Release 6
Tim Glauert, Dave Carver, Jim Gettys, David P. Wiggins

X Image Extension, Protocol Reference Manual
Version 5.0
X Version 11, Release 6
Bob Shelley

XTEST Extension
Version 2.2
Kieron Drake

Big Requests Extension
Version 2.0
X Version 11, Release 6
Bob Scheifler

XC-MISC Extension
Version 1.1
X Version 11, Release 6
Bob Scheifler, Dave Wiggins
.fi
.SH "DRAFT STANDARDS"
The following documents are currently draft standards of the X Consortium.
.nf

X Image Extension Libary
Public Review Draft
Gary Rogers

Extending X for Double-Buffering, Multi-Buffering, and Stereo
Version 3.3
Public Review Draft
Jeffrey Friedberg, Larry Seiler, Jeff Vroom
.fi

.SH "INCLUDE FILES"
The following include files are part of the Xlib standard.
.nf

<X11/cursorfont.h>
<X11/keysym.h>
<X11/keysymdef.h>
<X11/X.h>
<X11/Xatom.h>
<X11/Xcms.h>
<X11/Xlib.h>
<X11/Xlibint.h>
<X11/Xproto.h>
<X11/Xprotostr.h>
<X11/Xresource.h>
<X11/Xutil.h>
<X11/X10.h>
.fi
.PP
The following include files are part of the X Toolkit Intrinsics standard.
.nf

<X11/Composite.h>
<X11/CompositeP.h>
<X11/Constraint.h>
<X11/ConstrainP.h>
<X11/Core.h>
<X11/CoreP.h>
<X11/Intrinsic.h>
<X11/IntrinsicP.h>
<X11/Object.h>
<X11/ObjectP.h>
<X11/RectObj.h>
<X11/RectObjP.h>
<X11/Shell.h>
<X11/ShellP.h>
<X11/StringDefs.h>
<X11/Vendor.h>
<X11/VendorP.h>
.fi
.PP
The following include file is part of the
Nonrectangular Window Shape Extension standard.
.nf

<X11/extensions/shape.h>
.fi
.PP
The following include files are part of the X Input Extension standard.
.nf

<X11/extensions/XI.h>
<X11/extensions/XInput.h>
<X11/extensions/XIproto.h>
.fi
.PP
The following include files are part of the PEXlib standard.
.nf

<X11/PEX5/PEX.h>
<X11/PEX5/PEXlib.h>
<X11/PEX5/PEXlibint.h>
<X11/PEX5/PEXproto.h>
<X11/PEX5/PEXprotost.h>
.fi
.PP
The following include files are part of the ICElib standard.
.nf

<X11/ICE/ICE.h>
<X11/ICE/ICEconn.h>
<X11/ICE/ICElib.h>
<X11/ICE/ICEmsg.h>
<X11/ICE/ICEproto.h>
<X11/ICE/ICEutil.h>
.fi
.PP
The following include files are part of the SMlib standard.
.nf

<X11/SM/SM.h>
<X11/SM/SMlib.h>
<X11/SM/SMproto.h>
.fi
.PP
The following include file is part of the Synchronization standard.
.nf

<X11/extensions/sync.h>
.fi
.PP
The following include files are part of the XIElib draft standard.
.nf

<X11/extensions/XIE.h>
<X11/extensions/XIElib.h>
<X11/extensions/XIEproto.h>
<X11/extensions/XIEprotost.h>
.fi
.PP
The following include file is part of the XTEST standard.
.nf

<X11/extensions/XTest.h>
.fi
.PP
The following include file is part of the Multi-Buffering draft standard.
.nf

<X11/extensions/multibuf.h>
.fi

.SH "NON STANDARDS"
The X11R6 distribution contains \fIsample\fP implementations, not
\fIreference\fP implementations.  Although much of the code is believed
to be correct, the code should be assumed to be in error wherever it
conflicts with the specification.
.PP
The only X Consortium standards are the ones listed above.
No other documents, include files, or software in X11R6 carry special
status within the X Consortium.  For example, none of the following
are standards:
internal interfaces of the sample server;
the MIT-SHM extension;
the Athena Widget Set;
the Xmu library;
the Xau library;
the RGB database;
the fonts distributed with X11R6;
the applications distributed with X11R6;
the include files <X11/XWDFile.h>, <X11/Xfuncproto.h>, <X11/Xfuncs.h>,
<X11/Xosdefs.h>, <X11/Xos.h>, and <X11/Xthreads.h>;
the bitmap files in <X11/bitmaps>.
.PP
The following are works in progress within the X Consortium, and are
neither standards nor draft standards:
Fresco;
Low Bandwidth X;
X Keyboard Extension;
Record Extension.
