#-h- carch            478 ascii 08/20/81 13:17:48
 # /carch/ common block holding file info for the archiver
 # put on a file named 'carch'
 # Used only by the archiver
 
 
 common /carch/ fname(NAMESIZE,MAXFILES),fstat(MAXFILES),
                fcount, errcnt, verbos
 
    character fname      # file arguments
    integer fstat        # YES if touched, NO otherwise; init = NO
    integer fcount       # number of file args
    integer errcnt       # error count; init = 0
    integer verbos       # verbose flag; init = NO
#-t- carch            478 ascii 08/20/81 13:17:48
#-h- arhdr            368 ascii 08/20/81 13:17:48
 # /hdr/ - common block holding header info for archiver
 # put on a file called 'arhdr'
 # Used only by the archiver
 
  common /hdr/ new, hdr(5), asc(6), local(6), bin(4)
 
  integer new		#flag for new file
  character hdr		#header flag
  character asc		#flag for ascii files
  character local	#flag for local character files
  character bin		#flag for binary files
#-t- arhdr            368 ascii 08/20/81 13:17:48
#-h- ar2.r          15864 ascii 08/20/81 13:17:49
#-h- defns           1207 ascii 08/20/81 13:16:27
 #        include ratdef
 #definitions for the archiver
 
 define(FOLDF,)                  # fold all file names to single case
          #NOTE:  If you want upper and lower case in file names to
          # be signficant, leave out the definition
 
 define(NAMESIZE,FILENAMESIZE)   # Max number of characters in
                                 # file name (includes EOS)
 define(MAXFILES,24)   # Max number of files allowed per archive call
 define(MAXCHARS,20)   # Max number of characters allowed in header for
                       # the size of the file
 define(TBL,LETT)      # Command to print table of contents
 define(PRINT,LETP)    # Command to print files
 define(EXTR,LETX)     # Command to extract files from archive
 define(UPD,LETU)      # Command to update archive
 define(DEL,LETD)      # Command to delete files from archive
 define(SALVAGE,LETS)  # command to salvage damaged archive
 define(VRBS,LETV)     # Command to set "verbose" flag
 define(TWOCOLWIDTH,20)	# fixed width of filename in header
 define(ASCII,12)      # flag for files made up of ascii characters
 define(BINARY,60)     # flag for binary files
 define(LOCAL,6)       # flag for files made up of local characters
 
 
#-t- defns           1207 ascii 08/20/81 13:16:27
#-h- acopy            236 ascii 08/20/81 13:16:28
 ## acopy - copy size characters from fdi to fdo
 subroutine acopy (fdi, fdo, size)
 character getch
 character c
 integer fdi, fdo, i, size
 
 for (i=1; i<=size; i=i+1)
	{
	if (getch(c,fdi) != EOF)
	call putch (c, fdo)
	}
 return
 end
#-t- acopy            236 ascii 08/20/81 13:16:28
#-h- addfil           772 ascii 08/20/81 13:16:28
 ## addfil - add file 'name'  to archive
   subroutine addfil(name, fd, errct)
 
   character head(MAXLINE), name(ARB)
   integer open, fsize, gettyp
   integer errct, fd, nfd, size, type
   include carch
 
   nfd = open(name, READ)
   if (nfd == ERR) {
      call putlin(name, ERROUT)
      call remark(': cant add.')
      errct = errct + 1
      return
      }
  type = gettyp(name)
  #call close(nfd)		#need file space, so close for now
   if (errct == 0)
      {
       size = fsize (name)
       call makhdr (name, head, size, type)
       if (verbos == YES)
		{
		call putlin (name, STDOUT)
		call putch (NEWLINE, STDOUT)
		}
       # nfd = open(name,READ)
       call putlin(head, fd)
       call acopy (nfd, fd, size)
      }
   call close (nfd)
   return
   end
#-t- addfil           772 ascii 08/20/81 13:16:28
#-h- ars             1121 ascii 08/20/81 13:16:28
 ## ar - driver subroutine for 'ar' - file maintainer
 DRIVER(ar)
 
   character aname(NAMESIZE)
   integer getarg
   character comand(3)
 
   include carch
   include arhdr
 
  data errcnt /0/
  data verbos /NO/
 
  #Set up header format
  data hdr /SHARP, MINUS, LETH, MINUS, EOS/
  data asc /LETA, LETS, LETC, LETI, LETI, EOS/
  data local /LETL, LETO, LETC, LETA, LETL, EOS/
  data bin /LETB, LETI, LETN, EOS/
 
 
 
   if (getarg(1, comand, 3) == EOF |
       getarg(2, aname, NAMESIZE) == EOF |
       comand(1) == QMARK & comand(2) == EOS)
      call help
 
   call getfns   # put file names in array
 
   call fold(comand)		#fold commands to single case
   i = 1
   if (comand(1) == MINUS)      #allow '-' before commands
	i = 2
   if (comand(i+1) == VRBS)  verbos = YES
 
   if (comand(i) == UPD)
      call update(aname)
   else if (comand(i) == TBL)
      call table(aname)
   else if (comand(i) == EXTR | comand(i) == PRINT)
      call extrac(aname, comand(i))
   else if (comand(i) == DEL)
      call delet (aname)
 else if (comand(i) == SALVAGE)
	call recovr(aname)
   else
      call help
 DRETURN
   end
 
#-t- ars             1121 ascii 08/20/81 13:16:28
#-h- delet            883 ascii 08/20/81 13:16:29
 
  #---------------------------------------------------------------
 ## delet  - delet  files from archive
   subroutine delet (aname)
   character aname(NAMESIZE), tfile(FILENAMESIZE)
   integer create, open, amove
   integer afd, tfd
   include carch
    string tname 'arctemp'
 
   if (fcount <= 0)    # protect innocents
      call error('delete by name only.')
   afd = open(aname, READ)
   if (afd == ERR)
      call cant(aname)
   call mkuniq(tname, tfile)		#get scratch file name
   tfd = create(tfile, WRITE)
   if (tfd == ERR)
      call cant(tfile)
   call replac(afd, tfd, DEL, errcnt)
   call notfnd
   call close(afd)
   call close(tfd)
   if (errcnt == 0)
      {
      if (amove (tfile, aname) == ERR)
	call remark ("can't rename archive scratch file.")
      }
   else
      call remark('fatal errors - archive not altered.')
   call remove(tfile)
   return
   end
#-t- delet            883 ascii 08/20/81 13:16:29
#-h- extrac          1123 ascii 08/20/81 13:16:29
  #---------------------------------------------------------------
 ## extrac - extract files from archive
   subroutine extrac(aname, cmd)
 
   character aname(NAMESIZE), ename(NAMESIZE), in(MAXLINE), cmd
   integer create, filarg, gethdr, open
   integer afd, efd, size, type
   include carch
   include arhdr
 
   afd = open(aname, READ)
   if (afd == ERR)
      call cant(aname)
   if (cmd == PRINT)
      efd = STDOUT
   else
      efd = ERR
   while (gethdr(afd, in, ename, size, type) != EOF)
      if (filarg(ename) == NO)
         call fskip(afd, size)
      else {
         if (efd != STDOUT)
            efd = create(ename, WRITE)
         if (efd == ERR) {
            call putlin(ename, ERROUT)
            call remark(': cant create.')
            errcnt = errcnt + 1
            call fskip(afd, size)
            }
         else
            {
             if (verbos == YES)
		{
		call putlin (ename, STDOUT)
		call putch (NEWLINE, STDOUT)
		}
            call acopy (afd, efd, size)
            if (efd != STDOUT)
                   call close (efd)
            }
         }
   call notfnd
   return
   end
#-t- extrac          1123 ascii 08/20/81 13:16:29
#-h- filarg           472 ascii 08/20/81 13:16:29
  #---------------------------------------------------------------
 ## filarg - check if name matches argument list
   integer function filarg(name)
   character name(ARB)
   integer equal
   integer i
   include carch
 
   if (fcount <= 0) {
      filarg = YES
      return
      }
   for (i = 1; i <= fcount; i = i + 1)
      if (equal(name, fname(1, i)) == YES) {
         fstat(i) = YES
         filarg = YES
         return
         }
   filarg = NO
   return
   end
#-t- filarg           472 ascii 08/20/81 13:16:29
#-h- fsize            300 ascii 08/20/81 13:16:30
 ## fsize - determine size of file in characters
 integer function fsize (name)
 
 character getch
 character c, name(ARB)
 integer open
 integer fd
 
 fd = open (name, READ)
 if (fd == ERR)
	fsize = ERR
 else
	{
	for (fsize=0; getch(c,fd) != EOF; fsize=fsize+1)
		;
	call close (fd)
	}
 return
 end
#-t- fsize            300 ascii 08/20/81 13:16:30
#-h- fskip            189 ascii 08/20/81 13:16:30
 ## fskip - skip n characters on file fd
 subroutine fskip (fd, n)
 
 character getch
 character c
 integer fd, i, n
 
 for (i=1; i<=n; i=i+1)
	if (getch(c,fd) == EOF)
		break
 return
 end
#-t- fskip            189 ascii 08/20/81 13:16:30
#-h- getfns          1096 ascii 08/20/81 13:16:30
 ## getfns - get file names into fname, check for duplicates
   subroutine getfns
 
   integer equal, getarg, getlin
   character junk(2)
   integer i, j, usein
   include carch
 
  data usein /NO/
   errcnt = 0
   for (i = 1; i <= MAXFILES; i = i + 1)
	{
	if (usein == NO)		#pick up files from arg list
		{
		if (getarg(i+2, fname(1,i), NAMESIZE) == EOF)
			break
		if (fname(1,i) == MINUS & fname(2,i) == EOS)
			usein = YES
		}
	if (usein == YES)
		{
		len = getlin(fname(1,i), STDIN)
		if (len == EOF)
			break
		fname(len,i) = EOS
		}
                    # fold file names to single case, if desired
      ifdef(FOLDF, call fold(fname(1,i)) )
	}
   fcount = i - 1
   if (i > MAXFILES)
      if (getarg(i+2, junk, 1) != EOF)
         call error('too many file names.')
   for (i = 1; i <= fcount; i = i + 1)
      fstat(i) = NO
   for (i = 1; i < fcount; i = i + 1)
      for (j = i + 1; j <= fcount; j = j + 1)
         if (equal(fname(1, i), fname(1, j)) == YES) {
            call putlin(fname(1, i), ERROUT)
            call error(': duplicate file name.')
            }
   return
   end
#-t- getfns          1096 ascii 08/20/81 13:16:30
#-h- gethdr           946 ascii 08/20/81 13:16:31
  ## gethdr - get header info from archive member 'fd'
   integer function gethdr(fd, buf, name, size, type)
   character buf(MAXLINE), name(NAMESIZE), temp(NAMESIZE)
   integer ctoi, equal, getlin, getwrd
   integer fd, i, len, size, type
   include arhdr
   string ohdr "-h-"
 
 
 #***kluge since EOF isn't always sensed on an empty file
  if (new == YES)
	{
	gethdr = EOF
	return
	}
 
   if (getlin(buf, fd) == EOF) {
      gethdr = EOF
      return
      }
   ifdef(FOLDF,  call fold(buf) )
   i = 1
   len = getwrd(buf, i, temp)
   if ( (equal(temp,hdr) == NO) & (equal(temp,ohdr) == NO))
      call error('archive not in proper format.')
   gethdr = YES
   len = getwrd(buf, i, name)
   size = ctoi(buf, i)
   len = getwrd (buf, i+1, temp)
   if (len <= 0 | equal(temp,asc) == YES)
	type = ASCII
   else if (equal(temp, local) == YES)
	type = LOCAL
   else if (equal(temp, bin) == YES)
	type = BINARY
   else
	type = ASCII
   return
   end
#-t- gethdr           946 ascii 08/20/81 13:16:31
#-h- help             190 ascii 08/20/81 13:16:31
  #---------------------------------------------------------------
 ## help - diagnostic printout
   subroutine help
 
   call error('usage: ar {dptuxsv} arcname [files].')
   return
   end
#-t- help             190 ascii 08/20/81 13:16:31
#-h- makhdr          1285 ascii 08/20/81 13:16:31
 ## makhdr - make header line for archive member
   subroutine makhdr(name, head, size, type)
   character head(MAXLINE), name(NAMESIZE), filsiz(MAXCHARS)
   integer now(7)
   character time(9), date(9)
   integer itoc, length, j, n
   integer size, i, type
  include arhdr
  include carch
 
   i = 1
   call stcopy(hdr, 1, head, i)		# store header flag
   head(i) = BLANK
   i = i + 1
   call stcopy(name, 1, head, i)	# store file name
   if (size == ERR)
	{
	junk = 0
	filsiz(1) = EOS
	errcnt = errcnt + 1
	}
   else
	junk = itoc(size, filsiz, MAXCHARS)
   n = TWOCOLWIDTH - junk - length(name)
   j = 1
   repeat
	{
	head(i) = BLANK
	i = i + 1
	j = j + 1
	}
   until (j > n)			# padded blanks, at least one
   call stcopy(filsiz, 1, head, i)	# copy size of file
  # insert file type
  head(i) = BLANK
  i = i + 1
  if (type == ASCII)
	call stcopy(asc, 1, head, i)
  else if (type == LOCAL)
	call stcopy(local, 1, head, i)
  else if (type == BINARY)
	call stcopy(bin, 1, head, i)
  head(i) = BLANK
  i = i + 1
  # insert time and date
   call getnow (now)
   call fmtdat (date, time, now, 0)
   call stcopy (date, 1, head, i)
   head(i) = BLANK
   i = i + 1
   call stcopy (time, 1, head, i)

 
  head(i) = NEWLINE
  head(i+1) = EOS
  ifdef(FOLDF, call fold(head) )
 
  return
  end
#-t- makhdr          1285 ascii 08/20/81 13:16:31
#-h- notfnd           371 ascii 08/20/81 13:16:32
 
  #---------------------------------------------------------------
 ## notfnd - print 'not found' message
   subroutine notfnd
 
   integer i
   include carch
 
   for (i = 1; i <= fcount; i = i + 1)
      if (fstat(i) == NO) {
         call putlin(fname(1, i), ERROUT)
         call remark(': not in archive.')
         errcnt = errcnt + 1
         }
   return
   end
#-t- notfnd           371 ascii 08/20/81 13:16:32
#-h- nxtfl            853 ascii 08/20/81 13:16:32
 ## nxtfl - extract next file from damaged archive
 integer function nxtfl(name, afd)
 character name(ARB), holdnm(FILENAMESIZE), buf(MAXLINE), temp(MAXLINE)
 integer create, getlin, equal, getwrd
 integer afd, i, int
 include arhdr
 data holdnm(1) /EOS/
 
 
 if (holdnm(1) == EOS)		#pick up first name
	{
	if (getlin(buf, afd) == EOF)
                return (EOF)
	i = 1
	len = getwrd(buf, i, temp)
	if (equal(temp, hdr) == NO)
		call error ('archive not in proper format.')
	len = getwrd(buf, i, holdnm)
	}
 
 call scopy(holdnm, 1, name, 1)
 holdnm(1) = EOS
 int = create(name, WRITE)	#open file specified
 if (int == ERR)
	call cant(name)
 while (getlin(buf, afd) != EOF)
	{
	i = 1
	len = getwrd(buf, i, temp)
	if (equal(temp, hdr) == YES)
		{
		len = getwrd(buf, i, holdnm)
		break
		}
	call putlin(buf, int)
	}
 
 call close(int)
 return (OK)
 end
#-t- nxtfl            853 ascii 08/20/81 13:16:32
#-h- recovr           825 ascii 08/20/81 13:16:32
## recovr - recover archived file with incorrect byte counts
 subroutine recovr (aname)
 
 integer create, open, nxtfl, amove
 integer afd, tfd
 character aname(ARB), tfile(FILENAMESIZE), name(FILENAMESIZE)
 
 include carch
 string tname 'arctemp'
 
 #				open archive
 afd = open(aname, READ)
 if (afd == ERR)
	call cant(aname)
 #				open archive scratch file
 call mkuniq (tname, tfile)
 tfd = create(tfile, WRITE)
 if (tfd == ERR)
	call cant (tfile)
 #				loop through all files in archive

 while (nxtfl(name, afd) != EOF)
	{
	call addfil (name, tfd, errcnt)
	call remove (name)
	}
 
 call close(afd)
 call close(tfd)
 if (errcnt == 0)
	{
	if(amove (tfile, aname) == ERR)
		call remark ("can't rename archive scratch file.")
	}
 else
	call remark ('fatal errors - archive not altered.')
 call remove (tfile)
 return
 end
#-t- recovr           825 ascii 08/20/81 13:16:32
#-h- replac           732 ascii 08/20/81 13:16:33
 
  #---------------------------------------------------------------
 ## replac - replace or delete files
   subroutine replac(afd, tfd, cmd, errct)
   character in(MAXLINE), uname(NAMESIZE)
   integer filarg, gethdr
   integer afd, cmd, errct, size, tfd, type
   include carch
 
   while (gethdr(afd, in, uname, size, type) != EOF)
      if (filarg(uname) == YES) {
         if (cmd == UPD)    # add new one
            call addfil(uname, tfd, errct)
         if (verbos == YES & cmd == DEL)
		{
		call putlin (uname, STDOUT)
		call putch (NEWLINE, STDOUT)
		}
         call fskip(afd, size)    # discard old one
         }
      else {
         call putlin(in, tfd)
         call acopy(afd, tfd, size)
         }
   return
   end
#-t- replac           732 ascii 08/20/81 13:16:33
#-h- table            505 ascii 08/20/81 13:16:33
  #---------------------------------------------------------------
 ## table - print table of archive contents
   subroutine table(aname)
   character aname(NAMESIZE), in(MAXLINE), lname(NAMESIZE)
   integer filarg, gethdr, open
   integer afd, size
 
   afd = open(aname, READ)
   if (afd == ERR)
      call cant(aname)
   while (gethdr(afd, in, lname, size, type) != EOF) {
      if (filarg(lname) == YES)
         call tprint(in)
      call fskip(afd, size)
      }
   call notfnd
   return
   end
#-t- table            505 ascii 08/20/81 13:16:33
#-h- tprint           484 ascii 08/20/81 13:16:33
  #---------------------------------------------------------------
 ## tprint - print table entry for one member
   subroutine tprint(buf)
   character buf(ARB)
   include carch
 
 
  #skip initial header flag
  for (i=1; buf(i) != BLANK; i=i+1) ;
 
  #print filename
  for (i=i+1; buf(i) != BLANK; i=i+1)
     call putch (buf(i), STDOUT)
 
  # print remainder of info
  if (verbos == YES)
     call putlin (buf(i), STDOUT)
  else
     call putch (NEWLINE, STDOUT)
   return
   end
#-t- tprint           484 ascii 08/20/81 13:16:33
#-h- update          1274 ascii 08/20/81 13:16:34
  #---------------------------------------------------------------
 ## update - update existing files, add new ones at end
   subroutine update(aname)
   character aname(NAMESIZE), tfile(FILENAMESIZE)
   integer create, open, amove
   integer afd, i, tfd
   include carch
   include arhdr
    string tname 'arctemp'
 
   afd = open(aname, READ)
   if (afd == ERR)       # maybe it's a new one
   ###kluge since EOF can't always be sensed on a new file
	{
        afd = create(aname, WRITE)
        if (afd == ERR)
             call cant(aname)
	new = YES
	}
 else
	new = NO
   # STDIN file slot being closed to save space
    call close(STDIN)
    call mkuniq(tname, tfile)		#get scratch file name
    tfd = create(tfile, WRITE)
   if (tfd == ERR)
      call cant(tfile)
   call replac(afd, tfd, UPD, errcnt)       # update existing
   for (i = 1; i <= fcount; i = i + 1)       # add new ones
      if (fstat(i) == NO) {
         call addfil(fname(1, i), tfd, errcnt)
         fstat(i) = YES
         }
   call close(afd)
   call close(tfd)
   if (errcnt == 0)
      {
      if (amove(tfile, aname) == ERR)
		call remark ("can't rename archive scratch file.")
      }
   else
      call remark('fatal errors - archive not altered.')
   call remove(tfile)
   return
   end
#-t- update          1274 ascii 08/20/81 13:16:34
#-t- ar2.r          15864 ascii 08/20/81 13:17:49
