/*	tty.h	2.1	May 25 80	M03	*/

#define	MELB_TTY	1
/*
#define	O_LCASE		1
#define	O_UCASE		1
#define	O_INT		1
*/
#define	O_PAGE		1
/*
 * A clist structure is the head
 * of a linked list queue of characters.
 * The characters are stored in 4-word
 * blocks containing a link and several characters.
 * The routines getc and putc
 * manipulate these structures.
 */
struct clist
{
	int	c_cc;		/* character count */
	char	*c_cf;		/* pointer to first char */
	char	*c_cl;		/* pointer to last char */
};

#ifdef	MELB_TTY
/*
 * structure of arg for ioctl
 */
#define	ttiocb ttiocb1		/* for old timers */
struct	ttiocb1 {
	char	ioc_ispeed;
	char	ioc_ospeed;
	char	ioc_erase;
	char	ioc_kill;
	int	ioc_flags;
};

struct	ttiocb2 {
	char	ioc_intr;
	char	ioc_quit;
	char	ioc_start;
	char	ioc_stop;
	char	ioc_eof;
	char	ioc_break;
};

struct	ttiocb3 {
	char	ioc_redisp;
	char	ioc_escp;
	char	ioc_disc;
	char	ioc_dqueue;
	char	ioc_delq;
	char	ioc_brkin;
};

struct	ttiocb4 {
	char	ioc_nldel;
	char	ioc_crdel;
	char	ioc_tabdel;
	char	ioc_ffdel;
	char	ioc_dchar;
	char	ioc_ddel;
};

struct	ttiocb5 {
	short	ioc_state;
	short	ioc_ttype;
	char	ioc_width;
	char	ioc_depth;
};

struct	ttiocb6 {
	long	ioc_dctl;
	char	ioc_desc;
	char	ioc_delet;
};

#ifdef	O_PAGE
struct	ttiocb7 {
	short	ioc_pgflg;
	char	ioc_pgdel;
	char	ioc_pglen;
	char	ioc_pgon;	/* not supported yet */
	char	ioc_pgoff;	/* not supported yet */
};
#endif
#endif

/*
 * A tty structure is needed for
 * each UNIX character device that
 * is used for normal terminal IO.
 * The routines in tty.c handle the
 * common code associated with
 * these structures.
 * The definition and device dependent
 * code is in each driver. (kl.c dz.c)
 */

#ifndef	MELB_TTY
struct tc {
	char	t_intrc;	/* interrupt */
	char	t_quitc;	/* quit */
	char	t_startc;	/* start output */
	char	t_stopc;	/* stop output */
	char	t_eofc;		/* end-of-file */
	char	t_brkc;		/* input delimiter (like nl) */
};
#endif

struct tty
{
	struct	clist t_rawq;	/* input chars right off device */
	struct	clist t_canq;	/* input chars after erase and kill */
	struct	clist t_outq;	/* output list to device */
	int	(* t_oproc)();	/* routine to start output */
	int	(* t_iproc)();	/* routine to start input */
	struct chan *t_chan;	/* destination channel */
	caddr_t	t_linep;	/* aux line discipline pointer */
	caddr_t	t_addr;		/* device address */
	dev_t	t_dev;		/* device number */
	short	t_flags;	/* mode, settable by ioctl call */
	short	t_state;	/* internal state, not visible externally */
	short	t_pgrp;		/* process group name */
	char	t_delct;	/* number of delimiters in raw q */
	char	t_line;		/* line discipline */
	char	t_col;		/* printing column of device */
	char	t_erase;	/* erase character */
	char	t_kill;		/* kill character */
	char	t_char;		/* character temporary */
	char	t_ispeed;	/* input speed */
	char	t_ospeed;	/* output speed */
	union {
#ifdef	MELB_TTY
		struct ttiocb2 t_chr;
#else
		struct tc t_chr;
#endif
		struct clist t_ctlq;
	} t_un;
#ifdef	MELB_TTY
	struct ttiocb3 t_ch;	/* more special chars */
	struct ttiocb4 t_del;	/* delays */
	struct ttiocb6 t_ctl;	/* echo info for ctl chars */
#ifdef	O_PAGE
	struct ttiocb7 t_pag;	/* page mode control data */
#endif
	char	*t_nlpos;	/* ptr to start of current line */
	short	t_type;		/* terminal type   */
	short	t_xtra;		/* more state info */
	char	t_lcnt;		/* current line # on page */
#ifdef	O_PAGE
	char	t_pgcnt;	/* # lines output to go before auto pause */
#endif
	char	t_width;	/* terminal width (# columns) */
	char	t_depth;	/* terminal depth (# lines) */
#endif
};

#define	tun	tp->t_un.t_chr
#ifdef	MELB_TTY
#define	t_stopc		ioc_stop
#define	t_startc	ioc_start
#define	t_intrc		ioc_intr
#define	t_quitc		ioc_quit
#define	t_eofc		ioc_eof
#define	t_brkc		ioc_break
#define	t_redisp	t_ch.ioc_redisp
#define	t_escp		t_ch.ioc_escp
#define	t_disc		t_ch.ioc_disc
#define	t_dqueue	t_ch.ioc_dqueue
#define	t_delq		t_ch.ioc_delq
#define	t_brkin		t_ch.ioc_brkin
#define	t_nldel		t_del.ioc_nldel
#define	t_crdel		t_del.ioc_crdel
#define	t_tabdel	t_del.ioc_tabdel
#define	t_ffdel		t_del.ioc_ffdel
#define	t_dchar		t_del.ioc_dchar
#define	t_ddel		t_del.ioc_ddel
#define	t_dctl		t_ctl.ioc_dctl
#define	t_desc		t_ctl.ioc_desc
#define	t_delet		t_ctl.ioc_delet
#ifdef	O_PAGE
#define	t_pgflg		t_pag.ioc_pgflg
#define	t_pgdel		t_pag.ioc_pgdel
#define	t_pglen		t_pag.ioc_pglen
#define	t_pgon		t_pag.ioc_pgon
#define	t_pgoff		t_pag.ioc_pgoff
#endif
#endif


#ifndef	MELB_TTY
/*
 * structure of arg for ioctl
 */
struct	ttiocb {
	char	ioc_ispeed;
	char	ioc_ospeed;
	char	ioc_erase;
	char	ioc_kill;
	short	ioc_flags;
};
#endif

#define	TTIPRI	28
#define	TTOPRI	29
#ifdef	MELB_TTY
#define	TTBRKPRI (PZERO-1)
#endif

#ifndef	MELB_TTY
#define	CERASE	'#'		/* default special characters */
#define	CEOT	004
#define	CKILL	'@'
#define	CQUIT	034		/* FS, cntl shift L */
#define	CINTR	0177		/* DEL */
#define	CSTOP	023		/* Stop output: ctl-s */
#define	CSTART	021		/* Start output: ctl-q */
#define	CBRK	0377
#else

#define	ctl(x)	((x)&037)	/* control equiv of a printing char */

#define	CERASE	'#'		/* default special characters */
#define	CEOT	ctl('d')	/* end of file from a tty */
#define	CKILL	'@'		/* delete current input line */
#define	CQUIT	ctl('\\')	/* FS, cntl shift L */
#define	CINTR	0177		/* DEL */
#define	CSTOP	ctl('s')	/* Stop output: ctl-s */
#define	CSTART	ctl('q')	/* Start output: ctl-q */
#define	CESCAPE	033		/* Escape, cntl [, cntl shift k */
#define	CREDISP	ctl('a')	/* redisplay */
#define	CDSPQ	ctl('r')	/* display queue */
#define	CDELQ	ctl('x')	/* CAN, delete queue */
#define	CDISC	ctl('o')	/* discard output */
#define	CBRK	0200		/* no extra line delimiter */
#define	CPAGON	0200		/* no way to turn on page mode from tty */
#define	CPAGOFF	0200		/* nor any way to turn it off */
#endif

/* limits */
#define	TTHIWAT	650
#define	TTLOWAT	125
#define	TTYHOG	256

/* modes */
#define	TANDEM	01
#define	CBREAK	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#ifndef	MELB_TTY
#define	NLDELAY	001400
#define	TBDELAY	006000
#define	XTABS	006000
#define	CRDELAY	030000
#define	VTDELAY	040000
#else
#define	UCASE	0400		/* convert lower case -> upper case */
#define	KNL	01000		/* echo '\n' after a kill */
#define	RO_TYPE	06000		/* RO mode selected: (dflt is echo RO char) */
#define	RO_VDU	02000		/* 	echo ' ', '\b', ' ' */
#define	RO_HARD	04000		/*	echo char deleted (in '#' marks) */
#define	WRAP	010000		/* send '\n' if next char won't fit on line */
#define	PAGE	020000		/* pause output after page is full */
#define	HOLDSTOP 040000		/* don't go after ^S till have ^Q */
#define	DCASE	0100000		/* display the case actually read */


/*
 * Special 'delay' algorithms
 */
#define	XTABS	0200		/* convert tabs to spaces */
#define	XFORM	0200		/* simulate form feed using newline */
#define	TAB_37	0201		/* tab delay calc for tty 37 */
#define	NL_37	0201		/* nl delay calc for tty 37 */
#endif

/* Hardware bits */
#define	DONE	0200
#define	IENABLE	0100

/* Internal state bits */
#define	TIMEOUT	01		/* Delay timeout in progress */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	FLUSH	010		/* outq has been flushed during DMA */
#define	CARR_ON	020		/* Software copy of carrier-present */
#define	BUSY	040		/* Output in progress */
#define	ASLEEP	0100		/* Wakeup when output done */
#define	XCLUDE	0200		/* exclusive-use flag against open */
#define	TTSTOP	0400		/* Output stopped by ctl-s */
#define	HUPCLS	01000		/* Hang up upon last close */
#define	TBLOCK	02000		/* tandem queue blocked */
#define	SPEEDS	04000		/* t_ispeed and t_ospeed used by driver */
#define	PROTO1	010000		/* reserved for line discipline */
#define	EXTPROC	020000		/* external processor (kmc) */
#define	FSLEEP	040000		/* Wakeup on input framing */
#define	CNTLQ	0100000		/* interpret t_un as clist */

#ifdef	MELB_TTY
/* Extra internal state bits (for t_xtra) */
#define	KILL_PEND	01	/* kill pending (have seen '@' but no more) */
#define	ESC_PEND	02	/* last input char was escape */
#define	RO_MODE		04	/* currently doing hard copy rub out seq */
#define	TTY_BRK		010	/* currently sending long space to terminal */
#define	DISCARDING	020	/* all output being discarded */
#ifndef	O_PAGE
#define	PG_WAIT		000
#define	PG_PEND		000
#else
#define	PG_WAIT		040	/* waiting for user 'go' at page end */
#define	PG_PEND		0100	/* there is a page halt in outq */
#define	PG_IN		0200	/* temp ignore page full - ch from input */
#define	PG_CONT		0400	/* ignore current PG_PEND */

/* Page mode flags */
#define	PG_STOP		01	/* stop output at each page end */
#define	PG_PAUSE	02	/* pause for fixed time at page end */
#define	PG_FIXD		04	/* page size fixed - regardless of input */
#define	PG_CLEAR	010	/* clear page just before starting new one */
#define	PG_NLGO		020	/* only ^Q, \n and EOT resume from page hlt */
#endif
#endif

/*
 * tty ioctl commands
 */
#define	TIOCGETD	(('t'<<8)|0)
#define	TIOCSETD	(('t'<<8)|1)
#define	TIOCHPCL	(('t'<<8)|2)
#define	TIOCMODG	(('t'<<8)|3)
#define	TIOCMODS	(('t'<<8)|4)
#define	TIOCGETP	(('t'<<8)|8)
#define	TIOCSETP	(('t'<<8)|9)
#define	TIOCSETN	(('t'<<8)|10)
#define	TIOCEXCL	(('t'<<8)|13)
#define	TIOCNXCL	(('t'<<8)|14)
#define	TIOCFLUSH	(('t'<<8)|16)
#define	TIOCSETC	(('t'<<8)|17)
#define	TIOCGETC	(('t'<<8)|18)
#define	TIOCSBRK	(('t'<<8)|19)
#ifdef	MELB_TTY
#define	TIOCGDEL	(('t'<<8)|20)		/* get delay values */
#define	TIOCSDEL	(('t'<<8)|21)		/* set delay values */
#define	TIOCGETS	(('t'<<8)|22)		/* get tty type etc */
#define	TIOCSETS	(('t'<<8)|23)		/* set tty type etc */
#define	TIOCXBRK	(('t'<<8)|24)		/* xmit 250 ms space */
#define	TIOCRSTO	(('t'<<8)|25)		/* don't discard output */
#define	TIOCGCTL	(('t'<<8)|26)		/* get ctl char echo info */
#define	TIOCSCTL	(('t'<<8)|27)		/* set ctl char echo info */
#define	TIOCSCHR	(('t'<<8)|28)		/* set some more chars */
#define	TIOCGCHR	(('t'<<8)|29)		/* get cur state of above */
#define	TIOCMPTY	(('t'<<8)|30)		/* find out if input q empty */
#define	TIOCDELAY	(('t'<<8)|31)		/* delay output for arg ms */
#define	TIOCGPAG	(('t'<<8)|32)		/* get page mode ctl info */
#define	TIOCSPAG	(('t'<<8)|33)		/* set page mode ctl info */
#endif
#define	DIOCLSTN	(('d'<<8)|1)
#define	DIOCNTRL	(('d'<<8)|2)
#define	DIOCMPX		(('d'<<8)|3)
#define	DIOCNMPX	(('d'<<8)|4)
#define	DIOCSCALL	(('d'<<8)|5)
#define	DIOCRCALL	(('d'<<8)|6)
#define	DIOCPGRP	(('d'<<8)|7)
#define	DIOCGETP	(('d'<<8)|8)
#define	DIOCSETP	(('d'<<8)|9)
#define	DIOCLOSE	(('d'<<8)|10)
#define	DIOCTIME	(('d'<<8)|11)
#define	DIOCRESET	(('d'<<8)|12)
#define	DIOCSMETA	(('d'<<8)|13)
#define	DIOCMERGE	(('d'<<8)|14)
#define	DIOCICHAN	(('d'<<8)|15)
#define	DIOCPAD		(('d'<<8)|16)
#define	DIOCRMETA	(('d'<<8)|17)
#define	DIOCXOUT	(('d'<<8)|18)
#define	DIOCBMETA	(('d'<<8)|19)
#define	DIOCAMETA	(('d'<<8)|20)
#define	DIOCSBMETA	(('d'<<8)|21)
#define	FIOCLEX		(('f'<<8)|1)
#define	FIONCLEX	(('f'<<8)|2)
#define	MXLSTN		(('x'<<8)|1)
#define	MXNBLK		(('x'<<8)|2)

#ifdef	MELB_TTY
/*
 * Terminal type codes
 *
 *	CAUTION:
 *		the numbers here are meaningless,
 *		eventually a rational numbering scheme will be chosen
 */
#define	UNKNOWN		0
#define	VC404		1
#define	TRY1061		2
#define	VT52		3
#define	INT8001		4
#define	LA36		6
#define	LS120		7
#define	LA180		8
#define	CAR300		9
#define	DIAB1620	10
#define	TTY43		11
#define	ASR33		12
#define	TTY37		13
#define	ADM3A		14
#define	TEK4010		15
#define	TEK4012		16
#define	TEK4014		17
#define	TEK4015		18
#define	CDC713		19
#define	VT100		20
#define	TI700		21
#define	VT05		22
#define	VIS200		23
#define	HZL1500		24
#define	ADS520		25
#endif
