/*
 * NAME: wpatch [file]
 *
 * SYNOPSIS: wpatch
 *
 * DESCRIPTION: Edit wtmp file
 * AUTHOR - Kenj McDonell 
 */

#define	MAXTTY	100	/* Max num of tty's that will be cleaned up by 'u' */

#include <nstdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <utmp.h>
#include <setjmp.h>

struct utmp wtmp;
struct stat statbuf;
jmp_buf errj;

struct {
	char tt_name[8];
	char tt_flag;
} ttys[MAXTTY+1];


int flag;

int debug;

int lastrn;

main(argc, argv)
char **argv; {
	register cmd;
	register char *q;
	int i, len;
	FILE *f;
	int rn, last;
	char *file;
	int intrp();

	file = "/usr/adm/wtmp";
	if (argc > 1)
		file = argv[1];
	f = fopen(file, "r+");
	if (f == NULL) {
		printf("Can't open %s\n", file);
		exit(1);
	}

	fstat(fileno(f), &statbuf);
	lastrn = statbuf.st_size / sizeof(wtmp) - 1;
	rn = 0;

	setjmp(errj);
	get(f, rn);
	if (signal(SIGINT, SIG_IGN) == SIG_DFL)
		signal(SIGINT, intrp);

	for (;;) {
		if (flag != 2)
			printf("* ");
		cmd = nextc();
		if (flag && cmd == '\n') {
			cmd = '%';
			flag = 1;
		}
		else if (cmd == '\n') {
			flag = 1;
		}
		else
			flag = 0;
		switch (cmd) {
		case EOF:
		case 'q':
			exit(0);
		case 'h':
			printf("cmds: e<rn> +<delta> -<delta> p[<last>]\n");
			printf("      cu<user> cy<tty> ct[-]<delta>[y|l|d|h|m]\n");
			printf("      su<user>[<last>] sy<tty>[<last>]\n");
			printf("      st<delta>[y|l|d|h|m]\n");
			printf("      d[<last>] u<file> q\n");
			break;
		case '+':
			i = intval();
			rn = (i ? rn+i : rn+1);
			goto input;
		case '-':
			i = intval();
			rn = (i ? rn-i : rn-1);
			goto input;
		case '%':
			rn++;
			goto input;
		case 'e':
			rn = intval();
		input:
			if (get(f, rn))
				print(rn);
			break;
		case 'p':
			print(rn);
			last = intval();
			if (last == 0)
				break;
			for (rn++; rn <= last && get(f, rn); rn++) {
				print(rn);
			}
			break;
		case 's':
			rn = search(f, rn);
			break;
		case 'd':
			delete();
			put(f, rn);
			last = intval();
			if (last == 0)
				break;
			for (rn++; rn <= last && get(f, rn); rn++) {
				delete();
				put(f, rn);
			}
			get(f, rn);
			break;
		case 'u':
			update(f);
			break;
		case 'c':
			change();
			put(f, rn);
			break;
		case '\n':
			flag = 2;
			break;
		default:
		err:
			printf("cmd?\n");
			lflush();
		}
	}
}

print(rn)
int rn;
{
	int i;
	register char *p;
	printf("record no. %d  ", rn);
	if (wtmp.ut_line[0] == 0) {
		printf("<deleted>\n");
		return;
	}
	printf("user %8.8s on %8.8s", wtmp.ut_name, wtmp.ut_line);
	printf(" time %s", ctime(&wtmp.ut_time));
}

change()
{
	register char type, *p;
	register int i;
	static int lastdelta;
	type = nextc();
	switch (type) {
	case 'u':
		p = wtmp.ut_name;
		*p = nextc();
		while (p <= &wtmp.ut_name[7]) {
			if (p>wtmp.ut_name)
				*p = getchar();
			if (*p == '\n') {
				*p = 0;
				p++;
				flag = 1;
				break;
			}
			p++;
		}
		while (p <= &wtmp.ut_name[7])
			*p++ = 0;
		break;
	case 'y':
		p = wtmp.ut_line;
		*p = nextc();
		while (p <= &wtmp.ut_line[7]) {
			if (p>wtmp.ut_line)
				*p = getchar();
			if (*p == '\n') {
				*p = 0;
				p++;
				flag = 1;
				break;
			}
			p++;
		}
		while (p <= &wtmp.ut_line[7])
			*p++ = 0;
		break;
	case 't':
		i = intval();
		if (i)
			lastdelta = i;
		wtmp.ut_time += lastdelta;
		break;
	case '\n':
		flag = 1;
	default:
		printf("field?\n");
	if (flag == 0)
		lflush();
		return;
	}
}

intval()
{
	register char *q;
	register int i;
	char buf[16];

	q = buf;
	*q = nextc();
	if (*q == '$') {
		i = lastrn;
		goto done;
	}
	i = 1;
	if (*q == '-') {
		i = -1;
		*q = getchar();
	} else if (*q == '+')
		*q = getchar();
	while ('0' <= *q && *q <= '9')
		*(++q) = getchar();
	i *= atol(buf);
	if (*q == ' ')
		*q = nextc();
	switch (*q) {
	case 'y':
		i *= 31536000;
		break;
	case 'l':
		i *= 2592000;
		break;
	case 'd':
		i *= 86400;
		break;
	case 'h':
		i *= 3600;
		break;
	case 'm':
		i *= 60;
		break;
	case '\n':
		flag = 1;
	case 's':
		break;
	default:
		printf("scale unit must be 'y', 'l', 'd', 'h', 'm' or 's'!\n");
		lflush();
	}

done:
	return(i);
}

lflush()
{
	register char c;
	while ((c = getchar()) != '\n') ;
	flag = 1;
}

get(f, rn)
FILE *f;
int rn;
{
	if (rn < 0) {
		printf("read record no. %d? -- you've got to be joking!\n", rn);
		goto fail;
	}
	fseek(f, (long)rn*sizeof wtmp, 0);
	if (fread(&wtmp, sizeof wtmp, 1, f) == 1)
		return(1);
	else if (feof(f))
		printf("end-of-file!\n");
	else if (ferror(f))  {
		printf("read error!\n");
/**				not in libNS
		clrerr(f);
**/
	} else
		printf("Impossible read error!\n");
fail:
	delete();
	return(0);
}

put(f, rn)
FILE *f;
int rn;
{
	if (rn < 0) {
		printf("write record no. %d? -- you've got to be joking!\n", rn);
		return(0);
	}
	fseek(f, (long)rn*sizeof wtmp, 0);
	if (fwrite(&wtmp, sizeof wtmp, 1, f) == 1)
		return(1);
	printf("write error!\n");
	return(0);
}

delete()
{
	wtmp.ut_line[0] = 0;
}

update(f)
FILE *f;
{
	char new[128];
	register char *newp;
	char c;
	FILE *newf;
	register int rnin, rnout;
	register ttyn;

	newp = new;
	*newp = nextc();
	while (*newp != '\n' && *newp != 0)
		*(++newp) = getchar();
	*newp = 0;
	flag = 1;
	if (access(new, 0) >= 0) {
		printf("%s exists .. enter 'y' to confirm\n", new);
		c = nextc();
		if (c != '\n')
			lflush();
		if (c != 'y')
			return;
	}
	newf = fopen(new, "w");
	if (newf == NULL) {
		printf("Can't create %s\n", new);
		return;
	}
	for (ttyn=0; ttyn<MAXTTY; ttys[ttyn++].tt_flag=0)
		;
	rnin = 0;
	rnout = 0;
	while (get(f, rnin++)) {
		if (wtmp.ut_line[0] == '\0')
			continue;
		for (ttyn = 0; ttyn < MAXTTY; ttyn++) {
			if (strncmp(ttys[ttyn].tt_name, wtmp.ut_line, 8) == 0)
				break;
			if (ttys[ttyn].tt_name[0])
				continue;
			strncpy(ttys[ttyn].tt_name, wtmp.ut_line, 8);
			ttys[ttyn].tt_flag = 0;
			break;
		}
		if (ttyn < MAXTTY && ttys[ttyn].tt_flag && useless()) continue;
		else {
			ttys[ttyn].tt_flag = useless();
			put(newf, rnout++);
		}
	}
	printf("%d records copied\n", rnout);
	printf("%d records deleted\n", rnin-rnout);
}

useless()
{
	register char *p;
	register i;

	if (wtmp.ut_line[0] >= '|')
		return(0);
	if (wtmp.ut_line[0] == 0)
		return(1);
	p = wtmp.ut_name;
	if (*p == 0)
		return(1);
	for (i=0; i<8; i++) 
		if (*p != 0 && *p++ < ' ') return(1);
	return(0);
}

nextc()
{
	register char c;
	while ((c = getchar()) == ' ') ;
	return(c);
}

search(f, rn)
int f, rn;
{
	char tty[8],uname[8];
	register char *p, *q;
	int last, savern;
	int targtime;
	char type;
	type = nextc();
	switch (type) {
	case 'u':
		for (p=uname;p<&uname[8];*p++=0);
		p = uname;
		*p = nextc();
		while (p <= &uname[7]) {
			if (p>uname)
				*p = getchar();
			if (*p == ' ') {
				*p = 0;
				break;
			}
			if (*p == '\n') {
				flag = 1;
				*p = 0;
				break;
			}
			p++;
		}
		break;
	case 'y':
		for (p=tty;p<&tty[8];*p++=0);
		p = tty;
		*p = nextc();
		while (p <= &tty[7]) {
			if (p>tty)
				*p = getchar();
			if (*p == ' ') {
				*p = 0;
				break;
			}
			if (*p == '\n') {
				flag = 1;
				*p = 0;
				break;
			}
			p++;
		}
		break;
	case 't':
		targtime = wtmp.ut_time + intval();
		break;
	case '\n':
	woops:
		flag = 1;
	default:
		printf("field?\n");
		if (flag == 0)
			lflush();
		return(rn);
	}
	savern = rn;
	rn++;
	if (!flag)
		last = intval();
	else
		last = 0;
	while (get(f, rn) && (last == 0 || rn <= last)) {
		switch (type) {
		case 'y':
			p = wtmp.ut_line;
			for (q=tty; q<&tty[8]; p++,q++) {
				if (*p != *q)
					goto fail;
			}
			goto found;
			break;
		case 'u':
			p = wtmp.ut_name;
			for (q=uname; q<&uname[8]; p++,q++) {
				if (*p != *q)
					goto fail;
			}
			goto found;
		case 't':
			if (wtmp.ut_time >= targtime)
				goto found;
		}
fail:
	rn++;
	}
	printf("no match\n");
	rn = savern;
	get(f, rn);
	return(rn);
found:
	print(rn);
	return(rn);
}

intrp()
{
	printf("?\n");
	longjmp(errj, 1);
}
