/*
 * Melb Uni Comp Sci
 *
 *	LPD
 *
 *	Trapped signals come here, we slaughter a few of the bigger ones
 *	and release the rest to be caught again another day.
 *
 *	Both parent and child have been known to enter here at times,
 *	usually the child follows soon after the parent
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <signal.h>
#include <setjmp.h>
#include "local.h"
#include "spool.h"
#include "globals.h"

newjob()
{
	signal(NEW, SIG_IGN);
	if (child)
		return;
	if (!waiting) {
		morejobs++;
		return;
	}
	longjmp(env, 1);
}

newpr()
{
	signal(MERGE, SIG_IGN);
	signal(NEW, SIG_IGN);
	if (child)
		return;
	longjmp(redo, 1);
}

catch()
{
	register i;
	PR pr;
	register fd;
	struct lpdcmd cmd;
	char	junk;

	signal(CSIG, SIG_IGN);
	if (child) {
		killsig++;
		return;
	}

	if ((fd = open(killf, 0)) >= 0 && read(fd, &cmd, sizeof cmd) == sizeof cmd
					&& read(fd, &junk, 1) == 0) {
		close(fd);
		for (printers) {
			if ((i = pr->ppid)
			&&	( pr->pjob == cmd.cjob
				||	(cmd.xfn == LPD_KICK
					 && strncmp(pr->prnm, cmd.xname, DIRSIZ) == 0
					)
				)
			) {
				if (kill(i, CSIG) < 0)
					pr = lastpr;
				break;
			}
		}
		if (pr >= lastpr)
			unlink(killf);
		if (cmd.xjob) 
			kill(cmd.xjob, pr >= lastpr ? FAIL : SUCCEED);
	} else
		unlink(killf);
	signal(CSIG, catch);
	return;
}

int	contin;		/* set != 0 when 'contin' opctl cmd arrives */

childcatch()
{
	struct lpdcmd cmd;
	char junk;
	register fd;
	register i;
	int	clock();

	signal(CSIG, SIG_IGN);
	if (!spooling) {
		killsig++;
		return;
	}
	spooling = 0;
	killsig = 0;

	if ((fd = open(killf, 0)) >= 0 && read(fd, &cmd, sizeof cmd) == sizeof(cmd)
					&& read(fd, &junk, 1) == 0) {
		close(fd);
		unlink(killf);
		if (mypr->pjob == cmd.cjob) {
			switch(cmd.xfn) {
			case LPD_ABT:
			abort:
				throwout(fileno(op));
				msg("aborted");
				acct(mypr, A_ABT);
				aborted++;
				close(xinp);
				signal(CSIG, childcatch);
				longjmp(abt_env, 1);

			case LPD_REP:
				throwout(fileno(op));
				msg("restarted");
				acct(mypr, A_REP);
				signal(CSIG, childcatch);
				longjmp(spool_env, 1);

			case LPD_REQ:
				throwout(fileno(op));
				msg("returned to queue");
				acct(mypr, A_REQ);
				putc('\f', op);
				windup();
				exit(1);

			case LPD_PAUS:
				signal(SIGALRM, clock);
				contin = 0;
				signal(CSIG, childcatch);
				alarm(MAXPAUSE);
				if (!contin)
					pause();
				signal(SIGALRM, SIG_IGN);
				alarm(0);
				if (!contin)
					goto abort;
				spooling++;
				break;

			case LPD_KILL:
				throwout(fileno(op));
				msg("deleted");
				acct(mypr, A_KILL);
/***
 ***	for some undetermined (as of yet) reason, this doesn't work,
 ***	so it has been move to 'opctl' (who sent the signal in the first place)
 ***
				rewind(dfd2);
				while (fread(&test, sizeof(test), 1, dfd2) == 1)
					if (samejob(&test)) {
						STRCPM(nbuf, test.d_name);
						unlink(nbuf);
					}
 ***/
				putc('\f', op);
				windup();
				exit(1);

			case LPD_KICK:
				throwout(fileno(op));
							/** FALL THROUGH **/

			case LPD_CONT:
				contin++;
				spooling++;
				break;

			case LPD_STOP:
				stopped++;
				spooling++;
				break;

			default:
				spooling++;
				break;
			}
		}
	}
	signal(CSIG, childcatch);
}

clock()
{
	/* alarm timeout from opctl 'pause' - just returning
	   will terminate the pause & convert it to an 'abort'
	*/
}
