#include	"../mac/mac.h"
#include	"../mac/m.out.h"


/*
 *   MACDR:
 *
 *   Decode a pre-formatted MAC r-file, and symbolically
 *   print it.  This program is useful for debugging the
 *   MACTAB table formatter, and for inspecting a forgotten
 *   r-file.
 *
 */



extern char *malloc();
char	fmtdesc[ ]	=	"\tdesc %8x  value %8x  width %d\n";
char	buf[256];
struct oc *opcode;
int	fd;
struct	ht	h;

char	*symt[ ] =	{
	"NUL",
	"LBL",
	"CON",
	"SPA",
	"DEL",
	"EOL",
	"EOF",
	"COM",
	"OPR",
	"STR",
	"MCH",
	"LPL",
	 0, 0, 0, 0, 0, 0, 0, 0,
	"EXP",
	"SKP",
	"LIT",
	"CHR"
	};

char	*actt[ ] =	{
	"NOOP",
	"ALBL",
	"DOPV",
	"OLBL",
	"OOPR",
	"ODEL",
	"OCON",
	"OCHR",
	"OSTR",
	"ENDP",
	"SELC",
	"EXPR",
	"RETN",
	"GOTO",
	"OERR",
	"OREC",
	"LITP",
	"CLBL"
	};


main(argc, argv)
char *argv[ ];
{
	register struct st *s;
	register char *p;
	register int len;
	register int i;
	register int j;
	struct oc *op;
	struct os *os;

	if (argc != 2)  {
		printf("Usage: %s r-file-name\n", argv[0]);
		exit(1);
		}

	if ((fd = open(argv[1], 0)) < 0)  {
		printf("Can't open %s\n", argv[1]);
		exit(1);
		}

	p = buf;
	if(read(fd, &h, HT) != HT || h.h_mword != MWORDR) {
		printf("%s not an r-file\n", argv[1]);
		exit(1);
	}
	printf("m.out magic word is 0x%08x (0%011o)\n",
		h.h_macmword, h.h_macmword);
	printf("byte width is %d bits\n", h.h_bu_len);
	printf("word width is %d bytes\n", h.h_w_len);
	printf("basic instruction width is %d bytes\n", h.h_i_len);
	printf("instructions are ");
	if (!h.h_i_flg) printf("not ");
	printf("constrained by address boundaries\n");
	printf("machine %s\n", h.h_mac);
	printf("parser starts at %d\n", h.h_p_start);
	printf("page length %d lines\n", h.h_page);
	printf("pc is ");
	(h.h_pc_post ? printf("post") : printf("pre"));
	printf("-incremented\n\n");
	for (i=0; i<5; i++)
		if (h.dctype[i].f_len)  {
			printf("dc%c  ", h.dctype[i].f_class);
			printf("%2d bytes\n", h.dctype[i].f_len);
			for (j=0; h.dctype[i].f_desc[j]; j++)
				printf(fmtdesc, h.dctype[i].f_desc[j],
						h.dctype[i].f_value[j],
						h.dctype[i].f_width[j]);
			}
	putchar('\n');

	if (h.h_literals)
		printf("%d literals\n", h.h_literals);
	else
		printf("no literals\n");

	while (h.h_literals--)  {
		read(fd, buf, 8);
		printf("%8s  ", buf);
		}
	printf("\n\n");

	printf("format descriptors\n");
	for (i=0; h.h_formats--; i++)  {
		read (fd, buf, FD);
		printf("%3d: ", i);
		printf("class %2d  ", ((struct fd *)p)->f_class);
		printf("length %2d\n", ((struct fd *)p)->f_len);
		for (j=0; ((struct fd *)p)->f_desc[j]; j++)
			printf(fmtdesc, ((struct fd *)p)->f_desc[j],
					((struct fd *)p)->f_value[j],
					((struct fd *)p)->f_width[j]);
		}
	printf("\n\n");

	printf("opcode table\n");
	if((opcode = (struct oc *)malloc(h.h_o_len)) == NULL) {
		printf("no room for opcode table\n");
		exit(1);
	}

	read(fd, opcode, h.h_o_len);
	relopcodes(opcode);
	for(op = opcode; op < &opcode[h.h_ops]; op++) {
		printf("%-8s  ", op->oc_name);
		for(os = op->oc_list; os != NUL; os = os->os_next) {
			printf("(%2d %2d 0x%02x)",	os->os_sel, os->os_fmt,
				os->os_opc);
		}
		printf("\n");
	}
	printf("\n\n");

	printf("parser table\n\n");
	printf("Loc  Sym  Mem       Next    Act   Args\n");
	for (i=0; h.h_p_len--; i++)  {
		read(fd, buf, TBL);
		printf("%3d: ", i);
		printf("%3s  ", symt[abs(((struct tbl *)p)->tb_sym)]);
		printf("%8x  ", ((struct tbl *)p)->tb_mem);
		printf("(%4d)  ", ((struct tbl *)p)->tb_next);
		printf("%4s  ", actt[((struct tbl *)p)->tb_act]);
		for (j=0; j<4; j++)
			printf("%2x ", ((struct tbl *)p)->tb_arg[j]);
		putchar('\n');
		}
	printf("\n\n");

	if (h.h_labels) {
		printf("%d labels\n", h.h_labels);
		printf("Name     val(dec)     val(hex)  class(hex)\n");
	} else
		printf("no pre-defined labels\n");

	while (h.h_labels--)  {
		read(fd, buf, ST);
		printf("%-8s ", ((struct st *)p)->s_u.s_name);
		printf("%11d  %8x %8x\n", ((struct st *)p)->s_value,
					  ((struct st *)p)->s_value,
					  ((struct st *)p)->s_class);
		}

	return;
}


abs(k)
register int k;
{
	if (k < 0)
		return(-k);
	return(k);
}

relopcodes(op)
struct oc *op;
{
	register char *p;
	register struct os *q, *r;
	register int offset, i;

	offset = (char *)op - (char *)h.h_opstart;

	for(i = 0; i < h.h_ops; i++) {
		if(op->oc_list == NULL)
			break;
		p = ((char *)(op->oc_list)) + offset;
		q = op->oc_list = (struct os *)p;
		while(q != NULL) {
			r = q->os_next;
			if(r == NULL)
				break;

			p = ((char *) r) + offset;
			q->os_next = (struct os *)p;
			q = q->os_next;
		}
		op++;
	}
}
