#include "../mac/mac.h"
#include "mactab.h"
#include "mactab.x"
#include <ctype.h>

extern fflag, hflag, lflag, nflag, xflag;
extern char *list_header;
extern char *clasnam();

static int cmp99();
static int cmpxr();
static char line[512];
static int accept;
static int args;
static int xref, nfmt;

struct fmt {
	char	*fm_header,
		*fm_xhead,
		*fm_exp,
		*fm_lit,
		*fm_lbl,
		*fm_opr,
		*fm_con,
		*fm_eol,
		*fm_del,
		*fm_str,
		*fm_chr,
		*fm_trailer,
		*fm_spc1,
		*fm_spc2,
		*fm_spc3,
		*fm_bp,
		*fm_class;
};

struct fmt nml = {
	"\t\t%s Opcode Formats\n\n",
	"\t\t%s Opcode Crossreference\n\n",
	"<expr> ",
	"%s ",
	"<label> ",
	"%c ",
	"0x%x ",
	"",
	"%c ",
	"\"<string>\" ",
	"%c ",
	"",
	"\n",
	"\n\n",
	"\n\n\n",
	"\n\n\n",
	"<class:%.8s>"
};

struct fmt nrf = {
	".ce\n%s Opcode Formats\n.sp 2\n.nf\n",
	".ce\n%s Opcode Crossreference\n.sp 2\n.nf\n",
	"<expr> ",
	"\\fB%s\\fR ",
	"<label> ",
	"\\fB%c\\fR ",
	"\\fB0x%x\\fR ",
	"",
	"\\fB%c\\fR ",
	"\\fB\"\\fR<string>\\fB\"\\fR ",
	"\\fB%c\\fR ",
	".fi\n",
	".sp 1\n",
	".sp 2\n",
	".sp 3\n",
	".bp\n",
	"<class:%.8s>"
};
static struct fmt *fmt;
char *nrhead = "";

#ifdef		PDP11

int	bitmask[ ] =	{

	0x0000,	0x0001,	0x0003,	0x0007,	0x000f,
		0x001f,	0x003f,	0x007f,	0x00ff,
		0x01ff,	0x03ff,	0x07ff,	0x0fff,
		0x1fff,	0x3fff,	0x7fff,	0xffff

	};

#endif


#ifdef		INTERDATA

int	bitmask[ ] =	{

	0x00000000,  0x00000001,  0x00000003,  0x00000007,  0x0000000f,
		     0x0000001f,  0x0000003f,  0x0000007f,  0x000000ff,
		     0x000001ff,  0x000003ff,  0x000007ff,  0x00000fff,
		     0x00001fff,  0x00003fff,  0x00007fff,  0x0000ffff,
		     0x0001ffff,  0x0003ffff,  0x0007ffff,  0x000fffff,
		     0x001fffff,  0x003fffff,  0x007fffff,  0x00ffffff,
		     0x01ffffff,  0x03ffffff,  0x07ffffff,  0x0fffffff,
		     0x1fffffff,  0x3fffffff,  0x7fffffff,  0xffffffff

	};

#endif

propcodes() {
	register char *op = (char *)opcode;
	register int thisclass, lastclass, n, x;
	register struct ocdump *p, *startcl;
	register struct ocdump *model;

	if(lflag == 0)
		return;

	xref = 0;

	opclasses();

	if(hflag == 0 && head.h_mac[0] != 0) {
		list_header = head.h_mac;
	}

	fmt = nflag ? &nrf : &nml;
	if(nflag) {
		printf(nrhead);
	}

	printf(fmt->fm_header, list_header);

	for(args = 0; args <= ('m' - 'a'); args++) {
		p = dmplst;
		n = 0;
		x = 0;
		thisclass = lastclass = p->ocd_classes;

		while(n < nops) {
			startcl = p;
			model = NUL;
			while(thisclass == lastclass && n < nops) {
				accept = 0;
				scantree(tree, p, args, 0);
				if(accept) {
					printf("%-8.8s  ", (p->ocd_opc)->oc_name);
					if((x+1) % 6 == 0)
						printf("\n");
					x++;
					model = p;
				}
				p++;
				n++;
				lastclass = thisclass;
				if(n < nops)
					thisclass = p->ocd_classes;
			}
			if(model != NUL) {
				if(x % 6 != 0)
					printf("\n");
				printf(fmt->fm_spc2);

				dumptree(tree, line, startcl, p, model, 0, 0);
				printf(fmt->fm_spc2);
			}
			lastclass = thisclass;
			x = 0;
		}
	}
	if(xflag) {
		xref = 1;
		printf(fmt->fm_bp);
		printf(fmt->fm_xhead, list_header);
		doxref();
	}
	printf(fmt->fm_spc2);
	printf(fmt->fm_trailer);

}

dumptree(p, cp, startcl, endcl, modelcl, cont_str, picargs)
register struct node *p;
char *cp;
register struct ocdump *startcl, *endcl;
register struct ocdump *modelcl;
{
	register int class;
	register char *pp;
	register int form;

	if( p->n_alt != NUL )
		dumptree(p->n_alt, cp, startcl, endcl, modelcl, cont_str, picargs);

	switch(p->n_sym) {

	case EXP:
/***		printf("expr\n"); ***/
		cp = lformat(cp, fmt->fm_exp);
		picargs++;
		break;

	case LIT:
/***		printf("literal\n"); ***/
		cp = lformat(cp, fmt->fm_lit, getlit(p->n_mem));
		break;

	case LBL:
/***		printf("label\n"); ***/
		if((pp = clasnam(p->n_mem)) != NULL) {
			cp = lformat(cp, fmt->fm_class, pp);
		} else {
			cp = lformat(cp, fmt->fm_lbl);
		}
		picargs++;
		break;

	case OPR:
/***		printf("operator\n"); ***/
		cp = lformat(cp, fmt->fm_opr, oprtab[p->n_mem]);
		break;

	case CON:
/***		printf("constant\n"); ***/
		cp = lformat(cp, fmt->fm_con, p->n_mem);
		picargs++;
		break;

	case EOL:
/***		printf("eol\n"); ***/
		*cp++ = '\n';
		*cp = '\0';

		if(xref) {
			if(!cont_str)
				printf("%2d:\t<opcode>\t%s", ++nfmt, line);
			break;
		}

		class = (p->n_mem4[0] & SELOPC) ? p->n_mem4[2] : 0;

		form = (p->n_mem4[0] & SELFMT) ?
			p->n_mem4[3] :
			scanop(modelcl->ocd_opc, class)->os_fmt;

		if((modelcl->ocd_classes & (1 << class)) && args == picargs
			&& !cont_str) {
			printf("\t<opcode>\t%s", line);
			if(fflag) {
				printf(fmt->fm_spc1);
				prfmts(startcl, endcl, class, p);
				printf(fmt->fm_spc1);
			}
		}
		break;

	case DEL:
/***		printf("del\n"); ***/
		cp = lformat(cp, fmt->fm_del, p->n_mem);
		break;

	case STR:
/***		printf("string\n");***/
		cp = lformat(cp, fmt->fm_str);
		cont_str = 1;
		picargs++;
		break;

	case CHR:
/***		printf("chr\n"); ***/
		cp = lformat(cp, fmt->fm_chr, p->n_mem);
		break;

	default:
/***		printf("null action\n"); ***/
		break;
	}

	if( p->n_next != NUL )
		dumptree(p->n_next, cp, startcl, endcl, modelcl, cont_str, picargs);

}

char *
lformat(cp, format, a, b, c, d, e, f, g, h)
register char *cp, *format;
{
	sprintf(cp, format, a, b, c, d, e, f, g, h);

	while(*cp)
		cp++;

	return(cp);
}

char *
getlit(n)
{
	static char nosuch[] = "NONEXISTANT LITERAL ";
	static char lit[20];
	register char *s1, *s2;

	if(n >= nlit)
		return(nosuch);

	for(s1 = lit, s2 = literals[n]; *s2 && s2 < &literals[n][8];
		*s1++ = *s2++);
	*s1 = '\0';

	return(lit);
}

opclasses() {
	struct oc *op = opcode;
	register int i, classes;
	register struct os *q;
	struct ocdump *p;

	if((p = dmplst = (struct ocdump *)malloc(nops * sizeof(struct ocdump))) == NULL) {
		printf("No core for opcode dump\n");
		exit(1);
	}


	for(i = 0; i < nops; i++) {
		classes = 0;
		for(q = opcode[i].oc_list; q != NUL; q = q->os_next) {
			if(q->os_sel < WORDSIZ)
				classes |= (1 << q->os_sel);
		}
		p->ocd_classes = classes;
		p->ocd_opc = op;
		p++;
		op++;
	}

	qsort(dmplst, nops, sizeof (struct ocdump), cmp99);
}

static int cmp99(r, s)
register struct ocdump *r, *s;
{
	if(nbits(r->ocd_classes) > nbits(s->ocd_classes))
		return(1);

	if(nbits(r->ocd_classes) < nbits(s->ocd_classes))
		return(-1);

	if(r->ocd_classes > s->ocd_classes)
		return(1);

	if(r->ocd_classes < s->ocd_classes)
		return(-1);

	return(cmp(r->ocd_opc, s->ocd_opc));
}

static int cmpxr(r, s)
register struct ocdump *r, *s;
{
	return(cmp(r->ocd_opc, s->ocd_opc));
}

nbits(i)
register int i;
{
	register j, k;

	k = 0;
	for(j = WORDSIZ; j > 0; j--) {
		if(i == 0)
			break;
		if(i & 1)
			k++;
		i >>= 1;
	}
}

prfmts(startcl, endcl, class, node)
register struct node *node;
register struct ocdump *startcl, *endcl;
{
	register int val, fmt;

	while (startcl < endcl) {

		fmt = (node->n_mem4[0] & SELFMT) ?
			node->n_mem4[3] :
			scanop(startcl->ocd_opc, class)->os_fmt;

		val = (node->n_mem4[0] & SELVAL) ?
			node->n_mem4[1] : 0;

		if(args == nargs(fmt)) {
			printf("\t%-8.8s\t", (startcl->ocd_opc)->oc_name);
			prform(fmt, val, scanop(startcl->ocd_opc, class)->os_opc);
			putchar('\n');
		}

		startcl++;
	}
}
prform(form, val, op)
{
	register struct fd *fmt;
	register int pr;
	register int rf;
	register int n;
	register int mask;
	register int i;
	register int ilen;


	/*
	 *   Format descriptor loop.
	 *
	 */

	ilen = 0;
	fmt = &format[form];

	for (i=0; fmt->f_desc[i] != 0; i++)  {

		ilen += fmt->f_width[i];
		pr = fmt->f_desc[i] & (RMODE | PMODE);
		n  = fmt->f_desc[i] & 0xff;

						/* opcode field */
		if (n == 'o')  {
			rf = fmt->f_width[i];
			nprintb(op & BITMASK(rf), rf);
			continue;
			}

							/* pc field */
		if (n == '!')  {
			nprintc('!', fmt->f_width[i]);
			continue;
			}

							/* arg field */
		if (n >= 'a' && n <= 'm')  {
			rf = fmt->f_width[i];
			if (pr & PMODE)  {
				/* pc relative */
				n = toupper(n);
				}

			if (pr & RMODE)  {
				/* byte relocation */
				nprintc('_', fmt->f_value[i]);
				nprintc('\b', fmt->f_value[i]);
				}

			nprintc(n, rf);
			continue;
			}

							/* constant field */
		if (n == '#')  {
			nprintb(fmt->f_value[i], fmt->f_width[i]);
			continue;
			}

							/* value field */
		if (n == 'v')  {
			rf = fmt->f_width[i];
			mask = BITMASK(rf);
			nprintb(val & mask, rf);
			val >>= rf;
			continue;
			}

							/* next n bits of opcode */
		if (n == 'n')  {
			rf = fmt->f_width[i];
			mask = BITMASK(rf);
			nprintb(op & mask, rf);
			op >>= rf;
			continue;
			}



		/*  should never happen - but ... */

		printf("corrupted format descriptor <%c>\n", n);
		exit(1);

		}

	return;
}
nprintc(c, n)
register char c;
register int n;
{
	while(n-- > 0)
		putchar(c);
}

nprintb(v, n)
register int v, n;
{
	if(--n > 0)
		nprintb(v>>1, n);

	putchar('0' + (v & 1));
}

char *clasnam(class) {

	register int syms = nsym-1;

	while(syms >= 0) {

		if((symtab[syms].s_mode & CLAS) && symtab[syms].s_value == class)
			return(symtab[syms].s_u.s_name);
		syms--;
	}

	return(NULL);
}

scantree(p, ocd, args, cont_str)
register struct node *p;
register struct ocdump *ocd;
{
	register int fmt, class;

	if(p->n_alt != NUL)
		scantree(p->n_alt, ocd, args, cont_str);

	if(p->n_sym == STR)
		cont_str = 1;

	if(p->n_sym == EOL) {

		class = (p->n_mem4[0] & SELOPC) ? p->n_mem4[2] : 0;

		fmt = (p->n_mem4[0] & SELFMT) ?
			p->n_mem4[3] :
			scanop(ocd->ocd_opc, class)->os_fmt;

		if((ocd->ocd_classes & (1 << class)) && nargs(fmt) == args
			&& !cont_str)
			accept = 1;
	}

	if(p->n_next != NUL)
		scantree(p->n_next, ocd, args, cont_str);
}

nargs(form)
{
	return(format[form].f_class);
}

doxref() {
	register struct ocdump *p;
	register int i;

	qsort(dmplst, nops, sizeof(struct ocdump), cmpxr);

	dumptree(tree, line, NUL, NUL, NUL, 0, 0);

	printf(fmt->fm_spc1);

	printf("Op%sFmt   |", nflag ? "\\\\":"\\");
	for(i = 1; i <= nfmt; i++)
		printf(" %2d |", i);
	putchar('\n');
	printf("----------");
	for(i = 1; i <= nfmt; i++)
		printf("-----");
	putchar('\n');

	p = dmplst;
	for(i = 1; i <= nops ; i++) {
		printf("%-8.8s |", p->ocd_opc);
		nfmt = 0;
		xrtree(tree, p, 0, 0);
		putchar('\n');
		p++;
	}
}

xrtree(p, ocd, args, cont_str)
register struct node *p;
register struct ocdump *ocd;
{
	register int fmt, class;

	if(p->n_alt != NUL)
		xrtree(p->n_alt, ocd, args, cont_str);

	switch(p->n_sym) {

	case STR:
		cont_str = 1;
		args++;
		break;

	case EXP: case CON: case LBL:
		args++;
		break;

	case EOL:

		class = (p->n_mem4[0] & SELOPC) ? p->n_mem4[2] : 0;

		fmt = (p->n_mem4[0] & SELFMT) ?
			p->n_mem4[3] :
			scanop(ocd->ocd_opc, class)->os_fmt;

		if(!cont_str) {
			++nfmt;

			if((ocd->ocd_classes & (1 << class)) &&
				nargs(fmt) == args)
				printf(" %2d |", nfmt);
			else
				printf(" ** |");
		}
	}

	if(p->n_next != NUL)
		xrtree(p->n_next, ocd, args, cont_str);
}
