#include	"../mac/mac.h"
#include	"mactab.h"
#include	"mactab.x"


plab()
{
	register int i;

	for (i=0; i<NSYM; i++)  {
		if (!getlin())
			break;

		getsym();
		if (sym != LBL)  {
			error("pre-definition - label needed", 0);
			continue;
			}

		copy(clabel, &symtab[i].s_u.s_name[0]);

		getsym();
		if (sym != CON)  {
			error("defined label - value required",0);
			mem = 0;
			}

		symtab[i].s_value = mem;
		symtab[i].s_mode  = ABS | DEFN;
		}

	nsym = i;
	head.h_labels = i;

	return;
}

pclass() {
	register int i, class = 1, classp;

	while(getlin()) {
		getsym();

		if(sym != LBL) {
			error("class name required", 0);
			continue;
		}

		if(mem == ERR) {
			if(class == 0)
				error("%s too many classes\n", clabel);
			copy(clabel, symtab[nsym].s_u.s_name);
			symtab[nsym].s_value = class;
			symtab[nsym].s_mode = DEFN|CLAS;
			symtab[nsym].s_class = 0;
			classp = nsym;
			class <<= 1;
			nsym++;
		} else if(!(symtab[mem].s_mode & CLAS)) {
			error("%s is a label, not a classname", clabel);
			continue;
		} else {
			classp = mem;
		}

		for(;;) {
			getsym();
			if(sym == EOL)
				break;
			if(sym == DEL)
				continue;

			if(sym != LBL) {

				error("expected label", 0);
				continue;
			}

			if(mem == ERR || (symtab[mem].s_mode & CLAS)) {
				error("label name required", 0);
				continue;
			}

			symtab[mem].s_class |= symtab[classp].s_value;
		}
	}
	head.h_labels = nsym;
}
