#include "../mac/mac.h"
#include "mactab.h"
#include "mactab.x"

/*
 * Define section bits and which
 * sections will be notified if they don't appear
 * The bits must be upshifted by the section's index
 * in lvec
 */

#define PLIT	(1<<0)
#define PLAB	(1<<1)
#define PCLS	(1<<2)
#define PHED	(1<<3)
#define POPS	(1<<4)
#define PFMT	(1<<5)
#define PARG	(1<<6)
#define PEND	(1<<7)

#define MUST_HAVE	(PHED|PEND)
#define WARN_HAVE	(POPS|PFMT|PARG)

int fflag, lflag, nflag, hflag, xflag;
char *list_header = "Mactab";


main(argc, argv)
char	*argv[ ];
{
	register int i,j;
	register char *opts, c;
	int sects = 0;

	while(argc > 1 && *argv[1] == '-') {
		argc--;
		argv++;

		opts = &argv[0][1];
		while (c = *opts++)
			switch (c) {
	
			case 'h':
				if(argv[0][2] != 0) {
					list_header = &argv[0][2];
					opts = "";
				} else if(argc > 1) {
					argc--;
					list_header = *++argv;
				}
				hflag = 1;
				break;
	
			case 'x':
				xflag = 1;
				lflag = 1;
				break;

			case 'f':
				fflag = 1;
				lflag = 1;
				break;
	
			case 'n':		/* nroff listing */
				nflag = 1;
				lflag = 1;
				break;
	
			case 'l':		/* ordinary listing */
				lflag = 1;
				break;
	
			default:
				printf("bad option %s\n", argv[0]);
			}
	}

	if (argc > 1)  {
		close(0);
		if (open(argv[1], 0) < 0)  {
			error("can't open %s", argv[1]);
			exit(1);
			}
		if(hflag == 0) {
			list_header = argv[1];
			}
		}

	if (argc > 2)  {
		fd = creat(argv[2], 0666);
		if (fd < 0)  {
			error("can't create %s", argv[2]);
			return;
			}
		}


	/*
	 *   The parser description is made up of several parts.
	 *
	 *	The first symbol seen must be a label, and if not,
	 *	it is a fatal error. the label's value determines
	 *	the type of section to follow. the section is
	 *	terminated by an eof (% in col 1).
	 */

	for (;;)  {			/* get all segs */

		getlin();
		getsym();		/* initial label */

		if (sym == EOF)  {
			pend();
			break;
			}

		if (sym != LBL)  {
			error("section descriptor needed", 0);
			exit(1);
			}

		/*
		 *   Decode descriptor and call handler.
		 */

		for (i=0; lvec[i]; i++)
			if (compar(lvec[i], clabel))  {
				sects |= (1<<i);
				fn = avec[i];
				(*fn)();
				break;
				}

		if (!lvec[i])  {
			error("%s: no such section", clabel);
			exit(1);
			}

		}

	j = 1;
	for(i = 0; lvec[i]; i++) {
		j <<= 1;
		if((j & MUST_HAVE) && !(j & sects))
			error("section %s missing", lvec[i]);
		if((j & WARN_HAVE) && !(j & sects))
			warn("section %s missing", lvec[i]);
	}

}
