#include	"mac.h"
#include	"mac.x"

/*
 *   Standard linear search for pseudo op.
 */
pscan()
{
	register int i;
	register char *t;

	t = clabel;
	if (*t == 'd' && *(t+1) == 'c' && *(t+2) && !*(t+3))  {

		/*
		 *   Special define constant (dc?)
		 */
		for (i=0; i<4; i++)
			if (*(t+2) == head.dctype[i].f_class)
				return(i);
		return(ERR);
		}

	/*
	 *   Scan remaining pseudo ops.
	 */
	for (i=4; plabel[i]; i++)  {
		if (compar(clabel, plabel[i]))
			return(i);
		}

	return(ERR);
}


/*
 *   Binary search of opcode table.
 */
oscan()
{
	register struct oc *r;			/* pointer to opcodes */
	register int i;
	register int j;
	register int k;

	i = 0;
	j = head.h_ops - 1;
	while (i <= j)  {
		k = (i + j) >> 1;
		r = &opcode[k];
		switch (cmp(clabel, r))  {

			case  1:
				i = k + 1;
				break;

			case  0:
				/*
				 *   found symbolic.
				 */
				return(k);

			case -1:
				j = k - 1;
				break;

			}
		}
	/*
	 *   Not found.
	 */
	return(ERR);
}

/*
 *   Hashed list search for a label in the symbol
 *   table. options exist to define a label, look
 *   up a label (referenced) or check for label in
 *   the table currently.
 */
struct st *
lscan(name, mode, hashx, value, type)
register char	*name;
int	 mode;
register int	hashx;
register int	value;
register int	type;
{
	register struct st *q;

	switch (mode)  {

		default:
			fprintf(stderr, "internal error mode %d\n", mode);
			return(NULL);

		/*
		 *   Scan symbol table:
		 *	if label is present, return index,
		 *	if not - define a slot in the table,
		 *	mark the symbol as referenced but
		 *	undefined, and return the index.
		 */
		case LKP:
			q = symhash[hashx];
			if (!q)  {
				q = dslot(name, value, REFR);
				symhash[hashx] = q;
				return(q);
				}

			/*
			 *   Search list.
			 */
			while (q)  {
				if (compar(name, q->s_u.s_name))  {
					q->s_mode |= REFR;
					return(q);
					}
				q = q->s_next;
				}

			/*
			 *   Not in list.
			 */
			q = dslot(name, value, REFR);
			q->s_next = symhash[hashx];
			symhash[hashx] = q;
			return(q);

		/*
		 *   Scan symbol table:
		 *	if symbol is not in table, define
		 *	an entry for it, and return the index.
		 *	if it is present, mark it defined,
		 *	and enter its value (error if previously
		 *	defined) and return its index.
		 */
		case DEF:
			q = symhash[hashx];
			if (!q)  {
				q = dslot(name, value, type|DEFN);
				symhash[hashx] = q;
				return(q);
				}
			/*
			 *   Search list - error if dup. found.
			 */
			while (q)  {
				if (compar(name, q->s_u.s_name))  {
					if (q->s_mode & DEFN)  {
						synerr("multi def. label");
						return(NULL);
						}
					q->s_mode |= type|DEFN;
					q->s_value = value;
					q->s_lcntr = lcntr;
					return(q);
					}
				q = q->s_next;
				}
			/*
			 *   Add label definition.
			 */
			q = dslot(name, value, type|DEFN);
			q->s_next = symhash[hashx];
			symhash[hashx] = q;
			return(q);

		}


	/*
	 *   End of scanner.
	 */
}
/*
 *	Literal pool linked list.
 *	entries are interleaved with symbol table entries.
 *	each entry contains information identifying the code segment,
 *	current location count and the no. of the argument to the
 *	current instruction. the data is useful to an "intelligent" loader
 *	for machines with segmented memory.
 */
linkl(mode,value)
int	mode;
int	value;
{
	register struct st *q;
	static union s_ut b;	/* build identifier */

	switch (mode)	{

		default:
			fprintf(stderr, "internal error - mode %d\n",mode);
			return(NULL);

		/*
		 *	pass 1:
		 *	allocate new list element and
		 *	store ident data and mode
		 */
		case LKP:
			b.L_PCVAL = locn[lcntr].l_value;
			b.L_LCNTR = lcntr;

			q = dslot(b.s_name, value, LITR);
			if (lithd)  {
				lithd = litnxt = q;
				}
			else  {
				litnxt->s_next = q;
				litnxt = q;
				}
			nlit++;
			return;

		/*
		 *	pass 2:
		 *	insert value field
		 *	litnxt is reset to indicate start of pass 2
		 */
		case DEF:
			if (litnxt)  {
				q = lithd;
				}
			else  {
				q = litnxt;
				}
			q->s_value = value;
			litnxt = q->s_next;
			return;

		}
}
