#include	"mac.h"
#include	"m.out.h"
#include	"mac.x"

static int lc_offset; /* offset telling how far along an instruction
				you are (in basic units) */

/*
 *   Auxilliary routines 3 (for pass 2)
 */


/*
 *   Assemble binary object in a field 'width' bits,
 *   having a value of 'value'.
 *
 *   The value is checked to fit into the space and
 *   truncation errors will result if it overflows.
 *   If the host machine has generated a negative
 *   number as the result of an expression -
 *   check this also by complementing the number,
 *   and then checking it.
 */
assemble(value, width)
register int value;
register int width;
{
	register int mask;
	register int free;
	register int r;
	register int rel;
	static	 int	used;
	static	 int	buf;
	static   int	relbuf;
	static   int	reltype = NUL;



	if(reloc & RREL) {
		rel = BITMASK(width);
		reltype = reloc;
	} else {
		rel = 0;
	}

	/*
	 *   Check for overflow errors.
	 *   (a value too large to fit in
	 *   the desired space.)
	 */
	if (value >= 0)  {
		mask = (-1) << width;
		if (value & mask)
			warning("assemble overflow");
		}
	else  {
		mask = (-1) << (width - 1);
		if (value < mask)
			warning("assemble overflow");
		}

	/* generate formatted string for printing */
	if (ff) storef(value,width);
	if (wf) pt.w_bt += width;


	free = head.h_bu_len - used;			/* free bits in buf */
	while (width && width >= free)  {
		r = width - free;			/* remainder can't use yet */
		mask = BITMASK(free);
		buf = (buf << free) | ((value >> r) & mask);
		relbuf = (relbuf << free) | ((rel >> r) & mask);
		mask = BITMASK(r);
		value &= mask;
		width -= free;
		rel &= mask;
		if(reltype & RREL && relbuf)
			putrel(relbuf, reltype);
		*locn[lcntr].l_next++ = buf;		/* push out to core */
		lc_offset++;
		buf  = 0;
		used = 0;				/* none of buf used */
		relbuf = 0;
		free = head.h_bu_len;
		}

	if (!width)
		return;

	/*
	 *   Take care of remainder.
	 */
	used += width;
	mask = BITMASK(width);
	buf = (buf << width) | (value & mask);

	relbuf = (relbuf << width) | (rel & mask);

	reltype = NUL;
	return;
}

/*
 *   Code formatter.
 *
 *   Decode and assemble binary data in memory
 *   according to the selected format descriptor.
 */
format(fmt, os)
register struct fd *fmt;
struct os *os;
{
	register int pr;
	register int rf;
	register int n;
	register int mask;
	register int i;
	register int ilen;
	static	int val;
	register int op;

	/* offset within instruction for relocation info */
	lc_offset = 0;

	if (os == NUL)  {
		synerr("illegal instruction");
		return;
		}

	if ((int)os == ERR)
		op = ERR;
	else
		op = os->os_opc;
	if (intercode.i_selc[0] & SELVAL)
		val = intercode.i_selc[1];
	else
		val = 0;


	/*
	 *   Format descriptor loop.
	 *
	 *   Get each sub-section, decode it,
	 *   and assemble it's value into the instruction.
	 */

	ilen = 0;

	for (i=0; fmt->f_desc[i] != 0; i++)  {

		ilen += fmt->f_width[i];
		pr = fmt->f_desc[i] & (RMODE | PMODE);
		n  = fmt->f_desc[i] & 0xff;

						/* opcode field */
		if (n == 'o')  {
			reloc = RABS;
			rf = fmt->f_width[i];
			mask = BITMASK(rf);
			assemble(op & mask, rf);
			continue;
			}

							/* pc field */
		if (n == '!')  {
			reloc = RREL;
			assemble(locn[lcntr].l_value/bu, fmt->f_width[i]);
			continue;
			}

							/* arg field */
		if (n >= 'a' && n <= 'm')  {
			n = n - 'a' + 1;
			reloc = relstac[n];
			n = oprstac[n];
			if (pr & PMODE)  {
				/* pc relative */
				reloc = (reloc == RLBL) ? RLBL|RPMOD : RABS;
				n -= locn[lcntr].l_value/bu;
				}

			if (pr & RMODE)  {
				/* byte relocation */
				rf = fmt->f_value[i];
				mask = BITMASK(rf);
				n = ((n & mask) << rf) | ((n >> rf) & mask);
				}

			assemble(n, fmt->f_width[i]);
			continue;
			}

							/* constant field */
		if (n == '#')  {
			reloc = RABS;
			assemble(fmt->f_value[i], fmt->f_width[i]);
			continue;
			}

							/* value field */
		if (n == 'v')  {
			reloc = RABS;
			rf = fmt->f_width[i];
			mask = BITMASK(rf);
			assemble(val & mask, rf);
			val >>= rf;
			continue;
			}

							/* next n bits of opcode */
		if (n == 'n')  {
			reloc = RABS;
			rf = fmt->f_width[i];
			mask = BITMASK(rf);
			assemble(op & mask, rf);
			op >>= rf;
			continue;
			}



		/*  should never happen - but ... */

		fprintf(stderr, "corrupted format descriptor <%c>\n", n);
		exit(1);

		}

	return;
}

putrel(relmask, reltype)
register int relmask, reltype;
{
	register struct lt *lc = &locn[lcntr];
	register struct rl *r;

	r = getrel();
	r->rl_next = NUL;

	if(lc->l_rlsts == NUL)
		lc->l_rlsts = r;

	if(lc->l_rlste != NUL)
		(lc->l_rlste)->rl_next = r;

	lc->l_rlste = r;

	r->rl_type = reltype;
	r->rl_mask = relmask;
	r->rl_addr = lc->l_value + lc_offset -
		((head.h_pc_post) ? 0 : length);

	if((reltype & RLBL) == RLBL)
		r->rl_u.rl_glp = globptr;
	else
		r->rl_u.rl_lcntr = lcntr;
	lc->l_rsize++;
}

struct rl *
getrel() {
	static struct rl *block = NUL, *end = NUL;

	if(block >= end) {
		block = (struct rl *)getmem(RL*32);
		end = block + 32;
	}

	return(block++);
}
