#
/*
 * mt.c - magtape device driver for TI 979 magtape through TI-11 interface
 *
 * Bill Shannon, CWRU, 2/80
 */

#include "../h/param.h"
#include "../h/buf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/ti980.h"

struct buf	mttab;
struct buf	rmtbuf;
struct buf	cmtbuf;

int m_openf;

mtopen(dev, flag)
{
	mttab.b_flags |= B_TAPE;
	if (m_openf) {
		u.u_error = ENXIO;
		return;
	}
	m_openf++;
	if (mcommand(dev, T_OPEN, flag)) {
		u.u_error = ENXIO;
		mcommand(dev, T_CLOSE, flag);	/* make sure Filex thinks it's closed */
		m_openf = 0;
	}
}


mtclose(dev, flag)
{
	mcommand(dev, T_CLOSE, flag);
	m_openf = 0;
}


mcommand(dev, com, flag)
{
	register struct buf *bp;
	register int s;

	bp = &cmtbuf;
	spl5();
	while (bp->b_flags & B_BUSY) {
		bp->b_flags |= B_WANTED;
		sleep(bp, PRIBIO+1);
	}
	spl0();
	bp->b_dev = dev;
	bp->b_blkno = flag;
	bp->b_flags = B_BUSY | B_CTRL;
	bp->b_resid = com;
	mtstrategy(bp);
	iowait(bp);
	if (bp->b_flags & B_WANTED)
		wakeup(bp);
	s = bp->b_flags & B_ERROR;
	bp->b_flags = 0;
	return(s ? bp->b_error : 0);
}


mtstrategy(bp)
struct buf *bp;
{
	tistrategy(bp);
}


mtread(dev)
{
	physio(mtstrategy, &rmtbuf, dev, B_READ, 0);
}


mtwrite(dev)
{
	physio(mtstrategy, &rmtbuf, dev, B_WRITE, 0);
}
