#
/*
 * ds.c: ds disk driver for Texas Instruments version of RP04
 *
 * G. Ordy, CWRU, 6/79
*/

#include "../h/param.h"
#include "../h/buf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/ti980.h"

unsigned ds_size[8]		/* sizes of the file systems */
{
	5016,			/* rk05 sized */
	5016,			/* rk05 sized */
	41800,			/* general users */
	41800,			/* N.mPc project */
	65208,			/* system and scratch */
	8360,			/* scratch */
	0,
	0	};

struct buf dstab;
struct buf    rdsbuf;

dsopen(dev, flag)
{
	if(ds_size[minor(dev) - TIDSOFF] == 0) {
		u.u_error = ENXIO;
		return;
	}
}

dsstrategy(bp)
register struct buf *bp;
{
	if((ds_size[minor(bp->b_dev) - TIDSOFF]) <= bp->b_blkno) {
		bp->b_flags |= B_ERROR;
		iodone(bp);
		return;
	}
	tistrategy(bp);
}

dsread(dev)
{
	physio(dsstrategy, &rdsbuf, dev, B_READ, ds_size[minor(dev) - TIDSOFF]);
}

dswrite(dev)
{
	physio(dsstrategy, &rdsbuf, dev, B_WRITE, ds_size[minor(dev) - TIDSOFF]);
}
