/ low core

ZERO:

br4 = 200
br5 = 240
br6 = 300
br7 = 340

. = ZERO+0
	br	1f
	4

/ trap vectors
	trap; br7+0.		/ bus error
	trap; br7+1.		/ illegal instruction
	trap; br7+2.		/ bpt-trace trap
	trap; br7+3.		/ iot trap
	trap; br7+4.		/ power fail
	trap; br7+5.		/ emulator trap
	start;br7+6.		/ system  (overlaid by 'trap')

. = ZERO+40
.globl	start, dump
1:	jmp	start
	jmp	dump


. = ZERO+60
	klin; br4
	klou; br4

. = ZERO+100
	kwlp; br6
	kwlp; br6

. = ZERO+114
	trap; br7+10.		/ 11/70 parity

. = ZERO+220
	rkio; br5

. = ZERO+240
	trap; br7+7.		/ programmed interrupt
	trap; br7+8.		/ floating point
	trap; br7+9.		/ segmentation violation

. = ZERO+264
	rx2io; br5

/ floating vectors
. = ZERO+300
/dhdm 300
	dmin; br4+0.
	.=.+4
/dh 310
	dhin; br5+0.
	dhou; br5+0.

/ overlay descriptor tables

. = ZERO+400
.globl	ova, ovd, ovend
ova:	.=.+16.		/ overlay addresses
ovd:	.=.+16.		/ overlay sizes
ovend:	.=.+2		/ end of overlays

//////////////////////////////////////////////////////
/		interface code to C
//////////////////////////////////////////////////////

.text
.globl	call, trap

.globl	_klrint
klin:	jsr	r0,call; jmp _klrint
.globl	_klxint
klou:	jsr	r0,call; jmp _klxint

.globl	_clock
kwlp:	jsr	r0,call; jmp _clock


.globl	_rkintr
rkio:	jsr	r0,call; jmp _rkintr

.globl	_rx2intr
rx2io:	jsr	r0,call; jmp _rx2intr

.globl	_dmint
dmin:	jsr	r0,call; jmp _dmint

.globl	_dhrint
dhin:	jsr	r0,call; jmp _dhrint
.globl	_dhxint
dhou:	jsr	r0,call; jmp _dhxint
