/*
 * Code: show octal value of ascii input
 *
 * code [file]
 */
#include	<stdio.h>
#include	<sgtty.h>

main(argc, argv)
char *argv[];
{
	int	fd;
	struct sgttyb state;

	if (argc > 1) {
		argv++;
		while (argc-- > 1) {
			if ((fd = open(*argv, 0)) < 0)
				printf("can't open %s\n", *argv);
			else
				code(fd);
			argv++;
		}
	} else {
		gtty(0, &state);
		state.sg_flags |= RAW;
		state.sg_flags &= ~ECHO;
		stty(0, &state);
		code(0);
		state.sg_flags &= ~RAW;
		state.sg_flags |= ECHO;
		stty(0, &state);
	}
	exit(0);
}

code(fd)
int fd;
{
	char c;

	while (read(fd, &c, 1) > 0) {
		c &= 0177;
		if (c < 040)
			printf("^%c ", c+0100);
		else if (c == 0177)
			printf("   ");
		else
			printf("%c  ", c);
		printf("%03o\r\n", c);
		if (c == 0177)
			break;
	}
}
