# include "mfile1"

/*
 *	this file contains code which is dependent
 *	on the target machine
 */
#ifdef ONEPASS
# include "manifest"
# include "macdefs"
#endif


static		inwd;			/* current bit offset in word */
static CONSZ	word;			/* word being built from fields */
extern int	idebug;
int		initkluge = 0;		/* see pftn.c - endinit() */
extern int	xdebug;

# define BITMASK(n)	((1L<<n)-1)

/*
 *	Cast node p to type t
 */
NODE *
cast (p, t)
	register NODE	*p;
	TWORD		t;
{

	p = buildtree (CAST, block (NAME, NIL, NIL, t, 0, (int) t), p);
	p->left->op = FREE;
	p->op = FREE;
	return (p->right);
}

andable (p)
	NODE	*p;
{
	return (1);		       /* all names can have & taken on them */
}

/*
 * at the end of the arguments of a ftn,
 * set the automatic offset
 */
cendarg()
{
	autooff = AUTOINIT;
}

/*
 * is an automatic variable of type t
 * OK for a register variable
 */
cisreg (t)
	TWORD	t;
{
	return (0);
}

/*
 * return a node, for structure references, which is suitable for
 * being added to a pointer of type t, in order to be off bits offset
 * into a structure
 */
NODE *
offcon (off, t, d, s)
	OFFSZ	off;
	TWORD	t;
{
	register NODE	*p;
	extern int eprint();

	if (xdebug > 2) {
		printf("offcon( %ld, ", off);
		tprint(t);
		printf(", %d, %d )\n", d, s);
	}
	/*
	 * t, d, and s are the type, dimension offset, and sizeoffset
	 * in general they  are necessary for offcon, but not on H'well
	 */
	p = bcon (0);
	/*
	 * We want to put out byte offsets for those nodes involving
	 * chars in arrays or structures.  Otherwise use a word offset
	 * or we'll have to optimize the tree before it's written out.
	 * to avoid multiplies and divides by 3.
	 */
	if (bptype(t)) {	/* bptype lives in clocal.c */
		p->lval = off/SZCHAR;
		p->sym_x = BYTES;
	} else {
		p->lval = off/SZINT;
		p->sym_x = WORDS;
	}
	if (xdebug > 2) {
		printf("offcon returns\n");
		fwalk(p, eprint, 1);
	}
	return (p);
}

/*
 * generate initialization code for assigning a constant c
 * to a field of width sz
 */
incode (p, sz)
	register NODE	*p;
{
	extern long	word;
	/*
	 * we assume that the proper alignment has been obtained
	 * inoff is updated to have the proper final value
	 * we also assume sz  < SZINT
	 */

	if ((sz + inwd) > SZINT)
		cerror ("incode: field > int");
	word = (word << sz) | (p->lval & BITMASK(sz));
	inwd += sz;
	inoff += sz;
	if (inoff % SZINT == 0) {
		printf(")	.word	0%O\n", word);
		word = 0L, inwd = 0;
	}
}

/*
 * output code to initialize space of size sz to the value d
 * the proper alignment has been obtained
 * inoff is updated to have the proper final value
 * on the target machine, write it out in octal!
 */
fincode (d, sz)
	double	 d;
{

#if pdp11
	printf(")	.word %.10e\n", d);
#else
	printf(")	.long	0\n");	/* no floating point */
#endif
	inoff += sz;
}

/*
 * arrange for the initialization of p into a space of
 * size sz
 */
cinit (p, sz)
	NODE	*p;
{
#if DEBUG & LOCAL
	extern int	eprint();
#endif

	/*
	 * the proper alignment has been obtained
	 * inoff is updated to have the proper final value
	 */
	/*
	 * Special case: we can't allow names of objects to be typed
	 *  scalar, 'cuz then they'll be init'ed with a .word instead
	 *  of a .dac (as is necessary).
	 */
#if DEBUG & LOCAL
	if (idebug > 1) {
		printf("cinit( %o )\n", p);
		fwalk(p, eprint, 0);
	}
#endif
	if ((p->left->rval != NONAME) && (!ISPTR(p->type))) {
		p->type = INCREF(p->type);
#if DEBUG & LOCAL
		if (idebug) {
			printf("cinit( %o ), type modified\n", p);
			fwalk(p, eprint, 0);
		}
#endif
	}
	ecode (p);
	inoff += sz;
}

/*
 * define n bits of zeros in a vfd
 */
vfdzero (n)
{

	if (n <= 0)
		return;

	inwd += n;
	inoff += n;
	if (initkluge == 0)
		word <<= n;
	if (inoff % ALINT == 0) {
		printf(")	.word	0%O\n", word);
		word = 0L, inwd = 0;
	}
}


/*
 * make a name look like an external name in the local machine
 */
char *
exname (p)
	char	*p;
{
	static char     text[NCHNAM + 2];
	register        i;

	text[0] = '_';
	for (i = 1; *p && i < NCHNAM+1; ++i) {
		text[i] = *p++;
	}

	text[i] = '\0';
	text[NCHNAM+1] = '\0';	       /* truncate */

	return (text);
}

/*
 * map types which are not defined on the local machine
 */
ctype (type)
	TWORD	type;
{
	switch (BTYPE (type)) {
		case SHORT:
			MODTYPE (type, INT);
			break;
		case USHORT:
			MODTYPE (type, UNSIGNED);
	}
	return (type);
}

/*
 * curid is a variable which is defined but
 * is not initialized (and not a function );
 * This routine returns the stroage class for an uninitialized declaration
 */
noinit ()
{
	return (EXTERN);
}

/*
 * make a common declaration for id, if reasonable
 */
commdec (id)
{
	register struct symtab *q;
	OFFSZ off;

	q = &stab[id];
	off = tsize (q->stype, q->dimoff, q->sizoff);
	off = ((off-1)/SZINT)+1;
	if(off > 1)			/* multiple word common */
		printf(")	.comm	%s,%ld\n", exname(q->sname), off);
	else
		printf(")	.comm	%s\n", exname (q->sname));
}

/*
 * is lastcon to be long or short
 */
isitlong ()
{
	return(lastcon >= (1L << SZINT));
}


isitfloat (s)
	char	*s;
{
	double	atof();

	dcon = atof (s);
	return (FCON);
}

/*
 * walk the tree and write out the nodes..
 */
ecode (p)
	register NODE	*p;
{

	if (nerrors)
		return;
#ifdef ONEPASS
	p2tree (p);
	p2compile (p);
#else
	printf(".%d\t%s\n", lineno, ftitle);
	prtree(p);
#endif
}
