/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)address.h	1.1 84/06/12
*/

/*
**	Address types:
**
**	The following leading characters in a destination address string
**	identify the address type.
*/

#define	ATYP_MULTICAST	','
#define	ATYP_BROADCAST	'*'
#define	ATYP_EXPLICIT	'!'

/*
**	Anything else is a single address.
*/

#define	DOMAIN_SEP	'.'		/* Character to separate domains in address */

/*
**	Addresses may take the following forms:-
**
**		destination
**		,destination,destination ...
**		!destination!destination ...
**		*[.{*|domain}]
**	
**	where a "destination" is in the form:-
**
**		node[.domain ...]
*/

/*
**	Structure for containing parts of an address
*/

typedef struct
{
	char **	ad_strings;	/* Pointers to parts */
	short	ad_domains;	/* Count of domain parts */
}
	Address;

#define	ad_node	ad_strings[0]	/* The first string is always the node name */

/*
**	Externals
*/

extern char *	HomeNode;

extern Address	*SplitAddress();
extern void	FreeAddress();

extern bool
		DestReached(),
		DoRoute(),
		HomeAddress(),
		HomeDomain();
