/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetPrint.c	1.3 85/07/11
*/

/*
**	Control the output of the Print routines.
*/

#include	<setjmp.h>

#include	"global.h"
#include	"state.h"

#include	"node.h"
#include	"route.h"


/*
**	Structure for remembering restricted print items.
*/

typedef struct PrintEl *	PE_p;
typedef struct PrintEl
{
	PE_p	p_next;
	char	p_name[NODE_NAME_SIZE+1];
}
		PrintEl;

static PE_p	PrintList;

bool		PrintInDomain;

extern jmp_buf	NameErrJmp;


void
PrintOnly(namep)
	char *		namep;
{
	register PE_p	pp;

	pp = Talloc(PrintEl);

	pp->p_next = PrintList;
	PrintList = pp;

	(void)strncpy(pp->p_name, namep, NODE_NAME_SIZE);
}



States
SetPrint()
{
	register PE_p	pp;
	register Entry*	np;
	bool		found = false;

	if ( (pp = PrintList) == (PE_p)0 )
		return S_FOUND;			/* Match all nodes */

	if ( PrintInDomain && RouteBase == NULLSTR )
		MakeRoute();

	if ( setjmp(NameErrJmp) == 0 )
	do
	{
		if ( !PrintInDomain )
		{
			register char *	cp;

			/*
			**	Convolutions are to avoid calculating
			**	routefile if possible.
			**
			**	Once large relational expression broken
			**	up to avoid bug in some PCCs.
			*/

			if ( (np = Lookup(pp->p_name, NodeHash)) != (Entry *)0 )
			{
				found = true;
				np->e_states |= S_PRINT;
			}
			else
			{
				if ( RouteBase == NULLSTR )
					MakeRoute();
				if
				(
					(cp = FindAlias(pp->p_name)) != NULLSTR
					&&
					(np = Lookup(cp, NodeHash)) != (Entry *)0
				)
				{
					found = true;
					np->e_states |= S_PRINT;
				}
			}
		}
		else
		{
			NodeLink	nl;

			if ( FindDomain(pp->p_name, &nl) )
			{
				register int	i;
				register int	j;

				i = nl.nl_domind;

				for ( j = 0 ; j < NodeCount ; j++, i += DomainCount )
					if
					(
						(MemberTable[i/8] & (1<<(i%8)))
						&&
						(np = Lookup(RT_NODE(j)->ne_name, NodeHash)) != (Entry *)0
					)
					{
						found = true;
						np->e_states |= S_PRINT;
					}
			}
		}
	}
	while
		( (pp = pp->p_next) != (PE_p)0 );

	return found ? S_PRINT : (States)0;
}
