/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Debug.h	1.2 84/10/22
*/

/*
**	Parameters for debugging
*/

#ifndef	pdp11
#define	PKTHIST		30		/* Number of packets to remember */
#else	pdp11
#define	PKTHIST		6		/* Number of packets to remember */
#endif	pdp11
#define	PLOGIN		0		/* Packet received */
#define	PLOGOUT		1		/* Packet transmitted */
#define	PLOGSEND	2		/* Packet actually sent */
#define	PKTLOGLEN	7		/* Bytes to show from logged packet */

#if	DEBUG >= 1

#define	SETDEBUGTIME()	Debug_ticks=ticks()
#define	Logpkt(A,B)	{if(Ptraceflag)Plogpkt(A,B);}
#define	Tracehdrs(A)	{if(Ptraceflag)Ptracehdrs(A);}
#if	PSTATSDESC == 1
#define	Dumphist(A)	{if(Ptraceflag)Pdumphist(A);}
#define	Tracepkt(A,B)	{if(Ptraceflag)Ptracepkt(A,B,0);}
#else
#define	Dumphist(A)	{if(Ptraceflag)Pdumphist("");}
#define	Tracepkt(A,B)	{if(Ptraceflag)Ptracepkt(A,"",0);}
#endif

extern Time_t		Debug_ticks;
extern int		Ptraceflag;
extern void
			Pdumphist(),
			Plogpkt(),
			Ptracehdrs(),
			Ptracepkt();

#else	DEBUG

#define	SETDEBUGTIME()
#define	Logpkt(A,B)
#define	Tracepkt(A,B)
#define	Dumphist(A)
#define	Tracehdrs(A)

#endif	DEBUG
