/*
**	patterns and functions to call uqcspe from qfdts
*/

#include	"global.h"
#include	"caller.h"
#include	"passwd.q"

#ifndef	UQCSPE_PASSWD
#define	UQCSPE_PASSWD	""
#endif
#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif

extern	int	Traceflag;

extern struct patlist	*current;

char
	*daemon1 = NNDAEMON,		/* standard daemon */
	*daemon2 = NN2DAEMON,		/* alternate protocol */
	*host	 = "qfdts",		/* connecting from qfdts */
	*target  = "uqcspe",		/* connecting to uqcspe */
	*hostflg = "-BF",		/* dialup, don't fork, cooked */
	*phoneno = "3716255",		/* phone number to ring */
	*passwd  = UQCSPE_PASSWD,
	*speed   = "300",
	*retry	 = "60",		/* seconds between open attempts */
	*retries = "1",			/* times to attempt open */
	*delay	 = "30";		/* TIMEOUT every delay seconds */

int
	fcount	 = 0,	/* count of gross failures */
	tcount	 = 0,	/* count of timeouts */
	lcount	 = 0;	/* count of Unix login attempts */

char	*pump;		/* current string to prompt response from remote */

struct patlist *tostate;/* state to enter on timeout */

int
	eof(),
	failure(),
	gotlogin(),
	gotpasswd(),
	slowhost(),
	started(),
	start2(),
	timeout(),
	touqcspe();

struct patlist atuqcspe[] =
{
	{ "login", gotlogin },
	{ "Login", gotlogin },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

struct patlist uqcspelogin[] =
{
	{ "password", gotpasswd },
	{ "Password", gotpasswd },
	{ STARTMSG, started},	/* some moron might have deleted passwd */
	{ START2MSG, start2 },	/* alternate protocol */
	{ "[Ll]ogin +[Ii]ncorrect", touqcspe },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

struct patlist daemonwait[] =
{
	{ STARTMSG, started},
	{ START2MSG, start2 },				/* alternate protocol */
	{ "[Ll]ogin +[Ii]ncorrect", touqcspe },
	{ "[Ww]rong +[Pp]assword", touqcspe },		/* cretins ! */
	{ TIMEOUT, slowhost },
	{ EOFSTR, eof },
	{ 0, 0 }
};



args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 's':
					speed = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case 'p':
					phoneno = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					out(CALLARGS);
					exit(1);
				}
			}
break2:			;
		}
		else
		{
			out("fail unexpected argument ");
			out(*argv);
			out(" in ");
			out(CALLARGS);
			exit(1);
		}
	}
}



init(argc, argv)
	int	argc;
	char	*argv[];
{
	(void)readargs(concat(SPOOLDIR(/), target, "/", CALLARGS, NULLSTR),
	    args);
	srand((getpid() << 3) + (int)time((long *)0));
	out("mode "); outend(hostflg);
	out("timeout "); outend(delay);
	out("retry "); out(retry); out(" "); outend(retries);
	outend("ondelay");
	out("opendial "); outend(speed);
	out("dial "); outend(phoneno);
	outend("remote");
	outend("read");
	tcount = 0;
	fcount = 0;
	pump = "\r";
	tostate = atuqcspe;
	state(atuqcspe);
	getinput();
}

touqcspe()
{
	if (++lcount >= 4) {
		outend("fail unable to login at uqcspe");
		exit(1);
	}
	outend("sleep 10");
	outend("write \r");
	state(atuqcspe);
	getinput();
}

gotlogin()
{
#ifdef	TRACE
	if (Traceflag)
		out("trace "), out(host), outend("\r");			/**/
#endif	TRACE
	out("write "); out(host); outend("\r");
	pump = "\r";
	tostate = atuqcspe;
	state(uqcspelogin);
	getinput();
}


gotpasswd()
{
#ifdef	TRACE
	if (Traceflag)
		out("trace "), out("passwd"), outend("\r");		/**/
#endif	TRACE
	out("write "); out(passwd); outend("\r");
	state(daemonwait);
	getinput();
}


started()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon1);
	out("succeed -B "); outend(target);
	exit(0);
}


start2()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 2 starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon2);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


timeout()
{
	if (++tcount >= 3)
	{
		outend("fail timeout");
		exit(1);
	}
	out("write "); outend(pump);
	state(tostate);
	reset();
}


failure()
{
	if (++fcount >= 4) {
		outend("fail repeated failures");
		exit(1);
	}
	outend("close");
	sleep(((rand() >> 3) % (5 * 60)) + (5 * 60));
	out("retry "); out(retry); out(" "); outend(retries);
	outend("ondelay");
	out("opendial "); outend(speed);
	out("dial "); outend(phoneno);
	outend("remote");
	outend("read");
	tcount = 0;
	fcount = 0;
	pump = "\r";
	tostate = atuqcspe;
	state(atuqcspe);
	getinput();
}

eof()
{
	outend("fail lost line to dailler");
	exit(1);
}

slowhost()
{
	if (++tcount >= 4) {
		outend("fail uqcspe not responding");
		exit(1);
	}
	reset();
}
