/*
**	Binary search algorithm, generalized from Knuth (6.2.1) Algorithm B.
**
**	SCCSID @(#)bsearch.c	1.1 84/06/12
*/

char *
bsearch(key, base, nel, width, compar)
	char *		key;			/* Key to be located */
	register char *	base;			/* Beginning of table */
	int		nel;			/* Number of elements */
	register int	width;			/* Width of an element */
	int		(*compar)();		/* Comparison function */
{
	register char *	u = base+(--nel)*width;	/* Last element in table */
	register char *	i;			/* Approximate middle element */
	register int	res;			/* Result of comparison */        

	while ( u >= base )
	{
		i = base+width*(nel/2);

		if ( (res = (*compar)(key, i)) == 0 )
			return i;
		else
		if ( res < 0 )
			u = i-width;
		else
			base = i+width;

		nel = (u-base)/width;
	}

	return 0;
}
