/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)mailer.c	1.12 85/03/12";

/*
**	Process mail from message received from network.
*/

#define	FILE_CONTROL
#define	STAT_CALL
#define	RECOVER
#define	STDIO

#include	"global.h"

#include	"Passwd.h"
#include	"address.h"
#include	"debug.h"
#include	"ftheader.h"
#include	"header.h"
#include	"spool.h"
#include	"sub_proto.h"

#include	<errno.h>

/*
**	Parameters set from arguments.
*/

bool	Broadcast;		/* Message has been everywhere */
char *	CommandsFile;		/* Commands for files to be pre-pended to message */
char *	DupNode;		/* Name of node at which message duplicated */
char *	HomeNode;		/* Name of this node */
char *	LinkNode;		/* Message arrived from this node */
char *	Message;		/* Message */
char *	Name;			/* Program invoked name */
char *	SourceNode;		/* Message originated at this node */
Time_t	StartTime;		/* Time message started at source */
int	Traceflag;		/* Global tracing control */

/*
**	Miscellaneous
*/

bool	Ack;			/* Acknowledgement of delivery received */
char *	DataName;		/* Used by ExpandArgs() */
char	Buf[BUFSIZ];		/* Transfer buffer */
int	MesgFd;			/* File descriptor for message */
int	Pid;			/* Used by UniqueName() in Exec...() */
char	ProtoType[2];		/* Header protocol type */
int	RetVal;			/* Value returned by program */
bool	Returned;		/* True if invoked for returned message */
char *	SenderName;		/* Used by ExpandArgs() */
Time_t	Time;			/* Used by UniqueName() in Exec...() */
char *	UFthTo;			/* Sanitised "FthTo" string */
char *	UserName;		/* Used by ExpandArgs() */

char *	AckMessage	= WORKDIR(ack....message);
char *	PostMaster	= POSTMASTER;

#define	Fprintf		(void)fprintf

extern char	FthToRestricted[];

void	finish(), mailem(), readfiles(), recvack(), returnmsg(), sendack();
bool	printroute();



int
main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	register FthReason	reason;
	char *		cp;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	Pid = getpid();
	Time = time((long *)0);

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'B':
					Broadcast = true;
					continue;

				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				case 'c':
					CommandsFile = ++*argv;
					goto break2;

				case 'd':
					DataLength = atol(++*argv);
					break;

				case 'e':
					HdrEnv = ++*argv;
					goto break2;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'l':
					LinkNode = ++*argv;
					goto break2;

				case 's':
					SourceNode = ++*argv;
					goto break2;

				case 't':
					StartTime = Time - atol(++*argv);
					goto break2;

				default:
					Trace2(1, "unrecognised flag '%c'", c);
					goto break2;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
		{
			if ( Message != NULLSTR )
				Error("only one message name expected");

			Message = *argv;
		}
	}

	if ( (cp = GetEnv(ENV_RETURNED)) != NULLSTR )
	{
		free(cp);
		Returned = true;
	}

	if ( (cp = GetEnv(ENV_ACK)) != NULLSTR )
	{
		free(cp);
		Ack = true;
	}

	DupNode = GetEnv(ENV_DUP);

	while ( (MesgFd = open(Message, O_READ)) == SYSERROR )
		Syserror("Can't open \"%s\"", Message);

	if
	(
		(reason = ReadFtHeader(MesgFd, DataLength, !Returned && !Ack)) != fth_ok
		||
		(reason = GetFthFiles()) != fth_ok
	)
		Error("File transfer header \"%s\" error", FTHREASON(reason));

	UnQuoteChars((UFthTo = newstr(FthTo)), FthToRestricted);

	if ( Ack )
	{
		recvack();
	}
	else
	{
		readfiles();

		if ( NFthUsers > 0 )
			mailem();

		if ( RetVal )
			return RetVal;

		if ( !Returned && (FthType[0] & FTH_ACK) && NFthUsers > 0 )
			sendack();	/* send ack for each user here */
	}

	return 0;
}



/*
**	Called from the errors routines to cleanup
*/

void
finish(error)
	int	error;
{
	if ( Ack )
		(void)unlink(AckMessage);

	(void)exit(error);
}



/*
**	Read the file transfer header from the message containing the mail,
**	check and acknowledge the data if requested,
**	and identify any users at this host.
*/

void
readfiles()
{
#	if	VALIDATEMAIL == 1
	register FthUlist *	up;
#	endif	VALIDATEMAIL == 1

	if ( Returned )
	{
		FthUsers = Talloc(FthUlist);
		FthUsers->u_next = (FthUlist *)0;
		FthUsers->u_name = FthFrom;
		NFthUsers = 1;
		return;
	}

	if ( GetFthTo() == 0 )
	{
		Error("addressing error - no users at \"%s\" in list \"%s\"", HomeNode, UFthTo);
		return;	/* No users at this node */
	}

#	if	VALIDATEMAIL == 1
	Recover(ert_return);

	for ( up = FthUsers ; up != (FthUlist *)0 ; up = up->u_next )
	{
		Passwd	to;

		if ( !GetUid(&to, up->u_name) )
		{
#			ifdef	MAILGROUPS
			char *	file = concat(MAILGROUPS, up->u_name, NULLSTR);

			if ( access(file, 0) != SYSERROR )
			{
				free(file);
				continue;
			}

			free(file);
#			endif	MAILGROUPS

			if ( !Broadcast && strcmp(ACSNETNAME, up->u_name) != STREQUAL )
			{
				Error("User \"%s\" does not exist at %s", up->u_name, HomeNode);
				RetVal = 1;	/* Return message and reason to source */
			}

			up->u_name = NULLSTR;
			NFthUsers--;
			continue;
		}

	}

	Recover(ert_finish);
#	endif	VALIDATEMAIL == 1
}



/*
**	Mail identified users
*/

void
mailem()
{
	register char *		cp;
	register int		n;
	register int		r;
	register long		l;
	register FthUlist *	up;
	register FthFD_p	fp;
	register long		posn;
	register FILE *		fd;
	register char *		errs;
	register int		nusers;
	bool			piperr = false;
	VarArgs			va;

	if ( Returned )
		SenderName = PostMaster;
	else
		SenderName = FthFrom;

	/*
	**	Mail each file to all the users
	*/

	Recover(ert_return);

	for ( fp = FthFiles, posn = 0 ; fp != (FthFD_p)0 ; fp = fp->f_next )
	{
		nusers = NFthUsers;
		up = FthUsers;

		while ( nusers > 0 )
		{
			char *	savesource;

			FIRSTARG(&va) = MAILER;

#			ifdef	MAILERARGS
			savesource = SourceNode;

			if ( Returned )
				SourceNode = HomeNode;

			ExpandArgs(&va, MAILERARGS, NULLSTR);

			SourceNode = savesource;
#			endif	MAILERARGS

			if ( Returned )
			{
				NEXTARG(&va) = FthFrom;
				nusers = 0;
			}
			else
			for
			(
				;
				NARGS(&va) < MAXVARARGS && up != (FthUlist *)0
				;
				up = up->u_next
			)
			{
				if ( up->u_name == NULLSTR )
					continue;

				NEXTARG(&va) = up->u_name;
				nusers--;
			}

			fd = ExecPipe(&va);

			if ( Returned )
				returnmsg(fd);
#			if	MAIL_FROM == 1
			else
			if ( strchr(SourceNode, DOMAIN_SEP) != NULLSTR )
			{
				Fprintf(fd, "From %s@%s %s>", SenderName, SourceNode, ctime(&StartTime));
				(void)fflush(fd);
			}
#			endif	MAIL_FROM == 1

			if
			(
				CommandsFile != NULLSTR
				&&
				(fp->f_mode & FTH_NOT_IN_MESG)
			)
				CopyFromComFile(CommandsFile, fileno(fd), "pipe", fp->f_name);
			else
			{
				if ( lseek(MesgFd, posn, 0) == SYSERROR )
					Syserror("Can't seek \"%s\"", Message);

				for
				(
					l = fp->f_length ;
					(r = l > sizeof Buf ? sizeof Buf : l) > 0
					&&
					(n = read(MesgFd, Buf, r)) > 0 ;
				)
				{
					l -= n;
					cp = Buf;

					while ( (r = write(fileno(fd), cp, n)) != n )
					{
						if ( r == SYSERROR )
						{
							if ( errno == EPIPE )
							{
								piperr = true;
								goto break2;
							}

							Syserror("Can't write to pipe");
						}
						else
						{
							cp += r;
							n -= r;
						}
					}
				}

				if ( n == SYSERROR )
					Syserror("Can't read \"%s\"", Message);
			}

			if ( !Returned && (FthType[0] & FTH_ACK) )
				Fprintf
				(
					fd,
					"\n\n(%s:- This mail has been acknowledged.)\n",
					PostMaster
				);

			if ( DupNode != NULLSTR )
				Fprintf
				(
					fd,
					"\n\n(%s:- This mail may have been duplicated at \"%s\" due to link problems.)\n",
					PostMaster,
					DupNode
				);
break2:
			if
			(
				(errs = ExPipeClose(fd)) != NULLSTR
				||
				piperr && (errs = newstr("broken pipe"))
			)
			{
#				if	IGNMAILERSTATUS == 1
				if ( piperr )
#				endif	IGNMAILERSTATUS == 1
				{
					Error("Could not deliver mail\n%s\n", errs);
					RetVal = 1;
				}
				free(errs);
			}
		}

		if
		(
			CommandsFile == NULLSTR
			||
			!(fp->f_mode & FTH_NOT_IN_MESG)
		)
			posn += fp->f_length;
	}

	Recover(ert_finish);
}



/*
**	Make up message for returned mail
*/

Time_t	Rtt;
FILE *	Rfd;

void
returnmsg(fd)
	FILE *		fd;
{
	register char *	cp;
	register int	i;

	Fprintf
	(
		fd,
		"From %s %sSubject: undelivered mail returned from %s\n\n",
		PostMaster,
		ctime(&Time),
		SourceNode
	);

	for ( i = 0 ; i < 79 ; i++ )
		putc('*', fd);

	Fprintf
	(
		fd,
		"\nMAIL SENT TO \"%s\" RETURNED FROM \"%s\"\n",
		UFthTo,
		SourceNode
	);

	if ( (cp = GetEnv(ENV_ERR1)) != NULLSTR )
	{
		Fprintf(fd, "\nFailure explanation follows :-\n");
		Fprintf(fd, "%s\n", cp);
		free(cp);
	}

/*	if ( (cp = GetEnv(ENV_ERR2)) != NULLSTR )
**	{
**		Fprintf(fd, "%s\n", cp);
**		free(cp);
**	}
*/
	if ( (cp = GetEnv(ENV_ROUTE)) != NULLSTR )
	{
		Rtt = 0;
		Rfd = fd;

		ExRoute(cp, printroute);

		if ( Rtt > 0 )
			Fprintf(fd, "\"\n");
		free(cp);
	}

	for ( i = 0 ; i < 79 ; i++ )
		putc('*', fd);

	putc('\n', fd);
	putc('\n', fd);

	(void)fflush(fd);
}



/*
**	Print out each node in route, and accumulate travel-time.
*/

bool
printroute(time, from, to)
	Time_t	time;
	char *	from;
	char *	to;
{
	if ( Rtt == (Time_t)0 )
		Fprintf(Rfd, "\nMessage was routed via \"");
	else
		putc(',', Rfd);
	Rtt += time;
	Fprintf(Rfd, to);
	return true;
}



/*
**	Send an acknowledgement message to source.
*/

void
sendack()
{
	register long		size;
	register char *		errs;
	int			fd;
	VarArgs			va;

	HdrEnv = MakeEnv(ENV_ACK, NULLSTR, ENV_NORET, NULLSTR, NULLSTR);

	HdrDest = SourceNode;
	HdrSource = HomeNode;
	HdrHandler = Name;

	SetFthFiles();
	SetFthTo();

	while ( (fd = creat(UniqueName(AckMessage, (long)0, Time), 0600)) == SYSERROR )
		Syserror("Can't creat \"%s\"", AckMessage);

	while ( (size = WriteFtHeader(fd, (long)0, false, false)) == SYSERROR )
		Syserror("Can't write \"%s\"", AckMessage);

	ProtoType[0] = FTP;
	HdrSubpt = ProtoType;

	while ( WriteHeader(fd, size, 0) == SYSERROR )
		Syserror("Can't write \"%s\"", AckMessage);
	
	(void)close(fd);

	FIRSTARG(&va) = RECEIVER;
	NEXTARG(&va) = concat("-h", HomeNode, NULLSTR);
	NEXTARG(&va) = AckMessage;

	if ( (errs = Execute(&va)) != NULLSTR )
	{
		Error("Acknowledgement failed;\n%s\n", errs);

		RetVal = 1;
		free(errs);
	}
}



/*
**	Receive an acknowledgement generated by 'sendack()'.
**
**	Notify sender of acknowledgement.
*/

void
recvack()
{
	register FILE *	fd;
	char *		errs;
	VarArgs		va;

	FIRSTARG(&va) = BINMAIL;

#	ifdef	BINMAILARGS
	SenderName = UFthTo;	/* Ack from receiver of mail */

	ExpandArgs(&va, BINMAILARGS, NULLSTR);
#	endif	BINMAILARGS

	NEXTARG(&va) = FthFrom;	/* Ack to original sender */

	fd = ExecPipe(&va);
	
	Fprintf(fd, "From %s %s", PostMaster, ctime(&Time));

	Fprintf
	(
		fd,
		"Subject: Acknowledgement received for mail sent to %s at %s\n\n",
		UFthTo,
		SourceNode
	);

	errs = newstr(ctime(&StartTime));

	Fprintf
	(
		fd,
		"Mail sent on %.12s was delivered on %.12s to %s at %s.\n",
		ctime(&FthFiles->f_time)+4,
		errs+4,
		UFthTo,
		SourceNode
	);

	free(errs);

	if ( (errs = ExPipeClose(fd)) != NULLSTR )
	{
		Error(errs);
		free(errs);
	}
}
