.\" tbl install.mm | troff -mm
.\" SCCSID %W% %E%
.nr Hy 0
.ds HF 3 3 2 2 2 2 2
.TL
Installation Guide for ACSnet
.AF "Sydney University"
.AU "Piers Lauder"
.AU "(piers\|@basser.oz)"
.AS
This document aims to be an exhaustive guide to the installation
of the ACSnet software from the distribution file.
It includes a detailed description for the configuration of the network.
It should be read with care,
and any deficiencies, additions, or modifications
notified to the author.
.AE
.OF "''V E R S I O N   %I%'\\\\*(DT'"
.EF "'\\\\*(DT'V E R S I O N   %I%''"
.MT 4
.SA 1
.H 1 INTRODUCTION
The ACSnet software distribution arrives as either a
.I tar
format, or
.I cpio
format file.
The contents of this file should be extracted\*F
.FS
Extract a \fIcpio\fP format file with the command \fBcpio -iumd <file\fP.
Extract a \fItar\fP format file with the command \fBtar xf file\fP.
.FE
into an appropriately labelled directory on a file system
with at least three megabytes of free space.
The basic source takes around one megabyte,
the extra two will only be needed during the installation process.
.P
There are many sub-directories created by the extraction process,
their contents will be explained below.
.P
There is only one file that you are going to have to edit
for the preliminary stage of compilation,
however,
there are other files that must be set up before the network will function,
so the best course of action is to make hard copies of all the manuals,
and the top-level
.I Makefile ,
and have them to hand during the installation process.
.H 2 "What's in a name?"
Just a brief comment on names.
While the name
.I ACSnet
appears frequently in this document,
it is used somewhat ambiguously to refer both to the
network of nodes that communicate with each other,
and also to the software used to do the communication.
The software should more properly be referred to as
.I "SUN\ III" .\*F
.FS
For ``Sydney UNIX Network, Version 3''.
.FE
The facts of the matter are that the network of Universities
whose departments use this software to communicate with each
other are participating in the
.I "Australian Computer Science Network" .
In the future other networks,
with even less to do with computer science,
will also use this software.
.H 2 "The name of your node."
Choosing the name of your node should be straight forward,
but there are a few rules you should bear in mind.
The name must be 15 characters or less,
and consist of letters from the set
.B [\-_A-Za-z0-9] .
It should also be unique amongst the nodes with which you will
exchange most of your network traffic,
and it must certainly be distinct
from any of the nodes that you will be directly linked to.
If your node is one of a group at a large site,
the name should also follow the convention
of starting with a few letters that identify your site.
.P
The decision may already have been made for you.
If your version of
\s-1UNIX\s0\*F
.FS
\s-1UNIX\s0 is a trademark of A.T.&T. Bell Laboratories.
.FE
supports a 
.I nodename
type system call,
such as ``gethostname'' in 4.2 \s-1BSD\s0
or ``uname'' in \s-1SYSTEM III\s0,
then you should use the name returned by the system.
.P
You may change the name of your node at any time.
You will need the cooperation of the managers at the nodes
that are directly connected to you, but the rest of the nodes
will find out about the change automatically,
as your new state information propagates through the network.
Be warned, though, that your users will object!
.H 2 "Installation should be easy."
You should read this document and follow the directions
as you go along,
then, by the time you reach the end of it,
you will also have the network up and running.
.H 1 HIERARCHY
The directory tree created by the distribution is described below.
There are only three real files in the top level:
.I \s-1BUGS\s0 ,
.I \s-1README\s0 ,
and
.I Makefile.dist .
The \s-1BUGS\s0 file contains a list of current known bugs
and suggested temporary fixes,
\s-1README\s0 tells you where to start, and announces any new features,
and Makefile.dist is the source for your Makefile.
The rest are all directories.
Where manuals have been provided,
they are referred to with the name in italics
followed by the section number in parentheses.
Some of the information contains unavoidable forward references
\(em for which, my apologies.
.H 2 Admin
This directory contains some programs to help administration that
were sent to me by various people in the belief that they might be useful.
There are various accounting scripts,
and useful programs like \fInetmail\fP and a sendmail configuration
for 4.2 \s-1BSD\s0 sites.
Glance through it when you get the time.
.H 2 Bin
This directory is not in the distribution, but will be created when
you first run the program
.I make .
It will hold all the binaries made, and also the libraries of sub-routines
common to many of the programs.
.P
The contents of this directory are removed
by the command
.ft B
make clobber
.ft P
which will also remove all the files produced during the compilation process.
A slightly less draconian clean-up can be produced by the command
.ft B
make clean\c
.ft P
, which will leave the contents of
.I Bin
alone, but remove all the compilation temporaries
(such as \fB.o\fP files).
.H 2 Control
This contains the source of the programs used for network control functions:-
.VL "\w'changestate.cXX'u"
.LI changestate.c
Invoked by the node-node daemon to signal a change-of-state in the link.
.LI dis.c
This is a management tool that can be used to turn
the repeated page output format of programs like 
.I linkstats
into minimally updated screen displays.
See
.I dis (1).
.LI linkstats.c
Used to watch the state of a set of links.
See
.I linkstats (1).
.LI purge.c
Cleans out the work areas which can fill up with lost/discarded temporary files
(especially when debugging!).
See
.I acspurge (1).
.LI recover.c
Used to recover messages dumped into the 
.I "too hard"
directory by handlers.
(Not completed yet.)
.LI request.c
Used to request a global statefile update from other network nodes.
See
.I acsrequest (1).
.LI rundaemon.c
Used to run the daemons for the permanent virtual circuits.
See
.I rundaemon (1).
.LI state.c
The
.I statefile
manipulation program. Used by
.I changestate
and
.I stater
to update the statefile,
but also of use to users and managers.
See
.I acsstate (1).
.LE
.H 2 Dirlib
Contains a distribution of a \s-1UNIX\s0
version independent set of
directory reading routines.
See
.I directory (3).
.P
.ne 6
.H 2 Documents
This directory contains the following documents:-\*F
.FS
Or will, one day.
.FE
.VL "\w'manage.mmXX'u+4" 4
.LI design.mm
A guide to the design of the software.
.LI domain.mm
A guide to the design, implementation, and use of domains.
Pre-process with
.I tbl (1).
.LI handle.mm
A manual on how to write a message handler,
and implement your own end-to-end protocols.
.LI install.mm
The very document you are now reading.
Pre-process with
.I tbl (1).
.LI licence.nr
A copy of the licence form for educational or research use.
Please fill it in and return it if you haven't already done so.
.LI manage.mm
A management guide for day-to-day running of the network.
.LI proto.ms
A description of the link-level protocol used by the node-node daemons.
Pre-process with
.I tbl (1).
.LI usenix.ms
A copy of the paper presented at the summer 1984 \s-1USENIX\s0 conference
at Salt Lake City, Utah, U.S.A.
.LE
.P
These are all written using the
.I mm (7)
or
.I ms (7)
macros for
.I troff (1).
Some of them require pre-processing with a combination of
.I pic (1),
.I eqn (1),
or
.I tbl (1),
as noted here, and in the first line of each document.
.H 2 ENproto
This is a protocol package
which assumes an underlying unreliable datagram service,
but where the datagrams, if delivered, have no bit errors
(eg: Ethernet).
.H 2 Handlers
These are all the network handlers, which are invoked to process
the contents of messages upon reception at a valid destination.
In particular, the program
.I receiver
is the one that makes all the routing decisions,
and invokes the other handlers.
It in turn is invoked by the node-to-node daemons whenever a message
is successfully received off a link. It is also invoked directly by
programs wishing to pump messages into the network, such as
.I sendfile .
.H 2 Header
Contains the source for the routines making up the library
.I Header.a
in the directory
.I Bin .
These routines manage the message headers.
.H 2 Include
All the
.I include
files that are used by programs.
.H 2 Lib
All the routines that are non-specific.
.H 2 Libc
Routines that ought to be in your standard C-library,
but may not be.
.H 2 Makefiles
This directory contains sub-makefiles
used by the main one in the directory above,
and also example \fIrun\fP commands for some standard configurations.
.P
\fIRun\fP commands pass all the configuration details to \fImake\fP
and avoid having to edit the Makefile itself.
They are \fIshell\fP scripts that invoke \fImake\fP
with an appropriate set of parameters.
If you have a standard configuration,
you may be able to choose one of these,
and avoid the \fIMakefile\fP editing stage described below.
If so, copy the appropriate one to the directory above,
and invoke it with the same parameters as you would for \fImake\fP.
.P
.I Install
and
.I Site
are just parts of the
.I Makefile
that have been separated out to allow
.I make
to work on small machines without running out of heap space.
The are invoked directly from the main
.I Makefile
and you don't need to worry about them.
.H 2 Manuals
The manuals for sections 1 through 8
of volume 1 of the standard \s-1UNIX\s0 manual.
These should be copied into your user manual directories (\c
.I /usr/man/*
?).
.H 2 NNcall
The source for the programs that deal with intermittent links
over public access networks.
See
.I NNcall (1)
and
.I NNshell (1).
.H 2 NNdaemon
The node-to-node daemons.
See
.I NNdaemon (1).
There are three daemons made from this source,
each making use of a different protocol.
.VL "\w'NNdaemonXX'u"
.LI NNdaemon
The standard stream protocol daemon.
Suitable for use on RS-232 and \fIdial-up\fP links.
It uses the protocol module in NNstrpr.
.LI CNdaemon
A node-to-node daemon tailored for CSIRONET.
It uses the protocol module in NNstrpr2.
.LI ENdaemon
A node-to-node daemon tailored for links
that provide an unreliable datagram service.
It uses the protocol module in ENproto.
.LE
.H 2 NNstrpr
The node-to-node stream protocol source.
See the document
.I proto ,
and the manuals
.I proto (3)
and
.I proto (5).
.H 2 NNstrpr2
This is an alternative version of
.I NNstrpr
which is more robust in the face of lines with bad dropout characteristics.
.H 2 Route
The routines that make up the library
.I Route.a
in the directory
.I Bin .
These routines access the
.I routefile
created by
.I acsstate (1)
to do routing functions.
.H 2 State
These routines make up the library
.I State.a
in the directory
.I Bin .
They manage access to the
.I statefile
and creating the
.I routefile ,
and are only called from the program
.I acsstate (1).
.H 2 Utilities
These are the user programs for accessing the network:-
.VL "\w'getfile.cXX'u"
.LI con.c
Only of use if you wish to allow real-time connections to other hosts.
Only works really well if you have the \s-1AUSAS\s0\*F
.FS
.I "Australian \s-1UNIX\s0 Share Accounting System"
developed at the Universities of Sydney and New South Wales.
.FE
system call
.I ttyconnect (2).
However, later amendments will allow it to work on 4.2\s-1BSD\s0 sockets.
.I Con
makes use of the
.I ACSnet
routing tables to select virtual circuits,
and virtual circuit establishment programs.
See
.I con (1).
.LI getfile.c
This program retrieves files received from the network.
See
.I getfile (1).
.LI queue.c
A program used to show network queue status.
See
.I acsq (1).
.LI send.c
The program that pumps messages containing files into the network.
See
.I sendfile (1).
.LI fetch.c
This is the rough inverse of
.I sendfile (1).
It is used to request that another site
send you files that they have made publicly
available.
See
.I fetchfile (1).
.LI stop.c
Used to stop messages waiting in queues.
See
.I acsstop (1).
.LE
.H 2 VMS
This directory contains a quick hack to interface to a dumb
mail transfer only facility on \s-1VMS\s0 systems.
It may or may not be of any use.
.H 1 "EDITING THE MAKEFILE"
Your first job will be to edit the site-dependent parameters in the file
.I Makefile.dist
in the top-level directory.
No other files in the distribution should need to be changed by you!
If this proves not to be the case,
please let me have details of the deficiency/bug as soon as possible.
Copy
.I Makefile.dist
to
.I Makefile
before you start editing.
.P
There are comments with each site-dependent
.I Make
parameter that might have to be changed,
but the following list attempts to be more verbose.
Each of these parameters is exported from the
.I Makefile
into a site-dependent
header file called
.I site.h
in the directory
.I Include .
.P
Most of the parameters should be defined. If they are numeric in type,
then their effect can be turned off by giving them the value \fB0\fP.
Some parameters that have 
.I string
values can safely be undefined by just commenting them out
(just insert the character \fB#\fP at the beginning of the line).
The text should make it all clear.
.P
The parameters are listed in the same order as you will find them in the
.I Makefile .
.H 2 "System Interfaces"
The first set of parameters are to do with the network's interface
to your kernel and to the file system.
Note that where these parameters appear in the rest of the document,
you should interpolate their values.
.P
.S -2
.VL "\w'\s-1IGNMAILERSTATUS\s0xx'u"
.LI \s-1NODE\s0
\s-1NODE\s0 is the local node name used to make the file
.I nodename
for systems that don't have the equivalent of the \s-1SYSTEM III\s0
system call
.I uname (2).
For node independence on systems that \fBdo\fP have a suitable system call,
it should be a shell invocation that returns the node's name,
eg: \fB\(gahostame\(ga\fP for 4\s-1BSD\s0 systems,
or \fB\(gauname -n\(ga\fP for \s-1SYSTEM\s0 III and above.
Otherwise, just make it the name of the node, eg: ``basser''.
.LI \s-1SPOOLDIR\s0
This should be the name of a directory
where all the network activity will take place.
It will contain all the messages that are
.I "in flight"
as well as the handler programs and network state files.
It should be somewhere safe,
where the integrity of the messages is least likely to be compromised,
(so try and avoid less than fully reliable disk drives).
The usual choice would be
.I /usr/spool/ACSnet .
.LI \s-1WORKFLAG\s0
This parameter should be set to a single character that will distinguish
.I work
directories from
.I link
directories in \s-1SPOOLDIR\s0.
Some of the directories in \s-1SPOOLDIR\s0
are the names of directly connected nodes.
These
.I link
directories contain command files
describing messages queued for that particular link.
This flag is used to distinguish these directories from the work directories
for the benefit of programs such as
.I linkstats
which must search \s-1SPOOLDIR\s0 for the names of links.
The usual choice would be \fB\(ru\fP (rule, or underbar).
Any non-\c
.I alpha-numeric
character will do,
but take care to choose one that is usable with the shell and
.I make .\*F
.S
.FS
For instance, some versions of
.I make
object to finding the character `\fB=\fP' in a name
which is to appear in a rule as a dependency of a target.
.FE
.S
.LI \s-1INSLIB\s0
This defines the place for the directory which will hold
the network data files and handler programs.
Normally it would be in \s-1SPOOLDIR\s0,
.ft I
viz.\ $(\s-1SPOOLDIR\s0)/\|$(\s-1WORKFLAG\s0)lib.
.ft P
.LI \s-1INSBIN\s0
The directory where user visible network programs are to be installed.
We use
.I /bin ,
on \s-1BSD\s0 systems
.I /usr/local
might be more appropriate.
.LI \s-1DEVNET\s0
The directory holding all the network special files.
The node-to-node daemons expect to find a special file providing
a virtual circuit to the remote node of the same name in this directory.
We use
.I /dev/net .
.LI \s-1CONSOLE\s0
This is the name of a device where the daemons can write error messages
for operator attention.
It could be
.I /dev/console
but be aware that the device must be writable by the daemon.
We use 
.I $(DEVNET)/console .
.LI \s-1NICEDAEMON\s0
If you wish the daemons to run at a non-standard priority,
then this parameter should be defined as for use in the
.I nice (2)
system call.
For instance, if you wanted the network to run only when there was
idle \s-1CPU\s0 time, then give it the value 20.
However, be aware that if you do this when the system is very busy,
then the link may appear to go up and down a lot.
On the other hand, we use a value of -11, which is not very nice at all.
A value of 0 is probably safe.
.LI \s-1NICEHANDLERS\s0
When a message arrives,
and is passed to the routing program to be processed,
this parameter will cause the handlers to be run at a different priority
from the daemon.
We use a value of 10, which is nice to users.
.LI \s-1ACSNETNAME\s0
This parameter, together with the ones ending in
.I ID ,
are used to define the account which the network will operate under.
It ought not to be
.I root ,
but should probably be recognised by the mail and possibly news programs
as a priviledged originator of mail.
.LI \s-1FUZZ\s0
.I FUZZ
and
.I NCC_MANAGER
are the names of people to whom network generated error reports are sent.
At least one of them must be defined.
.I FUZZ
is by preference a local network wizard, or possibly
.I root .
You may use the network address
.ft B
acsnet@basser.oz
.ft P
for 
.I NCC_MANAGER
which will mean that I can spot the problems and fix them
without you having to tell me about them first.\*F
.S
.FS
On the other hand, it might not, but you get the general idea.
.FE
.S
.LI \s-1ASSEMBLER\s0
At the moment, this parameter is only of use if you have an MC68000 system.
It affects conditional compilation in the one and only file in the distribution
containing assembler code,
.I Lib/crc.c .
The problem is that there are several flavours of assembler in use
for these chips, so you will have to see what you've got, and choose
something appropriate. You may even have to add code for your particular
system \(em if so, please let me have a copy for inclusion in the next release.
So far, all the flavours of assembler outside Bell Laboratories seem to use
an assembler syntax compatible with the \s-1SUN_68K\s0 version.
.LI \s-1FILESEXPIREDAYS\s0
After files have been spooled at a site for delivery to a local user,
the user is notified by mail that the files have arrived,
and warned that the spooled files will be deleted
after a certain number of days.
This is where you specify that period.
It is effected by a periodic command run by
.I cron (1),
see the section
.I Maintenance
for more details.
.LI \s-1VMS_NET\s0
If you are connected to sites running the \s-1VMS\s0 operating system,
and have decided to use the mail interface code supplied in the directory
\s-1VMS\s0,
then this parameter should be set to be the path name of a spooling program
that will accept messages from the ACSnet_VMS gateway handler.
.LE
.S
.H 2 "Service Programs"
This introduces a set of parameters to do with \s-1UNIX\s0
programs that will be invoked by
.I ACSnet
handlers to to do things with the contents of messages.
The parameters specify both the names of programs,
and the format of any special arguments
that will need to be passed to them on invocation.
There are some macros that can be used inside arguments
to interpolate fields from the message being processed by the handler,
they are all identified by the special character \fB&\fP\|:-
.P
.VL "\w'&Wxxxx'u+.25i" .25i
.LI &D
.I "Data name" .
The name of the data in the message.*
.LI &F
.I From .
The name of the sender of the message.*
.LI &H
.I Home .
The name of the destination host (on which the program is being invoked).
.LI &L
.I Link .
The name of the link on which the message arrived.
.LI &O
.I Origin .
The name of the host from which the message originated.
.LI &U
.I User .
The name of the user to which the message is being delivered.*
.LI &&
If you really need to interpolate just an \fB&\fP\|!
.LE
.P
Those marked with an asterisk are only valid for messages containing \s-1FTP\s0.
.P
Arguments should be specified just as though you were listing them inside
a C program function invocation, eg: to pass two arguments to a program,
the first the name of the sender, and the second the name of her host,
you might specify
.P
.ce
.ft B
.S -1
ARGS = "-u&F\^","-h&O\^"
.S
.ft P
.P
Note the use of double-quotes.
.P
.S -2
.VL "\w'\s-1IGNMAILERSTATUS\s0xx'u"
.LI \s-1BINMAIL\s0
This defines the name of the program that will be used to deliver
mail generated internally by the network, eg: acknowledgements of
correctly delivered files, or error reports to the
.I FUZZ .
It must be able to read the body of the mail text from its standard input,
and to accept many user addresses as arguments
(after any special arguments mentioned in \s-1BINMAILARGS\s0 below).
.I /bin/mail
should always work.
.LI \s-1BINMAILARGS\s0
If you have a version of mail that understands about interpolating the
origin host address in the mail item, then this is where you tell it what to do.
At Basser, where we use a version of mail developed locally,
we use the argument \fB-n\fIuser\fB:\fIhost\fR
to tell mail that we wish the item to appear to come
from someone other than the invoker;
.br
ie: we set \s-1BINMAILARGS\s0 to be "\fB-n&F:&O\fP".
.LI \s-1MAILER\s0
This defines a program that will be used to deliver mail
received off the network, ie: from users at other hosts.
It must behave in the same way as \s-1BINMAIL\s0 above,
and again, 
.I /bin/mail
should always work.
However, if you have a special program used just for
.I delivering
mail, then this is the place to specify it.
.LI \s-1MAILERARGS\s0
If \s-1MAILER\s0 needs to be told where the mail originated,
then it can be specified in this argument,
much the same as for \s-1BINMAILARGS\s0 above.
.LI \s-1IGNMAILERSTATUS\s0
Some delivery programs, notably
.I sendmail
from 4\s-1BSD\s0,
return non-zero exit status, even when they have done something sensible
with the mail item.
In this case, the handler would normally assume that something went wrong,
and return the mail item to its origin with an appropriate error message,
but you can suppress this action by defining this flag to be \fB1\fP.
In which case, you must be perfectly sure that your delivery program will
always do the right thing!
.LI \s-1VALIDATEMAIL\s0
In contrast to the above, some mail delivery programs are guaranteed to
fail\*F
.S
.FS
Dump a
.I core
file, or write a
.I dead.letter
file.
.FE
.S
if the destination user doesn't exist, in which case the handler
might as well check first that the user exists in the password file.
You can force this check to happen by defining this flag to be \fB1\fP.
.LI \s-1MAIL_FROM\s0
If your version of \s-1MAILER\s0 does not correct the ``From'' line
using the information from \s-1MAILERARGS\s0,
then setting this to \fB1\fP
will enable the mail handler itself
to add a standard \s-1UNIX\s0 mail header.
.LI \s-1MAILGROUPS\s0
At Basser we have a mail 
.I aliasing
facility based on the presence of a program with the name of an otherwise
non-existent user in the directory named in this parameter.
This parameter needs to be defined if \s-1VALIDATEMAIL\s0 is defined to prevent
.I aliased
names being rejected.
All other sites can safely leave this parameter undefined.
.LI \s-1POSTMASTER\s0
This must be set to be a name that messages returned from your node
may legally be sent to in the case of the origin also returning them.
If your mail program doesn't recognise anything special such as
\s-1POSTMASTER\s0, then this must be the name of a real user.
.LI \s-1PRINTER\s0
The name of the program used to spool print jobs from the network.
Leave it undefined if this host has no printer,
or if you have no intention of letting other sites print their jobs here.
(But see \s-1PRINTORIGINS\s0 below.)
.LI \s-1PRINTERARGS\s0
Any arguments for \s-1PRINTER\s0.
.LI \s-1PRINTORIGINS\s0
If you \fBdo\fP define \s-1PRINTER\s0, then you will need to restrict
the sites from which you are prepared to accept print jobs.
This parameter can be either the full path name of a file
containing a list of legal network origins for print jobs
(which is preferable for site independent network binaries),
or just an explicit list of sites.
Use C strings in both cases.
Eg: a file \(em
.ft I
"\^$(INSLIB)/\^printorigins",
.ft P
or a list \(em
.ft I
"basset\^","basser40".
.ft P
.LI \s-1PRINTSITES\s0
If you wish to allow users to send print jobs to other sites,
then you should define this parameter to restrict the sites to which they
may transmit. Use the same formats as for \s-1PRINTORIGINS\s0.
If it is undefined, then print jobs can not be generated.
.LI \s-1NEWSEDITOR\s0
If you participate in the
.I netnews
system,
this argument specifies the news receiver program to be invoked by the handler
.I reporter .
For the standard netnews software,
this should be set to
.ft B
/usr/bin/rnews.
.ft P
For the news system distributed by U.N.S.W.,
this should be set to
.ft B
/usr/lib/postnews.
.ft P
.P
.LI \s-1NEWSARGS\s0
Any arguments for \s-1NEWSEDITOR\s0.
.LI \s-1NEWSCMDS\s0
This should be the name of a file which is used by
.I reporter
to provide the full pathname of a news command and any extra arguments.
This can safely be ignored until you become a sophisticated news gatherer,
but could be
.ft I
"\^\s-1INSLIB\s0/\^newscmds".
.ft P
The file should contain lines of the form:
.P
.DS 1
command\fI<tab>\fPfull_path_name[\fI<space>\fParg ...]
.DE
You should consult with your news neighbours to determine
the necessary commands to install here (if any).
.LI \s-1SVRHOST\s0
This should only be set if you want to set a default host
for
.I fetchfile
requests (but see the section entitled \fIActing As A Fileserver Node\fP).
.LI \s-1PUBLICFILES\s0
If you wish to allow others to retrieve files from
your system with the
.I fetchfile
command, then you should define this.
It can be set to the name of a directory
that will contain the publicly available
files (and directories containing publicly
available files and directories).
An example might be $(\s-1SPOOLDIR\s0)/\|$(\s-1WORKFLAG\s0)public.
Alternatively, you can define
.I \s-1PUBLICFILES\s0
to be the name of a file that contains more
specific details of precisely who may access
which files.
Typically this would be $(\s-1INSLIB\s0)/\|publicfiles.
This file contains lines of the following form
.DS 1
[<user>@]<host>\fI<tab>\fP[full_path_name]
.DE
.ds St \fB\v'0.3v'*\v'-0.3v'\fP
.ds Us <\fIuser\fP>
.ds Ho <\fIhost\fP>
Either \*(Us or \*(Ho may be \*(St,
which implies any user (or host).
A missing \*(Us implies
any user at the specified host (as does \*(St.)
.P
.I Fileserver
reads this file, forwards, looking for a match of user and host
with those of the user who requested files.
The first line that matches (ie: the first line for
which either the \*(Us part is the name of the remote
user, or is missing or \*(St, and the \*(Ho part is
either the name of the remote host, or is \*(St)
ends the search.
The
.I full_path_name
on that line is used as the name of the directory containing
files that this particular user may access.
If no line in
.I \s-1PUBLICFILES\s0
matches, or if the line that does match does not
contain a
.I full_path_name,
then the remote user is denied access.
.P
In any case, users are permitted access to files relative
to the final directory only, and may not use a path that
commences with \fB/\fP, or that contains `\fB.\^.\fP' anywhere within it.
.LI \s-1SERVERUSER\s0
If
.I \s-1PUBLICFILES\s0
is defined, then you may further restrict access
by defining
.I \s-1SERVERUSER\s0
to be a login name provided by your
system precisely for this purpose.
That is, you should create a new user name
in your password file, typically called
.I fileserver
who is prevented from logging in, and who
never owns any files.
If you already have such a user for other
purposes, using it should be fine.
.I \s-1SERVERUSER\s0
should be defined to be this user name.\*F
.S
.FS
Note: some systems limit the number of characters
in a login name (typically to 8).
This restriction is not important here, as
that restriction relates to the
.I login
program, which this particular user
should never use.
However, it might be wise to observe the
restriction if it does exist, as other
system utilities, such as
.I ls ,
have been known to make similar assumptions.
.FE
.S
.I Fileserver
will set its
.I uid
to be that of this user before accessing any files,
only those files that this special user has normal
\s-1UNIX\s0 access premissions to read will be
able to be accessed.
.P
It is strongly recommended that if you
have defined
.I \s-1PUBLICFILES\s0
then you also create such a user, and
define
.I \s-1SERVERUSER\s0 ,
otherwise
.I fileserver
will run as
.I root,
which is probably not a good idea.\*F
.S
.FS
While the security checks in
.I fileserver
are tight, there are no guarantees
that they are impregnable.
.FE
.S
.LI \s-1SERVERGROUP\s0
This provides a similar facility, to
.I \s-1SERVERUSER\s0
with the obvious difference that
the name defined should be the name
of a newly created group, and is
used to set the
.I gid
of fileserver.
Note: \s-1AUSAS\s0 systems\*F
.S
.FS
See below.
.FE
.S
do not use groups in the same way, and this
definition is not used.
Instead, the group defined in the
password file for
.I \s-1SERVERUSER\s0
is used.
.P
Usually, a group called
.I fileserver
will be created for this purpose.
If
.I \s-1SERVERGROUP\s0
is not defined, and this is not an \s-1AUSAS\s0 system,
.I fileserver
will run with the same group id as
.I NNdaemon .
.LE
.S
.H 2 "System Dependancies"
The next set of parameters are to do with the peculiarities of your
particular version of \s-1UNIX\s0.
Some of these are inter-dependent on most systems,
but may be isolated additions on others.
The software is written assuming a basic Bell Level 7 \s-1UNIX\s0 system,
and these parameters allow for extra
.I features 
provided by later versions.
They all take numeric values,\*F
.FS
Except for \s-1BSD4V\s0 and \s-1SYSLIBS\s0.
.FE
and will be used as arguments in C pre-processor \fB#if\fP lines,
so set them to \fB0\fP to nullify them.
.P
.S -2
.VL "\w'\s-1IGNMAILERSTATUS\s0xx'u"
.LI \s-1AUSAS\s0
Refers to your system having the features of the
.I "Australian \s-1UNIX\s0 Share Accounting System" .
This flag makes the network cognizant of the different
.I passwd
file accessing routines provided by this system.
A value of \fB1\fP turns it on.
.LI \s-1AUTO_LOCKING\s0
Also a part of the \s-1AUSAS\s0 package,
a value of \fB1\fP means that the
.I auto-lock
file type exists.
.LI \s-1BSD4\s0
This flag should have the value of the first number after the decimal point
of your Berkeley 4th. distribution. eg: 2 for 4.2\s-1BSD\s0.\*F
.S
.FS
If you have 4.1z\s-1BSD\s0, define this parameter as for 4.2\s-1BSD\s0.
If you have 4.0\s-1BSD\s0 (really?),
setting this parameter to 0 will do all the right things.
.FE
.S
.LI \s-1BSD4V\s0
If you have the beta-test-site distribution of 4.1c\s-1BSD\s0,
set this flag to be \fBc\fP.
.LI \s-1FCNTL\s0
\fB1\fP if your system has the 
.I fcntl (2)
system call
(ie: not 4.1? \s-1BSD\s0).
.LI \s-1FLOCK\s0
\fB1\fP if your system has the \s-1BSD\s0
.I flock (2)
system call.
.LI \s-1GETHOST\s0
\fB1\fP if your system has the \s-1BSD\s0
.I gethostname (2)
system call.
.LI \s-1KILL_0\s0
\fB1\fP if a signal value of 0 can be passed legally to the system call
.I kill (2)
in order to interrogate for the existence of a process.
True in \s-1SYSTEM III\s0*, and in 4.2\s-1BSD\s0.
.LI \s-1MUSH\s0
\fB1\fP if your system has the Melbourne
(4\s-1BSD\s0)
.I privs
stuff, and you want to use it to restrict network access.
.LI \s-1PRINTF_NULLS\s0
\fB1\fP if your
.I stdio
library allows the interpolation of nulls into strings
.br
(as in
.ft I
sprintf(str, "one\s-1%\s0\^ctwo", '\^\\0'); strlen(str) =\|= 3\c
.ft P
).
.LI \s-1OLD_CC\s0
\fB1\fP if you have a version of the C-compiler that doesn't understand
.I "unsigned\ char"
or 
.I void .
.LI \s-1PGRP\s0
\fB1\fP if your kernel supports the
.I setpgrp (2)
system call as per \s-1SYSTEM III\s0.
\fBNot\fP true for 4.2\s-1BSD\s0.
.LI \s-1SPRF_SIZE\s0
\fB1\fP if the
.I printf (3)
routines return the number of bytes output.
(As in the \s-1SYSTEM III\s0
.I stdio
library.)
.LI \s-1SYSLIBS\s0
Should be set to any extra system libraries that need to be searched by
.I ld (1).
For \s-1MUSH\s0 systems, this should be
.ft B
-lpriv.
.ft P
.LI \s-1SYSTEM\s0
Set this flag to be the version of the Bell \s-1SYSTEM\s0 that you are running,
\fB0\fP otherwise.
Eg: \fB3\fP for \s-1SYSTEM III\s0, \fB5\fP for \s-1SYSTEM V\s0, etc.
.LI \s-1UNAME\s0
\fB1\fP if your kernel supports the \s-1SYSTEM III\s0
.I uname (2)
system call.
.LI \s-1UNISOFT\s0
\fB1\fP if your kernel has the Unisoft 
.I locking (2)
system call.
.LI \s-1UUCPLOCKS\s0
\fB1\fP if you run
.I uucp
and you want compatible locking on devices.
.LE
.S
.H 2 "Conditional Compilation"
These parameters are all optional,
and affect the speed or memory usage of some programs.
They should be set to \fB1\fP if you want their effect,
\fB0\fP otherwise.
.P
.S -2
.VL "\w'\s-1IGNMAILERSTATUS\s0xx'u"
.LI \s-1ALL_COMMENTS\s0
It is possible to keep the node descriptions provided by state messages
from other nodes. This makes the statefile larger, but provides useful
information.
.LI \s-1CRC_HASH\s0
If your \s-1CPU\s0 supports a 
.I crc
instruction, then this parameter turns on use of 
.I crc
as a hashing function;
it is probably not worth the extra \s-1CPU\s0 time otherwise.
.LI \s-1KEEP_FGN_SUB_D\s0
For those of you who wish to see as much of the world as possible,
this option allows the statefile to retain knowledge of foreign sub-domains
whose names are unique.
Otherwise, these domains are removed,
and also any node which has one of them as a primary domain.
This makes the statefile much smaller, and cheaper to manage,
so don't select this option if you have a 16-bit \s-1CPU\s0.
.\" Piers - you should say (more clearly) what advantage
.\" it is to anyone to have this defined.
.LI \s-1LINK_STATS\s0
This one covers the accumulation in the statefile of link statistics,
ie: how many bytes were transferred across each link, and in what time.
Useful for seeing the effective throughput of links,
but it makes the statefile bigger.
.LI \s-1LOCALSEND\s0
If you wish to allow users to send files to others on the same
node without doing a permission check.
.LI \s-1LOG_RETURNED\s0
This causes the routing program to log all messages returned.
The log consists of passing the returning message and its error status
to the 
.I badhandler
which will in turn mail a message to the \s-1FUZZ\s0 about it.
.LI \s-1LOG_STATE\s0
Keeps track of the last state update message from each host
in the directory \s-1STATEDIR\s0.
Only of use in network de-bugging.
.LI \s-1NODE_STATS\s0
If you are going to want to keep statistics on nodes in your statefile,
then turn on this one.
The effects can be viewed with the
.I acsstate (1)
program, but it makes the statefile bigger.
The relevant statistics cover the number of bytes transferred
directly to/from,
or passed to/from,
each node.
.LI \s-1PROTO_STATS\s0
This forces the inclusion of code for collecting packet statistics
in the protocol routines.
If there,
then the node-to-node daemons print out the information on termination.
.LE
.S
.H 2 "Kernel Parameters"
Some kernel magic numbers are in non-standard places on all versions
of \s-1UNIX\s0, so here is where you get to dig them out.
.P
.S -2
.VL "\w'\s-1IGNMAILERSTATUS\s0xx'u"
.LI \s-1PBUFSIZE\s0
This should be set to the size of the buffers in the file system buffer cache.
Note that this is not necessarily the same as 
\s-1BUFSIZ\s0 in the include file
.I stdio.h .
``512'' should be adequate,
but if buffers are 8K in your system,
then setting this appropriately will improve throughput.
.LI \s-1VCBUFSIZE\s0
Setting this to an appropriate value, say 1024,
will turn on virtual circuit input bufferring for the daemon.
This is helpful on fast virtual circuits,
such as those created using TCP on Ethernets.
.LE
.S
.H 2 "Machine Peculiarities"
These parameters are to do with peculiarites of the machine architecture
that affect parameter processing
in routines with variable numbers of parameters in the 
.I Lib.a
library.
If your machine is peculiar,
you may have to look at the use of these macros in the file
.I Include/global.h
for ideas on what to change them to.
.P
.S -2
.VL "\w'\s-1IGNMAILERSTATUS\s0xx'u"
.LI \s-1STACK_WORD\s0
This should be set to indicate the width of the stack
maintained by the C-compiler.
.ft B
char\ *
.ft P
covers all cases so far.
.LI \s-1STACK_DIR\s0
Actually, the direction that arguments are
.I popped
off the stack.
\fB++\fP
covers all cases so far.
.LE
.S
.H 2 "User Visible Program Names"
You can choose what to call the programs that are going to be part
of the user interface to the network.
The sensible names to use are the ones in the manual entries as distributed.
However this section is for those of
you with an aesthetic sensibility appalled by the official choices.
Remember that if you do change the names, then you should also
fix up the manual entries to reflect your new choices.
If you elect not to have the program
.I con
in your system, then undefine the parameter \s-1CON\s0.
.H 2 "Compilation Control"
This section should be familiar to people who have already grappled
with the
.I make
program. 
There are two sets.
.P
\s-1CFLAGS\s0 and \s-1LDFLAGS\s0 should be set to be appropriate
options for your C-compiler and link-loader.
\fB-O\fP for the C-optimiser and \fB-n\fP for shared-text from the loader
should be generally applicable.\*F
.FS
If your \s-1CPU\s0 is a \s-1PDP\s0-11 with
.I "separate I & D space" ,
specify the \fB-i\fP loader flag also.
.FE
\s-1DEBUG\s0 can be null, or can be set to be either
.ft B
\s-1-DEBUG=1\s0
.ft P
which will include some error detection and code for issuing
.I reports ,
or to be
.ft B
\s-1-DEBUG=2\s0
.ft P
which will enable yet more code for doing 
.I traces
(which will enable all the programs to produce trace output when the
\fB-T\fP flag is used).
\s-1CONFIG\s0 can be used on the command line for
.I make
to pump
in circumstantial parameters.
If your \s-1CPU\s0 is a Motorola 68000 series,
and the C compiler pre-processor doesn't define the name 
.I mc68000
then \s-1CONFIG\s0 should be set as follows:
.P
.DS 1
.ta +2i
\s-1CONFIG\s0 = -Dmc68000	# define the \s-1CPU\s0 type
.DE
.P
The second set are the names of programs used by 
.I make 
to do its work.
For instance,
.I chown (1)
and
.I mknod (1)
often seem to live in peculiar places.
The only complex choice is the specification of the program
that will create a locking file (in \s-1MKLOCK\s0).
On \s-1AUSAS\s0 systems, this is done with the program
.I mknod (2)
and a file type of \fBa\fP,
which is specified in the parameter \s-1MKLOCKTYPE\s0.
On all other systems, 
\s-1MKLOCK\s0 should be set to be something like
.I touch (1)
which will just create an ordinary file,
and the parameter \s-1MKLOCKTYPE\s0 should be null.
The actual locking is then taken care of by code conditional
on the \s-1UNIX\s0 version parameters.
.P
If a program doesn't exist,
or you wish to cancel its effect,
use a variation on one of the following assignments:-
.P
.DS 1
.ta +2i
\s-1STRIP\s0 = :	# do nothing
\s-1STRIP\s0 = : strip	# show what you are not doing
.DE
.P
The exceptions to this rule are the programs for pre-sorting libraries,
.I lorder (1)
and 
.I tsort (1).
If they don't exist then you should cancel them as follows:-
.P
.DS 1
.ta +2i
\s-1LORDER\s0 = echo	# just echo the arguments
\s-1TSORT\s0 = cat	# just copy input to output
.DE
.P
Of course the program
.I ranlib (1),
(which doesn't exist in \s-1SYSTEM III\s0 or \s-1SYSTEM V\s0),
then becomes essential!
.\" I believe that V.2 'ar' comand altomatically does 'ranlib'
.\" if its given .o files, so it would be possible to have
.\" none of LORDER TSORT or RANLIB.  AT&T's cat -v ??
.H 1 "SYSTEM BUGS"
In this section we discuss a few well known system bugs that may
plague your installation.
Not all systems have them,
but if they exist they will all
cause \fBmake\fP to fail in one way or another.
.P
If
.I ranlib
does not exist on your system,
be warned that not all versions of 
.I lorder
and
.I tsort
do a proper sort;
if you get undefined global errors at
.I ld (1)
time,
you will need to re-arrange the library concerned by hand with judicious
applications of the command
\fBar ma ...\fP
(see
.I ar (1)).
.P
On the other hand,
there is a well known bug in
.I ranlib
when the number of symbols in the existing library
\fB_\|_.\s-1SYMDEF\s0\fP entry
just happen to make the first word \fB=\|= 0408\fP.
.I Ranlib
will fail with a message about ``old fashioned archive format'',
and the only solution is to remove the offending library and try again.
.P
If you have 4.1z\s-1BSD\s0 or 4.2\s-1BSD\s0 with \s-1MUSH\s0 defined,
and your \fB<udata.h>\fP doesn't have \s-1NET_SU\s0 in \fBenum u_priv\fP,
then it can simply be added
(just before the terminator).
.P
On small machines, 
(with small address spaces),
.I make
may fail with the message
``too many env parameters''
\(em try stripping the environment as in
.B "env - make certain" .
.P
The Gould system manual suggests that
.I "kill(pid, 0)"
is legal \(em but the Gould kernel disagrees.
You should define \s-1KILL_0\s0 to be \fB0\fP for these machines.
.P
If you are running an U.N.S.W. version of \s-AUSAS\s0,
and \fIctime\fP is undefined,
get a real \fIctime\fP off some friendly non-UNSW site,
and install it in your C-library.
.H 1 "MAKEFILE TARGETS"
Now we can get serious.
The default 
.I make
target,
.I all ,
will make the 
.I Bin
directory,
set up the
.I site.h
file, then make the libraries followed by all the programs.
.P
Try it.
.P
If you need to re-do anything, then
.ft B
make\ certain
.ft P
is the target that will force a re-load
of any libraries that might have changed.
You shouldn't use
.ft B
make\ all
.ft P
again, it probably won't do very much as it only knows
how to make targets that don't already exist in the directory
.I Bin .
.P
Finally,
.ft B
make\ directories\ special\ install
.ft P
will set up all the work directories,
create some network data-base files,
and install all the binaries.
The actual
.I makefile
involved with implementing these targets is called
.I Install .
Read it if you want.
Then do it.
.P
If you wish to make a listing at any stage, then try
.P
.DS 1
.ft B
make \s-1PRFORMATTER\s0=pr \s-1PRSPOOL\s0=lpr print
.ft P
.DE
.P
or some variation thereof.\*F
.FS
The last time I tried this,
it used slightly under 1000 pages of 66 line paper.
.FE
.H 1 DOMAINS
A brief discussion of domains and their configuration is necessary.\*F
.FS
But read the paper on domains first.
.FE
One of the reasons for the introduction of domains is to reduce the number
of nodes that must be remembered in the statefile.
A lot less information is needed to remember the route to a domain,
than to remember the routes to all the members of that domain.
This is brought about if all those nodes which are essentially local
workstations are relegated to site specific domains.
Knowledge of the local nodes will not appear in the statefiles of
nodes at other sites,
yet they may still be addressed explicitly by appending the domain
name (which \fBis\fP known) to the node name.
There is another advantage \(em you may choose node names that aren't
unique across the whole network,
yet which become unique when the domain is included in the address.
In fact, nodes are just special cases of domains,
so domains themselves also conform to this rule,
ie:- domain names can be made unique in a wider context
by appending the name of an encompassing domain.
.P
Domains are not necessarily hierarchical,
but for practical reasons there will be many domains entirely contained
within larger ones.
For instance,
there may be a domain called ``cs''
(for Computer Science)
at both Sydney and Melbourne Universities.
They are different domains,
one being contained within the domain ``su''
(for Sydney University)
and the other within the domain ``mu''
(for Melbourne University).
They are distinguished from each other in addresses by appending
the enclosing domain name,
as in ``cs.mu'' \(em the Computer Science Department at Melbourne University.
The same argument applies to distinguishing identical node names which
are in different domains,
eg: ``elecvax.unsw'' and ``elecvax.su''.
Of course, when addresses are being used within a context where a node
(or domain) name is unique,
there is no need to add any other domain information:-
within the University of New South Wales, 
the address ``elecvax'' clearly means the local one;
within the University of Melbourne,
the domain address ``cs'' finds the local Computer Science Department.
However in order to allow nodes to reject foreign
.I internal
domains, the local hierarchy must be fully specified.
.P
.I Nodes
and
.I domains
do not share the same address space,
so a node may have the same name as a domain.
.P
There are a few rules to consider when configuring domains for a node.
A node may belong to as many domains as necessary,
but the
.I first
domain named is important.
It becomes the
.I primary
domain for the node,
and essentially declares the largest addressing area in which the node
will be directly addressable (without having to append a domain name).
.P
.DS 0 1
.TS 
center ;
lw(5i) .
T{
The first rule is that the primary domain of a node
should be the smallest domain that encompasses all the nodes
to which it is directly connected.
.\" is this still true ??  Isn't it legal now for two
.\" nodes who don't share domains to be connected ??
To put it another way,
all the links to a node should be members of its primary domain,
or of a domain below the primary domain in the local hierarchy.
T}
.TE
.DE
.P
If the primary domain chosen is larger than necessary,
then information about the node will appear in more places than necessary,
and will incur unnecessary overheads for other nodes.
However,
this rule need not necessarily be followed,
as in the case of nodes connected
across international boundaries.
.P
.DS 0 1
.TS 
center ;
lw(5i) .
T{
The second rule is that the name of a node must be unique
in all the domains to which it belongs.
Also, of course, the name of a domain must be unique within any
encompassing domain.
T}
.TE
.DE
.P
.DS 0 1
.TS 
center ;
lw(5i) .
T{
The third rule is that a node should only belong to a domain
if all the other members of that domain can be reached internally.
That is, if another node exists belonging to the same domain,
then it should be reachable from yours without having to go
via a node that is not a member of that domain.
T}
.TE
.DE
.P
The domain encompassing all of the sites running
.ft I
SUN III
.ft P
in Australia is called ``oz''.
So, if your node is linked to other nodes outside your site,
your primary domain should probably be ``oz''.
On the other hand,
you may wish your node to
.I see
the names of nodes in other domains to which you may legally belong,\*F
.FS
Which has the effect of allowing your users to address these nodes directly.
.FE
and this is achieved by adding these domain names as secondary ones.
Most of the sites in the network are participating in 
.ft I
ACSnet,
.ft P
for which the chosen domain name is ``acsnet''.
.P
In our case,
our local domain is called ``cs''
(for ``Computer Science'').
We are part of Sydney University,
for which we have chosen the domain name ``su''.
We have nodes that are local to the department whose
.I primary
(and only)
domain is therefore ``cs'',
Some of the local nodes also wish to know about the rest of the network,
so they include either the domain ``su'',
or both the domains ``su'' and ``oz'',
as secondary domains.
However,
the main nodes communicate with other organisations,
and so their primary domain is ``oz'',
and their secondary domains are ``cs'', ``su'' and ``acsnet''.
Finally,
we specify that the local domain hierarchy is ``cs.su.oz'',
(note that the order is such that each domain named is fully contained
within the successor domain).
In fact,
all sites in Australia should have a hierarchy ending in ``.oz'',
or, to put it more generally,
the domain denoting your country should always be the last domain
mentioned in the hierarchy,
whether or not you include it in the list of domains your node belongs to.
Think of the hierarchy command as specifying the full 
.I postal
address of the node.
.P
If this explanation is opaque,
remember that the default
(no domain at all)
will make your node visible to the whole network.
.\" I still wish this could be changed, so default == local node (like before)
Your only cost will be that your statefile and routing tables will be larger,
and their management will consume more \s-1CPU\s0 cycles,
than if you had chosen a smaller domain.
Also, of course, other nodes in the global domain may object to your
possibly unnecessary intrusion into their statefiles,
and the resulting overhead of managing your irrelevant details.
.P
In general you should choose your domains
in consultation with the managers of neighbouring nodes,
because each of the nodes directly linked to you
should belong to one of your domains,
and you to one of theirs.
.H 1 COMMANDSFILE
You must now create the file
.I commandsfile
in \s-1INSLIB\s0 to control the behaviour of the program
.I acsstate (1).
You need not do this,
but you should at least execute these commands once,
as otherwise the network has to assume
that your node is to be globally known with no descriptive details or domains.
.\" well, not really, you could run acsstate -C <file (/dev/tty ??) once.
Please mark all your
.I workstations
as
.I local ,
it will reduce the size and number of broadcast routing messages
on the network considerably,\*F
.FS
.I Local
nodes only exchange routing information with directly connected nodes.
.FE
and reduce the size of other sites'
.I statefiles .
Best of all is to define a
.I domain
to which all your local nodes may belong,
and then only the nodes which communicate with the outside world
need belong to more widely known domains.
There is then a secondary effect for nodes marked
.I local ,
which is that outgoing messages are restricted to addresses
in the primary domain of the sender.
.P
The 
.I acsstate
commands that you put in
.I commandsfile
give you total control over the information that appears in your
network
.I state
and
.I routing
tables.
You can give a description of your node that will be seen by all
other hosts, control the choices made by the routing algorithm,
suppress or encourage the knowledge of particular links that
will be seen by the rest of the world, and tell the network
how to handle any special gateways that you are connected to.
You should now read the
.I acsstate (1)
manual, a couple of times.
.P
Here is a sample 
.I commandsfile
from the node ``basser''.
It is long and complex, but if you manage to understand it,
then you will have mastered most of the possibilities.
It is split into fragments, with comments after each one.
.br
.ne 10
.H 2 "The local node"
.S -2
.DS 1
.ta +0.75i +.25i +1.8i
#
#	Configure this node
#
comment		basser			Sydney Uni. Basser Research VAX-11/780
flag		basser			-local,-term
domain		basser			oz,acsnet,su,cs
hierarchy		cs.su.oz
.DE
.S
.P
First thing to notice is that the character \fB#\fP introduces a comment
extending to the end of a line.
Then we give our node a 
.I comment
that will be exported to all other nodes
as descriptive information on this one.\*F
.FS
Make this as global as possible,
eg. there are many ``electrical engineering'' departments out there!
.FE
Then the status of the node is configured with the command
.I flag .
\fB-local\fP means that we wish that knowledge of this node
be unrestricted.
\fB-term\fP (short for
.I -terminal\c
), means that this node will allow both types of
.I "through traffic" ,
messages and virtual circuits.
The individual types are controlled explicitly with the flags
.I msgterm
and
.I conterm .
Note that flags can be abreviated
to the shortest string that can distinguish them.
Notice also that the effect of a flag is turned off
by preceding it with a minus sign,
otherwise its effect is turned on.
.P
Next is the
.I domain
command to configure the domains that this node is in.
The first one, ``oz'',
is important.
It is the
.I primary
domain for this node and should be the smallest domain that includes
all the nodes to which this node is directly linked.
.\" again, this might need slight revisions, this is no longer
.\" really required is it?  With the section on domains above,
.\" and the domains paper, is it necessary at all to explain
.\" again here what a primary domain is ??  (But explaining
.\" again that the first one is the primary probably is a
.\" good idea - make sure it sinks in!)
In our case,
``basser'' communicates with nodes outside Sydney University,
as well as being connected to other nodes inside the University,
so the other domains mentioned,
``cs'', ``su'' (for Sydney University) and ``acsnet'',
are only 
.I secondary .
Finally,
we specify that there is a local domain
.I hierarchy
with the ``hierarchy'' command.
It says that the domain ``cs'' is entirely contained within the domain
``su'', which is in turn entirely contained within the domain ``oz''.
Then if some other site (outside ``su'')
invents its own domain called ``cs'',
it won't bother us.
.H 3 "A local node."
``Basser'' is not a
.I local
node,
so as an example,
here are the first four commands from the
.I commandsfile
for our node called ``graphics''.
.S -2
.DS 1
.ta +0.75i +.25i +1.8i
#
#	Configure the node ``graphics''
#
comment		graphics		Graphics Workstation PDP-11/34
flag		graphics		local,msgterm,-conterm
domain		graphics		cs
hierarchy		cs.su.oz
.DE
.S
You can see that ``graphics'' is an entirely local affair.
Knowledge of it will be restricted to those few nodes
that belong to the domain ``cs'', and it in turn will only need
to hold routing information to the other nodes in ``cs''.
Messages could normally still be sent to the outside world
because at least one of the other nodes in ``cs''
will inform it how to route messages to the domains ``su'' and ``oz'',
however by specifying the flag
.I local ,
the routing program is informed not to allow messages
to be addressed outside the primary domain.
Furthermore, ``graphics'' is not allowing
.I "through traffic"
for messages,
although we are going to allow virtual circuits
to other nodes to be established through it.
``graphics'' has a
.I "virtual circuit only"
connection to the Cyber at the University Computing Centre,
hence the use of
.I -conterm
above, to allow
.I through
connections from other nodes.
.H 2 Links
.S -2
.DS 1
.ta +0.75i +.25i +1.8i
#
#	Configure the local links
#
.\" could probably note here that putting "link" commands
.\" in for local links is not needed, daemons will config
.\" them when they start.  Somewhere it says to ignore the
.\" err messages from these lines before that has been
.\" done, though I forget where, but that could be mentioned
.\" here again too.
flag		basset,basser		msg,con
flag		graphics,basser		msg,con
flag		basser40,basser		msg,con
.DE
.S
.P
Here we flag the types of traffic allowed on each link.
The only two types of traffic allowed at the moment are messages (\c
.I msg )
and virtual circuits (\c
.I con )
which are set up by the program
.I con (1).
Note that you need not use the command ``link''
\(em this will be issued automatically by the program
.I changestate
when the link first comes up.
(If the link doesn't exist,
.I acsstate 
will issue a warning message for the 
.I flag
command which you can safely ignore.)
.P
.S -2
.DS 1
.ta +0.75i +.25i +1.8i
#
#	Prevent the routing process from being too clever
#
flag		basser40,basset		lan
flag		basser40,graphics	lan
flag		basser40,basser		lan
flag		basset,graphics		lan
flag		basset,basser		lan
flag		basser,graphics		lan
.DE
.S
.P
As we have a quartet of nodes all fully connected on an
.ft I
Ethernet,
.ft P
it is possible for the routing process to try to
route around links that have just gone down
before the routefiles have been fully updated.
(The fastest route between any of these nodes is always the direct one.)
.P
The flag
.ft B
lan
.ft P
forces all the links to a node so flagged
to track the status of its link to our node.
.ne 14
.H 2 Aliases
.S -2
.DS 1
.ta +0.75i +.25i +1.8i
#
#	Add the aliases
#
xalias		basservax
alias		orac			siromath
alias		sun			sunrise
alias		images			sueeise
alias		mundara			mundara.mu
.DE
.S
Here we add a few
.I aliases
to make references to some of the frequently used addresses more pleasant.\*F
.FS
You don't have to do this now,
in fact it is probably better to set up the aliases
later when you know what you want.
I just thought you might like the examples.
.FE
The
.I address
for an alias can contain domain names.
Also, the \fIexported\fP alias ``basservax''
allows messages from overseas users addressed to the old node name
to be delivered appropriately by the \s-1UUCP\s0 gateway handler.
This is a useful feature should you ever decide to change the name of your node.
Other sites are automatically informed of an alias to use for the old name,
and then users used to the old name will not get confused.
You may have more than one exported alias.
.\" Is that restriction absolutely necessary ??
Note that ordinary
.I aliases
are a purely local set of names,
they get changed into the
.I real
addresses by
.I sendfile (1),
so other nodes never see them.
.H 3 Caveats.
Local users may not distinguish between real node names and aliases,
so make sure they learn the difference.
They shouldn't inform their colleagues
that they can be addressed using what is in effect a local alias.
Also, if you make an alias and
an identical real node name appears after the alias is installed,
then the alias will override the real node name.
.H 1 "SETTING UP AUTO\|-CALL FACILITIES"
.I ACSnet
provides a facility for making dynamic connections between nodes
over 
.I dial-up
lines using 
.I auto-call
units,
or via virtual circuits established on Public Packet Switched Networks.
If there are to be any nodes that you wish to call automatically
(whenever the queue becomes non-empty, and there is not already a 
node-to-node daemon running), then a couple of things must be set up.
.P
The 
.I auto-call
facility is provided by the program
.I NNcall (1).
This program in turn provides support for running auto-call
.I programs
written in C
to control the establishment of a virtual circuit to some remote
node over some combination of intervening networks.
The successful completion of the script will result in
two node-to-node daemons communicating with each other
over the virtual circuit.
.I NNcall
expects at least one argument, which is the name of a script to run.
The routing program knows how to invoke
.I NNcall
with a script named ``call''
if the link is suitably flagged, and there is indeed such a file name
in the node-to-node daemon's queueing directory.
.P
You must create a script program
to make the connection and start the daemon.
There is an example in the
.I NNcall
source directory.
Put a copy of the compiled script in the node-to-node daemon's queue directory
in a file labelled
.I call .
Then add a line to the
.I commandsfile
to let the routing program know:-
.P
.S -2
.DS 1
.ta +0.75i +.25i +1.8i
#
#	Flag the auto-call links
#
flag		munnari,basser		call
.DE
.S
.P
Alternatively, if other nodes are going to call you,
then you need to create a
.I login
name for them to connect to.\*F
.FS
The method of doing this is idiosyncratic to your brand of \s-1UNIX\s0,
but on most versions it consists of using the editor
to add an extra line to the file 
.I /etc/passwd
.FE
The normal practice is for the account name to be the same
as the name of the node that is calling in,
but you can also choose any alias for that node
that you might have set up in the
.I commandsfile .
The 
.I shell
to be invoked must be set to be the path name of the installed version of
.I NNshell (1).
It is also advisable to set a password
for the account.
Some versions of
.I login (1)
(eg in 4\s-1BSD\s0 and \s-1V\s0\&7),
restrict the length of a login name allowed.
If yours does this and the name of one of the nodes dialing in is too long,
then you can add an alias that is shorter,
and
.I NNshell
will look it up to find the real node name.
.H 1 "SETTING UP PERIODIC CALLS"
If you only (or also) wish to make
.I periodic
calls to some other node,
then you need to add a 
.I crontab
entry to make the calls at the chosen intervals,
For instance, to call the node ``munnari'' at noon, 6pm, and midnight,
add the line:-
.P
.DS 1
.ft B
0 0,12,18 * * * \s-1INSLIB\s0/NNcall \s-1SPOOLDIR\s0/munnari/call
.ft R
.DE
.P
Doing the connections this way involves less overheads,
and allows the scheduling of connections
to take advantage of cheaper billing periods.
.H 1 STATISTICS
If you don't want to gather statistics\*F
.FS
Management oriented sites may interpolate the phrase ``accounting information''
in place of ``statistics''.
.FE
at all,
then you should remove the file called
.I statsfile
created in \s-1INSLIB\s0 by the 
.I make
target
.I special .
Otherwise, the network will log a statistics record in
.I statsfile
for every message processed.
Periodically,
the 
.I statsfile
records will be processed into the
.I statefile
and,
if a file exists called
.I Accumulated
in the directory 
in \s-1SPOOLDIR\s0/_stats,
the statistics records will be added onto the end.
.P
The statistics are collected as lines containing
`\fB:\fP' separated \s-1ASCII\s0 fields.
There are no programs as yet to summarise this information
(although you may have opted to have statistics accumulated in your statefile),
and the file can grow alarmingly quickly on busy systems,
so my advice is to turn off statistics accumulation for the time being.
Do this by removing the file
.I Accumulated
(also created by the 
.I make
target
.I special ).
.H 1 "INTERFACES TO MAIL"
The distribution does not contain a mail program capable of using the
network to send mail to remote sites.
.P
If you are running an \s-1AUSAS\s0 system, or a 4\s-1BSD\s0 system,
this is no problem, as you already have a version of mail that understands
what to do with network addresses.
You will just need to cause the mail delivery
program to use the
.I ACSnet
program
.I sendfile (1)
to deliver the message.
We use the sequence:
.P
.DS 1
.ft B
sendfile -amailer -q\fIperson\|\fB@\fIdestination\fP
.ft R
.DE
.P
to deliver a mail item read from 
.I stdin .
You can, of course,
specify many
.I persons
and
.I destinations
at one time to take advantage of 
.I ACSnet 's
multi-cast addressing capabilities.
.P
If you don't have one of these systems,
then your best bet is to negotiate with us for a separate mail distribution.
.H 1 "NETWORK DEVICES"
There are two sets of devices that the network will use.
The first are those used by the node-to-node daemons on links
to other nodes connected by permanent virtual circuits.
When the daemon starts up, it will expect to find a file
by the name of the node it is talking to
in the directory defined as \s-1DEVNET\s0.\*F
.FS
This can be over-ridden by the daemon parameter \fB-d\fR.
.FE
You should now create one of these for each permanently connected node,
presumably by a judicious use of the program
.I mknod (1).
When the daemon opens this line, it will set it in \s-1RAW\s0 mode,
and optionally set the speed as requested in the
.I params 
file, or in an argument.
If the default speed is not appropriate, then you should use the
daemon parameter \fB-p\fInumber\fR,\*F
.FS
Daemon parameters such as \fB-p\fR and \fB-d\fR should probably be
installed in the daemon's ``params'' file \(em see
.I NNdaemon (1).
.FE
where 
.I number
is a magic baud-rate number as defined in the system include file
.I termio.h
(\s-1SYSTEM III\s0*), or
.I sgtty.h .
.P
Daemons started by the virtual circuit establishment programs,
.I NNshell (1)
and 
.I NNcall (1),
will communicate via file descriptor 1.
This will be a standard
.I login
line for
.I NNshell ,
or a device you chose in the call script for
.I NNcall .
.P
The second set are only needed if you are going to use the program
.I con (1).
It requires there to be a set of files in the directory \s-1DEVNET\s0,
all starting with the name of a directly connected node,
and ending with a number in the range 0-9.
If you can only supply one virtual circuit to the remote host,
then you should only provide one file,
but if there are many, then
.I con
will attempt to open each one in turn until it succeeds.
Again the program
.I mknod
should be used to set these up as appropriate.
.H 1 "STARTING THE NETWORK"
Now you can run
.I acsstate (1)
to test out your command file (which it reads on seeing the flag \fBc\fP),
let's use the \fBW\fP flag to make it complain about your typos.
We also want to update the statefile and routing tables (\fB\s-1RS\s0\fP),
and print a verbose listing (\fBV\fP) of all the local connections
(put your node's name in place of \fInodename\fP).
Type:-
.P
.DS 1
.ft B
acsstate -\s-1RSVW\s0c \fInodename\fP
.ft P
.DE
.P
You will probably get warnings from
.I acsstate
when it encounters the names of nodes that it doesn't yet know about.
These can safely be ignored, they will cease when the network starts
communicating.
If there were any other complaints, fix up the commands, and try again.
.P
Then make a directory in \s-1SPOOLDIR\s0
named after each node that you are connected to.
This should be owned by \fIdaemon\fP or whomever, mode 0755.
.P
Finally, try starting all the daemons:-
.P
.DS 1
.ft B
\s-1INSLIB\s0/rundaemon node1 node2 ...
.ft P
.DE
.P
When a daemon starts on a previously unknown link,
details of the new link
together with a request for state information
will be broadcast to every host on the network.
If you have already configured the link into the statefile for some reason,
then the broadcast will not happen,
so you should probably force the
same effect by running the program
.I \s-1INSLIB\s0/request
(see 
.I request (1)).
.H 1 MAINTENANCE
You also need to automate the process of getting the daemons started
each time your system boots. Just put a line
.P
.DS 1
.ft B
\s-1INSLIB\s0/NNdaemon -I \fInode\fP
.ft R
.DE
for each node you are connected to
in the usual place,
which would be near where the line printer daemons are started in the
.I /etc/rc
file on most systems.
The \fB-I\fP flag is to ensure that the daemons ignore
the previous process \fIid\fP if they are being re-started after a crash.
Alternatively, use
.I rundaemon :-
.P
.DS 1
.ft B
\s-1INSLIB\s0/rundaemon -I \fInode1\fP \fInode2\fP ...
.ft R
.DE
.P
Once a night you should run a command from
.I crontab
to clean uncollected files out of the file spooling directory.
Eg:-
.P
.DS 1
.ft B
0 5 * * * find \s-1SPOOLDIR\s0/_files -mtime \s-2+\s-1FILESEXPIREDAYS\s+3 -a -exec rm -f {} ';'
.ft P
.DE
.P
You could also add a line to clean out temporary files:-
.P
.DS 1
.ft B
0 5 * * * \s-1INSLIB\s0/purge
.ft P
.DE
.P
After system crashes, you may find that the
.I statefile
got corrupted (by the crash happening in the middle of an update).
This will cause the daemons to hang when they get an error from
.I acsstate .
Repair the statefile by running the command
.P
.DS 1
.ft B
acsstate -\s-1ERS\s0c
.ft P
.DE
.P
This could also go into your 
.I rc
file before the daemons are started up.
If the statefile gets completely clobbered,
you can request an update from other nodes on the network by running
the program
.I \s-1INSLIB\s0/request
(see 
.I request (1)).
.P
If your kernel does not support file locking,
you should also add a command to remove any lock files
that might have survived a system crash:-
.P
.DS 1
.ft B
rm -f \s-1INSLIB\s0/*.l
.ft P
.DE
.H 1 TUNING
The node-to-node daemons will adjust their communication parameters
dynamically to cater for changing circuit conditions.
Once you are satisfied that you understand what is going on
(by using the
.I linkstats (1)
command),
then you can override these adjustments.
Create a file called ``params''
in the daemon's queueing directory and it will be read on start-up.
See the manual
.I NNdaemon (1)
for possible arguments you may use.
.P
As an example, the link to ``munnari'' from ``basser''
runs over \s-1CSIRONET\s0 using the 
.I cooked
packet protocol, and we use the following arguments in the file ``params'':-
.P
.DS 1
.ft B
-CN -b4 -i15 -q7 -s50 -z64 -rroutingdir
.ft P
.DE
.P
These turn on
.I cooked
mode, turn off dynamic adjustment,
set a packet window size of 4,
set the intra-packet timeout to at least 15 seconds,
set the minimum acceptable effective throughput to 7 bytes/second,
set the assumed speed to 50 bytes/second,
restrict the packet size to 64 bytes,
and tells the daemon to use \fIroutingdir\fP
(which must already have been created in its command directory)
to spool messages for the routing daemon.
.P
As the speed and packet size directly affect the time it takes
to get a response to a packet, the timeouts are calculated from
these values, so you need to juggle them to get reasonable values.
The packet size is the important constraint here,
as throughput seems to improve with bigger packets sent less often.
However, as 
.I cooked
mode can double the effective size of a packet on worst case translations,
the packet size can't get much bigger than 64,
as it can then cause unacceptable intra-packet delays
in \s-1CSIRONET\s0.
.P
Using the \fB-r\fP parameter
considerably speeds up processing of incoming messages,
as the daemon will just place each correctly received message
in that directory where it will be processed later by a routing daemon.
Meanwhile that channel immediately becomes free for use by a following message.
Without this parameter,
the daemon will invoke a routing program for each message received,
and the channel will be idle until the message has been processed.
.H 1 "REMOTE PRINTING"
Assuming that you wish to set up a remote printing facility,
the following example sets up the parameters for printing to be allowed
between three hosts ``site1'', ``site2'' and ``site3'',
all running a version of
.I lpr (1)
with some added features.
Let us also assume that the network is being configured at ``site1''
which has a printer, and that ``site2'' 
has two printers.
.P
The spooler program is called 
.I lpr .
It takes some unusual arguments:-
\fB-h\fIhost\fR to indicate that the job comes from a remote site called 
.I host ,
\fB-u\fIperson\fR to indicate that the job comes from a remote user called
.I person ,
\fB-n\fIname\fR to indicate the name of the print job,
and \fB-p\fIprinter\fR to indicate an alternative printer to print the job on.
The handler will pipe the contents of a 
.I print
message into the program \s-1PRINTER\s0,
so we should set the Makefile parameter \s-1PRINTER\s0 to be 
.I /bin/lpr ,
and \s-1PRINTERARGS\s0 should be set to show the true name
and origin of the job, ie:
.P
.DS 1
.ft B
\s-1PRINTERARGS\s0 = "-h&O","-u&F","-n&D"
.ft P
.DE
.P
Now we should define \s-1PRINTORIGINS\s0 to restrict print jobs to
our own sites, so we set
.P
.DS 1
.ft B
\s-1PRINTORIGINS\s0 = "/usr/lib/printorigins"
.ft P
.DE
.P
and in this file we put two lines naming the favoured sites:
.P
.DS 1
.ft B
site2
site3
.ft P
.DE
.P
We also need to set up \s-1PRINTSITES\s0 to enable our users to send
print jobs to the two printers at
.I site2 :-
.P
.DS 1
.ft B
\s-1PRINTSITES\s0 = "/usr/lib/printsites"
.ft P
.DE
.P
and in this file we put just the name ``site2''.
.P
That's all for the Makefile parameters,
but we also need to make it easy
for our users to send their print jobs to ``site2''
and be able to choose what printer it goes on.
This can be done by writing a shell script called, say
.I /usr/bin/netprint .
It could contain the following:-
.P
.DS 1
.ft B
.ta +.25i +.25i
printer=1

case $1
in
	-1)	printer=1 ; shift ;;
	-2)	printer=2 ; shift ;;
esac

sendfile -aprinter -dsite2 -e-p$printer $*
.ft P
.DE
The shell program has an optional first argument, either -1, or -2,
which selects which of the printers is to be used. The default is -1.
This information is passed as an argument for the remote spooler
inside the message
.I environment
using the
.I sendfile
argument \fB-e\fP.
.H 1 "INTERFACING TO NETNEWS"
To receive news, all that you normally need to is define
\s-1NEWSEDITOR\s0 when you configure \s-1SUN III\s0, and install
everything normally, and then get your news neighbour(s)
to start sending news to you.
.P
If, however, your news feed wishes to send you batched,
or compressed, news, or some combination, then you will
need to create the \s-1NEWSCMDS\s0 file.
This must have been defined when you configured the
network software as well.
It will usually have been defined to be \s-1INSLIB\s0/\|newscmds.
Your news feed should be able to tell you what you
need to put in this file.\*F
.FS
If they don't know, then they should probably restrict
themselves to sending simple one at a time articles!
.FE
.P
You are also going to want to send news back to your
news feed, so that local users can post articles.
Since we are assuming that you have read the
netnews documentation, you will know how to put
the following command in your subscription file,
for the node that you are going to send news to.
.P
.DS 1
INSBIN/\|sendfile -NRSareporter -d<node>
.DE
.P
That arranges for news articles (which are given
to the command on standard input) to be sent to
the \fIreporter\fP handler at <\fInode\fP>.
The \fBN\fP option causes the \fIsendfile\fP \fBFTP\fP protocol
to be avoided, and is essential.
The \fBR\fP option prevents news from being returned
to your host if (for some reason) it is not acceptable
at your neighbour node.
In general, this is a good idea, news is seldom
important enough to worry about the small chance
of its being rejected.
However, when you are just starting, you might want
to omit this option.
The \fBS\fP option causes \fIsendfile\fP to treat
news as the lowest possible priority traffic,
as if each item was a \fIhuge\fP file.
That has the side effect of keeping news articles
ordered, which is generally a good idea, especially
if you are acting as a news feed, and passing lots
of news from one site to another.
.P
Note, there is no requirement that the <\fInode\fP>
be a node that is directly connected to your host.
Anyone that you can address is a potential target.
However, sending news articles to sites without their
consent is not a ``nice'' thing to do!
.P
You can use \fIsendfile\fP's \fB\-e\fP parameter
to pass exotic remote commands to the news system,
should you have need to do that.\*F
.FS
This can be used to send batched news, or to
compress news articles.
The command that you send must be in the
\s-1NEWSCMDS\s0 file at your news neighbour.
.FE
By the time that need arises you will be an expert at
handling \s-1SUN III\s0 and the netnews systems,
and will not need explanations from here!
.H 1 "ACTING AS A FILESERVER NODE"
If you desire to, you can make your host available to
others to access files that you might happen to have
and which are generally available to all.
.P
If you are going to do this, then you should
have defined \s-1PUBLICFILES\s0
to be the name of a file or directory that
will give access to the files you will be making
available.
If \s-1PUBLICFILES\s0 is the name of a directory,
then you should make it now.
It can probably be owned by the \s-1SERVERUSER\s0
that you defined to act on behalf of remote users.
If you have any files that you wish to make immediately
available, you can copy, or link, them into this
directory.
Make sure that they are readable by \s-1SERVERUSER\s0!
Its fine to make subdirectories if there is a lot
of related material that should be kept together.
.P
If \s-1PUBLICFILES\s0 is the name of a file, then
you need to create that file.
A minimal case (and probably the best starting
point) would be
.P
.DS 1
.ta \w'friend@neighbourMM'u
*	SPOOLDIR/_public
.DE
.P
This allows anyone to access files in \s-1SPOOLDIR\s0/\|_public
and is equivalent to simply defining \s-1PUBLICFILES\s0 to
be this directory name.
However, it does leave room for expansion, should you
wish to at some later time.
Another example might be
.P
.DS 1
.ta \w'friend@neighbourMM'u
friend@neighbour	/
enemy@*
*	SPOOLDIR/_public
.DE
.P
This allows \fIfriend@neighbour\fP to access any files
on your system, provided that \s-1SERVERUSER\s0 has
read permissions on the requested files.
\fIEnemy\fR is not permitted any access at all, whatever
host he happens to be using, as there is no path specified
for him.
.\" Piers - this really needs to be expanded to allow
.\" domains to be listed (eg: foo@host.su) - how do
.\" you suggest that be done ??  I assume that all
.\" the info exists in the headers, how is it got at??
.\" you wouldn't like to make this simple (?) change would you ??
All others can access files in the public directory only.
.P
Once this file is created, you should make sure that any
directories it names exist, and have suitable permissions.
.P
You should also make sure that the user \s-1SERVERUSER\s0
exists in your password file, and that \s-1SERVERGROUP\s0
is in your group file.\*F
.FS
If you are not running an \s-1AUSAS\s0 system, and
have a group file!
.FE
.P
\s-1SVRHOST\s0 should be defined if you would like a default for the
\fB-d\fP flag to \fIfetchfile\fP(1).
This might be useful if your users will be fetching most files
from one particular host.
Otherwise the \fB-d\fP flag must always be used.
\s-1SVRHOST\s0 can be the name of the host itself,
or the name of a file containing the name of the host.
.H 1 UPDATES
From time-to-time,
there will be distributions of updates for your source.
These will arrive over the network as a file called
ACSnet.up.\fItype\fP,
where
.I type
is either ``tar'' or ``cpio''
depending on your original choice.
.P
After extracting the new source files,
run \fBmake certain\fP.
When re-compilation has succeeded,
stop any network daemons and run
\fBmake install\fP,
followed by
\fBacsstate -ERSc\fP.
Then restart the network.
.SK
.H 1 SUMMARY
Here is a brief summary of the steps you should have taken,
just in case you missed something.
.AL 1
.LI
Read everything that comes with the distribution, carefully.
.LI
Choose a node name, and the domains it will belong to.
.LI
Extract the tape (or whatever).
.LI
Copy ``Makefile.dist'' to ``Makefile''.
.LI
Edit ``Makefile'', set system dependent definitions.
(Section 3.)
.LI
\fBmake\ all\fR. (Section 5.)
.DL
.LI
If anything goes wrong, fix it and \fBmake\ certain\fR.
.LI
Repeat.
.LE
.LI
\fBmake\ directories\ special\ install\fR
.LI
Create \fI\s-1INSLIB\s0/commandsfile\fR.
(Section 7.)
.LI
\fBacsstate -RSVWc\fR
(Section 14.)
.LI
Repeat steps 8 and 9 until it's right.
.LI
Create the node directories in \s-1INSLIB\s0.
.LI
\fBmknod\fR the network special files.
.LI 
Start the daemons.
.LE
.TC
.CS
