/
/ loader for algol68s for unix.
/
/	*********************************************************
/	*							*
/	*	In the event of mysterious failures, the most	*
/	*	likely cause is a kernel change.  The two areas *
/	*	we have had problems with are (a) mapping of	*
/	*	system calls;  (b) changes to SINCR.  Consult	*
/	*	ANW or WJA about these!				*
/	*					ANW, April 1985 *
/	*							*
/	*********************************************************
/
/ this program loads a file containing a core image of the
/ algol68s compiler, produced by carnegie-mellon university,
/ sets up, and branches to it.
/
/ since unix does i/o in 512 byte multiples and since the
/ compiler is very large (approximately 51000 bytes), two
/ methods of loading the compiler are provided.
/
/  1) if the variable "where" in this program has the value
/     -1, then the compiler is assumed to be found on file
/     /etc/alg68 and is read from there using regular unix i/o.
/  2) if the variable "where" has a positive or zero value,
/     then the compiler is to be found in contiguous blocks
/     starting with block "where" on the device specified by
/     the raw i/o name given by variable "which".  in this case,
/     the compiler will be loaded very significantly faster.
/     probably the easiest way to obtain a set of contiguous
/     blocks on disk is to initialize a disk with /etc/mkfs so
/     that only part of the disk is used by unix (by specifying
/     the number of blocks on the disk to /etc/mkfs).  the compiler
/     can then be placed in the remaining blocks using raw i/o.
/
/ as distributed, the variable "where" has a value of -1, so
/ to simply get the thing to run, just copy the compiler core
/ image file to /etc/alg68.
/
/ since the unix user cannot alter the core image file, to
/ provide the most flexibility, the compiler does not perform
/ unix system calls directly: it uses the emt instruction instead
/ of trap for system calls, but with the same parameters, so
/ that the unix user may modify, if he so desires, for example,
/ the writing of data to the object file.
/ the system calls so used are:
/	indir	0
/	exit	1
/	read	3
/	write	4
/	open	5
/	close	6
/	creat	8.
/	unlin	10.
/	seek	19.
/
/ since no knowledge of the size of this program is known
/ to the compiler, it generates no free space in its area for
/ this program: thus, the part of this program that runs
/ along with the compiler relocates itself up above the last
/ address in the compiler.
/
/ the entry point to the compiler can be found in the word
/ at +16(base 8) in the first block of the compiler core
/ image file.  before entry r5 must be loaded with the word
/ at +20(base 8), and r4 must point to the lower end of an
/ area (extending up to 177776) to be used as the compiler
/ work area.  the size of the compiler is found in the word
/ at +22(base 8).  on entry to the compiler, the sp must have
/ the same contents as it does on entry to this program.
/
/ assuming this program is in /usr/bin/alg, algol68s is called
/ with the command:
/	alg [-wls#] [file]
/ where w requests warnings to be suppressed.
/	l requests a source listing (on the standard output file)
/	s# specifies the stropping with # one of:
/		r reserved word
/		p point
/		u upper
/		l lower
/	file specifies the source file (if omitted, the
/		standard input file is used).
/ the object file is placed in a68.out
/ since random i/o is used to build the object file, it
/ cannot be output to a pipe, or to the standard output file.
/
/ written by howard j. ferch,
/  dept. of computer science,
/  university of manitoba,
/  september, 1977.
/
/ no guarantees are made as to the correct functioning of this
/ program, or to the compiler core image file.
/
/ This program has been modified in order to run
/ under UNIX V7.
/ Main change is difference between the various seeks.
/ Also the raw interface to the run time system has been
/ commented out -- very serious algol users (do they exist)
/ should consider reinstating it.
/ To run under V7 the variables V7 and V6 should be set
/ to 1 and 0 resp., for V6 operation use your imagination.
/
/  ben salama, october 1980.

.V7 = 1
.V6 = 0
.if .V7
indir	= 0.
exit	= 1.
fork	= 2.
read	= 3.
write	= 4.
open	= 5.
close	= 6.
wait	= 7.
creat	= 8.
link	= 9.
unlink	= 10.
exec	= 11.
chdir	= 12.
time	= 13.
mknod	= 14.
chmod	= 15.
chown	= 16.
break	= 17.
stat	= 18.
lseek	= 19.
getpid	= 20.
mount	= 21.
umount	= 22.
setuid	= 23.
getuid	= 24.
stime	= 25.
ptrace	= 26.
alarm	= 27.
fstat	= 28.
pause	= 29.
utime	= 30.
smdate	= 30.
stty	= 31.
gtty	= 32.
access	= 33.
nice	= 34.
sleep	= 35.
sync	= 36.
kill	= 37.
csw	= 38.
setpgrp = 39.
dup	= 41.
pipe	= 42.
times	= 43.
profil	= 44.
setgid	= 46.
getgid	= 47.
signal	= 48.
acct	= 51.
phys	= 52.
lock	= 53.
ioctl	= 54.
reboot	= 55.
mpx	= 56.
setinf	= 59.
umask	= 60.
getinf	= 60.
.endif
nop	= 240

enter:	jmp	reale
.=.+508.			/ leave room for block 0 of compiler
reale:  mov	sp,r4		/ save entry stack
sincr	= 14			/ current value!
	mov	$100*sincr 160000,sp
				/ allocate stack page - we do this
				/ before the sys break since it will
				/ be faster (the process is smaller)
				/	This nonsense is necessary on the one
				/	hand because the compiler wants to use
				/	the stack segment for its own purposes,
				/	and only stack instructions are allowed
				/	to make the stack segment grow, and on
				/	the other because the kernel insists on
				/	allocating SINCR clicks more than you
				/	ask for, so accessing $160000 directly
				/	would encroach on data space.  Grrr!
				/		ANW [aided WJA], April 1985
	tst	*sp		/ force allocation
	mov	r4,sp		/ restore stack pointer
	tst	where		/ raw or regular load?
	bpl	raw		/ do raw open
	sys	open; aci; 0	/ open core image file
	nop			/ dummy extra parameter for S5 open
	bcc	comr
2:	mov	$2,r0
	sys	write; uop; 29. / cant open compiler
	sys	exit
comr:	mov	r0,r5		/ save file desc for comp.
	sys	read; 0
a512:	512.			/ read initial block
	bcc	1f
3:	mov	$2,r0
	sys	write;urd;29.	/ cant read compiler
	sys	exit
1:	cmp	r0,a512		/ did we read whole block?
	bne	3b
	mov	22,csize	/ size of compiler
	add	$p2end-p2,csize / plus relocated chunk
	sys	break
csize:	0			/ allocate suff. core
	bcc	1f
	mov	$2,r0
	sys	write;umem;20.	/ cannot obtain memory
	sys	exit
/
/ memory allocated: relocate part 2
/
1:	mov	22,r0
	inc	r0
	bic	$1,r0		/ round comp size to word
	mov	where,wh2	/ save where for part2
	mov	r0,r3
	mov	$p2end-p2,r1	/ size of relocated code
	asr	r1		/ in words
	mov	$p2,r2		/ addr of section two
1:	mov	(r2)+,(r0)+	/ relocate part two
	sob	r1,1b		/ (slow way)
/
/ fix up absolute addresses in part 2
/
	mov	r3,r0		/ end of compiler
	sub	$p2,r0		/ relocation amount
	mov	$rltabl,r1	/ addr. of reloc. table
4:	mov	(r1)+,r2	/ addr(old) of value to reloc
	beq	1f		/ no more
	add	r0,r2		/ new addr of absolute amt
	add	r0,*r2		/ relocate it
	br	4b
/
/ go to part 2 and read in rest of compiler
/
1:
	jmp	*r3		/ go to part 2
/
/ raw i/o code
/ removed for V7.
raw:
	br	2b
/	sys	open; which; 0	/ open raw compiler file
/	nop			/ extra param for S5 open
/	bcs	2b
/	mov	r0,r5
/	mov	where,iseek
/	sys	seek
/iseek: 0	;3		/ seek to beginning of comp.
/	bcs	3b
/	jmp	comr
/
/ constants for part 1:
/
where:	-1
which:	</dev/rrk0\0>
aci:	</etc/alg68\0>
uop:	<unable to open compiler file\n>
urd:	<unable to read compiler file\n>
umem:	<insufficient memory\n>
	.even
rltabl:
	arl1
	arl2
	arl3
	0
/
/ part 2: relocated section
/
p2:
	tst	wh2		/ raw i/o?
	bpl	rawrd		/ yup-do seek
coml:	mov	r5,r0
	mov	*$22,rsize	/ size of compiler
	sub	$512.,rsize	/ minus initial blk already read
	inc	rsize
	bic	$1,rsize	/ must be even for raw i/o
	sys	read; 512.
rsize:	0			/ read rest of compiler
	bcc	1f
rerr:	mov	$2,r0
	sys	write
arl1:	ugh; 29.		/ write read error msg
	sys	exit
1:	cmp	r0,rsize	/ read correct amt?
	bne	rerr		/ no-quit
	mov	r5,r0
	sys	close		/ close compiler core image
	br	1f		/ go set up to call compiler
rawrd:
	br	rerr		/ raw i/o removed (ben salama)
/	mov	wh2,rseek
/	inc	rseek		/ seek to rest of comp.
/	mov	r5,r0
/	sys	seek
/rseek:	0	;3
/	bcs	rerr		/ seek failed
/	br	coml		/ read in compiler
ugh:	<unable to read compiler file\n>
	.even
1:
/
/ compiler in-core: set sys signal for emt's
/ and branch to compiler.
/
	sys	signal; 7
arl2:	emth
	mov	*$20,r5		/ get real sp
	mov	$161000,r4	/ compiler work area
	mov	*$16,r3		/ addr of compiler
	jmp	*r3		/ go to compiler

.if .V6
/
/ emt handler:
/ V6 version
/  since we dont wish to handle the emt's ourselves,
/  simply alter them to traps and branch back.
/
emth:
	mov	r0,-(sp)		/ save due to sys signal
	sys	signal; 7		/ restore sys signal (only
arl3:	emth				/ takes forever)
	mov	2(sp),r0		/ old pc
	tst	-(r0)			/ pnt to emt
	mov	r0,2(sp)		/ will go back to it
	bis	$400,*r0		/ set to trap
	tstb	*r0			/ indirect call?
	beq	indr			/ yup-fix up indirect emt
	mov	(sp)+,r0		/ recover r0
rti = 2
	rti				/ issue trap
indr:	mov	2(r0),r0		/ pnt to indirect emt
	bis	$400,*r0		/ alter to trap
	mov	(sp)+,r0
	rti
wh2:	0
p2end:	0
.endif

.if .V7
/
/ emt handler:
/ V7 version
/ this code is messy and complicated due to
/ the difference between the v6 seek and the v7 lseek.
/ For 'normal' system calls (i.e. everything except a seek
/ and an indirect call) just modify the emt instruction to
/ a trap instruction and re-execute. (as for v6).
/ For indirect system calls which are not seeks -- modify
/ both the indirect emt and the actual emt to traps and re-execute
/ the instructions (as for v6).
/ The fun begins for seeks and indirect seek calls. Since the v7
/ lseek has one more word of arguments (offset is long)
/ then the v6 seek, it is necessary
/ to pull the arguments out of the code modify them for v7 and
/ execute them here, then restore everything to normal, fix up
/ pc, sp etc and continue execution.
/ What a mess.
/
/	Code added for S5 open (extra parameter), June 1984, ANW.
/ Note that indirect opens are OK, only direct ones need be intercepted,
/ 'cos they return to the wrong place.

emth:
	mov	r0,-(sp)		/ save due to sys signal
	sys	signal; 7		/ restore sys signal (only
arl3:	emth				/ takes forever)
	mov	2(sp),r0		/ old pc
	tst	-(r0)			/ pnt to emt
	cmpb	$lseek,*r0		/ is it lseek ?
	beq	emtseek			/ yes, branch
	tstb	*r0			/ indirect call?
	beq	indr			/ yup-fix up indirect emt
	cmpb	$open,*r0		/ fix for extra param in S5
	beq	emtopen
2:	bis	$400,*r0
7:	mov	r0,2(sp)		/ will return to this instruction
	mov	(sp)+,r0		/ recover r0
rti = 2
	rti				/ issue trap

emtseek:
	mov	r0,savr0		/ save r0
	mov	r1,savr1		/ and r1
	mov	2(r0),r1		/ offset
	mov	4(r0),whence		/ type of seek
	clr	r0
3:	cmp	whence,$3		/ type = 3,4,5 ?
	blt	1f			/ no branch
	sub	$3,whence
	mov	r1,r0
	clr	r1
	mul	$512.,r0		/ r0 contains high word
					/ r1 contains low word
1:	mov	r0,offset1
	mov	r1,offset2
	mov	(sp),r0			/ recover r0
	sys	lseek;
offset1:0
offset2:0
whence: 0
	bec	4f
	bis	$1,4(sp)		/ set c bit for return
	br	5f
4:	bic	$1,4(sp)
5:	mov	savr1,r1
	mov	savr0,r0
6:	add	$6,r0			/ correct return address
	br	7b

emtopen:
	mov	r0,-(sp)		/ keep r0 over sys open
	mov	2(r0),openfn		/ grab filename
	mov	4(r0),openmd		/ and mode
	sys	open;
openfn: 0
openmd: 0
	nop				/ dummy for S5
	mov	r0,2(sp)		/ result to be returned
	mov	(sp)+,r0		/ recover old r0
	bec	4f
	bis	$1,4(sp)
	br	6b
4:	bic	$1,4(sp)
	br	6b

indr:	mov	r1,savr1
	mov	2(r0),r1
	cmpb	$lseek,*r1		/ indirect seek ?
	beq	1f			/ yes, branch
	bis	$400,*r1		/ fix up trap.
	mov	savr1,r1		/ restore r1
	br	2b
1:	mov	4(r1),whence
	mov	2(r1),r1
	tst	-(r0)
	mov	r0,savr0
	br	3b
savr0:0
savr1:0
wh2:	0
p2end:	0
.endif
