/*
**	Send a message to remote fileserver - request files
*/

static char	sccsid[]	= "@(#)fetch.c	1.7 87/10/26";

#ifdef	SVRHOST
char *	Usage	= "\"%s [-[C][L][V]] [-dfromhost] file ...\"";
#else
char *	Usage	= "\"%s [-[C][L][V]] -dfromhost file ...\"";
#endif

#define	FILE_CONTROL
#define	STDIO

#include	"global.h"
#include	"Passwd.h"
#include	"address.h"
#include	"handlers.h"
#include	"debug.h"


/*
**	Parameters set from arguments.
*/

bool	CRC;			/* Perform CRC on returned data */
bool	List;			/* Return file names, rather than data */
char *	Name;			/* Program invoked name */
bool	NoRet;			/* Don't return message on error detection */
int	Traceflag;		/* Global tracing control */
bool	Verbose;		/* with List, return more data */

VarArgs	Dargs;			/* list of hosts to obtain files from */
VarArgs Fargs;			/* list of names of files to return */


/*
**	Miscellaneous
*/

bool	Explain;		/* Explain useage in finish() */

Passwd	Me;			/* Who I am */

void	addfile(), finish(), getdest(), send();
char *	mktemp();


main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	if (!GetUser(&Me, getuid()))
	{
		Error("Who are you?");
		finish(1);
	}

	Explain = true;

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'C':
					CRC = true;
					continue;

				case 'L':
					List = true;
					continue;

				case 'R':
					NoRet = true;
					continue;

				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				case 'V':
					Verbose = true;
					continue;

				case 'd':
					(void)getdest(++*argv);
					goto break2;

				default:
					Mesg("unrecognised flag", "'%c'", c);
					putc('\n', stderr);
					Explain = false;
					finish(1);
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
			addfile(*argv);
	}

	if ( NARGS(&Fargs) == 0 )
	{
		Error("No files to get??");
		finish(1);
	}


	if ( NARGS(&Dargs) == 0 )
	{
#		ifdef	SVRHOST
		if (SVRHOST[0] == '/')
			FIRSTARG(&Dargs) = concat("-d", ReadFile(SVRHOST),
			    NULLSTR);
		else
			FIRSTARG(&Dargs) = concat("-d", SVRHOST, NULLSTR);
#		else
		Error("No server host specified");
		finish(1);
#		endif
	}

	Explain = false;

	send();
}



/*
**	Called from the errors routines to cleanup
*/

void
finish(error)
	int	error;
{
	if ( Explain )
	{
		Mesg("Usage", Usage, Name);
		putc('\n', stderr);
	}

	(void)exit(error);
}



/*
**	A destination must be in one of the following forms:
**
**	'*[.domain]'			Broadcast
**	'address[,address...]'		Multicast
**	'address!address[!address...]'	Explicit
**
**	["address" may contain domains, eg: "node.domain"]
**
**	'broadcast' supercedes any 'multicast' addresses,
**	but 'explicit' is exclusive.
**
**	All of this is actually implemented in 'sendfile'
**	(although we do impose some administrative policy here).
*/

void
getdest(s)
	register char *	s;
{
	if (s == NULLSTR || *s == '\0')
	{
		Error("Null server host??");
		finish(1);
	}
	if ( strchr(s, ATYP_BROADCAST) != NULLSTR )
	{
		Error("Broadcast disallowed");	/* Asshole! */
		finish(1);
	}
	NEXTARG(&Dargs) = concat("-d", s, NULLSTR);
}



/*
**	Add a file name into appropriate list, and extract details.
*/

void
addfile(file)
	char *		file;
{
	if (NARGS(&Fargs) >= MAXVARARGS) {
		Error("Too many files to fetch");
		finish(1);
	}
	NEXTARG(&Fargs) = file;
}



/*
**	Call 'sendfile' to transmit message to server host
*/

void
send()
{
	register int	n;
	register char**	cpp;
	register char * file;
	register int	fd;
	register FILE * ofd;
	char **		args;
	char		traceflag[8];
	char		tempname[32];

	strcpy(tempname, "/tmp/Fetch.aXXXXX");
	file = mktemp(tempname);
	args = (char **)Malloc((NARGS(&Dargs) + 6) * sizeof (char *));
	cpp = args;

	*cpp++ = SEND;
	*cpp++ = "-N";
	if (NoRet)
		*cpp++ = "-R";
	*cpp++ = concat("-a", FSVRHANDLER, NULLSTR);

#	ifdef	DEBUG
	if ( Traceflag )
	{
		(void)sprintf(traceflag, "-T%d", Traceflag);
		*cpp++ = traceflag;
	}
#	endif	DEBUG

	for (n = 0; n < NARGS(&Dargs); n++)
		*cpp++ = ARG(&Dargs, n);
	*cpp = NULLSTR;

	while ((fd = creat(file, 0600)) == SYSERROR)
	{
		Syserror("Can't create %s", file);
	}
	(void) close(fd);

	(void) close(0);
	if ((fd = open(file, O_RDWR)) == SYSERROR)
	{
		(void) unlink(file);	/* may screw errno, but ... */
		Syserror("Can't reopen %s", file);
		finish(1);
	}
	(void) unlink(file);
	if (fd != 0)
	{
		Syserror("Failed to assign unit 0");
		finish(1);
	}

	if ((ofd = fdopen(fd, "w")) == NULL)
	{
		Syserror("This error NEVER happens");
		finish(1);
	}

	putstr(ofd, Me.P_name);

	if (List)
		if (Verbose)
			putstr(ofd, "ListVerbose");
		else
			putstr(ofd, "List");
	else
		putstr(ofd, "SendFile");

	if (CRC)
		putstr(ofd, "-C");
	else
		putc('\0', ofd);

	putc('\0', ofd);	/* file name marker */

	for (n = 0; n < NARGS(&Fargs); n++)
		putstr(ofd, ARG(&Fargs, n));
	putc('\0', ofd);

	fflush(ofd);
	if (ferror(ofd))
	{
		Syserror("Write error on temp file");
		finish(1);
	}

	(void) lseek(fd, 0L, 0);

#	ifdef	DEBUG
	if (Traceflag)
	{
		fprintf(stderr, "Command:");
		for (cpp = args; *cpp != NULLSTR; cpp++)
			fprintf(stderr, " %s", *cpp);
		fprintf(stderr, " <<EOF\n");
		ofd = fdopen(fd, "r");
		while ((n = getc(ofd)) != EOF)
		{
			if (n == 0)
				putc('\n', stderr);
			else
				putc(n, stderr);
		}
		fprintf(stderr, "EOF\n");
		(void) lseek(fd, 0L, 0);
	}
#	endif

	for ( ;; )
	{
		(void)execve(args[0], args, StripEnv());
		Syserror("Can't execve \"%s\"", args[0]);
	}
}

putstr(fd, str)
	register FILE *	fd;
	register char *	str;
{
	do {
		putc(*str, fd);
	} while (*str++);
}
